/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.utility;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NonDumbAxisABB {
    public double minY;
    public double maxX;
    public double maxY;
    public double minX;
    public double maxZ;
    public double minZ;

    public NonDumbAxisABB(BlockPos pos1, BlockPos pos2) {
        this(pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
    }

    public AxisAlignedBB toAxisAlignedBB() {
        return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean intersects(Vec3d min, Vec3d max) {
        return this.intersects(Math.min(min.field_72450_a, max.field_72450_a), Math.min(min.field_72448_b, max.field_72448_b), Math.min(min.field_72449_c, max.field_72449_c), Math.max(min.field_72450_a, max.field_72450_a), Math.max(min.field_72448_b, max.field_72448_b), Math.max(min.field_72449_c, max.field_72449_c));
    }

    @Nullable
    @VisibleForTesting
    Vec3d collideWithXPlane(double p_186671_1_, Vec3d p_186671_3_, Vec3d p_186671_4_) {
        Vec3d vec3d = p_186671_3_.func_72429_b(p_186671_4_, p_186671_1_);
        if (vec3d != null && this.intersectsWithYZ(vec3d)) {
            return vec3d;
        }
        return null;
    }

    public NonDumbAxisABB union(NonDumbAxisABB other) {
        NonDumbAxisABB nonDumbAxisABB = this;
        double d0 = Math.min(nonDumbAxisABB.minX, other.minX);
        double d1 = Math.min(nonDumbAxisABB.minY, other.minY);
        double d2 = Math.min(nonDumbAxisABB.minZ, other.minZ);
        double d3 = Math.max(nonDumbAxisABB.maxX, other.maxX);
        double d4 = Math.max(nonDumbAxisABB.maxY, other.maxY);
        double d5 = Math.max(nonDumbAxisABB.maxZ, other.maxZ);
        return new NonDumbAxisABB(d0, d1, d2, d3, d4, d5);
    }

    public NonDumbAxisABB offset(double x, double y, double z) {
        return new NonDumbAxisABB(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    @Nullable
    @VisibleForTesting
    Vec3d collideWithZPlane(double p_186665_1_, Vec3d p_186665_3_, Vec3d p_186665_4_) {
        Vec3d vec3d = p_186665_3_.func_72434_d(p_186665_4_, p_186665_1_);
        if (vec3d != null && this.intersectsWithXY(vec3d)) {
            return vec3d;
        }
        return null;
    }

    public boolean intersects(double x1, double y1, double z1, double x2, double y2, double z2) {
        if (this.minX < x2 && this.maxX > x1 && this.minY < y2 && this.maxY > y1 && this.minZ < z2 && this.maxZ > z1) {
            return true;
        }
        return false;
    }

    public boolean intersects(NonDumbAxisABB other) {
        return this.intersects(other.minX, other.minY, other.minZ, other.maxX, other.maxY, other.maxZ);
    }

    public String toString() {
        return new StringBuilder().insert(0, "box[").append(this.minX).append(", ").append(this.minY).append(", ").append(this.minZ).append(" -> ").append(this.maxX).append(", ").append(this.maxY).append(", ").append(this.maxZ).append("]").toString();
    }

    public NonDumbAxisABB intersect(NonDumbAxisABB other) {
        NonDumbAxisABB nonDumbAxisABB = this;
        double d0 = Math.max(nonDumbAxisABB.minX, other.minX);
        double d1 = Math.max(nonDumbAxisABB.minY, other.minY);
        double d2 = Math.max(nonDumbAxisABB.minZ, other.minZ);
        double d3 = Math.min(nonDumbAxisABB.maxX, other.maxX);
        double d4 = Math.min(nonDumbAxisABB.maxY, other.maxY);
        double d5 = Math.min(nonDumbAxisABB.maxZ, other.maxZ);
        return new NonDumbAxisABB(d0, d1, d2, d3, d4, d5);
    }

    @VisibleForTesting
    public boolean intersectsWithXZ(Vec3d vec) {
        if (vec.field_72450_a >= this.minX && vec.field_72450_a <= this.maxX && vec.field_72449_c >= this.minZ && vec.field_72449_c <= this.maxZ) {
            return true;
        }
        return false;
    }

    public int hashCode() {
        NonDumbAxisABB nonDumbAxisABB = this;
        long i = Double.doubleToLongBits(nonDumbAxisABB.minX);
        int j = (int)(i ^ i >>> 32);
        i = Double.doubleToLongBits(nonDumbAxisABB.minY);
        long l = i;
        j = 31 * j + (int)(l ^ l >>> 32);
        i = Double.doubleToLongBits(nonDumbAxisABB.minZ);
        long l2 = i;
        j = 31 * j + (int)(l2 ^ l2 >>> 32);
        i = Double.doubleToLongBits(nonDumbAxisABB.maxX);
        long l3 = i;
        j = 31 * j + (int)(l3 ^ l3 >>> 32);
        i = Double.doubleToLongBits(nonDumbAxisABB.maxY);
        long l4 = i;
        j = 31 * j + (int)(l4 ^ l4 >>> 32);
        i = Double.doubleToLongBits(nonDumbAxisABB.maxZ);
        long l5 = i;
        j = 31 * j + (int)(l5 ^ l5 >>> 32);
        return j;
    }

    public NonDumbAxisABB contract(double x, double y, double z) {
        double d;
        double d2;
        NonDumbAxisABB nonDumbAxisABB = this;
        double d0 = nonDumbAxisABB.minX;
        double d1 = nonDumbAxisABB.minY;
        double d22 = nonDumbAxisABB.minZ;
        double d3 = nonDumbAxisABB.maxX;
        double d4 = nonDumbAxisABB.maxY;
        double d5 = nonDumbAxisABB.maxZ;
        if (x < 0.0) {
            d0 -= x;
            d2 = y;
        } else {
            if (x > 0.0) {
                d3 -= x;
            }
            d2 = y;
        }
        if (d2 < 0.0) {
            d1 -= y;
            d = z;
        } else {
            if (y > 0.0) {
                d4 -= y;
            }
            d = z;
        }
        if (d < 0.0) {
            d22 -= z;
        } else if (z > 0.0) {
            d5 -= z;
        }
        return new NonDumbAxisABB(d0, d1, d22, d3, d4, d5);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getCenter() {
        return new Vec3d(this.minX + (this.maxX - this.minX) * 0.5, this.minY + (this.maxY - this.minY) * 0.5, this.minZ + (this.maxZ - this.minZ) * 0.5);
    }

    public NonDumbAxisABB grow(double x, double y, double z) {
        NonDumbAxisABB nonDumbAxisABB = this;
        double d0 = nonDumbAxisABB.minX - x;
        double d1 = nonDumbAxisABB.minY - y;
        double d2 = nonDumbAxisABB.minZ - z;
        double d3 = nonDumbAxisABB.maxX + x;
        double d4 = nonDumbAxisABB.maxY + y;
        double d5 = nonDumbAxisABB.maxZ + z;
        return new NonDumbAxisABB(d0, d1, d2, d3, d4, d5);
    }

    public double calculateYOffset(NonDumbAxisABB other, double offsetY) {
        if (other.maxX > this.minX && other.minX < this.maxX && other.maxZ > this.minZ && other.minZ < this.maxZ) {
            if (offsetY > 0.0 && other.maxY <= this.minY) {
                double d;
                double d1 = this.minY - other.maxY;
                if (d < offsetY) {
                    offsetY = d1;
                }
            } else if (offsetY < 0.0 && other.minY >= this.maxY) {
                double d;
                double d0 = this.maxY - other.minY;
                if (d > offsetY) {
                    offsetY = d0;
                }
            }
            return offsetY;
        }
        return offsetY;
    }

    @Nullable
    public RayTraceResult calculateIntercept(Vec3d vecA, Vec3d vecB) {
        NonDumbAxisABB nonDumbAxisABB = this;
        Vec3d vec3d = nonDumbAxisABB.collideWithXPlane(nonDumbAxisABB.minX, vecA, vecB);
        EnumFacing enumfacing = EnumFacing.WEST;
        Vec3d vec3d1 = nonDumbAxisABB.collideWithXPlane(nonDumbAxisABB.maxX, vecA, vecB);
        if (vec3d1 != null && this.isClosest(vecA, vec3d, vec3d1)) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.EAST;
        }
        NonDumbAxisABB nonDumbAxisABB2 = this;
        vec3d1 = nonDumbAxisABB2.collideWithYPlane(nonDumbAxisABB2.minY, vecA, vecB);
        if (vec3d1 != null && this.isClosest(vecA, vec3d, vec3d1)) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.DOWN;
        }
        NonDumbAxisABB nonDumbAxisABB3 = this;
        vec3d1 = nonDumbAxisABB3.collideWithYPlane(nonDumbAxisABB3.maxY, vecA, vecB);
        if (vec3d1 != null && this.isClosest(vecA, vec3d, vec3d1)) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.UP;
        }
        NonDumbAxisABB nonDumbAxisABB4 = this;
        vec3d1 = nonDumbAxisABB4.collideWithZPlane(nonDumbAxisABB4.minZ, vecA, vecB);
        if (vec3d1 != null && this.isClosest(vecA, vec3d, vec3d1)) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.NORTH;
        }
        NonDumbAxisABB nonDumbAxisABB5 = this;
        vec3d1 = nonDumbAxisABB5.collideWithZPlane(nonDumbAxisABB5.maxZ, vecA, vecB);
        if (vec3d1 != null && this.isClosest(vecA, vec3d, vec3d1)) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.SOUTH;
        }
        if (vec3d == null) {
            return null;
        }
        return new RayTraceResult(vec3d, enumfacing);
    }

    public NonDumbAxisABB setMaxY(double y2) {
        return new NonDumbAxisABB(this.minX, this.minY, this.minZ, this.maxX, y2, this.maxZ);
    }

    @SideOnly(value=Side.CLIENT)
    public NonDumbAxisABB(Vec3d min, Vec3d max) {
        this(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof NonDumbAxisABB)) {
            return false;
        }
        NonDumbAxisABB axisalignedbb = (NonDumbAxisABB)p_equals_1_;
        if (Double.compare(axisalignedbb.minX, this.minX) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.minY, this.minY) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.minZ, this.minZ) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.maxX, this.maxX) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.maxY, this.maxY) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.maxZ, this.maxZ) == 0) {
            return true;
        }
        return false;
    }

    public NonDumbAxisABB offset(Vec3d vec) {
        return this.offset(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    @VisibleForTesting
    public boolean intersectsWithXY(Vec3d vec) {
        if (vec.field_72450_a >= this.minX && vec.field_72450_a <= this.maxX && vec.field_72448_b >= this.minY && vec.field_72448_b <= this.maxY) {
            return true;
        }
        return false;
    }

    public NonDumbAxisABB offset(BlockPos pos) {
        return new NonDumbAxisABB(this.minX + (double)pos.func_177958_n(), this.minY + (double)pos.func_177956_o(), this.minZ + (double)pos.func_177952_p(), this.maxX + (double)pos.func_177958_n(), this.maxY + (double)pos.func_177956_o(), this.maxZ + (double)pos.func_177952_p());
    }

    public double calculateXOffset(NonDumbAxisABB other, double offsetX) {
        if (other.maxY > this.minY && other.minY < this.maxY && other.maxZ > this.minZ && other.minZ < this.maxZ) {
            if (offsetX > 0.0 && other.maxX <= this.minX) {
                double d;
                double d1 = this.minX - other.maxX;
                if (d < offsetX) {
                    offsetX = d1;
                }
            } else if (offsetX < 0.0 && other.minX >= this.maxX) {
                double d;
                double d0 = this.maxX - other.minX;
                if (d > offsetX) {
                    offsetX = d0;
                }
            }
            return offsetX;
        }
        return offsetX;
    }

    /*
     * WARNING - void declaration
     */
    public NonDumbAxisABB(double d, double d2, double d3, double d4, double d5, double d6) {
        void z2;
        void z1;
        void y2;
        void y1;
        void x2;
        void x1;
        NonDumbAxisABB nonDumbAxisABB = this;
        NonDumbAxisABB nonDumbAxisABB2 = this;
        NonDumbAxisABB nonDumbAxisABB3 = this;
        nonDumbAxisABB3.minX = Math.min((double)x1, (double)x2);
        nonDumbAxisABB3.minY = Math.min((double)y1, (double)y2);
        nonDumbAxisABB2.minZ = Math.min((double)z1, (double)z2);
        nonDumbAxisABB2.maxX = Math.max((double)x1, (double)x2);
        nonDumbAxisABB.maxY = Math.max((double)y1, (double)y2);
        nonDumbAxisABB.maxZ = Math.max(d3, (double)z2);
    }

    public NonDumbAxisABB grow(double value) {
        double d = value;
        return this.grow(d, d, d);
    }

    public NonDumbAxisABB(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
    }

    public double calculateZOffset(NonDumbAxisABB other, double offsetZ) {
        if (other.maxX > this.minX && other.minX < this.maxX && other.maxY > this.minY && other.minY < this.maxY) {
            if (offsetZ > 0.0 && other.maxZ <= this.minZ) {
                double d;
                double d1 = this.minZ - other.maxZ;
                if (d < offsetZ) {
                    offsetZ = d1;
                }
            } else if (offsetZ < 0.0 && other.minZ >= this.maxZ) {
                double d;
                double d0 = this.maxZ - other.minZ;
                if (d > offsetZ) {
                    offsetZ = d0;
                }
            }
            return offsetZ;
        }
        return offsetZ;
    }

    public double getAverageEdgeLength() {
        NonDumbAxisABB nonDumbAxisABB = this;
        double d0 = nonDumbAxisABB.maxX - this.minX;
        NonDumbAxisABB nonDumbAxisABB2 = this;
        double d1 = nonDumbAxisABB.maxY - nonDumbAxisABB2.minY;
        double d2 = nonDumbAxisABB2.maxZ - this.minZ;
        return (d0 + d1 + d2) / 3.0;
    }

    public NonDumbAxisABB shrink(double value) {
        return this.grow(-value);
    }

    public NonDumbAxisABB expand(double x, double y, double z) {
        double d;
        double d2;
        NonDumbAxisABB nonDumbAxisABB = this;
        double d0 = nonDumbAxisABB.minX;
        double d1 = nonDumbAxisABB.minY;
        double d22 = nonDumbAxisABB.minZ;
        double d3 = nonDumbAxisABB.maxX;
        double d4 = nonDumbAxisABB.maxY;
        double d5 = nonDumbAxisABB.maxZ;
        if (x < 0.0) {
            d0 += x;
            d2 = y;
        } else {
            if (x > 0.0) {
                d3 += x;
            }
            d2 = y;
        }
        if (d2 < 0.0) {
            d1 += y;
            d = z;
        } else {
            if (y > 0.0) {
                d4 += y;
            }
            d = z;
        }
        if (d < 0.0) {
            d22 += z;
        } else if (z > 0.0) {
            d5 += z;
        }
        return new NonDumbAxisABB(d0, d1, d22, d3, d4, d5);
    }

    @Nullable
    @VisibleForTesting
    Vec3d collideWithYPlane(double p_186663_1_, Vec3d p_186663_3_, Vec3d p_186663_4_) {
        Vec3d vec3d = p_186663_3_.func_72435_c(p_186663_4_, p_186663_1_);
        if (vec3d != null && this.intersectsWithXZ(vec3d)) {
            return vec3d;
        }
        return null;
    }

    public boolean contains(Vec3d vec) {
        if (vec.field_72450_a > this.minX && vec.field_72450_a < this.maxX) {
            if (vec.field_72448_b > this.minY && vec.field_72448_b < this.maxY) {
                if (vec.field_72449_c > this.minZ && vec.field_72449_c < this.maxZ) {
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasNaN() {
        if (Double.isNaN(this.minX) || Double.isNaN(this.minY) || Double.isNaN(this.minZ) || Double.isNaN(this.maxX) || Double.isNaN(this.maxY) || Double.isNaN(this.maxZ)) {
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public boolean intersectsWithYZ(Vec3d vec) {
        if (vec.field_72448_b >= this.minY && vec.field_72448_b <= this.maxY && vec.field_72449_c >= this.minZ && vec.field_72449_c <= this.maxZ) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public NonDumbAxisABB(AxisAlignedBB axisAlignedBB) {
        void axis;
        NonDumbAxisABB nonDumbAxisABB = this;
        void v1 = axis;
        NonDumbAxisABB nonDumbAxisABB2 = this;
        void v3 = axis;
        this.minX = v3.field_72340_a;
        nonDumbAxisABB2.minY = v3.field_72338_b;
        nonDumbAxisABB2.minZ = axis.field_72339_c;
        this.maxX = v1.field_72336_d;
        nonDumbAxisABB.maxY = v1.field_72337_e;
        nonDumbAxisABB.maxZ = axisAlignedBB.field_72334_f;
    }

    @VisibleForTesting
    boolean isClosest(Vec3d p_186661_1_, @Nullable Vec3d p_186661_2_, Vec3d p_186661_3_) {
        if (p_186661_2_ == null || p_186661_1_.func_72436_e(p_186661_3_) < p_186661_1_.func_72436_e(p_186661_2_)) {
            return true;
        }
        return false;
    }
}

