/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.utility;

import com.modularwarfare.ModConfig;
import com.modularwarfare.ModularWarfare;
import com.modularwarfare.common.guns.GunType;
import com.modularwarfare.common.guns.ItemBullet;
import com.modularwarfare.common.guns.ItemGun;
import com.modularwarfare.common.hitbox.PlayerHitbox;
import com.modularwarfare.common.hitbox.PlayerSnapshot;
import com.modularwarfare.common.hitbox.hits.BulletHit;
import com.modularwarfare.common.hitbox.hits.PlayerHit;
import com.modularwarfare.common.hitbox.playerdata.PlayerData;
import com.modularwarfare.common.hitbox.playerdata.PlayerDataHandler;
import com.modularwarfare.common.network.PacketGunTrail;
import com.modularwarfare.common.network.PacketPlaySound;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class RayUtil {
    public static boolean isLiving(Entity entity) {
        if (entity instanceof EntityLivingBase && !(entity instanceof EntityArmorStand)) {
            return true;
        }
        return false;
    }

    @Nullable
    public static BulletHit standardEntityRayTrace(World world, float rotationPitch, float rotationYaw, EntityLivingBase player, double range, ItemGun item, boolean isPunched) {
        int ping;
        HashSet<Entity> hashset = new HashSet<Entity>(1);
        hashset.add((Entity)player);
        float accuracy = RayUtil.calculateAccuracyServer(item, player);
        Vec3d dir = RayUtil.getGunAccuracy(rotationPitch, rotationYaw, accuracy, player.field_70170_p.field_73012_v);
        double dx = dir.field_72450_a * range;
        double dy = dir.field_72448_b * range;
        double dz = dir.field_72449_c * range;
        ModularWarfare.NETWORK.sendToDimension(new PacketGunTrail(player.field_70165_t, player.func_174813_aQ().field_72338_b + (double)player.func_70047_e() - (double)0.1f, player.field_70161_v, player.field_70159_w, player.field_70179_y, dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, range, 10.0f, isPunched), player.field_70170_p.field_73011_w.getDimension());
        boolean bl = false;
        if (player instanceof EntityPlayerMP) {
            ping = ((EntityPlayerMP)player).field_71138_i;
        }
        return RayUtil.tracePath(world, (float)player.field_70165_t, (float)(player.func_174813_aQ().field_72338_b + (double)player.func_70047_e() - (double)0.1f), (float)player.field_70161_v, (float)(player.field_70165_t + dx + player.field_70159_w), (float)(player.field_70163_u + dy + player.field_70181_x), (float)(player.field_70161_v + dz + player.field_70179_y), 0.001f, hashset, false, ping);
    }

    public static boolean attackEntityWithoutKnockback(Entity entity, DamageSource source, float amount) {
        Entity entity2 = entity;
        double vx = entity2.field_70159_w;
        double vy = entity2.field_70181_x;
        double vz = entity.field_70179_y;
        boolean succeeded = entity.func_70097_a(source, amount);
        entity.field_70159_w = vx;
        entity.field_70181_x = vy;
        entity.field_70179_y = vz;
        return succeeded;
    }

    @Nullable
    public static RayTraceResult rayTraceBlocks(World world, Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c))) {
            if (!(Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
                RayTraceResult raytraceresult;
                Vec3d vec3d = vec32;
                int i = MathHelper.func_76128_c((double)vec3d.field_72450_a);
                int j = MathHelper.func_76128_c((double)vec3d.field_72448_b);
                int k = MathHelper.func_76128_c((double)vec3d.field_72449_c);
                Vec3d vec3d2 = vec31;
                int l = MathHelper.func_76128_c((double)vec3d2.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)vec3d2.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)vec3d2.field_72449_c);
                BlockPos blockpos = new BlockPos(l, i1, j1);
                IBlockState iblockstate = world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if ((!ignoreBlockWithoutBoundingBox || iblockstate.func_185890_d((IBlockAccess)world, blockpos) != Block.field_185506_k) && block.func_176209_a(iblockstate, stopOnLiquid) && (raytraceresult = iblockstate.func_185910_a(world, blockpos, vec31, vec32)) != null) {
                    return raytraceresult;
                }
                RayTraceResult raytraceresult2 = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    Vec3d vec3d3;
                    EnumFacing enumfacing;
                    int n;
                    int n2;
                    if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        if (returnLastUncollidableBlock) {
                            return raytraceresult2;
                        }
                        return null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                        n2 = j;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                        n2 = j;
                    } else {
                        flag2 = false;
                        n2 = j;
                    }
                    if (n2 > i1) {
                        d1 = (double)i1 + 1.0;
                        n = k;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                        n = k;
                    } else {
                        flag = false;
                        n = k;
                    }
                    if (n > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    Vec3d vec3d4 = vec32;
                    double d6 = vec3d4.field_72450_a - vec31.field_72450_a;
                    double d7 = vec3d4.field_72448_b - vec31.field_72448_b;
                    double d8 = vec3d4.field_72449_c - vec31.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vec31.field_72450_a) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - vec31.field_72448_b) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - vec31.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        vec3d3 = new Vec3d(d0, vec31.field_72448_b + d7 * d3, vec31.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        vec3d3 = new Vec3d(vec31.field_72450_a + d6 * d4, d1, vec31.field_72449_c + d8 * d4);
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        vec3d3 = new Vec3d(vec31.field_72450_a + d6 * d5, vec31.field_72448_b + d7 * d5, d2);
                    }
                    l = MathHelper.func_76128_c((double)vec3d3.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)vec31.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)vec31.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos = new BlockPos(l, i1, j1);
                    IBlockState iblockstate1 = world.func_180495_p(blockpos);
                    Block block1 = iblockstate1.func_177230_c();
                    if (ModConfig.INSTANCE.canShotBreakGlass && (block1 instanceof BlockGlass || block1 instanceof BlockStainedGlassPane || block1 instanceof BlockStainedGlass)) {
                        world.func_175698_g(blockpos);
                        ModularWarfare.NETWORK.sendToAllAround(new PacketPlaySound(blockpos, "impact.glass", 1.0f, 1.0f), new NetworkRegistry.TargetPoint(0, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), 15.0));
                        return null;
                    }
                    if (block1 instanceof BlockDoor || block1 instanceof BlockLeaves) {
                        return null;
                    }
                    if (ignoreBlockWithoutBoundingBox && iblockstate1.func_185904_a() != Material.field_175972_I && iblockstate1.func_185904_a() != Material.field_151567_E && iblockstate1.func_185890_d((IBlockAccess)world, blockpos) == Block.field_185506_k) continue;
                    if (block1.func_176209_a(iblockstate1, stopOnLiquid)) {
                        RayTraceResult raytraceresult1 = iblockstate1.func_185910_a(world, blockpos, vec31, vec32);
                        if (raytraceresult1 == null) continue;
                        return raytraceresult1;
                    }
                    raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, vec31, enumfacing, blockpos);
                }
                if (returnLastUncollidableBlock) {
                    return raytraceresult2;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static float calculateAccuracyClient(ItemGun item, EntityPlayer player) {
        ItemBullet bullet;
        GunType gun = item.type;
        float acc = gun.bulletSpread;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        if (settings.field_74351_w.func_151470_d() || settings.field_74370_x.func_151470_d() || settings.field_74368_y.func_151470_d() || settings.field_74366_z.func_151470_d()) {
            acc += 0.75f;
        }
        if (!player.field_70122_E) {
            acc += 1.5f;
        }
        if (player.func_70051_ag()) {
            acc += 0.25f;
        }
        if (player.func_70093_af()) {
            acc *= gun.accuracySneakFactor;
        }
        if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemGun && (bullet = ItemGun.getUsedBullet(player.func_184614_ca(), ((ItemGun)player.func_184614_ca().func_77973_b()).type)) != null && bullet.type != null) {
            acc *= bullet.type.bulletAccuracyFactor;
        }
        return acc;
    }

    @Nullable
    public static BulletHit tracePath(World world, float x, float y, float z, float tx, float ty, float tz, float borderSize, HashSet<Entity> excluded, boolean collideablesOnly, int ping) {
        int i;
        Vec3d realVecEnd;
        Vec3d startVec = new Vec3d((double)x, (double)y, (double)z);
        Vec3d endVec = new Vec3d((double)tx, (double)ty, (double)tz);
        float minX = x < tx ? x : tx;
        float minY = y < ty ? y : ty;
        float minZ = z < tz ? z : tz;
        float maxX = x > tx ? x : tx;
        float maxY = y > ty ? y : ty;
        float maxZ = z > tz ? z : tz;
        AxisAlignedBB bb = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
        World world2 = world;
        List allEntities = world2.func_72839_b(null, bb);
        RayTraceResult blockHit = RayUtil.rayTraceBlocks(world2, startVec, endVec, true, true, false);
        startVec = new Vec3d((double)x, (double)y, (double)z);
        endVec = new Vec3d((double)tx, (double)ty, (double)tz);
        float maxDistance = (float)endVec.func_72438_d(startVec);
        if (blockHit != null) {
            RayTraceResult rayTraceResult = blockHit;
            maxDistance = (float)rayTraceResult.field_72307_f.func_72438_d(startVec);
            realVecEnd = rayTraceResult.field_72307_f;
        } else {
            realVecEnd = endVec;
        }
        int n = i = 0;
        while (n < world.field_72996_f.size()) {
            Entity obj = (Entity)world.field_72996_f.get(i);
            if ((excluded != null && !excluded.contains(obj) || excluded == null) && obj instanceof EntityPlayer) {
                PlayerSnapshot snapshot;
                PlayerData data = PlayerDataHandler.getPlayerData((EntityPlayer)obj);
                int snapshotToTry = ping / 50;
                if (snapshotToTry >= data.snapshots.length) {
                    snapshotToTry = data.snapshots.length - 1;
                }
                if ((snapshot = data.snapshots[snapshotToTry]) == null) {
                    snapshot = data.snapshots[0];
                }
                for (PlayerHitbox hitbox : snapshot.hitboxes) {
                    RayTraceResult intercept = hitbox.getAxisAlignedBB(snapshot.pos).func_72327_a(startVec, realVecEnd);
                    if (intercept == null) continue;
                    intercept.field_72308_g = hitbox.player;
                    return new PlayerHit(hitbox, intercept);
                }
            }
            n = ++i;
        }
        Entity closestHitEntity = null;
        Vec3d hit = null;
        float closestHit = maxDistance;
        float currentHit = 0.0f;
        for (Entity ent : allEntities) {
            RayTraceResult intercept;
            if (!ent.func_70067_L() && collideablesOnly || (excluded == null || excluded.contains(ent)) && excluded != null || !(ent instanceof EntityLivingBase) || ent instanceof EntityPlayer) continue;
            EntityLivingBase entityLivingBase = (EntityLivingBase)ent;
            if (ent.field_70128_L || !(entityLivingBase.func_110143_aJ() > 0.0f)) continue;
            Entity entity = ent;
            float entBorder = entity.func_70111_Y();
            AxisAlignedBB entityBb = entity.func_174813_aQ();
            if (entityBb == null || (intercept = (entityBb = entityBb.func_72314_b((double)entBorder, (double)entBorder, (double)entBorder)).func_72327_a(startVec, endVec)) == null) continue;
            RayTraceResult rayTraceResult = intercept;
            currentHit = (float)rayTraceResult.field_72307_f.func_72438_d(startVec);
            hit = rayTraceResult.field_72307_f;
            if (!(currentHit < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            closestHitEntity = ent;
        }
        if (closestHitEntity != null && hit != null) {
            blockHit = new RayTraceResult(closestHitEntity, hit);
        }
        return new BulletHit(blockHit);
    }

    public static Vec3d getGunAccuracy(float pitch, float yaw, float accuracy, Random rand) {
        Random random = rand;
        float randAccPitch = random.nextFloat() * accuracy;
        float randAccYaw = random.nextFloat() * accuracy;
        float f = MathHelper.func_76134_b((float)(-(yaw += rand.nextBoolean() ? randAccYaw : -randAccYaw) * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.func_76134_b((float)(-(pitch += rand.nextBoolean() ? randAccPitch : -randAccPitch) * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f2 * f3), (double)f4, (double)(f * f3));
    }

    public static float calculateAccuracyServer(ItemGun item, EntityLivingBase player) {
        ItemBullet bullet;
        GunType gun = item.type;
        float acc = gun.bulletSpread;
        if (player.field_70165_t != player.field_70142_S || player.field_70161_v != player.field_70136_U) {
            acc += 0.75f;
        }
        if (!player.field_70122_E) {
            acc += 1.5f;
        }
        if (player.func_70051_ag()) {
            acc += 0.25f;
        }
        if (player.func_70093_af()) {
            acc *= gun.accuracySneakFactor;
        }
        if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemGun && (bullet = ItemGun.getUsedBullet(player.func_184614_ca(), ((ItemGun)player.func_184614_ca().func_77973_b()).type)) != null && bullet.type != null) {
            acc *= bullet.type.bulletAccuracyFactor;
        }
        return acc;
    }
}

