/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.utility;

import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;

public class RenderHelperMW {
    private static final DecimalFormat energyValue = new DecimalFormat("###,###,###,###,###");

    public static void drawHoveringText(List list, int x, int y, FontRenderer font, int guiWidth, int guiHeight) {
        GuiUtils.drawHoveringText((List)list, (int)x, (int)y, (int)guiWidth, (int)guiHeight, (int)-1, (FontRenderer)font);
    }

    public static String formatNumber(long value) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        if (value < 1000000L) {
            return (double)Math.round(value) / 1000.0 + "K";
        }
        if (value < 1000000000L) {
            return (double)Math.round(value / 1000L) / 1000.0 + "M";
        }
        if (value < 1000000000000L) {
            return (double)Math.round(value / 1000000L) / 1000.0 + "G";
        }
        if (value < 1000000000000000L) {
            return (double)Math.round(value / 1000000000L) / 1000.0 + "T";
        }
        if (value < 1000000000000000000L) {
            return (double)Math.round(value / 1000000000000L) / 1000.0 + "P";
        }
        if (value <= Long.MAX_VALUE) {
            return (double)Math.round(value / 1000000000000000L) / 1000.0 + "E";
        }
        return "Something is very broken!!!!";
    }

    /*
     * WARNING - void declaration
     */
    public static void drawColouredRect(int n, int n2, int n3, int n4, int n5) {
        void ySize;
        void posY;
        void xSize;
        void colour;
        int posX;
        int n6 = posX;
        void v1 = colour;
        RenderHelperMW.drawGradientRect(n6, n2, n6 + xSize, (int)(posY + ySize), (int)v1, (int)v1, 1.0f, 0.0);
    }

    /*
     * WARNING - void declaration
     */
    public static void renderLine(double posX, double posY, double posZ, double posX2, double posY2, double posZ2, int givenColor, float width) {
        void alpha;
        Minecraft mc = Minecraft.func_71410_x();
        float red = (float)(givenColor >> 16 & 0xFF) / 255.0f;
        float blue = (float)(givenColor >> 8 & 0xFF) / 255.0f;
        float green = (float)(givenColor & 0xFF) / 255.0f;
        float f = (float)(givenColor >> 24 & 0xFF) / 255.0f;
        Minecraft minecraft = mc;
        double d0 = minecraft.field_71439_g.field_70169_q + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70169_q);
        Minecraft minecraft2 = mc;
        double d2 = minecraft.field_71439_g.field_70167_r + (minecraft2.field_71439_g.field_70163_u - mc.field_71439_g.field_70167_r);
        double d3 = minecraft2.field_71439_g.field_70166_s + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70166_s);
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glLineWidth((float)width);
        GL11.glTranslated((double)(-d0), (double)(-d2), (double)(-d3));
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)posX, (double)posY, (double)posZ);
        GL11.glVertex3d((double)posX2, (double)posY2, (double)posZ2);
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    public static void renderCenteredTextScaledWithOutline(String text, int posX, int posY, double par4, int givenColor) {
        Minecraft mc = Minecraft.func_71410_x();
        double width = (double)(mc.field_71466_p.func_78256_a(text) / 2) * par4;
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)posX - width), (double)posY, (double)0.0);
        double d = par4;
        GL11.glScaled((double)d, (double)d, (double)d);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, -1, -1, 0);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, 1, -1, 0);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, -1, 1, 0);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, 1, 1, 0);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, 0, -1, 0);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, -1, 0, 0);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, 1, 0, 0);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, 0, 1, 0);
        mc.field_71466_p.func_78276_b(text, 0, 0, givenColor);
        GL11.glPopMatrix();
    }

    public static void renderPositionedImageNoDepth(ResourceLocation par1, double par2, double par3, double par4, float par5, float width, float height) {
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        RenderHelperMW.renderPositionedImage(par1, par2, par3, par4, par5, width, height);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    public static void renderRect(int givenPosX, int givenPosY, int givenWidth, int givenHeight, int givenColor) {
        GL11.glPushMatrix();
        givenWidth = givenPosX + givenWidth;
        givenHeight = givenPosY + givenHeight;
        if (givenPosX < givenWidth) {
            int n = givenPosX;
            givenPosX = givenWidth;
            givenWidth = n;
        }
        if (givenPosY < givenHeight) {
            int n = givenPosY;
            givenPosY = givenHeight;
            givenHeight = n;
        }
        float f = (float)(givenColor >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(givenColor >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(givenColor & 0xFF) / 255.0f;
        float f3 = (float)(givenColor >> 24 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        BufferBuilder bufferBuilder = bufferbuilder;
        int n = givenWidth;
        BufferBuilder bufferBuilder2 = bufferbuilder;
        bufferBuilder2.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferBuilder2.func_181662_b((double)givenPosX, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)n, (double)givenHeight, 0.0).func_181675_d();
        bufferBuilder.func_181662_b((double)n, (double)givenPosY, 0.0).func_181675_d();
        bufferBuilder.func_181662_b((double)givenPosX, (double)givenPosY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GL11.glPopMatrix();
    }

    public static boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        if (mouseX >= x && mouseX < x + xSize && mouseY >= y && mouseY < y + ySize) {
            return true;
        }
        return false;
    }

    public static void renderImageCenteredScaled(double givenX, double givenY, ResourceLocation givenTexture, double givenWidth, double givenHeight, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)givenX, (double)givenY, (double)0.0);
        double d = givenScale;
        GL11.glScaled((double)d, (double)d, (double)d);
        RenderHelperMW.renderImageCentered(givenX - givenWidth / 2.0, givenY, givenTexture, givenWidth, givenHeight);
        GL11.glPopMatrix();
    }

    public static String formatNumber(double value) {
        if (value < 1000.0) {
            return String.valueOf(value);
        }
        if (value < 1000000.0) {
            return (double)Math.round(value) / 1000.0 + "K";
        }
        if (value < 1.0E9) {
            return (double)Math.round(value / 1000.0) / 1000.0 + "M";
        }
        if (value < 1.0E12) {
            return (double)Math.round(value / 1000000.0) / 1000.0 + "B";
        }
        return (double)Math.round(value / 1.0E9) / 1000.0 + "T";
    }

    /*
     * WARNING - void declaration
     */
    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        void buffer;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        void v1 = buffer;
        int n = x;
        void v3 = buffer;
        v3.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        v3.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        buffer.func_181662_b((double)(n + width), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        v1.func_181662_b((double)(n + width), (double)(y + 0), 0.0).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        v1.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderPlayer(int x, int y, float givenScale, float givenRotation) {
        GL11.glPushMatrix();
        GL11.glPopMatrix();
    }

    public static String addCommas(int value) {
        return energyValue.format(value);
    }

    /*
     * WARNING - void declaration
     */
    public static void renderImageSpecial(double x, double y, double i, double j, double k, double l, float alpha, ResourceLocation image) {
        void he;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        double w = i;
        double h = j;
        double we = k;
        double d = l;
        BufferBuilder bufferBuilder = bufferbuilder;
        double d2 = x;
        BufferBuilder bufferBuilder2 = bufferbuilder;
        bufferBuilder2.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder2.func_181662_b(x + w, y + he, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(d2 + we, y + he, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferBuilder.func_181662_b(d2 + we, y + h, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(x + w, y + h, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
    }

    public static void renderPlayerHead(String playerName, int xPos, int yPos, String givenPlayerUUID) {
        ResourceLocation resourceLocation = new ResourceLocation("textures/hologram/steve.png");
        if (playerName.length() > 0) {
            RenderHelperMW.getDownloadImageSkin(resourceLocation, givenPlayerUUID);
        }
        GL11.glPushMatrix();
        RenderHelperMW.renderRect(xPos - 1, yPos - 1, 20, 21, 0x44000000);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resourceLocation);
        GL11.glTranslated((double)xPos, (double)yPos, (double)30.0);
        GL11.glScaled((double)0.75, (double)0.39, (double)0.0);
        double scale = 0.75;
        GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71456_v.func_73729_b(0, 0, 32, 64, 32, 64);
        Minecraft.func_71410_x().field_71456_v.func_73729_b(0, 0, 160, 64, 32, 64);
        GL11.glPopMatrix();
    }

    public static void renderTextWithShadow(String text, int posX, int posY, int color) {
        Minecraft.func_71410_x().field_71466_p.func_175063_a(text, (float)posX, (float)posY, color);
    }

    public static void renderPositionedImage(ResourceLocation par1, double par2, double par3, double par4, float par5, float width, float height) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-mc.func_175598_ae().field_78730_l), (double)(-mc.func_175598_ae().field_78731_m), (double)(-mc.func_175598_ae().field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        EntityPlayerSP entityPlayerSP = player;
        GL11.glRotatef((float)(-entityPlayerSP.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)entityPlayerSP.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelperMW.renderImage(-width / 2.0f, -height / 2.0f, par1, width, height);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    /*
     * WARNING - void declaration
     */
    public static void drawNameplate(FontRenderer fontRendererIn, String str, float x, float y, float z, int verticalShift, float viewerYaw, float viewerPitch, boolean isThirdPersonFrontal, boolean isSneaking) {
        void bufferbuilder;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-viewerYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(isThirdPersonFrontal ? -1 : 1) * viewerPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        if (!isSneaking) {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int i = fontRendererIn.func_78256_a(str) / 2;
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        void v1 = bufferbuilder;
        int n = i;
        void v3 = bufferbuilder;
        v3.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        v3.func_181662_b((double)(-i - 1), (double)(-1 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        bufferbuilder.func_181662_b((double)(-n - 1), (double)(8 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        v1.func_181662_b((double)(n + 1), (double)(8 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        v1.func_181662_b((double)(i + 1), (double)(-1 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        if (!isSneaking) {
            FontRenderer fontRenderer = fontRendererIn;
            fontRenderer.func_78276_b(str, -fontRenderer.func_78256_a(str) / 2, verticalShift, 0x20FFFFFF);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179132_a((boolean)true);
        FontRenderer fontRenderer = fontRendererIn;
        fontRenderer.func_78276_b(str, -fontRenderer.func_78256_a(str) / 2, verticalShift, isSneaking ? 0x20FFFFFF : -1);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    /*
     * WARNING - void declaration
     */
    public static void drawGradientRect(int left, int top, int right, int bottom, int colour1, int colour2, float fade, double zLevel) {
        void vertexbuffer;
        float f = (float)(colour1 >> 24 & 0xFF) / 255.0f * fade;
        float f1 = (float)(colour1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colour1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colour1 & 0xFF) / 255.0f;
        float f4 = (float)(colour2 >> 24 & 0xFF) / 255.0f * fade;
        float f5 = (float)(colour2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colour2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colour2 & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        void v1 = vertexbuffer;
        int n = left;
        void v3 = vertexbuffer;
        v3.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        v3.func_181662_b((double)right, (double)top, zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b((double)n, (double)top, zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        v1.func_181662_b((double)n, (double)bottom, zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        v1.func_181662_b((double)right, (double)bottom, zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void renderCenteredTextWithShadow(String text, int posX, int posY, int color) {
        Minecraft minecraft = Minecraft.func_71410_x();
        String string = text;
        RenderHelperMW.renderTextWithShadow(string, posX - minecraft.field_71466_p.func_78256_a(string) / 2, posY, color);
    }

    public static void renderRectWithOutline(int givenPosX, int givenPosY, int givenWidth, int givenHeight, int givenColor, int givenOutlineColor, int outlineThickness) {
        GL11.glPushMatrix();
        RenderHelperMW.renderRect(givenPosX - outlineThickness, givenPosY - outlineThickness, givenWidth + outlineThickness * 2, givenHeight + outlineThickness * 2, givenOutlineColor);
        RenderHelperMW.renderRect(givenPosX, givenPosY, givenWidth, givenHeight, givenColor);
        GL11.glPopMatrix();
    }

    /*
     * WARNING - void declaration
     */
    public static void renderRectWithGradient(int givenPosX, int givenPosY, int givenWidth, int givenHeight, int startColor, int endColor, double givenZLevel) {
        void bufferbuilder;
        GL11.glPushMatrix();
        givenWidth = givenPosX + givenWidth;
        givenHeight = givenPosY + givenHeight;
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        void v1 = bufferbuilder;
        int n = givenPosX;
        void v3 = bufferbuilder;
        v3.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        v3.func_181662_b((double)givenWidth, (double)givenPosY, givenZLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)n, (double)givenPosY, givenZLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        v1.func_181662_b((double)n, (double)givenHeight, givenZLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        v1.func_181662_b((double)givenWidth, (double)givenHeight, givenZLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GL11.glPopMatrix();
    }

    private static final /* synthetic */ String pad(String s) {
        if (s.length() == 1) {
            return new StringBuilder().insert(0, "0").append(s).toString();
        }
        return s;
    }

    public static void renderCenteredTextScaled(String text, int posX, int posY, int color, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)0.0);
        double d = givenScale;
        GL11.glScaled((double)d, (double)d, (double)d);
        RenderHelperMW.renderCenteredText(text, 0, 0, color);
        GL11.glPopMatrix();
    }

    public static void renderPositionedTextInView(String par1, double par2, double par3, double par4, float par5) {
        RenderHelperMW.renderPositionedTextInView(par1, par2, par3, par4, par5, 1.0f);
    }

    public static void renderPositionedTextScaled(String givenText, double par2, double par3, double par4, float par5, int givenColor) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-mc.func_175598_ae().field_78730_l), (double)(-mc.func_175598_ae().field_78731_m), (double)(-mc.func_175598_ae().field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        EntityPlayerSP entityPlayerSP = player;
        GL11.glRotatef((float)(-entityPlayerSP.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)entityPlayerSP.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelperMW.renderCenteredTextScaled(givenText, 0, 0, givenColor, par5);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void renderImage(double x, double y, ResourceLocation image, double width, double height) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        BufferBuilder bufferBuilder = bufferbuilder;
        double d = x;
        BufferBuilder bufferBuilder2 = bufferbuilder;
        bufferBuilder2.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder2.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(d + width, y + height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferBuilder.func_181662_b(d + width, y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
    }

    public static long getTime() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    public static void renderImageCentered(double givenX, double givenY, ResourceLocation givenTexture, double givenWidth, double givenHeight) {
        GL11.glPushMatrix();
        RenderHelperMW.renderImage(givenX - givenWidth / 2.0, givenY, givenTexture, givenWidth, givenHeight);
        GL11.glPopMatrix();
    }

    /*
     * WARNING - void declaration
     */
    public static void drawTextInWorld(Minecraft minecraft, RenderManager renderManager, String string, double d, double d2, double d3, int n, int n2, float f) {
        void color;
        void backgroundColour;
        void scale;
        void z;
        void y;
        void x;
        void text;
        void renderManager2;
        void v0 = renderManager2;
        int strWidth = v0.func_78716_a().func_78256_a((String)text);
        int strCenter = strWidth / 2;
        int yOffset = -4;
        GL11.glPushMatrix();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-v0.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)v0.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-0.025f * scale), (float)(-0.025f * scale), (float)(0.025f * scale));
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        RenderHelperMW.drawColouredRect(-strCenter - 1, yOffset - 1, strWidth + 1, 9, (int)backgroundColour);
        minecraft.field_71466_p.func_78276_b((String)text, -strCenter, yOffset, (int)color);
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    /*
     * WARNING - void declaration
     */
    public static void renderTextWithOutline(String string, int n, int n2, int n3, int n4) {
        void color;
        void outlineColor;
        void y;
        void x;
        String text;
        String string2 = text;
        void v1 = x;
        String string3 = text;
        void v3 = x;
        String string4 = text;
        void v5 = x;
        RenderHelperMW.renderText(text, (int)(v5 - true), (int)(y + true), (int)outlineColor);
        RenderHelperMW.renderText(string4, (int)v5, (int)(y + true), (int)outlineColor);
        RenderHelperMW.renderText(string4, (int)(x + true), (int)(y + true), (int)outlineColor);
        RenderHelperMW.renderText(text, (int)(v3 - true), (int)y, (int)outlineColor);
        RenderHelperMW.renderText(string3, (int)(v3 + true), (int)y, (int)outlineColor);
        RenderHelperMW.renderText(string3, (int)(x - true), (int)(y - true), (int)outlineColor);
        RenderHelperMW.renderText(text, (int)v1, (int)(y - true), (int)outlineColor);
        RenderHelperMW.renderText(string2, (int)(v1 + true), (int)(y - true), (int)outlineColor);
        RenderHelperMW.renderText(string2, n, (int)y, (int)color);
    }

    public static String addCommas(long value) {
        return energyValue.format(value);
    }

    public static void renderCenteredTextScaledWithShadow(String text, int posX, int posY, int color, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)0.0);
        double d = givenScale;
        GL11.glScaled((double)d, (double)d, (double)d);
        RenderHelperMW.renderCenteredTextWithShadow(text, 0, 0, color);
        GL11.glPopMatrix();
    }

    public static int toHex(Color color) {
        Color color2 = color;
        String alpha = RenderHelperMW.pad(Integer.toHexString(color2.getAlpha()));
        String red = RenderHelperMW.pad(Integer.toHexString(color2.getRed()));
        String green = RenderHelperMW.pad(Integer.toHexString(color2.getGreen()));
        String blue = RenderHelperMW.pad(Integer.toHexString(color2.getBlue()));
        return Integer.parseInt(new StringBuilder().insert(0, "0x").append(alpha).append(red).append(green).append(blue).toString(), 16);
    }

    /*
     * WARNING - void declaration
     */
    public static void renderTextScaledWithOutline(String string, int n, int n2, int n3, int n4, double d) {
        void color;
        void givenScale;
        void outlineColor;
        void y;
        void x;
        String text;
        String string2 = text;
        void v1 = x;
        String string3 = text;
        void v3 = x;
        String string4 = text;
        void v5 = x;
        RenderHelperMW.renderTextScaled(text, (int)(v5 - true), (int)(y + true), (int)outlineColor, (double)givenScale);
        RenderHelperMW.renderTextScaled(string4, (int)v5, (int)(y + true), (int)outlineColor, (double)givenScale);
        RenderHelperMW.renderTextScaled(string4, (int)(x + true), (int)(y + true), (int)outlineColor, (double)givenScale);
        RenderHelperMW.renderTextScaled(text, (int)(v3 - true), (int)y, (int)outlineColor, (double)givenScale);
        RenderHelperMW.renderTextScaled(string3, (int)(v3 + true), (int)y, (int)outlineColor, (double)givenScale);
        RenderHelperMW.renderTextScaled(string3, (int)(x - true), (int)(y - true), (int)outlineColor, (double)givenScale);
        RenderHelperMW.renderTextScaled(text, (int)v1, (int)(y - true), (int)outlineColor, (double)givenScale);
        RenderHelperMW.renderTextScaled(string2, (int)(v1 + true), (int)(y - true), (int)outlineColor, (double)givenScale);
        RenderHelperMW.renderTextScaled(string2, n, (int)y, (int)color, (double)givenScale);
    }

    public static ThreadDownloadImageData getDownloadImageSkin(ResourceLocation resourceLocationIn, String givenUUID) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        ITextureObject object = texturemanager.func_110581_b(resourceLocationIn);
        if (object == null) {
            Object[] objectArray = new Object[1];
            objectArray[0] = StringUtils.func_76338_a((String)givenUUID);
            object = new ThreadDownloadImageData(null, String.format("https://crafatar.com/skins/%s.png", objectArray), new ResourceLocation("textures/hologram/steve.png"), (IImageBuffer)new ImageBufferDownload());
            texturemanager.func_110579_a(resourceLocationIn, object);
        }
        return (ThreadDownloadImageData)object;
    }

    public static void renderCenteredText(String text, int posX, int posY, int color) {
        Minecraft minecraft = Minecraft.func_71410_x();
        String string = text;
        RenderHelperMW.renderText(string, posX - minecraft.field_71466_p.func_78256_a(string) / 2, posY, color);
    }

    public static void renderText(String text, int posX, int posY, int color) {
        Minecraft.func_71410_x().field_71466_p.func_78276_b(text, posX, posY, color);
    }

    public static void renderTextScaled(String text, int posX, int posY, int color, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)0.0);
        double d = givenScale;
        GL11.glScaled((double)d, (double)d, (double)d);
        RenderHelperMW.renderText(text, 0, 0, color);
        GL11.glPopMatrix();
    }

    /*
     * WARNING - void declaration
     */
    public static void renderPositionedTextInView(String par1, double par2, double par3, double par4, float par5, float alpha) {
        void width;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        Minecraft minecraft = mc;
        GL11.glTranslated((double)(-mc.func_175598_ae().field_78730_l), (double)(-minecraft.func_175598_ae().field_78731_m), (double)(-mc.func_175598_ae().field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int n = minecraft.field_71466_p.func_78256_a(par1);
        EntityPlayerSP entityPlayerSP = player;
        GL11.glRotatef((float)(-entityPlayerSP.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)entityPlayerSP.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.01f, (float)-0.01f, (float)0.01f);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        java.awt.Color color = new java.awt.Color(1.0f, 1.0f, 1.0f, alpha);
        mc.field_71466_p.func_78276_b(par1, (int)(-(width / 2)), 0, color.getRGB());
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    /*
     * WARNING - void declaration
     */
    public static void renderCenteredTextWithOutline(String text, int x, int y, int color, int outlineColor) {
        void fr;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int n = x;
        String string = text;
        RenderHelperMW.renderText(string, n - 1 - fontRenderer.func_78256_a(string) / 2, y + 1, outlineColor);
        String string2 = text;
        RenderHelperMW.renderText(string2, n - fontRenderer.func_78256_a(string2) / 2, y + 1, outlineColor);
        String string3 = text;
        RenderHelperMW.renderText(string3, n + 1 - fontRenderer.func_78256_a(string3) / 2, y + 1, outlineColor);
        String string4 = text;
        RenderHelperMW.renderText(string4, n - 1 - fontRenderer.func_78256_a(string4) / 2, y, outlineColor);
        String string5 = text;
        RenderHelperMW.renderText(string5, n + 1 - fontRenderer.func_78256_a(string5) / 2, y, outlineColor);
        String string6 = text;
        RenderHelperMW.renderText(string6, n - 1 - fontRenderer.func_78256_a(string6) / 2, y - 1, outlineColor);
        String string7 = text;
        RenderHelperMW.renderText(string7, n - fontRenderer.func_78256_a(string7) / 2, y - 1, outlineColor);
        String string8 = text;
        RenderHelperMW.renderText(string8, n + 1 - fontRenderer.func_78256_a(string8) / 2, y - 1, outlineColor);
        String string9 = text;
        RenderHelperMW.renderText(string9, n - fr.func_78256_a(string9) / 2, y, color);
    }

    public static void drawTextInWorld(Minecraft mc, RenderManager renderManager, String text, double x, double y, double z, int color) {
        RenderHelperMW.drawTextInWorld(mc, renderManager, text, x, y, z, color, 0x7F000000, 1.0f);
    }

    public static void renderBackgroundImage(double offsx, double offsy, int width, int height, float brightness, ResourceLocation background) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        float f = brightness;
        GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(background);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        BufferBuilder bufferBuilder = bufferbuilder;
        double d = offsx;
        BufferBuilder bufferBuilder2 = bufferbuilder;
        bufferBuilder2.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder2.func_181662_b(offsx, offsy + (double)height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(d + (double)width, offsy + (double)height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferBuilder.func_181662_b(d + (double)width, offsy, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(offsx, offsy, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void renderMainMenuPlayer(int width, int height, float offsetx, float offsety, int par1, int par2) {
    }

    public static void renderTranspImage(double x, double y, ResourceLocation image, double width, double height) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        BufferBuilder bufferBuilder = bufferbuilder;
        double d = x;
        BufferBuilder bufferBuilder2 = bufferbuilder;
        bufferBuilder2.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder2.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(d + width, y + height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferBuilder.func_181662_b(d + width, y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
    }

    public static void renderImageAlpha(double x, double y, ResourceLocation image, double width, double height, double alpha) {
        GL11.glColor4d((double)255.0, (double)255.0, (double)255.0, (double)alpha);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        BufferBuilder bufferBuilder = bufferbuilder;
        double d = x;
        BufferBuilder bufferBuilder2 = bufferbuilder;
        bufferBuilder2.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder2.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(d + width, y + height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferBuilder.func_181662_b(d + width, y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
    }

    public static void renderCenteredTextScaledWithOutlineFade(String text, int posX, int posY, double par4, int givenColor, double givenFade) {
        Minecraft mc = Minecraft.func_71410_x();
        double width = (double)(mc.field_71466_p.func_78256_a(text) / 2) * par4;
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)posX - width), (double)posY, (double)0.0);
        double d = par4;
        GL11.glScaled((double)d, (double)d, (double)d);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, -1, -1, 0);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, 1, -1, 0);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, -1, 1, 0);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, 1, 1, 0);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, 0, -1, 0);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, -1, 0, 0);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, 1, 0, 0);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, 0, 1, 0);
        mc.field_71466_p.func_78276_b(text, 0, 0, givenColor);
        GL11.glPopMatrix();
    }
}

