/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.core;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.CentralDirectory;
import net.lingala.zip4j.model.DigitalSignature;
import net.lingala.zip4j.model.EndCentralDirRecord;
import net.lingala.zip4j.model.ExtraDataRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.Zip64EndCentralDirLocator;
import net.lingala.zip4j.model.Zip64EndCentralDirRecord;
import net.lingala.zip4j.model.Zip64ExtendedInfo;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.util.Raw;
import net.lingala.zip4j.util.Zip4jUtil;

public class HeaderReader {
    private RandomAccessFile zip4jRaf;
    private ZipModel zipModel;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ ArrayList readExtraDataRecords(int extraFieldLength) throws ZipException {
        if (extraFieldLength <= 0) {
            return null;
        }
        try {
            void v1;
            void extraDataList;
            block9: {
                byte[] extraFieldBuf = new byte[extraFieldLength];
                this.zip4jRaf.read(extraFieldBuf);
                int counter = 0;
                ArrayList arrayList = new ArrayList();
                int n = counter;
                while (n < extraFieldLength) {
                    ExtraDataRecord extraDataRecord = new ExtraDataRecord();
                    extraDataRecord.setHeader(Raw.readShortLittleEndian(extraFieldBuf, counter));
                    int sizeOfRec = Raw.readShortLittleEndian(extraFieldBuf, counter += 2);
                    if (2 + sizeOfRec > extraFieldLength) {
                        sizeOfRec = Raw.readShortBigEndian(extraFieldBuf, counter);
                        if (2 + sizeOfRec > extraFieldLength) {
                            v1 = extraDataList;
                            break block9;
                        }
                    }
                    extraDataRecord.setSizeOfData(sizeOfRec);
                    counter += 2;
                    if (sizeOfRec > 0) {
                        void data;
                        byte[] byArray = new byte[sizeOfRec];
                        void v2 = data;
                        System.arraycopy(extraFieldBuf, counter, v2, 0, sizeOfRec);
                        extraDataRecord.setData((byte[])v2);
                    }
                    n = counter = counter + sizeOfRec;
                    extraDataList.add(extraDataRecord);
                }
                v1 = extraDataList;
            }
            if (v1.size() > 0) {
                return extraDataList;
            }
            return null;
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
    }

    private /* synthetic */ void readAndSaveExtraDataRecord(FileHeader fileHeader) throws ZipException {
        if (this.zip4jRaf == null) {
            throw new ZipException("invalid file handler when trying to read extra data record");
        }
        if (fileHeader == null) {
            throw new ZipException("file header is null");
        }
        int extraFieldLength = fileHeader.getExtraFieldLength();
        if (extraFieldLength <= 0) {
            return;
        }
        fileHeader.setExtraDataRecords(this.readExtraDataRecords(extraFieldLength));
    }

    /*
     * Unable to fully structure code
     */
    public ZipModel readAllHeaders(String fileNameCharset) throws ZipException {
        v0 = this;
        v0.zipModel = new ZipModel();
        this.zipModel.setFileNameCharset(fileNameCharset);
        v0.zipModel.setEndCentralDirRecord(this.readEndOfCentralDirectoryRecord());
        v0.zipModel.setZip64EndCentralDirLocator(this.readZip64EndCentralDirLocator());
        if (!v0.zipModel.isZip64Format()) ** GOTO lbl19
        v1 = this;
        this.zipModel.setZip64EndCentralDirRecord(v1.readZip64EndCentralDirRec());
        if (v1.zipModel.getZip64EndCentralDirRecord() != null && this.zipModel.getZip64EndCentralDirRecord().getNoOfThisDisk() > 0) {
            v2 = this;
            v3 = v2;
            v2.zipModel.setSplitArchive(true);
        } else {
            this.zipModel.setSplitArchive(false);
lbl19:
            // 2 sources

            v3 = this;
        }
        v3.zipModel.setCentralDirectory(this.readCentralDirectory());
        return this.zipModel;
    }

    private /* synthetic */ byte[] readIntoBuff(RandomAccessFile zip4jRaf, byte[] buf) throws ZipException {
        block3: {
            try {
                if (zip4jRaf.read(buf, 0, buf.length) == -1) break block3;
                return buf;
            }
            catch (IOException e) {
                throw new ZipException("IOException when reading short buff", e);
            }
        }
        throw new ZipException("unexpected end of file when reading short buff");
    }

    private /* synthetic */ Zip64ExtendedInfo readZip64ExtendedInfo(ArrayList extraDataRecords, long unCompressedSize, long compressedSize, long offsetLocalHeader, int diskNumberStart) throws ZipException {
        int i;
        int n = i = 0;
        while (n < extraDataRecords.size()) {
            ExtraDataRecord extraDataRecord = (ExtraDataRecord)extraDataRecords.get(i);
            if (extraDataRecord != null && extraDataRecord.getHeader() == 1L) {
                long val;
                Zip64ExtendedInfo zip64ExtendedInfo = new Zip64ExtendedInfo();
                ExtraDataRecord extraDataRecord2 = extraDataRecord;
                byte[] byteBuff = extraDataRecord2.getData();
                if (extraDataRecord2.getSizeOfData() <= 0) break;
                byte[] longByteBuff = new byte[8];
                byte[] intByteBuff = new byte[4];
                int counter = 0;
                boolean valueAdded = false;
                if ((unCompressedSize & 0xFFFFL) == 65535L && counter < extraDataRecord.getSizeOfData()) {
                    System.arraycopy(byteBuff, counter, longByteBuff, 0, 8);
                    counter += 8;
                    val = Raw.readLongLittleEndian(longByteBuff, 0);
                    zip64ExtendedInfo.setUnCompressedSize(val);
                    valueAdded = true;
                }
                if ((compressedSize & 0xFFFFL) == 65535L && counter < extraDataRecord.getSizeOfData()) {
                    System.arraycopy(byteBuff, counter, longByteBuff, 0, 8);
                    counter += 8;
                    val = Raw.readLongLittleEndian(longByteBuff, 0);
                    zip64ExtendedInfo.setCompressedSize(val);
                    valueAdded = true;
                }
                if ((offsetLocalHeader & 0xFFFFL) == 65535L && counter < extraDataRecord.getSizeOfData()) {
                    System.arraycopy(byteBuff, counter, longByteBuff, 0, 8);
                    counter += 8;
                    val = Raw.readLongLittleEndian(longByteBuff, 0);
                    zip64ExtendedInfo.setOffsetLocalHeader(val);
                    valueAdded = true;
                }
                if ((diskNumberStart & 0xFFFF) == 65535 && counter < extraDataRecord.getSizeOfData()) {
                    System.arraycopy(byteBuff, counter, intByteBuff, 0, 4);
                    counter += 8;
                    int val2 = Raw.readIntLittleEndian(intByteBuff, 0);
                    zip64ExtendedInfo.setDiskNumberStart(val2);
                    valueAdded = true;
                }
                if (!valueAdded) break;
                return zip64ExtendedInfo;
            }
            n = ++i;
        }
        return null;
    }

    private /* synthetic */ void readAndSaveAESExtraDataRecord(FileHeader fileHeader) throws ZipException {
        if (fileHeader == null) {
            throw new ZipException("file header is null in reading Zip64 Extended Info");
        }
        if (fileHeader.getExtraDataRecords() == null || fileHeader.getExtraDataRecords().size() <= 0) {
            return;
        }
        AESExtraDataRecord aesExtraDataRecord = this.readAESExtraDataRecord(fileHeader.getExtraDataRecords());
        if (aesExtraDataRecord != null) {
            FileHeader fileHeader2 = fileHeader;
            fileHeader2.setAesExtraDataRecord(aesExtraDataRecord);
            fileHeader2.setEncryptionMethod(99);
        }
    }

    /*
     * Unable to fully structure code
     */
    public LocalFileHeader readLocalFileHeader(FileHeader fileHeader) throws ZipException {
        block21: {
            block20: {
                if (fileHeader == null || this.zip4jRaf == null) {
                    throw new ZipException("invalid read parameters for local header");
                }
                v0 = fileHeader;
                locHdrOffset = v0.getOffsetLocalHeader();
                if (v0.getZip64ExtendedInfo() != null && (zip64ExtendedInfo = fileHeader.getZip64ExtendedInfo()).getOffsetLocalHeader() > 0L) {
                    locHdrOffset = fileHeader.getOffsetLocalHeader();
                }
                if (locHdrOffset < 0L) {
                    throw new ZipException("invalid local header offset");
                }
                try {
                    v1 = this;
                    v1.zip4jRaf.seek(locHdrOffset);
                    length = 0;
                    localFileHeader = new LocalFileHeader();
                    shortBuff = new byte[2];
                    intBuff = new byte[4];
                    longBuff = new byte[8];
                    this.readIntoBuff(v1.zip4jRaf, intBuff);
                    var9_10 = Raw.readIntLittleEndian(intBuff, 0);
                    if ((long)sig != 67324752L) {
                        throw new ZipException(new StringBuilder().insert(0, "invalid local header signature for file: ").append(fileHeader.getFileName()).toString());
                    }
                    v2 = localFileHeader;
                    length += 4;
                    localFileHeader.setSignature((int)sig);
                    this.readIntoBuff(this.zip4jRaf, shortBuff);
                    length += 2;
                    localFileHeader.setVersionNeededToExtract(Raw.readShortLittleEndian(shortBuff, 0));
                    this.readIntoBuff(this.zip4jRaf, shortBuff);
                    if ((Raw.readShortLittleEndian(shortBuff, 0) & 2048) == 0) break block20;
                    v3 = true;
                    ** GOTO lbl65
                }
                catch (IOException e) {
                    throw new ZipException(e);
                }
            }
            v3 = false;
lbl65:
            // 2 sources

            v2.setFileNameUTF8Encoded(v3);
            firstByte = shortBuff[0];
            if ((firstByte & 1) != 0) {
                localFileHeader.setEncrypted(true);
            }
            localFileHeader.setGeneralPurposeFlag(shortBuff);
            length += 2;
            binary = Integer.toBinaryString(firstByte);
            if (binary.length() < 4) ** GOTO lbl97
            v4 = localFileHeader;
            if (binary.charAt(3) != '1') break block21;
            v5 = true;
            ** GOTO lbl96
        }
        v5 = false;
lbl96:
        // 2 sources

        v4.setDataDescriptorExists(v5);
lbl97:
        // 2 sources

        v6 = this;
        v6.readIntoBuff(v6.zip4jRaf, shortBuff);
        length += 2;
        localFileHeader.setCompressionMethod(Raw.readShortLittleEndian(shortBuff, 0));
        this.readIntoBuff(this.zip4jRaf, intBuff);
        length += 4;
        localFileHeader.setLastModFileTime(Raw.readIntLittleEndian(intBuff, 0));
        this.readIntoBuff(this.zip4jRaf, intBuff);
        localFileHeader.setCrc32(Raw.readIntLittleEndian(intBuff, 0));
        length += 4;
        localFileHeader.setCrcBuff((byte[])intBuff.clone());
        v7 = this;
        v7.readIntoBuff(v7.zip4jRaf, intBuff);
        v8 = this;
        longBuff = v8.getLongByteFromIntByte(intBuff);
        length += 4;
        localFileHeader.setCompressedSize(Raw.readLongLittleEndian(longBuff, 0));
        v8.readIntoBuff(v8.zip4jRaf, intBuff);
        v9 = this;
        longBuff = v9.getLongByteFromIntByte(intBuff);
        length += 4;
        localFileHeader.setUncompressedSize(Raw.readLongLittleEndian(longBuff, 0));
        v9.readIntoBuff(v9.zip4jRaf, shortBuff);
        length += 2;
        fileNameLength = Raw.readShortLittleEndian(shortBuff, 0);
        localFileHeader.setFileNameLength(fileNameLength);
        this.readIntoBuff(this.zip4jRaf, shortBuff);
        length += 2;
        extraFieldLength = Raw.readShortLittleEndian(shortBuff, 0);
        localFileHeader.setExtraFieldLength(extraFieldLength);
        if (fileNameLength > 0) {
            fileNameBuf = new byte[fileNameLength];
            v10 = this;
            v10.readIntoBuff(v10.zip4jRaf, fileNameBuf);
            var16_16 = Zip4jUtil.decodeFileName(fileNameBuf, localFileHeader.isFileNameUTF8Encoded());
            if (fileName == null) {
                throw new ZipException("file name is null, cannot assign file name to local file header");
            }
            if (fileName.indexOf(new StringBuilder().insert(0, ":").append(System.getProperty("file.separator")).toString()) >= 0) {
                v11 = fileName;
                fileName = v11.substring(v11.indexOf(":" + System.getProperty("file.separator")) + 2);
            }
            localFileHeader.setFileName(fileName);
            length += fileNameLength;
            v12 = this;
        } else {
            localFileHeader.setFileName(null);
            v12 = this;
        }
        v12.readAndSaveExtraDataRecord(localFileHeader);
        v13 = localFileHeader;
        localFileHeader.setOffsetStartOfData(locHdrOffset + (long)(length += extraFieldLength));
        v13.setPassword(fileHeader.getPassword());
        this.readAndSaveZip64ExtendedInfo(localFileHeader);
        this.readAndSaveAESExtraDataRecord(v13);
        if (!v13.isEncrypted()) ** GOTO lbl191
        if (localFileHeader.getEncryptionMethod() == 99) {
            v14 = localFileHeader;
        } else if ((firstByte & 64) == 64) {
            v15 = localFileHeader;
            v14 = v15;
            v15.setEncryptionMethod(1);
        } else {
            localFileHeader.setEncryptionMethod(0);
lbl191:
            // 2 sources

            v14 = localFileHeader;
        }
        if (v14.getCrc32() <= 0L) {
            v16 = localFileHeader;
            v16.setCrc32(fileHeader.getCrc32());
            v16.setCrcBuff(fileHeader.getCrcBuff());
        }
        if (localFileHeader.getCompressedSize() <= 0L) {
            localFileHeader.setCompressedSize(fileHeader.getCompressedSize());
        }
        if (localFileHeader.getUncompressedSize() <= 0L) {
            localFileHeader.setUncompressedSize(fileHeader.getUncompressedSize());
        }
        return localFileHeader;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ EndCentralDirRecord readEndOfCentralDirectoryRecord() throws ZipException {
        if (this.zip4jRaf == null) {
            throw new ZipException("random access file was null", 3);
        }
        try {
            EndCentralDirRecord endCentralDirRecord;
            void shortBuff;
            byte[] ebs = new byte[4];
            long pos = this.zip4jRaf.length() - 22L;
            EndCentralDirRecord endCentralDirRecord2 = new EndCentralDirRecord();
            int counter = 0;
            do {
                HeaderReader headerReader = this;
                long l = pos;
                ++counter;
                pos = l - 1L;
                headerReader.zip4jRaf.seek(l);
                if ((long)Raw.readLeInt(headerReader.zip4jRaf, ebs) == 101010256L) break;
            } while (counter <= 3000);
            if ((long)Raw.readIntLittleEndian(ebs, 0) != 101010256L) {
                throw new ZipException("zip headers not found. probably not a zip file");
            }
            byte[] intBuff = new byte[4];
            byte[] byArray = new byte[2];
            HeaderReader headerReader = this;
            endCentralDirRecord2.setSignature(101010256L);
            headerReader.readIntoBuff(headerReader.zip4jRaf, (byte[])shortBuff);
            HeaderReader headerReader2 = this;
            endCentralDirRecord2.setNoOfThisDisk(Raw.readShortLittleEndian((byte[])shortBuff, 0));
            headerReader2.readIntoBuff(headerReader2.zip4jRaf, (byte[])shortBuff);
            HeaderReader headerReader3 = this;
            endCentralDirRecord2.setNoOfThisDiskStartOfCentralDir(Raw.readShortLittleEndian((byte[])shortBuff, 0));
            headerReader3.readIntoBuff(headerReader3.zip4jRaf, (byte[])shortBuff);
            HeaderReader headerReader4 = this;
            endCentralDirRecord2.setTotNoOfEntriesInCentralDirOnThisDisk(Raw.readShortLittleEndian((byte[])shortBuff, 0));
            headerReader4.readIntoBuff(headerReader4.zip4jRaf, (byte[])shortBuff);
            HeaderReader headerReader5 = this;
            endCentralDirRecord2.setTotNoOfEntriesInCentralDir(Raw.readShortLittleEndian((byte[])shortBuff, 0));
            headerReader5.readIntoBuff(headerReader5.zip4jRaf, intBuff);
            HeaderReader headerReader6 = this;
            endCentralDirRecord2.setSizeOfCentralDir(Raw.readIntLittleEndian(intBuff, 0));
            headerReader6.readIntoBuff(headerReader6.zip4jRaf, intBuff);
            HeaderReader headerReader7 = this;
            byte[] longBuff = headerReader7.getLongByteFromIntByte(intBuff);
            endCentralDirRecord2.setOffsetOfStartOfCentralDir(Raw.readLongLittleEndian(longBuff, 0));
            headerReader7.readIntoBuff(headerReader7.zip4jRaf, (byte[])shortBuff);
            int commentLength = Raw.readShortLittleEndian((byte[])shortBuff, 0);
            endCentralDirRecord2.setCommentLength(commentLength);
            if (commentLength > 0) {
                byte[] commentBuf = new byte[commentLength];
                HeaderReader headerReader8 = this;
                EndCentralDirRecord endCentralDirRecord3 = endCentralDirRecord2;
                headerReader8.readIntoBuff(headerReader8.zip4jRaf, commentBuf);
                endCentralDirRecord = endCentralDirRecord3;
                endCentralDirRecord2.setComment(new String(commentBuf));
                endCentralDirRecord3.setCommentBytes(commentBuf);
            } else {
                EndCentralDirRecord endCentralDirRecord4 = endCentralDirRecord2;
                endCentralDirRecord = endCentralDirRecord4;
                endCentralDirRecord4.setComment(null);
            }
            int diskNumber = endCentralDirRecord.getNoOfThisDisk();
            if (diskNumber > 0) {
                this.zipModel.setSplitArchive(true);
                return endCentralDirRecord2;
            }
            this.zipModel.setSplitArchive(false);
            return endCentralDirRecord2;
        }
        catch (IOException e) {
            throw new ZipException("Probably not a zip file or a corrupted zip file", e, 4);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ CentralDirectory readCentralDirectory() throws ZipException {
        if (this.zip4jRaf == null) {
            throw new ZipException("random access file was null", 3);
        }
        if (this.zipModel.getEndCentralDirRecord() == null) {
            throw new ZipException("EndCentralRecord was null, maybe a corrupt zip file");
        }
        try {
            void signature;
            int i;
            CentralDirectory centralDirectory = new CentralDirectory();
            ArrayList<FileHeader> fileHeaderList = new ArrayList<FileHeader>();
            HeaderReader headerReader = this;
            EndCentralDirRecord endCentralDirRecord = headerReader.zipModel.getEndCentralDirRecord();
            long offSetStartCentralDir = endCentralDirRecord.getOffsetOfStartOfCentralDir();
            int centralDirEntryCount = endCentralDirRecord.getTotNoOfEntriesInCentralDir();
            if (headerReader.zipModel.isZip64Format()) {
                HeaderReader headerReader2 = this;
                offSetStartCentralDir = headerReader2.zipModel.getZip64EndCentralDirRecord().getOffsetStartCenDirWRTStartDiskNo();
                centralDirEntryCount = (int)headerReader2.zipModel.getZip64EndCentralDirRecord().getTotNoOfEntriesInCentralDir();
            }
            this.zip4jRaf.seek(offSetStartCentralDir);
            byte[] intBuff = new byte[4];
            byte[] shortBuff = new byte[2];
            byte[] longBuff = new byte[8];
            int n = i = 0;
            while (n < centralDirEntryCount) {
                void fileCommentLength;
                HeaderReader headerReader3;
                void signature2;
                FileHeader fileHeader = new FileHeader();
                HeaderReader headerReader4 = this;
                headerReader4.readIntoBuff(headerReader4.zip4jRaf, intBuff);
                int n2 = Raw.readIntLittleEndian(intBuff, 0);
                if ((long)signature2 != 33639248L) {
                    throw new ZipException(new StringBuilder().insert(0, "Expected central directory entry not found (#").append(i + 1).append(")").toString());
                }
                HeaderReader headerReader5 = this;
                fileHeader.setSignature((int)signature2);
                headerReader5.readIntoBuff(headerReader5.zip4jRaf, shortBuff);
                HeaderReader headerReader6 = this;
                fileHeader.setVersionMadeBy(Raw.readShortLittleEndian(shortBuff, 0));
                headerReader6.readIntoBuff(headerReader6.zip4jRaf, shortBuff);
                HeaderReader headerReader7 = this;
                fileHeader.setVersionNeededToExtract(Raw.readShortLittleEndian(shortBuff, 0));
                headerReader7.readIntoBuff(headerReader7.zip4jRaf, shortBuff);
                fileHeader.setFileNameUTF8Encoded((Raw.readShortLittleEndian(shortBuff, 0) & 0x800) != 0);
                byte firstByte = shortBuff[0];
                if ((firstByte & 1) != 0) {
                    fileHeader.setEncrypted(true);
                }
                fileHeader.setGeneralPurposeFlag((byte[])shortBuff.clone());
                fileHeader.setDataDescriptorExists(firstByte >> 3 == 1);
                HeaderReader headerReader8 = this;
                headerReader8.readIntoBuff(headerReader8.zip4jRaf, shortBuff);
                HeaderReader headerReader9 = this;
                fileHeader.setCompressionMethod(Raw.readShortLittleEndian(shortBuff, 0));
                headerReader9.readIntoBuff(headerReader9.zip4jRaf, intBuff);
                HeaderReader headerReader10 = this;
                fileHeader.setLastModFileTime(Raw.readIntLittleEndian(intBuff, 0));
                headerReader10.readIntoBuff(headerReader10.zip4jRaf, intBuff);
                fileHeader.setCrc32(Raw.readIntLittleEndian(intBuff, 0));
                fileHeader.setCrcBuff((byte[])intBuff.clone());
                HeaderReader headerReader11 = this;
                headerReader11.readIntoBuff(headerReader11.zip4jRaf, intBuff);
                HeaderReader headerReader12 = this;
                longBuff = headerReader12.getLongByteFromIntByte(intBuff);
                fileHeader.setCompressedSize(Raw.readLongLittleEndian(longBuff, 0));
                headerReader12.readIntoBuff(headerReader12.zip4jRaf, intBuff);
                HeaderReader headerReader13 = this;
                longBuff = headerReader13.getLongByteFromIntByte(intBuff);
                fileHeader.setUncompressedSize(Raw.readLongLittleEndian(longBuff, 0));
                headerReader13.readIntoBuff(headerReader13.zip4jRaf, shortBuff);
                int fileNameLength = Raw.readShortLittleEndian(shortBuff, 0);
                fileHeader.setFileNameLength(fileNameLength);
                this.readIntoBuff(this.zip4jRaf, shortBuff);
                fileHeader.setExtraFieldLength(Raw.readShortLittleEndian(shortBuff, 0));
                this.readIntoBuff(this.zip4jRaf, shortBuff);
                int n3 = Raw.readShortLittleEndian(shortBuff, 0);
                fileHeader.setFileComment(new String(shortBuff));
                this.readIntoBuff(this.zip4jRaf, shortBuff);
                HeaderReader headerReader14 = this;
                fileHeader.setDiskNumberStart(Raw.readShortLittleEndian(shortBuff, 0));
                headerReader14.readIntoBuff(headerReader14.zip4jRaf, shortBuff);
                fileHeader.setInternalFileAttr((byte[])shortBuff.clone());
                HeaderReader headerReader15 = this;
                headerReader15.readIntoBuff(headerReader15.zip4jRaf, intBuff);
                fileHeader.setExternalFileAttr((byte[])intBuff.clone());
                HeaderReader headerReader16 = this;
                headerReader16.readIntoBuff(headerReader16.zip4jRaf, intBuff);
                longBuff = this.getLongByteFromIntByte(intBuff);
                fileHeader.setOffsetLocalHeader(Raw.readLongLittleEndian(longBuff, 0) & 0xFFFFFFFFL);
                if (fileNameLength > 0) {
                    byte[] fileNameBuf = new byte[fileNameLength];
                    HeaderReader headerReader17 = this;
                    headerReader17.readIntoBuff(headerReader17.zip4jRaf, fileNameBuf);
                    String fileName = null;
                    if ((Zip4jUtil.isStringNotNullAndNotEmpty(headerReader17.zipModel.getFileNameCharset()) ? (fileName = new String(fileNameBuf, this.zipModel.getFileNameCharset())) : (fileName = Zip4jUtil.decodeFileName(fileNameBuf, fileHeader.isFileNameUTF8Encoded()))) == null) {
                        throw new ZipException("fileName is null when reading central directory");
                    }
                    if (fileName.indexOf(new StringBuilder().insert(0, ":").append(System.getProperty("file.separator")).toString()) >= 0) {
                        String string = fileName;
                        fileName = string.substring(string.indexOf(":" + System.getProperty("file.separator")) + 2);
                    }
                    String string = fileName;
                    fileHeader.setFileName(string);
                    fileHeader.setDirectory(string.endsWith("/") || fileName.endsWith("\\"));
                    headerReader3 = this;
                } else {
                    fileHeader.setFileName(null);
                    headerReader3 = this;
                }
                headerReader3.readAndSaveExtraDataRecord(fileHeader);
                HeaderReader headerReader18 = this;
                headerReader18.readAndSaveZip64ExtendedInfo(fileHeader);
                headerReader18.readAndSaveAESExtraDataRecord(fileHeader);
                if (fileCommentLength > 0) {
                    byte[] fileCommentBuf = new byte[fileCommentLength];
                    HeaderReader headerReader19 = this;
                    headerReader19.readIntoBuff(headerReader19.zip4jRaf, fileCommentBuf);
                    fileHeader.setFileComment(new String(fileCommentBuf));
                }
                fileHeaderList.add(fileHeader);
                n = ++i;
            }
            centralDirectory.setFileHeaders(fileHeaderList);
            DigitalSignature digitalSignature = new DigitalSignature();
            HeaderReader headerReader20 = this;
            headerReader20.readIntoBuff(headerReader20.zip4jRaf, intBuff);
            int fileHeader = Raw.readIntLittleEndian(intBuff, 0);
            if ((long)signature != 84233040L) {
                return centralDirectory;
            }
            digitalSignature.setHeaderSignature((int)signature);
            HeaderReader headerReader21 = this;
            headerReader21.readIntoBuff(headerReader21.zip4jRaf, shortBuff);
            int sizeOfData = Raw.readShortLittleEndian(shortBuff, 0);
            digitalSignature.setSizeOfData(sizeOfData);
            if (sizeOfData > 0) {
                byte[] sigDataBuf = new byte[sizeOfData];
                HeaderReader headerReader22 = this;
                headerReader22.readIntoBuff(headerReader22.zip4jRaf, sigDataBuf);
                digitalSignature.setSignatureData(new String(sigDataBuf));
            }
            return centralDirectory;
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
    }

    public ZipModel readAllHeaders() throws ZipException {
        return this.readAllHeaders(null);
    }

    private /* synthetic */ void setFilePointerToReadZip64EndCentralDirLoc() throws ZipException {
        try {
            HeaderReader headerReader;
            byte[] ebs = new byte[4];
            long pos = this.zip4jRaf.length() - 22L;
            do {
                headerReader = this;
                headerReader.zip4jRaf.seek(pos--);
            } while ((long)Raw.readLeInt(headerReader.zip4jRaf, ebs) != 101010256L);
            HeaderReader headerReader2 = this;
            headerReader2.zip4jRaf.seek(headerReader2.zip4jRaf.getFilePointer() - 4L - 4L - 8L - 4L - 4L);
            return;
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
    }

    private /* synthetic */ void readAndSaveExtraDataRecord(LocalFileHeader localFileHeader) throws ZipException {
        if (this.zip4jRaf == null) {
            throw new ZipException("invalid file handler when trying to read extra data record");
        }
        if (localFileHeader == null) {
            throw new ZipException("file header is null");
        }
        int extraFieldLength = localFileHeader.getExtraFieldLength();
        if (extraFieldLength <= 0) {
            return;
        }
        localFileHeader.setExtraDataRecords(this.readExtraDataRecords(extraFieldLength));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Zip64EndCentralDirRecord readZip64EndCentralDirRec() throws ZipException {
        if (this.zipModel.getZip64EndCentralDirLocator() == null) {
            throw new ZipException("invalid zip64 end of central directory locator");
        }
        long offSetStartOfZip64CentralDir = this.zipModel.getZip64EndCentralDirLocator().getOffsetZip64EndOfCentralDirRec();
        if (offSetStartOfZip64CentralDir < 0L) {
            throw new ZipException("invalid offset for start of end of central directory record");
        }
        try {
            void extDataSecSize;
            void signature;
            HeaderReader headerReader = this;
            headerReader.zip4jRaf.seek(offSetStartOfZip64CentralDir);
            Zip64EndCentralDirRecord zip64EndCentralDirRecord = new Zip64EndCentralDirRecord();
            byte[] shortBuff = new byte[2];
            byte[] intBuff = new byte[4];
            byte[] longBuff = new byte[8];
            headerReader.readIntoBuff(headerReader.zip4jRaf, intBuff);
            int n = Raw.readIntLittleEndian(intBuff, 0);
            if ((long)signature != 101075792L) {
                throw new ZipException("invalid signature for zip64 end of central directory record");
            }
            zip64EndCentralDirRecord.setSignature((long)signature);
            HeaderReader headerReader2 = this;
            headerReader2.readIntoBuff(headerReader2.zip4jRaf, longBuff);
            HeaderReader headerReader3 = this;
            zip64EndCentralDirRecord.setSizeOfZip64EndCentralDirRec(Raw.readLongLittleEndian(longBuff, 0));
            headerReader3.readIntoBuff(headerReader3.zip4jRaf, shortBuff);
            HeaderReader headerReader4 = this;
            zip64EndCentralDirRecord.setVersionMadeBy(Raw.readShortLittleEndian(shortBuff, 0));
            headerReader4.readIntoBuff(headerReader4.zip4jRaf, shortBuff);
            HeaderReader headerReader5 = this;
            zip64EndCentralDirRecord.setVersionNeededToExtract(Raw.readShortLittleEndian(shortBuff, 0));
            headerReader5.readIntoBuff(headerReader5.zip4jRaf, intBuff);
            HeaderReader headerReader6 = this;
            zip64EndCentralDirRecord.setNoOfThisDisk(Raw.readIntLittleEndian(intBuff, 0));
            headerReader6.readIntoBuff(headerReader6.zip4jRaf, intBuff);
            HeaderReader headerReader7 = this;
            zip64EndCentralDirRecord.setNoOfThisDiskStartOfCentralDir(Raw.readIntLittleEndian(intBuff, 0));
            headerReader7.readIntoBuff(headerReader7.zip4jRaf, longBuff);
            HeaderReader headerReader8 = this;
            zip64EndCentralDirRecord.setTotNoOfEntriesInCentralDirOnThisDisk(Raw.readLongLittleEndian(longBuff, 0));
            headerReader8.readIntoBuff(headerReader8.zip4jRaf, longBuff);
            HeaderReader headerReader9 = this;
            zip64EndCentralDirRecord.setTotNoOfEntriesInCentralDir(Raw.readLongLittleEndian(longBuff, 0));
            headerReader9.readIntoBuff(headerReader9.zip4jRaf, longBuff);
            HeaderReader headerReader10 = this;
            zip64EndCentralDirRecord.setSizeOfCentralDir(Raw.readLongLittleEndian(longBuff, 0));
            headerReader10.readIntoBuff(headerReader10.zip4jRaf, longBuff);
            Zip64EndCentralDirRecord zip64EndCentralDirRecord2 = zip64EndCentralDirRecord;
            zip64EndCentralDirRecord2.setOffsetStartCenDirWRTStartDiskNo(Raw.readLongLittleEndian(longBuff, 0));
            long l = zip64EndCentralDirRecord2.getSizeOfZip64EndCentralDirRec() - 44L;
            if (extDataSecSize > 0L) {
                byte[] extDataSecRecBuf = new byte[(int)extDataSecSize];
                HeaderReader headerReader11 = this;
                headerReader11.readIntoBuff(headerReader11.zip4jRaf, extDataSecRecBuf);
                zip64EndCentralDirRecord.setExtensibleDataSector(extDataSecRecBuf);
            }
            return zip64EndCentralDirRecord;
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
    }

    public HeaderReader(RandomAccessFile randomAccessFile) {
        HeaderReader headerReader = this;
        headerReader.zip4jRaf = null;
        headerReader.zip4jRaf = randomAccessFile;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Zip64EndCentralDirLocator readZip64EndCentralDirLocator() throws ZipException {
        HeaderReader headerReader;
        byte[] longBuff;
        byte[] intBuff;
        Zip64EndCentralDirLocator zip64EndCentralDirLocator;
        block6: {
            block5: {
                if (this.zip4jRaf == null) {
                    throw new ZipException("invalid file handler when trying to read Zip64EndCentralDirLocator");
                }
                try {
                    void signature;
                    zip64EndCentralDirLocator = new Zip64EndCentralDirLocator();
                    HeaderReader headerReader2 = this;
                    headerReader2.setFilePointerToReadZip64EndCentralDirLoc();
                    intBuff = new byte[4];
                    longBuff = new byte[8];
                    headerReader2.readIntoBuff(headerReader2.zip4jRaf, intBuff);
                    int n = Raw.readIntLittleEndian(intBuff, 0);
                    if ((long)signature != 117853008L) break block5;
                    HeaderReader headerReader3 = this;
                    headerReader = headerReader3;
                    headerReader3.zipModel.setZip64Format(true);
                    zip64EndCentralDirLocator.setSignature((long)signature);
                    break block6;
                }
                catch (Exception e) {
                    throw new ZipException(e);
                }
            }
            this.zipModel.setZip64Format(false);
            return null;
        }
        headerReader.readIntoBuff(this.zip4jRaf, intBuff);
        HeaderReader headerReader4 = this;
        zip64EndCentralDirLocator.setNoOfDiskStartOfZip64EndOfCentralDirRec(Raw.readIntLittleEndian(intBuff, 0));
        headerReader4.readIntoBuff(headerReader4.zip4jRaf, longBuff);
        HeaderReader headerReader5 = this;
        zip64EndCentralDirLocator.setOffsetZip64EndOfCentralDirRec(Raw.readLongLittleEndian(longBuff, 0));
        headerReader5.readIntoBuff(headerReader5.zip4jRaf, intBuff);
        zip64EndCentralDirLocator.setTotNumberOfDiscs(Raw.readIntLittleEndian(intBuff, 0));
        return zip64EndCentralDirLocator;
    }

    private /* synthetic */ void readAndSaveZip64ExtendedInfo(LocalFileHeader localFileHeader) throws ZipException {
        if (localFileHeader == null) {
            throw new ZipException("file header is null in reading Zip64 Extended Info");
        }
        if (localFileHeader.getExtraDataRecords() == null || localFileHeader.getExtraDataRecords().size() <= 0) {
            return;
        }
        Zip64ExtendedInfo zip64ExtendedInfo = this.readZip64ExtendedInfo(localFileHeader.getExtraDataRecords(), localFileHeader.getUncompressedSize(), localFileHeader.getCompressedSize(), -1L, -1);
        if (zip64ExtendedInfo != null) {
            Zip64ExtendedInfo zip64ExtendedInfo2 = zip64ExtendedInfo;
            localFileHeader.setZip64ExtendedInfo(zip64ExtendedInfo2);
            if (zip64ExtendedInfo2.getUnCompressedSize() != -1L) {
                localFileHeader.setUncompressedSize(zip64ExtendedInfo.getUnCompressedSize());
            }
            if (zip64ExtendedInfo.getCompressedSize() != -1L) {
                localFileHeader.setCompressedSize(zip64ExtendedInfo.getCompressedSize());
            }
        }
    }

    private /* synthetic */ void readAndSaveZip64ExtendedInfo(FileHeader fileHeader) throws ZipException {
        if (fileHeader == null) {
            throw new ZipException("file header is null in reading Zip64 Extended Info");
        }
        if (fileHeader.getExtraDataRecords() == null || fileHeader.getExtraDataRecords().size() <= 0) {
            return;
        }
        Zip64ExtendedInfo zip64ExtendedInfo = this.readZip64ExtendedInfo(fileHeader.getExtraDataRecords(), fileHeader.getUncompressedSize(), fileHeader.getCompressedSize(), fileHeader.getOffsetLocalHeader(), fileHeader.getDiskNumberStart());
        if (zip64ExtendedInfo != null) {
            Zip64ExtendedInfo zip64ExtendedInfo2 = zip64ExtendedInfo;
            fileHeader.setZip64ExtendedInfo(zip64ExtendedInfo2);
            if (zip64ExtendedInfo2.getUnCompressedSize() != -1L) {
                fileHeader.setUncompressedSize(zip64ExtendedInfo.getUnCompressedSize());
            }
            if (zip64ExtendedInfo.getCompressedSize() != -1L) {
                fileHeader.setCompressedSize(zip64ExtendedInfo.getCompressedSize());
            }
            if (zip64ExtendedInfo.getOffsetLocalHeader() != -1L) {
                fileHeader.setOffsetLocalHeader(zip64ExtendedInfo.getOffsetLocalHeader());
            }
            if (zip64ExtendedInfo.getDiskNumberStart() != -1) {
                fileHeader.setDiskNumberStart(zip64ExtendedInfo.getDiskNumberStart());
            }
        }
    }

    private /* synthetic */ byte[] getLongByteFromIntByte(byte[] intByte) throws ZipException {
        if (intByte == null) {
            throw new ZipException("input parameter is null, cannot expand to 8 bytes");
        }
        if (intByte.length != 4) {
            throw new ZipException("invalid byte length, cannot expand to 8 bytes");
        }
        byte[] byArray = new byte[8];
        byArray[0] = intByte[0];
        byArray[1] = intByte[1];
        byArray[2] = intByte[2];
        byArray[3] = intByte[3];
        byArray[4] = 0;
        byArray[5] = 0;
        byArray[6] = 0;
        byArray[7] = 0;
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ AESExtraDataRecord readAESExtraDataRecord(ArrayList extraDataRecords) throws ZipException {
        int i;
        if (extraDataRecords == null) {
            return null;
        }
        int n = i = 0;
        while (n < extraDataRecords.size()) {
            ExtraDataRecord extraDataRecord = (ExtraDataRecord)extraDataRecords.get(i);
            if (extraDataRecord != null && extraDataRecord.getHeader() == 39169L) {
                void aesData;
                AESExtraDataRecord aesExtraDataRecord;
                if (extraDataRecord.getData() == null) {
                    throw new ZipException("corrput AES extra data records");
                }
                AESExtraDataRecord aESExtraDataRecord = aesExtraDataRecord = new AESExtraDataRecord();
                aesExtraDataRecord.setSignature(39169L);
                aESExtraDataRecord.setDataSize(extraDataRecord.getSizeOfData());
                byte[] byArray = extraDataRecord.getData();
                aESExtraDataRecord.setVersionNumber(Raw.readShortLittleEndian(byArray, 0));
                byte[] vendorIDBytes = new byte[2];
                System.arraycopy(byArray, 2, vendorIDBytes, 0, 2);
                aesExtraDataRecord.setVendorID(new String(vendorIDBytes));
                aesExtraDataRecord.setAesStrength((int)(aesData[4] & 0xFF));
                aesExtraDataRecord.setCompressionMethod(Raw.readShortLittleEndian((byte[])aesData, 5));
                return aesExtraDataRecord;
            }
            n = ++i;
        }
        return null;
    }

    private /* synthetic */ void readAndSaveAESExtraDataRecord(LocalFileHeader localFileHeader) throws ZipException {
        if (localFileHeader == null) {
            throw new ZipException("file header is null in reading Zip64 Extended Info");
        }
        if (localFileHeader.getExtraDataRecords() == null || localFileHeader.getExtraDataRecords().size() <= 0) {
            return;
        }
        AESExtraDataRecord aesExtraDataRecord = this.readAESExtraDataRecord(localFileHeader.getExtraDataRecords());
        if (aesExtraDataRecord != null) {
            LocalFileHeader localFileHeader2 = localFileHeader;
            localFileHeader2.setAesExtraDataRecord(aesExtraDataRecord);
            localFileHeader2.setEncryptionMethod(99);
        }
    }
}

