/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.core;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.SplitOutputStream;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.Zip64EndCentralDirLocator;
import net.lingala.zip4j.model.Zip64EndCentralDirRecord;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.util.Raw;
import net.lingala.zip4j.util.Zip4jUtil;

public class HeaderWriter {
    private final int ZIP64_EXTRA_BUF = 50;

    private /* synthetic */ int countNumberOfFileHeaderEntriesOnDisk(ArrayList fileHeaders, int numOfDisk) throws ZipException {
        int i;
        if (fileHeaders == null) {
            throw new ZipException("file headers are null, cannot calculate number of entries on this disk");
        }
        int noEntries = 0;
        int n = i = 0;
        while (n < fileHeaders.size()) {
            if (((FileHeader)fileHeaders.get(i)).getDiskNumberStart() == numOfDisk - 1) {
                ++noEntries;
            }
            n = ++i;
        }
        return noEntries;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void writeZip64EndOfCentralDirectoryLocator(ZipModel zipModel, OutputStream outputStream) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("zip model or output stream is null, cannot write zip64 end of central directory locator");
        }
        try {
            void longByte;
            ArrayList byteArrayList = new ArrayList();
            byte[] intByte = new byte[4];
            byte[] byArray = new byte[8];
            HeaderWriter headerWriter = this;
            Raw.writeIntLittleEndian(intByte, 0, 117853008);
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            Raw.writeIntLittleEndian(intByte, 0, zipModel.getZip64EndCentralDirLocator().getNoOfDiskStartOfZip64EndOfCentralDirRec());
            HeaderWriter headerWriter2 = this;
            headerWriter2.copyByteArrayToArrayList(intByte, byteArrayList);
            Raw.writeLongLittleEndian((byte[])longByte, 0, zipModel.getZip64EndCentralDirLocator().getOffsetZip64EndOfCentralDirRec());
            headerWriter2.copyByteArrayToArrayList((byte[])longByte, byteArrayList);
            Raw.writeIntLittleEndian(intByte, 0, zipModel.getZip64EndCentralDirLocator().getTotNumberOfDiscs());
            headerWriter.copyByteArrayToArrayList(intByte, byteArrayList);
            outputStream.write(headerWriter.byteArrayListToByteArray(byteArrayList));
            return;
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ int writeFileHeader(ZipModel zipModel, FileHeader fileHeader, OutputStream outputStream) throws ZipException {
        block20: {
            block19: {
                if (fileHeader == null || outputStream == null) {
                    throw new ZipException("input parameters is null, cannot write local file header");
                }
                try {
                    sizeOfFileHeader = 0;
                    byteArrayList = new ArrayList<E>();
                    shortByte = new byte[2];
                    intByte = new byte[4];
                    longByte = new byte[8];
                    v0 = new byte[2];
                    v0[0] = 0;
                    v0[1] = 0;
                    emptyShortByte = v0;
                    v1 = new byte[4];
                    v1[0] = 0;
                    v1[1] = 0;
                    v1[2] = 0;
                    v1[3] = 0;
                    emptyIntByte = v1;
                    writeZip64FileSize = false;
                    var12_13 = false;
                    v2 = this;
                    Raw.writeIntLittleEndian(intByte, 0, fileHeader.getSignature());
                    v3 = this;
                    v4 = this;
                    sizeOfFileHeader += 4;
                    this.copyByteArrayToArrayList(intByte, byteArrayList);
                    sizeOfFileHeader += 2;
                    Raw.writeShortLittleEndian(shortByte, 0, (short)fileHeader.getVersionMadeBy());
                    v4.copyByteArrayToArrayList(shortByte, byteArrayList);
                    sizeOfFileHeader += 2;
                    Raw.writeShortLittleEndian(shortByte, 0, (short)fileHeader.getVersionNeededToExtract());
                    v4.copyByteArrayToArrayList(shortByte, byteArrayList);
                    sizeOfFileHeader += 2;
                    v3.copyByteArrayToArrayList(fileHeader.getGeneralPurposeFlag(), byteArrayList);
                    sizeOfFileHeader += 2;
                    Raw.writeShortLittleEndian(shortByte, 0, (short)fileHeader.getCompressionMethod());
                    v3.copyByteArrayToArrayList(shortByte, byteArrayList);
                    dateTime = fileHeader.getLastModFileTime();
                    Raw.writeIntLittleEndian(intByte, 0, dateTime);
                    sizeOfFileHeader += 4;
                    v2.copyByteArrayToArrayList(intByte, byteArrayList);
                    Raw.writeIntLittleEndian(intByte, 0, (int)fileHeader.getCrc32());
                    sizeOfFileHeader += 4;
                    v2.copyByteArrayToArrayList(intByte, byteArrayList);
                    if (fileHeader.getCompressedSize() < 0xFFFFFFFFL && fileHeader.getUncompressedSize() + 50L < 0xFFFFFFFFL) break block19;
                    Raw.writeLongLittleEndian(longByte, 0, 0xFFFFFFFFL);
                    System.arraycopy(longByte, 0, intByte, 0, 4);
                    v5 = shortByte;
                    v6 = this;
                    sizeOfFileHeader += 4;
                    sizeOfFileHeader += 4;
                    v6.copyByteArrayToArrayList(intByte, byteArrayList);
                    v6.copyByteArrayToArrayList(intByte, byteArrayList);
                    writeZip64FileSize = true;
                    ** GOTO lbl159
                }
                catch (Exception e) {
                    throw new ZipException(e);
                }
            }
            Raw.writeLongLittleEndian(longByte, 0, fileHeader.getCompressedSize());
            sizeOfFileHeader += 4;
            System.arraycopy(longByte, 0, intByte, 0, 4);
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            Raw.writeLongLittleEndian(longByte, 0, fileHeader.getUncompressedSize());
            System.arraycopy(longByte, 0, intByte, 0, 4);
            v5 = shortByte;
            sizeOfFileHeader += 4;
            this.copyByteArrayToArrayList(intByte, byteArrayList);
lbl159:
            // 2 sources

            Raw.writeShortLittleEndian(v5, 0, (short)fileHeader.getFileNameLength());
            sizeOfFileHeader += 2;
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            offsetLocalHeaderBytes = new byte[4];
            if (fileHeader.getOffsetLocalHeader() <= 0xFFFFFFFFL) break block20;
            Raw.writeLongLittleEndian(longByte, 0, 0xFFFFFFFFL);
            System.arraycopy(longByte, 0, offsetLocalHeaderBytes, 0, 4);
            writeZip64OffsetLocalHeader = true;
            ** GOTO lbl196
        }
        Raw.writeLongLittleEndian(longByte, 0, fileHeader.getOffsetLocalHeader());
        System.arraycopy(longByte, 0, offsetLocalHeaderBytes, 0, 4);
lbl196:
        // 2 sources

        extraFieldLength = 0;
        if (writeZip64FileSize || writeZip64OffsetLocalHeader) {
            extraFieldLength += 4;
            if (writeZip64FileSize) {
                extraFieldLength += 16;
            }
            if (writeZip64OffsetLocalHeader) {
                extraFieldLength += 8;
            }
        }
        if (fileHeader.getAesExtraDataRecord() != null) {
            extraFieldLength += 11;
        }
        Raw.writeShortLittleEndian(shortByte, 0, (short)extraFieldLength);
        v7 = this;
        sizeOfFileHeader += 2;
        sizeOfFileHeader += 2;
        v7.copyByteArrayToArrayList(shortByte, byteArrayList);
        v7.copyByteArrayToArrayList(emptyShortByte, byteArrayList);
        Raw.writeShortLittleEndian(shortByte, 0, (short)fileHeader.getDiskNumberStart());
        v8 = this;
        sizeOfFileHeader += 2;
        sizeOfFileHeader += 2;
        v8.copyByteArrayToArrayList(shortByte, byteArrayList);
        v8.copyByteArrayToArrayList(emptyShortByte, byteArrayList);
        v9 = this;
        if (fileHeader.getExternalFileAttr() != null) {
            v9.copyByteArrayToArrayList(fileHeader.getExternalFileAttr(), byteArrayList);
        } else {
            v9.copyByteArrayToArrayList(emptyIntByte, byteArrayList);
        }
        sizeOfFileHeader += 4;
        sizeOfFileHeader += 4;
        this.copyByteArrayToArrayList(offsetLocalHeaderBytes, byteArrayList);
        if (Zip4jUtil.isStringNotNullAndNotEmpty(zipModel.getFileNameCharset())) {
            var16_17 = fileHeader.getFileName().getBytes(zipModel.getFileNameCharset());
            this.copyByteArrayToArrayList((byte[])fileNameBytes, byteArrayList);
            sizeOfFileHeader += ((void)fileNameBytes).length;
            v10 = writeZip64FileSize;
        } else {
            this.copyByteArrayToArrayList(Zip4jUtil.convertCharset(fileHeader.getFileName()), byteArrayList);
            sizeOfFileHeader += Zip4jUtil.getEncodedStringLength(fileHeader.getFileName());
            v10 = writeZip64FileSize;
        }
        if (v10 || writeZip64OffsetLocalHeader) {
            zipModel.setZip64Format(true);
            sizeOfFileHeader += 2;
            Raw.writeShortLittleEndian(shortByte, 0, (short)1);
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            dataSize = 0;
            if (writeZip64FileSize) {
                dataSize += 16;
            }
            if (writeZip64OffsetLocalHeader) {
                dataSize += 8;
            }
            Raw.writeShortLittleEndian(shortByte, 0, (short)dataSize);
            sizeOfFileHeader += 2;
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            if (writeZip64FileSize) {
                v11 = this;
                sizeOfFileHeader += 8;
                Raw.writeLongLittleEndian(longByte, 0, fileHeader.getUncompressedSize());
                v11.copyByteArrayToArrayList(longByte, byteArrayList);
                Raw.writeLongLittleEndian(longByte, 0, fileHeader.getCompressedSize());
                sizeOfFileHeader += 8;
                v11.copyByteArrayToArrayList(longByte, byteArrayList);
            }
            if (writeZip64OffsetLocalHeader) {
                sizeOfFileHeader += 8;
                Raw.writeLongLittleEndian(longByte, 0, fileHeader.getOffsetLocalHeader());
                this.copyByteArrayToArrayList(longByte, byteArrayList);
            }
        }
        if (fileHeader.getAesExtraDataRecord() != null) {
            dataSize = fileHeader.getAesExtraDataRecord();
            v12 = this;
            v13 = this;
            Raw.writeShortLittleEndian(shortByte, 0, (short)aesExtraDataRecord.getSignature());
            v13.copyByteArrayToArrayList(shortByte, byteArrayList);
            Raw.writeShortLittleEndian(shortByte, 0, (short)aesExtraDataRecord.getDataSize());
            v13.copyByteArrayToArrayList(shortByte, byteArrayList);
            Raw.writeShortLittleEndian(shortByte, 0, (short)aesExtraDataRecord.getVersionNumber());
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            v12.copyByteArrayToArrayList(aesExtraDataRecord.getVendorID().getBytes(), byteArrayList);
            var17_19 = new byte[1];
            v14 = aesStrengthBytes;
            v14[0] = (byte)aesExtraDataRecord.getAesStrength();
            v12.copyByteArrayToArrayList((byte[])v14, byteArrayList);
            Raw.writeShortLittleEndian(shortByte, 0, (short)aesExtraDataRecord.getCompressionMethod());
            sizeOfFileHeader += 11;
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
        }
        outputStream.write(this.byteArrayListToByteArray(byteArrayList));
        return sizeOfFileHeader;
    }

    private /* synthetic */ void copyByteArrayToArrayList(byte[] byteArray, ArrayList arrayList) throws ZipException {
        int i;
        if (arrayList == null || byteArray == null) {
            throw new ZipException("one of the input parameters is null, cannot copy byte array to array list");
        }
        int n = i = 0;
        while (n < byteArray.length) {
            arrayList.add(Byte.toString(byteArray[i++]));
            n = i;
        }
    }

    private /* synthetic */ byte[] byteArrayListToByteArray(ArrayList arrayList) throws ZipException {
        int i;
        if (arrayList == null) {
            throw new ZipException("input byte array list is null, cannot conver to byte array");
        }
        if (arrayList.size() <= 0) {
            return null;
        }
        byte[] retBytes = new byte[arrayList.size()];
        int n = i = 0;
        while (n < arrayList.size()) {
            int n2 = i++;
            retBytes[n2] = Byte.parseByte((String)arrayList.get(n2));
            n = i;
        }
        return retBytes;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void updateCompressedSizeInLocalFileHeader(SplitOutputStream outputStream, LocalFileHeader localFileHeader, long offset, long toUpdate, byte[] bytesToWrite, boolean isZip64Format) throws ZipException {
        block5: {
            if (outputStream == null) {
                throw new ZipException("invalid output stream, cannot update compressed size for local file header");
            }
            try {
                void zip64CompressedSizeOffset;
                if (!localFileHeader.isWriteComprSizeInZip64ExtraRecord()) break block5;
                if (bytesToWrite.length != 8) {
                    throw new ZipException("attempting to write a non 8-byte compressed size block for a zip64 file");
                }
                long l = offset + toUpdate + 4L + 4L + 2L + 2L + (long)localFileHeader.getFileNameLength() + 2L + 2L + 8L;
                SplitOutputStream splitOutputStream = outputStream;
                splitOutputStream.seek((long)zip64CompressedSizeOffset);
                splitOutputStream.write(bytesToWrite);
                return;
            }
            catch (IOException e) {
                throw new ZipException(e);
            }
        }
        outputStream.seek(offset + toUpdate);
        outputStream.write(bytesToWrite);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void writeZip64EndOfCentralDirectoryRecord(ZipModel zipModel, OutputStream outputStream, int sizeOfCentralDir, long offsetCentralDir) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("zip model or output stream is null, cannot write zip64 end of central directory record");
        }
        try {
            void v5;
            byte[] byArray;
            void longByte;
            ArrayList byteArrayList = new ArrayList();
            byte[] shortByte = new byte[2];
            byte[] byArray2 = new byte[2];
            byArray2[0] = 0;
            byArray2[1] = 0;
            byte[] emptyShortByte = byArray2;
            byte[] intByte = new byte[4];
            byte[] byArray3 = new byte[8];
            Raw.writeIntLittleEndian(intByte, 0, 101075792);
            HeaderWriter headerWriter = this;
            headerWriter.copyByteArrayToArrayList(intByte, byteArrayList);
            Raw.writeLongLittleEndian((byte[])longByte, 0, 44L);
            headerWriter.copyByteArrayToArrayList((byte[])longByte, byteArrayList);
            if (zipModel.getCentralDirectory() != null && zipModel.getCentralDirectory().getFileHeaders() != null && zipModel.getCentralDirectory().getFileHeaders().size() > 0) {
                Raw.writeShortLittleEndian(shortByte, 0, (short)((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(0)).getVersionMadeBy());
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
                Raw.writeShortLittleEndian(shortByte, 0, (short)((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(0)).getVersionNeededToExtract());
                byArray = intByte;
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
            } else {
                this.copyByteArrayToArrayList(emptyShortByte, byteArrayList);
                this.copyByteArrayToArrayList(emptyShortByte, byteArrayList);
                byArray = intByte;
            }
            Raw.writeIntLittleEndian(byArray, 0, zipModel.getEndCentralDirRecord().getNoOfThisDisk());
            HeaderWriter headerWriter2 = this;
            headerWriter2.copyByteArrayToArrayList(intByte, byteArrayList);
            Raw.writeIntLittleEndian(intByte, 0, zipModel.getEndCentralDirRecord().getNoOfThisDiskStartOfCentralDir());
            headerWriter2.copyByteArrayToArrayList(intByte, byteArrayList);
            int numEntries = 0;
            int numEntriesOnThisDisk = 0;
            if (zipModel.getCentralDirectory() == null || zipModel.getCentralDirectory().getFileHeaders() == null) {
                throw new ZipException("invalid central directory/file headers, cannot write end of central directory record");
            }
            ZipModel zipModel2 = zipModel;
            numEntries = zipModel2.getCentralDirectory().getFileHeaders().size();
            if (zipModel2.isSplitArchive()) {
                v5 = longByte;
                this.countNumberOfFileHeaderEntriesOnDisk(zipModel.getCentralDirectory().getFileHeaders(), zipModel.getEndCentralDirRecord().getNoOfThisDisk());
            } else {
                numEntriesOnThisDisk = numEntries;
                v5 = longByte;
            }
            Raw.writeLongLittleEndian((byte[])v5, 0, numEntriesOnThisDisk);
            HeaderWriter headerWriter3 = this;
            void v7 = longByte;
            ArrayList arrayList = byteArrayList;
            this.copyByteArrayToArrayList((byte[])longByte, arrayList);
            Raw.writeLongLittleEndian((byte[])longByte, 0, numEntries);
            this.copyByteArrayToArrayList((byte[])v7, arrayList);
            Raw.writeLongLittleEndian((byte[])longByte, 0, sizeOfCentralDir);
            headerWriter3.copyByteArrayToArrayList((byte[])v7, byteArrayList);
            Raw.writeLongLittleEndian((byte[])longByte, 0, offsetCentralDir);
            headerWriter3.copyByteArrayToArrayList((byte[])longByte, byteArrayList);
            outputStream.write(headerWriter3.byteArrayListToByteArray(byteArrayList));
            return;
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    private /* synthetic */ int writeCentralDirectory(ZipModel zipModel, OutputStream outputStream) throws ZipException {
        int i;
        if (zipModel == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot write central directory");
        }
        if (zipModel.getCentralDirectory() == null || zipModel.getCentralDirectory().getFileHeaders() == null || zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
            return 0;
        }
        int sizeOfCentralDir = 0;
        int n = i = 0;
        while (n < zipModel.getCentralDirectory().getFileHeaders().size()) {
            FileHeader fileHeader = (FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i);
            int sizeOfFileHeader = this.writeFileHeader(zipModel, fileHeader, outputStream);
            sizeOfCentralDir += sizeOfFileHeader;
            n = ++i;
        }
        return sizeOfCentralDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateLocalFileHeader(LocalFileHeader localFileHeader, long offset, int toUpdate, ZipModel zipModel, byte[] bytesToWrite, int noOfDisk, SplitOutputStream outputStream) throws ZipException {
        if (localFileHeader == null || offset < 0L || zipModel == null) {
            throw new ZipException("invalid input parameters, cannot update local file header");
        }
        try {
            boolean bl;
            SplitOutputStream splitOutputStream;
            boolean closeFlag = false;
            SplitOutputStream currOutputStream = null;
            if (noOfDisk != outputStream.getCurrSplitFileCounter()) {
                File zipFile = new File(zipModel.getZipFile());
                String parentFile = zipFile.getParent();
                String fileNameWithoutExt = Zip4jUtil.getZipFileNameWithoutExt(zipFile.getName());
                String fileName = new StringBuilder().insert(0, parentFile).append(System.getProperty("file.separator")).toString();
                fileName = noOfDisk < 9 ? new StringBuilder().insert(0, fileName).append(fileNameWithoutExt).append(".z0").append(noOfDisk + 1).toString() : new StringBuilder().insert(0, fileName).append(fileNameWithoutExt).append(".z").append(noOfDisk + 1).toString();
                currOutputStream = new SplitOutputStream(new File(fileName));
                closeFlag = true;
                splitOutputStream = currOutputStream;
            } else {
                splitOutputStream = currOutputStream = outputStream;
            }
            long currOffset = splitOutputStream.getFilePointer();
            if (currOutputStream == null) {
                throw new ZipException("invalid output stream handler, cannot update local file header");
            }
            switch (toUpdate) {
                case 14: {
                    currOutputStream.seek(offset + (long)toUpdate);
                    currOutputStream.write(bytesToWrite);
                    bl = closeFlag;
                    break;
                }
                case 18: {
                    this.updateCompressedSizeInLocalFileHeader(currOutputStream, localFileHeader, offset, toUpdate, bytesToWrite, zipModel.isZip64Format());
                    bl = closeFlag;
                    break;
                }
                default: {
                    bl = closeFlag;
                }
            }
            if (bl) {
                currOutputStream.close();
                return;
            }
            outputStream.seek(currOffset);
            return;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void writeEndOfCentralDirectoryRecord(ZipModel zipModel, OutputStream outputStream, int sizeOfCentralDir, long offsetCentralDir) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("zip model or output stream is null, cannot write end of central directory record");
        }
        try {
            void longByte;
            byte[] byArray;
            ArrayList byteArrayList = new ArrayList();
            byte[] shortByte = new byte[2];
            byte[] intByte = new byte[4];
            byte[] byArray2 = new byte[8];
            Raw.writeIntLittleEndian(intByte, 0, (int)zipModel.getEndCentralDirRecord().getSignature());
            HeaderWriter headerWriter = this;
            ArrayList arrayList = byteArrayList;
            this.copyByteArrayToArrayList(intByte, arrayList);
            Raw.writeShortLittleEndian(shortByte, 0, (short)zipModel.getEndCentralDirRecord().getNoOfThisDisk());
            headerWriter.copyByteArrayToArrayList(shortByte, arrayList);
            Raw.writeShortLittleEndian(shortByte, 0, (short)zipModel.getEndCentralDirRecord().getNoOfThisDiskStartOfCentralDir());
            headerWriter.copyByteArrayToArrayList(shortByte, byteArrayList);
            int numEntries = 0;
            int numEntriesOnThisDisk = 0;
            if (zipModel.getCentralDirectory() == null || zipModel.getCentralDirectory().getFileHeaders() == null) {
                throw new ZipException("invalid central directory/file headers, cannot write end of central directory record");
            }
            ZipModel zipModel2 = zipModel;
            numEntries = zipModel2.getCentralDirectory().getFileHeaders().size();
            if (zipModel2.isSplitArchive()) {
                byArray = shortByte;
                numEntriesOnThisDisk = this.countNumberOfFileHeaderEntriesOnDisk(zipModel.getCentralDirectory().getFileHeaders(), zipModel.getEndCentralDirRecord().getNoOfThisDisk());
            } else {
                numEntriesOnThisDisk = numEntries;
                byArray = shortByte;
            }
            Raw.writeShortLittleEndian(byArray, 0, (short)numEntriesOnThisDisk);
            HeaderWriter headerWriter2 = this;
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            Raw.writeShortLittleEndian(shortByte, 0, (short)numEntries);
            headerWriter2.copyByteArrayToArrayList(shortByte, byteArrayList);
            Raw.writeIntLittleEndian(intByte, 0, sizeOfCentralDir);
            headerWriter2.copyByteArrayToArrayList(intByte, byteArrayList);
            if (offsetCentralDir > 0xFFFFFFFFL) {
                void v5 = longByte;
                Raw.writeLongLittleEndian((byte[])v5, 0, 0xFFFFFFFFL);
                System.arraycopy(v5, 0, intByte, 0, 4);
                this.copyByteArrayToArrayList(intByte, byteArrayList);
            } else {
                Raw.writeLongLittleEndian((byte[])longByte, 0, offsetCentralDir);
                System.arraycopy(longByte, 0, intByte, 0, 4);
                this.copyByteArrayToArrayList(intByte, byteArrayList);
            }
            int commentLength = 0;
            if (zipModel.getEndCentralDirRecord().getComment() != null) {
                commentLength = zipModel.getEndCentralDirRecord().getComment().length();
            }
            Raw.writeShortLittleEndian(shortByte, 0, (short)commentLength);
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            if (commentLength > 0) {
                this.copyByteArrayToArrayList(zipModel.getEndCentralDirRecord().getComment().getBytes(), byteArrayList);
            }
            outputStream.write(this.byteArrayListToByteArray(byteArrayList));
            return;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finalizeZipFile(ZipModel zipModel, OutputStream outputStream) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot finalize zip file");
        }
        try {
            long offsetCentralDir = zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir();
            int sizeOfCentralDir = this.writeCentralDirectory(zipModel, outputStream);
            if (zipModel.isZip64Format()) {
                HeaderWriter headerWriter;
                if (zipModel.getZip64EndCentralDirRecord() == null) {
                    zipModel.setZip64EndCentralDirRecord(new Zip64EndCentralDirRecord());
                }
                if (zipModel.getZip64EndCentralDirLocator() == null) {
                    zipModel.setZip64EndCentralDirLocator(new Zip64EndCentralDirLocator());
                }
                zipModel.getZip64EndCentralDirLocator().setOffsetZip64EndOfCentralDirRec(offsetCentralDir + (long)sizeOfCentralDir);
                if (outputStream instanceof SplitOutputStream) {
                    zipModel.getZip64EndCentralDirLocator().setNoOfDiskStartOfZip64EndOfCentralDirRec(((SplitOutputStream)outputStream).getCurrSplitFileCounter());
                    zipModel.getZip64EndCentralDirLocator().setTotNumberOfDiscs(((SplitOutputStream)outputStream).getCurrSplitFileCounter() + 1);
                    headerWriter = this;
                } else {
                    ZipModel zipModel2 = zipModel;
                    zipModel2.getZip64EndCentralDirLocator().setNoOfDiskStartOfZip64EndOfCentralDirRec(0);
                    zipModel2.getZip64EndCentralDirLocator().setTotNumberOfDiscs(1);
                    headerWriter = this;
                }
                headerWriter.writeZip64EndOfCentralDirectoryRecord(zipModel, outputStream, sizeOfCentralDir, offsetCentralDir);
                this.writeZip64EndOfCentralDirectoryLocator(zipModel, outputStream);
            }
            this.writeEndOfCentralDirectoryRecord(zipModel, outputStream, sizeOfCentralDir, offsetCentralDir);
            return;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public int writeExtendedLocalHeader(LocalFileHeader localFileHeader, OutputStream outputStream) throws ZipException, IOException {
        void intByte;
        if (localFileHeader == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot write extended local header");
        }
        ArrayList byteArrayList = new ArrayList();
        byte[] byArray = new byte[4];
        HeaderWriter headerWriter = this;
        void v1 = intByte;
        Raw.writeIntLittleEndian((byte[])intByte, 0, 134695760);
        headerWriter.copyByteArrayToArrayList((byte[])v1, byteArrayList);
        Raw.writeIntLittleEndian((byte[])v1, 0, (int)localFileHeader.getCrc32());
        headerWriter.copyByteArrayToArrayList(byArray, byteArrayList);
        long compressedSize = localFileHeader.getCompressedSize();
        if (compressedSize >= Integer.MAX_VALUE) {
            compressedSize = Integer.MAX_VALUE;
        }
        Raw.writeIntLittleEndian((byte[])intByte, 0, (int)compressedSize);
        this.copyByteArrayToArrayList((byte[])intByte, byteArrayList);
        long uncompressedSize = localFileHeader.getUncompressedSize();
        if (uncompressedSize >= Integer.MAX_VALUE) {
            uncompressedSize = Integer.MAX_VALUE;
        }
        Raw.writeIntLittleEndian((byte[])intByte, 0, (int)uncompressedSize);
        HeaderWriter headerWriter2 = this;
        headerWriter2.copyByteArrayToArrayList((byte[])intByte, byteArrayList);
        byte[] extLocHdrBytes = headerWriter2.byteArrayListToByteArray(byteArrayList);
        outputStream.write(extLocHdrBytes);
        return extLocHdrBytes.length;
    }

    public void finalizeZipFileWithoutValidations(ZipModel zipModel, OutputStream outputStream) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot finalize zip file without validations");
        }
        long offsetCentralDir = zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir();
        int sizeOfCentralDir = this.writeCentralDirectory(zipModel, outputStream);
        if (zipModel.isZip64Format()) {
            if (zipModel.getZip64EndCentralDirRecord() == null) {
                zipModel.setZip64EndCentralDirRecord(new Zip64EndCentralDirRecord());
            }
            if (zipModel.getZip64EndCentralDirLocator() == null) {
                zipModel.setZip64EndCentralDirLocator(new Zip64EndCentralDirLocator());
            }
            zipModel.getZip64EndCentralDirLocator().setOffsetZip64EndOfCentralDirRec(offsetCentralDir + (long)sizeOfCentralDir);
            HeaderWriter headerWriter = this;
            headerWriter.writeZip64EndOfCentralDirectoryRecord(zipModel, outputStream, sizeOfCentralDir, offsetCentralDir);
            headerWriter.writeZip64EndOfCentralDirectoryLocator(zipModel, outputStream);
        }
        this.writeEndOfCentralDirectoryRecord(zipModel, outputStream, sizeOfCentralDir, offsetCentralDir);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writeLocalFileHeader(ZipModel zipModel, LocalFileHeader localFileHeader, OutputStream outputStream) throws ZipException {
        if (localFileHeader == null) {
            throw new ZipException("input parameters are null, cannot write local file header");
        }
        try {
            boolean bl;
            AESExtraDataRecord fileNameBytes;
            ArrayList byteArrayList = new ArrayList();
            int headerLength = 0;
            byte[] shortByte = new byte[2];
            byte[] intByte = new byte[4];
            byte[] longByte = new byte[8];
            byte[] byArray = new byte[8];
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = 0;
            byArray[3] = 0;
            byArray[4] = 0;
            byArray[5] = 0;
            byArray[6] = 0;
            byArray[7] = 0;
            byte[] byArray2 = byArray;
            HeaderWriter headerWriter = this;
            Raw.writeIntLittleEndian(intByte, 0, localFileHeader.getSignature());
            HeaderWriter headerWriter2 = this;
            HeaderWriter headerWriter3 = this;
            headerLength += 4;
            headerWriter3.copyByteArrayToArrayList(intByte, byteArrayList);
            headerLength += 2;
            Raw.writeShortLittleEndian(shortByte, 0, (short)localFileHeader.getVersionNeededToExtract());
            headerWriter3.copyByteArrayToArrayList(shortByte, byteArrayList);
            headerLength += 2;
            headerWriter2.copyByteArrayToArrayList(localFileHeader.getGeneralPurposeFlag(), byteArrayList);
            headerLength += 2;
            Raw.writeShortLittleEndian(shortByte, 0, (short)localFileHeader.getCompressionMethod());
            headerWriter2.copyByteArrayToArrayList(shortByte, byteArrayList);
            int dateTime = localFileHeader.getLastModFileTime();
            Raw.writeIntLittleEndian(intByte, 0, dateTime);
            headerLength += 4;
            headerWriter.copyByteArrayToArrayList(intByte, byteArrayList);
            Raw.writeIntLittleEndian(intByte, 0, (int)localFileHeader.getCrc32());
            headerLength += 4;
            headerWriter.copyByteArrayToArrayList(intByte, byteArrayList);
            boolean writingZip64Rec = false;
            if (localFileHeader.getUncompressedSize() + 50L >= 0xFFFFFFFFL) {
                Raw.writeLongLittleEndian(longByte, 0, 0xFFFFFFFFL);
                System.arraycopy(longByte, 0, intByte, 0, 4);
                HeaderWriter headerWriter4 = this;
                headerWriter4.copyByteArrayToArrayList(intByte, byteArrayList);
                headerWriter4.copyByteArrayToArrayList(intByte, byteArrayList);
                zipModel.setZip64Format(true);
                writingZip64Rec = true;
                localFileHeader.setWriteComprSizeInZip64ExtraRecord(true);
            } else {
                Raw.writeLongLittleEndian(longByte, 0, localFileHeader.getCompressedSize());
                System.arraycopy(longByte, 0, intByte, 0, 4);
                this.copyByteArrayToArrayList(intByte, byteArrayList);
                Raw.writeLongLittleEndian(longByte, 0, localFileHeader.getUncompressedSize());
                System.arraycopy(longByte, 0, intByte, 0, 4);
                this.copyByteArrayToArrayList(intByte, byteArrayList);
                localFileHeader.setWriteComprSizeInZip64ExtraRecord(false);
            }
            headerLength += 8;
            headerLength += 2;
            Raw.writeShortLittleEndian(shortByte, 0, (short)localFileHeader.getFileNameLength());
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            int extraFieldLength = 0;
            if (writingZip64Rec) {
                extraFieldLength += 20;
            }
            if (localFileHeader.getAesExtraDataRecord() != null) {
                extraFieldLength += 11;
            }
            Raw.writeShortLittleEndian(shortByte, 0, (short)extraFieldLength);
            headerLength += 2;
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            if (Zip4jUtil.isStringNotNullAndNotEmpty(zipModel.getFileNameCharset())) {
                byte[] byArray3 = localFileHeader.getFileName().getBytes(zipModel.getFileNameCharset());
                this.copyByteArrayToArrayList((byte[])fileNameBytes, byteArrayList);
                headerLength += ((void)fileNameBytes).length;
                bl = writingZip64Rec;
            } else {
                this.copyByteArrayToArrayList(Zip4jUtil.convertCharset(localFileHeader.getFileName()), byteArrayList);
                headerLength += Zip4jUtil.getEncodedStringLength(localFileHeader.getFileName());
                bl = writingZip64Rec;
            }
            if (bl) {
                void emptyLongByte;
                byte[] byArray4 = shortByte;
                headerLength += 2;
                Raw.writeShortLittleEndian(byArray4, 0, (short)1);
                this.copyByteArrayToArrayList(byArray4, byteArrayList);
                Raw.writeShortLittleEndian(shortByte, 0, (short)16);
                HeaderWriter headerWriter5 = this;
                headerLength += 2;
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
                headerLength += 8;
                Raw.writeLongLittleEndian(longByte, 0, localFileHeader.getUncompressedSize());
                headerLength += 8;
                headerWriter5.copyByteArrayToArrayList(longByte, byteArrayList);
                headerWriter5.copyByteArrayToArrayList((byte[])emptyLongByte, byteArrayList);
            }
            if (localFileHeader.getAesExtraDataRecord() != null) {
                void aesStrengthBytes;
                void aesExtraDataRecord;
                fileNameBytes = localFileHeader.getAesExtraDataRecord();
                HeaderWriter headerWriter6 = this;
                HeaderWriter headerWriter7 = this;
                Raw.writeShortLittleEndian(shortByte, 0, (short)aesExtraDataRecord.getSignature());
                headerWriter7.copyByteArrayToArrayList(shortByte, byteArrayList);
                Raw.writeShortLittleEndian(shortByte, 0, (short)aesExtraDataRecord.getDataSize());
                headerWriter7.copyByteArrayToArrayList(shortByte, byteArrayList);
                Raw.writeShortLittleEndian(shortByte, 0, (short)aesExtraDataRecord.getVersionNumber());
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
                headerWriter6.copyByteArrayToArrayList(aesExtraDataRecord.getVendorID().getBytes(), byteArrayList);
                byte[] byArray5 = new byte[1];
                void v10 = aesStrengthBytes;
                v10[0] = (byte)aesExtraDataRecord.getAesStrength();
                headerWriter6.copyByteArrayToArrayList((byte[])v10, byteArrayList);
                Raw.writeShortLittleEndian(shortByte, 0, (short)aesExtraDataRecord.getCompressionMethod());
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
            }
            byte[] lhBytes = this.byteArrayListToByteArray(byteArrayList);
            outputStream.write(lhBytes);
            return lhBytes.length;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }
}

