/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import net.lingala.zip4j.core.HeaderReader;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.UnzipParameters;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.unzip.Unzip;
import net.lingala.zip4j.util.ArchiveMaintainer;
import net.lingala.zip4j.util.InternalZipConstants;
import net.lingala.zip4j.util.Zip4jUtil;
import net.lingala.zip4j.zip.ZipEngine;

public class ZipFile {
    private ProgressMonitor progressMonitor;
    private String fileNameCharset;
    private boolean runInThread;
    private ZipModel zipModel;
    private String file;
    private boolean isEncrypted;
    private int mode;

    public void extractAll(String destPath, UnzipParameters unzipParameters) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(destPath)) {
            throw new ZipException("output path is null or invalid");
        }
        if (!Zip4jUtil.checkOutputFolder(destPath)) {
            throw new ZipException("invalid output path");
        }
        if (this.zipModel == null) {
            this.readZipInfo();
        }
        if (this.zipModel == null) {
            throw new ZipException("Internal error occurred when extracting zip file");
        }
        if (this.progressMonitor.getState() == 1) {
            throw new ZipException("invalid operation - Zip4j is in busy state");
        }
        ZipFile zipFile = this;
        new Unzip(this.zipModel).extractAll(unzipParameters, destPath, zipFile.progressMonitor, zipFile.runInThread);
    }

    public String getComment() throws ZipException {
        return this.getComment(null);
    }

    public void extractFile(String fileName, String destPath) throws ZipException {
        this.extractFile(fileName, destPath, null);
    }

    /*
     * WARNING - void declaration
     */
    public ZipFile(String string) throws ZipException {
        this(new File((String)zipFile));
        void zipFile;
    }

    public String getComment(String encoding) throws ZipException {
        if (encoding == null) {
            encoding = InternalZipConstants.CHARSET_DEFAULT;
        }
        if (!Zip4jUtil.checkFileExists(this.file)) {
            throw new ZipException("zip file does not exist, cannot read comment");
        }
        ZipFile zipFile = this;
        zipFile.checkZipModel();
        if (zipFile.zipModel == null) {
            throw new ZipException("zip model is null, cannot read comment");
        }
        if (this.zipModel.getEndCentralDirRecord() == null) {
            throw new ZipException("end of central directory record is null, cannot read comment");
        }
        if (this.zipModel.getEndCentralDirRecord().getCommentBytes() == null || this.zipModel.getEndCentralDirRecord().getCommentBytes().length <= 0) {
            return null;
        }
        try {
            return new String(this.zipModel.getEndCentralDirRecord().getCommentBytes(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZipException(e);
        }
    }

    public void createZipFileFromFolder(String folderToAdd, ZipParameters parameters, boolean splitArchive, long splitLength) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(folderToAdd)) {
            throw new ZipException("folderToAdd is empty or null, cannot create Zip File from folder");
        }
        this.createZipFileFromFolder(new File(folderToAdd), parameters, splitArchive, splitLength);
    }

    public List getFileHeaders() throws ZipException {
        ZipFile zipFile = this;
        zipFile.readZipInfo();
        if (zipFile.zipModel == null || this.zipModel.getCentralDirectory() == null) {
            return null;
        }
        return this.zipModel.getCentralDirectory().getFileHeaders();
    }

    public FileHeader getFileHeader(String fileName) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileName)) {
            throw new ZipException("input file name is emtpy or null, cannot get FileHeader");
        }
        ZipFile zipFile = this;
        zipFile.readZipInfo();
        if (zipFile.zipModel == null || this.zipModel.getCentralDirectory() == null) {
            return null;
        }
        return Zip4jUtil.getFileHeader(this.zipModel, fileName);
    }

    public void createZipFileFromFolder(File folderToAdd, ZipParameters parameters, boolean splitArchive, long splitLength) throws ZipException {
        if (folderToAdd == null) {
            throw new ZipException("folderToAdd is null, cannot create zip file from folder");
        }
        if (parameters == null) {
            throw new ZipException("input parameters are null, cannot create zip file from folder");
        }
        if (Zip4jUtil.checkFileExists(this.file)) {
            throw new ZipException(new StringBuilder().insert(0, "zip file: ").append(this.file).append(" already exists. To add files to existing zip file use addFolder method").toString());
        }
        ZipFile zipFile = this;
        zipFile.zipModel = new ZipModel();
        zipFile.zipModel.setZipFile(this.file);
        zipFile.zipModel.setSplitArchive(splitArchive);
        if (splitArchive) {
            this.zipModel.setSplitLength(splitLength);
        }
        this.addFolder(folderToAdd, parameters, false);
    }

    public void createZipFile(ArrayList sourceFileList, ZipParameters parameters, boolean splitArchive, long splitLength) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(this.file)) {
            throw new ZipException("zip file path is empty");
        }
        if (Zip4jUtil.checkFileExists(this.file)) {
            throw new ZipException(new StringBuilder().insert(0, "zip file: ").append(this.file).append(" already exists. To add files to existing zip file use addFile method").toString());
        }
        if (sourceFileList == null) {
            throw new ZipException("input file ArrayList is null, cannot create zip file");
        }
        if (!Zip4jUtil.checkArrayListTypes(sourceFileList, 1)) {
            throw new ZipException("One or more elements in the input ArrayList is not of type File");
        }
        ZipFile zipFile = this;
        zipFile.zipModel = new ZipModel();
        ZipFile zipFile2 = this;
        zipFile.zipModel.setZipFile(zipFile2.file);
        zipFile2.zipModel.setSplitArchive(splitArchive);
        zipFile.zipModel.setSplitLength(splitLength);
        this.addFiles(sourceFileList, parameters);
    }

    public void addStream(InputStream inputStream, ZipParameters parameters) throws ZipException {
        if (inputStream == null) {
            throw new ZipException("inputstream is null, cannot add file to zip");
        }
        if (parameters == null) {
            throw new ZipException("zip parameters are null");
        }
        ZipFile zipFile = this;
        zipFile.setRunInThread(false);
        zipFile.checkZipModel();
        if (zipFile.zipModel == null) {
            throw new ZipException("internal error: zip model is null");
        }
        if (Zip4jUtil.checkFileExists(this.file) && this.zipModel.isSplitArchive()) {
            throw new ZipException("Zip file already exists. Zip file format does not allow updating split/spanned files");
        }
        new ZipEngine(this.zipModel).addStreamToZip(inputStream, parameters);
    }

    public ZipInputStream getInputStream(FileHeader fileHeader) throws ZipException {
        if (fileHeader == null) {
            throw new ZipException("FileHeader is null, cannot get InputStream");
        }
        ZipFile zipFile = this;
        zipFile.checkZipModel();
        if (zipFile.zipModel == null) {
            throw new ZipException("zip model is null, cannot get inputstream");
        }
        return new Unzip(this.zipModel).getInputStream(fileHeader);
    }

    /*
     * WARNING - void declaration
     */
    public ZipFile(File file) throws ZipException {
        void zipFile;
        if (file == null) {
            throw new ZipException("Input zip file parameter is not null", 1);
        }
        ZipFile zipFile2 = this;
        zipFile2.file = zipFile.getPath();
        zipFile2.mode = 2;
        ZipFile zipFile3 = this;
        zipFile2.progressMonitor = new ProgressMonitor();
        this.runInThread = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void readZipInfo() throws ZipException {
        if (!Zip4jUtil.checkFileExists(this.file)) {
            throw new ZipException("zip file does not exist");
        }
        if (!Zip4jUtil.checkFileReadAccess(this.file)) {
            throw new ZipException("no read access for the input zip file");
        }
        if (this.mode != 2) {
            throw new ZipException("Invalid mode");
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(new File(this.file), "r");
            if (this.zipModel == null) {
                HeaderReader headerReader = new HeaderReader(raf);
                ZipFile zipFile = this;
                zipFile.zipModel = headerReader.readAllHeaders(zipFile.fileNameCharset);
                if (zipFile.zipModel != null) {
                    ZipFile zipFile2 = this;
                    zipFile2.zipModel.setZipFile(zipFile2.file);
                }
            }
            if (raf == null) return;
        }
        catch (FileNotFoundException e) {
            try {
                throw new ZipException(e);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (raf != null) {
                    try {
                        raf.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        try {
            raf.close();
            return;
        }
        catch (IOException headerReader) {
            return;
        }
    }

    public void addFiles(ArrayList sourceFileList, ZipParameters parameters) throws ZipException {
        ZipFile zipFile = this;
        zipFile.checkZipModel();
        if (zipFile.zipModel == null) {
            throw new ZipException("internal error: zip model is null");
        }
        if (sourceFileList == null) {
            throw new ZipException("input file ArrayList is null, cannot add files");
        }
        if (!Zip4jUtil.checkArrayListTypes(sourceFileList, 1)) {
            throw new ZipException("One or more elements in the input ArrayList is not of type File");
        }
        if (parameters == null) {
            throw new ZipException("input parameters are null, cannot add files to zip");
        }
        if (this.progressMonitor.getState() == 1) {
            throw new ZipException("invalid operation - Zip4j is in busy state");
        }
        if (Zip4jUtil.checkFileExists(this.file) && this.zipModel.isSplitArchive()) {
            throw new ZipException("Zip file already exists. Zip file format does not allow updating split/spanned files");
        }
        ZipFile zipFile2 = this;
        new ZipEngine(this.zipModel).addFiles(sourceFileList, parameters, zipFile2.progressMonitor, zipFile2.runInThread);
    }

    private /* synthetic */ void addFolder(File path, ZipParameters parameters, boolean checkSplitArchive) throws ZipException {
        ZipFile zipFile = this;
        zipFile.checkZipModel();
        if (zipFile.zipModel == null) {
            throw new ZipException("internal error: zip model is null");
        }
        if (checkSplitArchive && this.zipModel.isSplitArchive()) {
            throw new ZipException("This is a split archive. Zip file format does not allow updating split/spanned files");
        }
        ZipFile zipFile2 = this;
        new ZipEngine(this.zipModel).addFolderToZip(path, parameters, zipFile2.progressMonitor, zipFile2.runInThread);
    }

    public void addFolder(File path, ZipParameters parameters) throws ZipException {
        if (path == null) {
            throw new ZipException("input path is null, cannot add folder to zip file");
        }
        if (parameters == null) {
            throw new ZipException("input parameters are null, cannot add folder to zip file");
        }
        this.addFolder(path, parameters, true);
    }

    public void removeFile(FileHeader fileHeader) throws ZipException {
        ArchiveMaintainer archiveMaintainer;
        if (fileHeader == null) {
            throw new ZipException("file header is null, cannot remove file");
        }
        if (this.zipModel == null && Zip4jUtil.checkFileExists(this.file)) {
            this.readZipInfo();
        }
        if (this.zipModel.isSplitArchive()) {
            throw new ZipException("Zip file format does not allow updating split/spanned files");
        }
        ArchiveMaintainer archiveMaintainer2 = archiveMaintainer = new ArchiveMaintainer();
        archiveMaintainer2.initProgressMonitorForRemoveOp(this.zipModel, fileHeader, this.progressMonitor);
        ZipFile zipFile = this;
        archiveMaintainer2.removeZipFile(this.zipModel, fileHeader, zipFile.progressMonitor, zipFile.runInThread);
    }

    public void createZipFile(ArrayList sourceFileList, ZipParameters parameters) throws ZipException {
        this.createZipFile(sourceFileList, parameters, false, -1L);
    }

    public void addFile(File sourceFile, ZipParameters parameters) throws ZipException {
        ArrayList<File> sourceFileList = new ArrayList<File>();
        sourceFileList.add(sourceFile);
        this.addFiles(sourceFileList, parameters);
    }

    public void setComment(String comment) throws ZipException {
        if (comment == null) {
            throw new ZipException("input comment is null, cannot update zip file");
        }
        if (!Zip4jUtil.checkFileExists(this.file)) {
            throw new ZipException("zip file does not exist, cannot set comment for zip file");
        }
        ZipFile zipFile = this;
        zipFile.readZipInfo();
        if (zipFile.zipModel == null) {
            throw new ZipException("zipModel is null, cannot update zip file");
        }
        if (this.zipModel.getEndCentralDirRecord() == null) {
            throw new ZipException("end of central directory is null, cannot set comment");
        }
        new ArchiveMaintainer().setComment(this.zipModel, comment);
    }

    public boolean isRunInThread() {
        return this.runInThread;
    }

    public void setPassword(String password) throws ZipException {
        int i;
        if (this.zipModel == null) {
            ZipFile zipFile = this;
            zipFile.readZipInfo();
            if (zipFile.zipModel == null) {
                throw new ZipException("Zip Model is null");
            }
        }
        if (this.zipModel.getCentralDirectory() == null || this.zipModel.getCentralDirectory().getFileHeaders() == null) {
            throw new ZipException("invalid zip file");
        }
        int n = i = 0;
        while (n < this.zipModel.getCentralDirectory().getFileHeaders().size()) {
            if (this.zipModel.getCentralDirectory().getFileHeaders().get(i) != null && ((FileHeader)this.zipModel.getCentralDirectory().getFileHeaders().get(i)).isEncrypted()) {
                ((FileHeader)this.zipModel.getCentralDirectory().getFileHeaders().get(i)).setPassword(password);
            }
            n = ++i;
        }
    }

    public void setFileNameCharset(String charsetName) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(charsetName)) {
            throw new ZipException("null or empty charset name");
        }
        if (!Zip4jUtil.isSupportedCharset(charsetName)) {
            throw new ZipException(new StringBuilder().insert(0, "unsupported charset: ").append(charsetName).toString());
        }
        this.fileNameCharset = charsetName;
    }

    public void mergeSplitFiles(File outputZipFile) throws ZipException {
        ArchiveMaintainer archiveMaintainer;
        if (outputZipFile == null) {
            throw new ZipException("outputZipFile is null, cannot merge split files");
        }
        if (outputZipFile.exists()) {
            throw new ZipException("output Zip File already exists");
        }
        ZipFile zipFile = this;
        zipFile.checkZipModel();
        if (zipFile.zipModel == null) {
            throw new ZipException("zip model is null, corrupt zip file?");
        }
        ArchiveMaintainer archiveMaintainer2 = archiveMaintainer = new ArchiveMaintainer();
        ZipFile zipFile2 = this;
        archiveMaintainer2.initProgressMonitorForMergeOp(zipFile2.zipModel, zipFile2.progressMonitor);
        ZipFile zipFile3 = this;
        archiveMaintainer2.mergeSplitZipFiles(this.zipModel, outputZipFile, zipFile3.progressMonitor, zipFile3.runInThread);
    }

    public boolean isValidZipFile() {
        boolean bl;
        try {
            this.readZipInfo();
            bl = true;
        }
        catch (Exception e) {
            return false;
        }
        return bl;
    }

    private /* synthetic */ void checkZipModel() throws ZipException {
        if (this.zipModel == null) {
            if (Zip4jUtil.checkFileExists(this.file)) {
                this.readZipInfo();
                return;
            }
            this.zipModel = new ZipModel();
            this.zipModel.setZipFile(this.file);
        }
    }

    public void extractFile(FileHeader fileHeader, String destPath) throws ZipException {
        this.extractFile(fileHeader, destPath, null);
    }

    public void addFolder(String path, ZipParameters parameters) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(path)) {
            throw new ZipException("input path is null or empty, cannot add folder to zip file");
        }
        this.addFolder(new File(path), parameters);
    }

    public void removeFile(String fileName) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileName)) {
            throw new ZipException("file name is empty or null, cannot remove file");
        }
        if (this.zipModel == null && Zip4jUtil.checkFileExists(this.file)) {
            this.readZipInfo();
        }
        if (this.zipModel.isSplitArchive()) {
            throw new ZipException("Zip file format does not allow updating split/spanned files");
        }
        FileHeader fileHeader = Zip4jUtil.getFileHeader(this.zipModel, fileName);
        if (fileHeader == null) {
            throw new ZipException(new StringBuilder().insert(0, "could not find file header for file: ").append(fileName).toString());
        }
        this.removeFile(fileHeader);
    }

    public void extractAll(String destPath) throws ZipException {
        this.extractAll(destPath, null);
    }

    public void extractFile(String fileName, String destPath, UnzipParameters unzipParameters) throws ZipException {
        this.extractFile(fileName, destPath, unzipParameters, null);
    }

    public void setRunInThread(boolean runInThread) {
        this.runInThread = runInThread;
    }

    public boolean isSplitArchive() throws ZipException {
        if (this.zipModel == null) {
            ZipFile zipFile = this;
            zipFile.readZipInfo();
            if (zipFile.zipModel == null) {
                throw new ZipException("Zip Model is null");
            }
        }
        return this.zipModel.isSplitArchive();
    }

    public ArrayList getSplitZipFiles() throws ZipException {
        ZipFile zipFile = this;
        zipFile.checkZipModel();
        return Zip4jUtil.getSplitZipFiles(zipFile.zipModel);
    }

    public void createZipFile(File sourceFile, ZipParameters parameters, boolean splitArchive, long splitLength) throws ZipException {
        ArrayList<File> sourceFileList = new ArrayList<File>();
        sourceFileList.add(sourceFile);
        this.createZipFile(sourceFileList, parameters, splitArchive, splitLength);
    }

    public void extractFile(String fileName, String destPath, UnzipParameters unzipParameters, String newFileName) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileName)) {
            throw new ZipException("file to extract is null or empty, cannot extract file");
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(destPath)) {
            throw new ZipException("destination string path is empty or null, cannot extract file");
        }
        ZipFile zipFile = this;
        zipFile.readZipInfo();
        FileHeader fileHeader = Zip4jUtil.getFileHeader(zipFile.zipModel, fileName);
        if (fileHeader == null) {
            throw new ZipException("file header not found for given file name, cannot extract file");
        }
        if (this.progressMonitor.getState() == 1) {
            throw new ZipException("invalid operation - Zip4j is in busy state");
        }
        ZipFile zipFile2 = this;
        fileHeader.extractFile(this.zipModel, destPath, unzipParameters, newFileName, zipFile2.progressMonitor, zipFile2.runInThread);
    }

    public void extractFile(FileHeader fileHeader, String destPath, UnzipParameters unzipParameters) throws ZipException {
        this.extractFile(fileHeader, destPath, unzipParameters, null);
    }

    public boolean isEncrypted() throws ZipException {
        ZipFile zipFile;
        block5: {
            int i;
            if (this.zipModel == null) {
                ZipFile zipFile2 = this;
                zipFile2.readZipInfo();
                if (zipFile2.zipModel == null) {
                    throw new ZipException("Zip Model is null");
                }
            }
            if (this.zipModel.getCentralDirectory() == null || this.zipModel.getCentralDirectory().getFileHeaders() == null) {
                throw new ZipException("invalid zip file");
            }
            ArrayList fileHeaderList = this.zipModel.getCentralDirectory().getFileHeaders();
            int n = i = 0;
            while (n < fileHeaderList.size()) {
                FileHeader fileHeader = (FileHeader)fileHeaderList.get(i);
                if (fileHeader != null && fileHeader.isEncrypted()) {
                    zipFile = this;
                    this.isEncrypted = true;
                    break block5;
                }
                n = ++i;
            }
            zipFile = this;
        }
        return zipFile.isEncrypted;
    }

    public void createZipFile(File sourceFile, ZipParameters parameters) throws ZipException {
        ArrayList<File> sourceFileList = new ArrayList<File>();
        sourceFileList.add(sourceFile);
        this.createZipFile(sourceFileList, parameters, false, -1L);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void extractFile(FileHeader fileHeader, String destPath, UnzipParameters unzipParameters, String newFileName) throws ZipException {
        if (fileHeader == null) {
            throw new ZipException("input file header is null, cannot extract file");
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(destPath)) {
            throw new ZipException("destination path is empty or null, cannot extract file");
        }
        ZipFile zipFile = this;
        zipFile.readZipInfo();
        if (zipFile.progressMonitor.getState() == 1) {
            throw new ZipException("invalid operation - Zip4j is in busy state");
        }
        ZipFile zipFile2 = this;
        fileHeader.extractFile(this.zipModel, destPath, unzipParameters, newFileName, zipFile2.progressMonitor, zipFile2.runInThread);
    }
}

