/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import java.util.ArrayList;
import java.util.Arrays;
import net.lingala.zip4j.crypto.IDecrypter;
import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Engine;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import net.lingala.zip4j.crypto.engine.AESEngine;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.util.Raw;
import net.lingala.zip4j.util.Zip4jUtil;

public class AESDecrypter
implements IDecrypter {
    private int MAC_LENGTH;
    private byte[] derivedPasswordVerifier;
    private int SALT_LENGTH;
    private int nonce;
    private AESEngine aesEngine;
    private byte[] macKey;
    private byte[] storedMac;
    private final int PASSWORD_VERIFIER_LENGTH = 2;
    private byte[] aesKey;
    private LocalFileHeader localFileHeader;
    private MacBasedPRF mac;
    private int KEY_LENGTH;

    private /* synthetic */ void init(byte[] salt, byte[] passwordVerifier) throws ZipException {
        byte[] derivedKey;
        block15: {
            block14: {
                AESDecrypter aESDecrypter;
                if (this.localFileHeader == null) {
                    throw new ZipException("invalid file header in init method of AESDecryptor");
                }
                AESExtraDataRecord aesExtraDataRecord = this.localFileHeader.getAesExtraDataRecord();
                if (aesExtraDataRecord == null) {
                    throw new ZipException("invalid aes extra data record - in init method of AESDecryptor");
                }
                switch (aesExtraDataRecord.getAesStrength()) {
                    case 1: {
                        aESDecrypter = this;
                        while (false) {
                        }
                        AESDecrypter aESDecrypter2 = this;
                        this.KEY_LENGTH = 16;
                        aESDecrypter2.MAC_LENGTH = 16;
                        aESDecrypter2.SALT_LENGTH = 8;
                        break;
                    }
                    case 2: {
                        aESDecrypter = this;
                        AESDecrypter aESDecrypter3 = this;
                        this.KEY_LENGTH = 24;
                        aESDecrypter3.MAC_LENGTH = 24;
                        aESDecrypter3.SALT_LENGTH = 12;
                        break;
                    }
                    case 3: {
                        aESDecrypter = this;
                        AESDecrypter aESDecrypter4 = this;
                        this.KEY_LENGTH = 32;
                        aESDecrypter4.MAC_LENGTH = 32;
                        aESDecrypter4.SALT_LENGTH = 16;
                        break;
                    }
                    default: {
                        throw new ZipException(new StringBuilder().insert(0, "invalid aes key strength for file: ").append(this.localFileHeader.getFileName()).toString());
                    }
                }
                if (!Zip4jUtil.isStringNotNullAndNotEmpty(aESDecrypter.localFileHeader.getPassword())) {
                    throw new ZipException("empty or null password provided for AES Decryptor");
                }
                derivedKey = this.deriveKey(salt, this.localFileHeader.getPassword());
                if (derivedKey == null) break block14;
                AESDecrypter aESDecrypter5 = this;
                if (derivedKey.length == aESDecrypter5.KEY_LENGTH + aESDecrypter5.MAC_LENGTH + 2) break block15;
            }
            throw new ZipException("invalid derived key");
        }
        AESDecrypter aESDecrypter = this;
        this.aesKey = new byte[this.KEY_LENGTH];
        this.macKey = new byte[this.MAC_LENGTH];
        this.derivedPasswordVerifier = new byte[2];
        AESDecrypter aESDecrypter6 = this;
        System.arraycopy(derivedKey, 0, aESDecrypter6.aesKey, 0, this.KEY_LENGTH);
        System.arraycopy(derivedKey, aESDecrypter6.KEY_LENGTH, this.macKey, 0, this.MAC_LENGTH);
        System.arraycopy(derivedKey, aESDecrypter.KEY_LENGTH + this.MAC_LENGTH, this.derivedPasswordVerifier, 0, 2);
        if (aESDecrypter.derivedPasswordVerifier == null) {
            throw new ZipException("invalid derived password verifier for AES");
        }
        if (!Arrays.equals(passwordVerifier, this.derivedPasswordVerifier)) {
            throw new ZipException(new StringBuilder().insert(0, "Wrong Password for file: ").append(this.localFileHeader.getFileName()).toString());
        }
        this.aesEngine = new AESEngine(this.aesKey);
        AESDecrypter aESDecrypter7 = this;
        aESDecrypter7.mac = new MacBasedPRF("HmacSHA1");
        this.mac.init(this.macKey);
    }

    public int getSaltLength() {
        return this.SALT_LENGTH;
    }

    @Override
    public int decryptData(byte[] buff) throws ZipException {
        return this.decryptData(buff, 0, buff.length);
    }

    public int getPasswordVerifierLength() {
        return 2;
    }

    private /* synthetic */ byte[] deriveKey(byte[] salt, String password) throws ZipException {
        try {
            PBKDF2Parameters p = new PBKDF2Parameters("HmacSHA1", "ISO-8859-1", salt, 1000);
            AESDecrypter aESDecrypter = this;
            byte[] derivedKey = new PBKDF2Engine(p).deriveKey(password, aESDecrypter.KEY_LENGTH + aESDecrypter.MAC_LENGTH + 2);
            return derivedKey;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int decryptData(byte[] buff, int start, int len) throws ZipException {
        if (this.aesEngine == null) {
            throw new ZipException("AES not initialized properly");
        }
        try {
            int i;
            int i2;
            int i3;
            ArrayList<byte[]> byteBlocks = new ArrayList<byte[]>();
            ArrayList<byte[]> decBlocks = new ArrayList<byte[]>();
            int n = i3 = 0;
            while (n < len) {
                byte[] block;
                byte[] byArray;
                if (i3 + 16 > len) {
                    byte[] byArray2 = new byte[len - i3];
                    byArray = buff;
                } else {
                    block = new byte[16];
                    byArray = buff;
                }
                System.arraycopy(byArray, i3, block, 0, block.length);
                byteBlocks.add(block);
                n = i3 += 16;
            }
            byte[] iv = new byte[16];
            byte[] counterBlock = new byte[16];
            int n2 = i2 = 0;
            while (n2 < byteBlocks.size()) {
                void j;
                byte[] cipherBlock = (byte[])byteBlocks.get(i2);
                byte[] decryptedBlock = new byte[cipherBlock.length];
                AESDecrypter aESDecrypter = this;
                aESDecrypter.mac.update(cipherBlock);
                iv = Raw.toByteArray(aESDecrypter.nonce, 16);
                aESDecrypter.aesEngine.processBlock(iv, counterBlock);
                boolean bl = false;
                void v4 = j;
                while (v4 < cipherBlock.length) {
                    void v5 = j++;
                    decryptedBlock[v5] = (byte)(cipherBlock[j] ^ counterBlock[v5]);
                    v4 = j;
                }
                decBlocks.add(decryptedBlock);
                ++this.nonce;
                n2 = ++i2;
            }
            int pos = 0;
            int n3 = i = 0;
            while (true) {
                if (n3 >= decBlocks.size()) {
                    return len;
                }
                System.arraycopy(decBlocks.get(i), 0, buff, pos, ((byte[])decBlocks.get(i)).length);
                pos += ((byte[])decBlocks.get(++i)).length;
                n3 = i;
            }
        }
        catch (ZipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public void setStoredMac(byte[] storedMac) {
        this.storedMac = storedMac;
    }

    public byte[] getStoredMac() {
        return this.storedMac;
    }

    /*
     * WARNING - void declaration
     */
    public AESDecrypter(LocalFileHeader localFileHeader, byte[] byArray, byte[] byArray2) throws ZipException {
        void passwordVerifier;
        void salt;
        void localFileHeader2;
        AESDecrypter aESDecrypter = this;
        aESDecrypter.PASSWORD_VERIFIER_LENGTH = 2;
        aESDecrypter.nonce = 1;
        if (localFileHeader == null) {
            throw new ZipException("one of the input parameters is null in AESDecryptor Constructor");
        }
        AESDecrypter aESDecrypter2 = this;
        aESDecrypter2.localFileHeader = localFileHeader2;
        aESDecrypter2.storedMac = null;
        this.init((byte[])salt, (byte[])passwordVerifier);
    }

    public byte[] getCalculatedAuthenticationBytes() {
        return this.mac.doFinal();
    }
}

