/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import java.util.ArrayList;
import java.util.Random;
import net.lingala.zip4j.crypto.IEncrypter;
import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Engine;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import net.lingala.zip4j.crypto.engine.AESEngine;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.util.Raw;
import net.lingala.zip4j.util.Zip4jUtil;

public class AESEncrpyter
implements IEncrypter {
    private int nonce;
    private byte[] macKey;
    private boolean finished;
    private byte[] saltBytes;
    private int keyStrength;
    private int KEY_LENGTH;
    private AESEngine aesEngine;
    private byte[] aesKey;
    private int MAC_LENGTH;
    private byte[] aesSplitBlock;
    private byte[] counterBlock;
    private MacBasedPRF mac;
    private String password;
    private byte[] iv;
    private byte[] derivedPasswordVerifier;
    private final int PASSWORD_VERIFIER_LENGTH = 2;
    private int SALT_LENGTH;

    @Override
    public int encryptData(byte[] buff) throws ZipException {
        if (buff == null) {
            throw new ZipException("input bytes are null, cannot perform AES encrpytion");
        }
        return this.encryptData(buff, 0, buff.length);
    }

    private /* synthetic */ void init() throws ZipException {
        byte[] keyBytes;
        block8: {
            block7: {
                switch (this.keyStrength) {
                    case 1: {
                        AESEncrpyter aESEncrpyter = this;
                        while (false) {
                        }
                        AESEncrpyter aESEncrpyter2 = this;
                        this.KEY_LENGTH = 16;
                        aESEncrpyter2.MAC_LENGTH = 16;
                        aESEncrpyter2.SALT_LENGTH = 8;
                        break;
                    }
                    case 3: {
                        AESEncrpyter aESEncrpyter = this;
                        AESEncrpyter aESEncrpyter3 = this;
                        this.KEY_LENGTH = 32;
                        aESEncrpyter3.MAC_LENGTH = 32;
                        aESEncrpyter3.SALT_LENGTH = 16;
                        break;
                    }
                    default: {
                        throw new ZipException("invalid aes key strength, cannot determine key sizes");
                    }
                }
                aESEncrpyter.saltBytes = AESEncrpyter.generateSalt(this.SALT_LENGTH);
                AESEncrpyter aESEncrpyter = this;
                keyBytes = aESEncrpyter.deriveKey(this.saltBytes, aESEncrpyter.password);
                if (keyBytes == null) break block7;
                AESEncrpyter aESEncrpyter4 = this;
                if (keyBytes.length == aESEncrpyter4.KEY_LENGTH + aESEncrpyter4.MAC_LENGTH + 2) break block8;
            }
            throw new ZipException("invalid key generated, cannot decrypt file");
        }
        this.aesKey = new byte[this.KEY_LENGTH];
        this.macKey = new byte[this.MAC_LENGTH];
        this.derivedPasswordVerifier = new byte[2];
        System.arraycopy(keyBytes, 0, this.aesKey, 0, this.KEY_LENGTH);
        System.arraycopy(keyBytes, this.KEY_LENGTH, this.macKey, 0, this.MAC_LENGTH);
        System.arraycopy(keyBytes, this.KEY_LENGTH + this.MAC_LENGTH, this.derivedPasswordVerifier, 0, 2);
        AESEncrpyter aESEncrpyter = this;
        this.aesEngine = new AESEngine(this.aesKey);
        AESEncrpyter aESEncrpyter5 = this;
        this.mac = new MacBasedPRF("HmacSHA1");
        this.mac.init(this.macKey);
    }

    public void setDerivedPasswordVerifier(byte[] derivedPasswordVerifier) {
        this.derivedPasswordVerifier = derivedPasswordVerifier;
    }

    public byte[] getSaltBytes() {
        return this.saltBytes;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ byte[] generateSalt(int size) throws ZipException {
        int j;
        if (size != 8) {
            if (size != 16) {
                throw new ZipException("invalid salt size, cannot generate salt");
            }
        }
        int rounds = 0;
        if (size == 8) {
            rounds = 2;
        }
        if (size == 16) {
            rounds = 4;
        }
        byte[] salt = new byte[size];
        int n = j = 0;
        while (n < rounds) {
            void i;
            int n2 = new Random().nextInt();
            salt[0 + j * 4] = (byte)(i >> 24);
            salt[1 + j * 4] = (byte)(i >> 16);
            salt[2 + j * 4] = (byte)(i >> 8);
            int n3 = 3 + j * 4;
            salt[n3] = (byte)i;
            n = ++j;
        }
        return salt;
    }

    /*
     * WARNING - void declaration
     */
    public AESEncrpyter(String string, int n) throws ZipException {
        void password;
        void keyStrength;
        AESEncrpyter aESEncrpyter = this;
        AESEncrpyter aESEncrpyter2 = this;
        this.PASSWORD_VERIFIER_LENGTH = 2;
        aESEncrpyter2.nonce = 1;
        aESEncrpyter2.iv = new byte[16];
        aESEncrpyter.counterBlock = new byte[16];
        aESEncrpyter.aesSplitBlock = new byte[16];
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("input password is empty or null in AES encrypter constructor");
        }
        if (keyStrength != true) {
            if (keyStrength != 3) {
                throw new ZipException("Invalid key strength in AES encrypter constructor");
            }
        }
        AESEncrpyter aESEncrpyter3 = this;
        this.password = password;
        aESEncrpyter3.keyStrength = keyStrength;
        aESEncrpyter3.finished = false;
        this.init();
    }

    public int getPasswordVeriifierLength() {
        return 2;
    }

    public byte[] getFinalMac() {
        byte[] rawMacBytes = this.mac.doFinal();
        byte[] macBytes = new byte[10];
        System.arraycopy(rawMacBytes, 0, macBytes, 0, 10);
        return macBytes;
    }

    public void setSaltBytes(byte[] saltBytes) {
        this.saltBytes = saltBytes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int encryptData(byte[] buff, int start, int len) throws ZipException {
        int i;
        int i2;
        if (this.finished) {
            throw new ZipException("AES Encrypter is in finished state (A non 16 byte block has already been passed to encrypter)");
        }
        if (len % 16 != 0) {
            this.finished = true;
        }
        ArrayList<Object> byteBlocks = new ArrayList<Object>();
        ArrayList<byte[]> encBlocks = new ArrayList<byte[]>();
        int n = i2 = 0;
        while (n < len) {
            if (i2 + 16 > len) {
                byte[] block = new byte[len - i2];
                System.arraycopy(buff, i2 + start, block, 0, block.length);
                byteBlocks.add(block);
            } else {
                System.arraycopy(buff, i2 + start, this.aesSplitBlock, 0, this.aesSplitBlock.length);
                byteBlocks.add(this.aesSplitBlock.clone());
            }
            n = i2 += 16;
        }
        int n2 = i2 = 0;
        while (n2 < byteBlocks.size()) {
            void j;
            byte[] plainBlock = (byte[])byteBlocks.get(i2);
            byte[] encryptedBlock = new byte[plainBlock.length];
            AESEncrpyter aESEncrpyter = this;
            aESEncrpyter.iv = Raw.toByteArray(aESEncrpyter.nonce, 16);
            AESEncrpyter aESEncrpyter2 = this;
            aESEncrpyter.aesEngine.processBlock(aESEncrpyter2.iv, aESEncrpyter2.counterBlock);
            boolean bl = false;
            void v4 = j;
            while (v4 < plainBlock.length) {
                void v5 = j++;
                encryptedBlock[v5] = (byte)(plainBlock[j] ^ this.counterBlock[v5]);
                v4 = j;
            }
            encBlocks.add(encryptedBlock);
            AESEncrpyter aESEncrpyter3 = this;
            aESEncrpyter3.mac.update(encryptedBlock);
            ++aESEncrpyter3.nonce;
            n2 = ++i2;
        }
        int pos = start;
        int n3 = i = 0;
        while (n3 < encBlocks.size()) {
            System.arraycopy(encBlocks.get(i), 0, buff, pos, ((byte[])encBlocks.get(i)).length);
            pos += ((byte[])encBlocks.get(++i)).length;
            n3 = i;
        }
        return len;
    }

    public int getSaltLength() {
        return this.SALT_LENGTH;
    }

    private /* synthetic */ byte[] deriveKey(byte[] salt, String password) throws ZipException {
        try {
            PBKDF2Parameters p = new PBKDF2Parameters("HmacSHA1", "ISO-8859-1", salt, 1000);
            AESEncrpyter aESEncrpyter = this;
            byte[] derivedKey = new PBKDF2Engine(p).deriveKey(password, aESEncrpyter.KEY_LENGTH + aESEncrpyter.MAC_LENGTH + 2);
            return derivedKey;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public byte[] getDerivedPasswordVerifier() {
        return this.derivedPasswordVerifier;
    }
}

