/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto.PBKDF2;

import java.io.UnsupportedEncodingException;
import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import net.lingala.zip4j.crypto.PBKDF2.PRF;

public class PBKDF2Engine {
    protected PRF prf;
    protected PBKDF2Parameters parameters;

    protected void assertPRF(byte[] P) {
        if (this.prf == null) {
            PBKDF2Engine pBKDF2Engine = this;
            this.prf = new MacBasedPRF(this.parameters.getHashAlgorithm());
        }
        this.prf.init(P);
    }

    /*
     * WARNING - void declaration
     */
    public PBKDF2Engine(PBKDF2Parameters pBKDF2Parameters) {
        void parameters;
        PBKDF2Engine pBKDF2Engine = this;
        pBKDF2Engine.parameters = parameters;
        pBKDF2Engine.prf = null;
    }

    public boolean verifyKey(String inputPassword) {
        int i;
        byte[] referenceKey = this.getParameters().getDerivedKey();
        if (referenceKey == null || referenceKey.length == 0) {
            return false;
        }
        byte[] inputKey = this.deriveKey(inputPassword, referenceKey.length);
        if (inputKey == null || inputKey.length != referenceKey.length) {
            return false;
        }
        int n = i = 0;
        while (n < inputKey.length) {
            if (inputKey[i] != referenceKey[i]) {
                return false;
            }
            n = ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public PBKDF2Engine(PBKDF2Parameters pBKDF2Parameters, PRF pRF) {
        void parameters;
        PBKDF2Engine pBKDF2Engine = this;
        pBKDF2Engine.parameters = parameters;
        pBKDF2Engine.prf = pRF;
    }

    /*
     * WARNING - void declaration
     */
    protected void INT(byte[] byArray, int n, int n2) {
        void i;
        void offset;
        void dest;
        void v0 = dest;
        void v1 = offset;
        dest[offset + false] = (byte)(i / 0x1000000);
        dest[v1 + true] = (byte)(i / 65536);
        v0[v1 + 2] = (byte)(i / 256);
        v0[n + 3] = (byte)i;
    }

    public PBKDF2Parameters getParameters() {
        return this.parameters;
    }

    protected void _F(byte[] dest, int offset, PRF prf, byte[] S, int c, int blockIndex) {
        int i;
        int hLen = prf.getHLen();
        byte[] U_r = new byte[hLen];
        byte[] U_i = new byte[S.length + 4];
        System.arraycopy(S, 0, U_i, 0, S.length);
        this.INT(U_i, S.length, blockIndex);
        int n = i = 0;
        while (n < c) {
            U_i = prf.doFinal(U_i);
            this.xor(U_r, U_i);
            n = ++i;
        }
        System.arraycopy(U_r, 0, dest, offset, hLen);
    }

    public byte[] deriveKey(String inputPassword) {
        return this.deriveKey(inputPassword, 0);
    }

    public PRF getPseudoRandomFunction() {
        return this.prf;
    }

    public byte[] deriveKey(String inputPassword, int dkLen) {
        String charset;
        byte[] P;
        byte[] r;
        block5: {
            r = null;
            P = null;
            charset = this.parameters.getHashCharset();
            if (inputPassword == null) {
                inputPassword = "";
            }
            try {
                if (charset != null) break block5;
                P = inputPassword.getBytes();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        P = inputPassword.getBytes(charset);
        this.assertPRF(P);
        if (dkLen == 0) {
            dkLen = this.prf.getHLen();
        }
        PBKDF2Engine pBKDF2Engine = this;
        r = pBKDF2Engine.PBKDF2(pBKDF2Engine.prf, pBKDF2Engine.parameters.getSalt(), this.parameters.getIterationCount(), dkLen);
        return r;
    }

    public PBKDF2Engine() {
        PBKDF2Engine pBKDF2Engine = this;
        pBKDF2Engine.parameters = null;
        pBKDF2Engine.prf = null;
    }

    protected byte[] PBKDF2(PRF prf, byte[] S, int c, int dkLen) {
        int i;
        if (S == null) {
            S = new byte[]{};
        }
        int hLen = prf.getHLen();
        int l = this.ceil(dkLen, hLen);
        int r = dkLen - (l - 1) * hLen;
        byte[] T = new byte[l * hLen];
        int ti_offset = 0;
        int n = i = 1;
        while (n <= l) {
            int n2 = ti_offset;
            this._F(T, n2, prf, S, c, i);
            ti_offset = n2 + hLen;
            n = ++i;
        }
        if (r < hLen) {
            byte[] DK = new byte[dkLen];
            System.arraycopy(T, 0, DK, 0, dkLen);
            return DK;
        }
        return T;
    }

    protected int ceil(int a, int b) {
        int m = 0;
        if (a % b > 0) {
            m = 1;
        }
        return a / b + m;
    }

    public void setPseudoRandomFunction(PRF prf) {
        this.prf = prf;
    }

    protected void xor(byte[] dest, byte[] src) {
        int i;
        int n = i = 0;
        while (n < dest.length) {
            int n2 = i;
            byte by = (byte)(dest[n2] ^ src[i]);
            dest[n2] = by;
            n = ++i;
        }
    }

    public void setParameters(PBKDF2Parameters parameters) {
        this.parameters = parameters;
    }
}

