/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import net.lingala.zip4j.crypto.IDecrypter;
import net.lingala.zip4j.crypto.engine.ZipCryptoEngine;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.util.Zip4jUtil;

public class StandardDecrypter
implements IDecrypter {
    private byte[] crc = new byte[4];
    private ZipCryptoEngine zipCryptoEngine;
    private FileHeader fileHeader;

    @Override
    public int decryptData(byte[] buff) throws ZipException {
        return this.decryptData(buff, 0, buff.length);
    }

    @Override
    public int decryptData(byte[] buff, int start, int len) throws ZipException {
        if (start < 0 || len < 0) {
            throw new ZipException("one of the input parameters were null in standard decrpyt data");
        }
        try {
            int i;
            int n = i = 0;
            while (n < len) {
                int val = buff[i] & 0xFF;
                val = (val ^ this.zipCryptoEngine.decryptByte()) & 0xFF;
                this.zipCryptoEngine.updateKeys((byte)val);
                buff[i++] = (byte)val;
                n = i;
            }
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
        return len;
    }

    /*
     * WARNING - void declaration
     */
    public StandardDecrypter(FileHeader fileHeader, byte[] byArray) throws ZipException {
        void headerBytes;
        void fileHeader2;
        if (fileHeader == null) {
            throw new ZipException("one of more of the input parameters were null in StandardDecryptor");
        }
        this.fileHeader = fileHeader2;
        StandardDecrypter standardDecrypter = this;
        standardDecrypter.zipCryptoEngine = new ZipCryptoEngine();
        this.init((byte[])headerBytes);
    }

    public void init(byte[] headerBytes) throws ZipException {
        block11: {
            block10: {
                StandardDecrypter standardDecrypter = this;
                byte[] crcBuff = standardDecrypter.fileHeader.getCrcBuff();
                standardDecrypter.crc[3] = (byte)(crcBuff[3] & 0xFF);
                standardDecrypter.crc[2] = (byte)(crcBuff[3] >> 8 & 0xFF);
                standardDecrypter.crc[1] = (byte)(crcBuff[3] >> 16 & 0xFF);
                standardDecrypter.crc[0] = (byte)(crcBuff[3] >> 24 & 0xFF);
                if (standardDecrypter.crc[2] > 0) break block10;
                if (this.crc[1] > 0) break block10;
                if (this.crc[0] <= 0) break block11;
            }
            throw new IllegalStateException("Invalid CRC in File Header");
        }
        String password = this.fileHeader.getPassword();
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(password)) {
            throw new ZipException("Wrong password!", 5);
        }
        this.zipCryptoEngine.initKeys(password);
        try {
            byte result = headerBytes[0];
            int i = 0;
            while (true) {
                if (i < 12) {
                    this.zipCryptoEngine.updateKeys((byte)(result ^ this.zipCryptoEngine.decryptByte()));
                    if (i + 1 != 12) {
                        result = headerBytes[i + 1];
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }
}

