/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import java.util.Random;
import net.lingala.zip4j.crypto.IEncrypter;
import net.lingala.zip4j.crypto.engine.ZipCryptoEngine;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.util.Zip4jUtil;

public class StandardEncrypter
implements IEncrypter {
    private ZipCryptoEngine zipCryptoEngine;
    private byte[] headerBytes;

    /*
     * WARNING - void declaration
     */
    public StandardEncrypter(String string, int n) throws ZipException {
        void crc;
        void password;
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("input password is null or empty in standard encrpyter constructor");
        }
        StandardEncrypter standardEncrypter = this;
        standardEncrypter.zipCryptoEngine = new ZipCryptoEngine();
        standardEncrypter.headerBytes = new byte[12];
        this.init((String)password, (int)crc);
    }

    @Override
    public int encryptData(byte[] buff) throws ZipException {
        if (buff == null) {
            throw new NullPointerException();
        }
        return this.encryptData(buff, 0, buff.length);
    }

    public byte[] getHeaderBytes() {
        return this.headerBytes;
    }

    private /* synthetic */ void init(String password, int crc) throws ZipException {
        int i;
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(password)) {
            throw new ZipException("input password is null or empty, cannot initialize standard encrypter");
        }
        StandardEncrypter standardEncrypter = this;
        standardEncrypter.zipCryptoEngine.initKeys(password);
        this.headerBytes = StandardEncrypter.generateRandomBytes(12);
        standardEncrypter.headerBytes[11] = (byte)(crc >> 24);
        if (this.headerBytes.length < 12) {
            throw new ZipException("invalid header bytes generated, cannot perform standard encryption");
        }
        int n = i = 0;
        while (n < this.headerBytes.length) {
            StandardEncrypter standardEncrypter2 = this;
            int val = standardEncrypter2.headerBytes[i] & 0xFF;
            standardEncrypter2.headerBytes[i] = (byte)(val ^ this.zipCryptoEngine.decryptByte());
            standardEncrypter2.zipCryptoEngine.updateKeys((byte)val);
            n = ++i;
        }
    }

    protected static byte[] generateRandomBytes(int size) throws ZipException {
        int i;
        if (size <= 0) {
            throw new ZipException("size is either 0 or less than 0, cannot generate header for standard encryptor");
        }
        byte[] buff = new byte[size];
        Random rand = new Random();
        int n = i = 0;
        while (n < buff.length) {
            buff[i++] = (byte)rand.nextInt(256);
            n = i;
        }
        return buff;
    }

    @Override
    public int encryptData(byte[] buff, int start, int len) throws ZipException {
        if (len < 0) {
            throw new ZipException("invalid length specified to decrpyt data");
        }
        try {
            int i;
            int n = i = start;
            while (n < len) {
                int val = buff[i] & 0xFF;
                buff[i] = (byte)(val ^ this.zipCryptoEngine.decryptByte() & 0xFF);
                this.zipCryptoEngine.updateKeys((byte)val);
                n = ++i;
            }
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
        return len;
    }
}

