/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.CRC32;
import net.lingala.zip4j.core.HeaderWriter;
import net.lingala.zip4j.crypto.AESEncrpyter;
import net.lingala.zip4j.crypto.IEncrypter;
import net.lingala.zip4j.crypto.StandardEncrypter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.BaseOutputStream;
import net.lingala.zip4j.io.SplitOutputStream;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.CentralDirectory;
import net.lingala.zip4j.model.EndCentralDirRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.Zip64EndCentralDirLocator;
import net.lingala.zip4j.model.Zip64EndCentralDirRecord;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.util.Raw;
import net.lingala.zip4j.util.Zip4jUtil;

public class CipherOutputStream
extends BaseOutputStream {
    private long totalBytesWritten;
    protected CRC32 crc;
    private IEncrypter encrypter;
    private long bytesWrittenForThisFile;
    protected LocalFileHeader localFileHeader;
    private File sourceFile;
    protected FileHeader fileHeader;
    private int pendingBufferLength;
    protected ZipParameters zipParameters;
    protected ZipModel zipModel;
    protected OutputStream outputStream;
    private byte[] pendingBuffer;

    private /* synthetic */ void initZipModel(ZipModel zipModel) {
        CipherOutputStream cipherOutputStream;
        if (zipModel == null) {
            cipherOutputStream = this;
            this.zipModel = new ZipModel();
        } else {
            cipherOutputStream = this;
            this.zipModel = zipModel;
        }
        if (cipherOutputStream.zipModel.getEndCentralDirRecord() == null) {
            this.zipModel.setEndCentralDirRecord(new EndCentralDirRecord());
        }
        if (this.zipModel.getCentralDirectory() == null) {
            this.zipModel.setCentralDirectory(new CentralDirectory());
        }
        if (this.zipModel.getCentralDirectory().getFileHeaders() == null) {
            this.zipModel.getCentralDirectory().setFileHeaders(new ArrayList());
        }
        if (this.zipModel.getLocalFileHeaderList() == null) {
            this.zipModel.setLocalFileHeaderList(new ArrayList());
        }
        if (this.outputStream instanceof SplitOutputStream && ((SplitOutputStream)this.outputStream).isSplitZipFile()) {
            CipherOutputStream cipherOutputStream2 = this;
            cipherOutputStream2.zipModel.setSplitArchive(true);
            cipherOutputStream2.zipModel.setSplitLength(((SplitOutputStream)this.outputStream).getSplitLength());
        }
        this.zipModel.getEndCentralDirRecord().setSignature(101010256L);
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    private /* synthetic */ void createLocalFileHeader() throws ZipException {
        if (this.fileHeader == null) {
            throw new ZipException("file header is null, cannot create local file header");
        }
        CipherOutputStream cipherOutputStream = this;
        cipherOutputStream.localFileHeader = new LocalFileHeader();
        cipherOutputStream.localFileHeader.setSignature(67324752);
        cipherOutputStream.localFileHeader.setVersionNeededToExtract(this.fileHeader.getVersionNeededToExtract());
        cipherOutputStream.localFileHeader.setCompressionMethod(this.fileHeader.getCompressionMethod());
        cipherOutputStream.localFileHeader.setLastModFileTime(this.fileHeader.getLastModFileTime());
        cipherOutputStream.localFileHeader.setUncompressedSize(this.fileHeader.getUncompressedSize());
        cipherOutputStream.localFileHeader.setFileNameLength(this.fileHeader.getFileNameLength());
        cipherOutputStream.localFileHeader.setFileName(this.fileHeader.getFileName());
        cipherOutputStream.localFileHeader.setEncrypted(this.fileHeader.isEncrypted());
        cipherOutputStream.localFileHeader.setEncryptionMethod(this.fileHeader.getEncryptionMethod());
        cipherOutputStream.localFileHeader.setAesExtraDataRecord(this.fileHeader.getAesExtraDataRecord());
        cipherOutputStream.localFileHeader.setCrc32(this.fileHeader.getCrc32());
        cipherOutputStream.localFileHeader.setCompressedSize(this.fileHeader.getCompressedSize());
        cipherOutputStream.localFileHeader.setGeneralPurposeFlag((byte[])this.fileHeader.getGeneralPurposeFlag().clone());
    }

    private /* synthetic */ int[] generateGeneralPurposeBitArray(boolean isEncrpyted, int compressionMethod) {
        CipherOutputStream cipherOutputStream;
        int n;
        int[] generalPurposeBits = new int[8];
        if (isEncrpyted) {
            n = compressionMethod;
            generalPurposeBits[0] = 1;
        } else {
            generalPurposeBits[0] = 0;
            n = compressionMethod;
        }
        if (n == 8) {
            cipherOutputStream = this;
        } else {
            generalPurposeBits[1] = 0;
            generalPurposeBits[2] = 0;
            cipherOutputStream = this;
        }
        int[] nArray = generalPurposeBits;
        if (cipherOutputStream.outputStream instanceof SplitOutputStream) {
            nArray[3] = 0;
            return generalPurposeBits;
        }
        nArray[3] = 1;
        return generalPurposeBits;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ AESExtraDataRecord generateAESExtraDataRecord(ZipParameters parameters) throws ZipException {
        void v3;
        void aesDataRecord;
        if (parameters == null) {
            throw new ZipException("zip parameters are null, cannot generate AES Extra Data record");
        }
        AESExtraDataRecord aESExtraDataRecord = new AESExtraDataRecord();
        void v0 = aesDataRecord;
        void v1 = aesDataRecord;
        v1.setSignature(39169L);
        v1.setDataSize(7);
        v0.setVendorID("AE");
        v0.setVersionNumber(2);
        if (parameters.getAesKeyStrength() == 1) {
            void v2 = aesDataRecord;
            v3 = v2;
            v2.setAesStrength(1);
        } else if (parameters.getAesKeyStrength() == 3) {
            void v4 = aesDataRecord;
            v3 = v4;
            v4.setAesStrength(3);
        } else {
            throw new ZipException("invalid AES key strength, cannot generate AES Extra data record");
        }
        v3.setCompressionMethod(parameters.getCompressionMethod());
        return aesDataRecord;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (b.length == 0) {
            return;
        }
        this.write(b, 0, b.length);
    }

    private /* synthetic */ void encryptAndWrite(byte[] b, int off, int len) throws IOException {
        CipherOutputStream cipherOutputStream;
        if (this.encrypter != null) {
            try {
                this.encrypter.encryptData(b, off, len);
                cipherOutputStream = this;
            }
            catch (ZipException e) {
                throw new IOException(e.getMessage());
            }
        } else {
            cipherOutputStream = this;
        }
        cipherOutputStream.outputStream.write(b, off, len);
        CipherOutputStream cipherOutputStream2 = this;
        cipherOutputStream2.totalBytesWritten += (long)len;
        cipherOutputStream2.bytesWrittenForThisFile += (long)len;
    }

    /*
     * Unable to fully structure code
     */
    public void closeEntry() throws IOException, ZipException {
        if (this.pendingBufferLength != 0) {
            v0 = this;
            v0.encryptAndWrite(v0.pendingBuffer, 0, this.pendingBufferLength);
            v0.pendingBufferLength = 0;
        }
        if (!this.zipParameters.isEncryptFiles()) ** GOTO lbl22
        if (this.zipParameters.getEncryptionMethod() != 99) ** GOTO lbl22
        if (this.encrypter instanceof AESEncrpyter) {
            v1 = this;
            v1.outputStream.write(((AESEncrpyter)v1.encrypter).getFinalMac());
            v2 = this;
            v3 = v2;
            v2.bytesWrittenForThisFile += 10L;
            v2.totalBytesWritten += 10L;
        } else {
            throw new ZipException("invalid encrypter for AES encrypted file");
lbl22:
            // 2 sources

            v3 = this;
        }
        v3.fileHeader.setCompressedSize(this.bytesWrittenForThisFile);
        v4 = this;
        v5 = this;
        v4.localFileHeader.setCompressedSize(v5.bytesWrittenForThisFile);
        crc32 = v4.crc.getValue();
        if (!v5.fileHeader.isEncrypted()) ** GOTO lbl37
        if (this.fileHeader.getEncryptionMethod() == 99) {
            crc32 = 0L;
            v6 = this;
        } else {
            if (this.fileHeader.getEncryptionMethod() == 0 && (int)crc32 != this.zipParameters.getSourceFileCRC()) {
                throw new ZipException(new StringBuilder().insert(0, "source file CRC and calculated CRC do not match for file: ").append(this.fileHeader.getFileName()).toString());
            }
lbl37:
            // 3 sources

            v6 = this;
        }
        if (!v6.zipParameters.isEncryptFiles()) ** GOTO lbl-1000
        if (this.zipParameters.getEncryptionMethod() == 99) {
            v7 = this;
            v8 = v7;
            v7.fileHeader.setCrc32(0L);
            v7.localFileHeader.setCrc32(0L);
        } else lbl-1000:
        // 2 sources

        {
            v9 = this;
            v8 = v9;
            v9.fileHeader.setCrc32(crc32);
            v9.localFileHeader.setCrc32(crc32);
        }
        v8.zipModel.getLocalFileHeaderList().add(this.localFileHeader);
        this.zipModel.getCentralDirectory().getFileHeaders().add(this.fileHeader);
        headerWriter = new HeaderWriter();
        if (this.outputStream instanceof SplitOutputStream) {
            intByte = new byte[4];
            if (this.localFileHeader.isWriteComprSizeInZip64ExtraRecord()) {
                var5_4 = new byte[8];
                v10 = this;
                Raw.writeLongLittleEndian((byte[])longByte, 0, v10.localFileHeader.getCompressedSize());
                headerWriter.updateLocalFileHeader(v10.localFileHeader, this.fileHeader.getOffsetLocalHeader(), 18, this.zipModel, (byte[])longByte, this.fileHeader.getDiskNumberStart(), (SplitOutputStream)this.outputStream);
                v11 = this;
            } else {
                Raw.writeIntLittleEndian(intByte, 0, (int)this.localFileHeader.getCompressedSize());
                v12 = this;
                headerWriter.updateLocalFileHeader(v12.localFileHeader, v12.fileHeader.getOffsetLocalHeader(), 18, this.zipModel, intByte, this.fileHeader.getDiskNumberStart(), (SplitOutputStream)this.outputStream);
                v11 = this;
            }
            if (v11.localFileHeader.getCrc32() != 0L) {
                v13 = this;
                Raw.writeIntLittleEndian(intByte, 0, (int)v13.localFileHeader.getCrc32());
                headerWriter.updateLocalFileHeader(v13.localFileHeader, this.fileHeader.getOffsetLocalHeader(), 14, this.zipModel, intByte, this.fileHeader.getDiskNumberStart(), (SplitOutputStream)this.outputStream);
            }
        } else {
            v14 = this;
            this.totalBytesWritten += (long)headerWriter.writeExtendedLocalHeader(v14.localFileHeader, v14.outputStream);
        }
        this.crc.reset();
        this.bytesWrittenForThisFile = 0L;
        this.encrypter = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ void initEncrypter() throws ZipException {
        if (!this.zipParameters.isEncryptFiles()) {
            this.encrypter = null;
            return;
        }
        switch (this.zipParameters.getEncryptionMethod()) {
            case 0: {
                this.encrypter = new StandardEncrypter(this.zipParameters.getPassword(), this.zipParameters.getSourceFileCRC());
                return;
            }
            case 99: {
                this.encrypter = new AESEncrpyter(this.zipParameters.getPassword(), this.zipParameters.getAesKeyStrength());
                return;
            }
        }
        throw new ZipException("invalid encprytion method");
    }

    public void finish() throws IOException, ZipException {
        CipherOutputStream cipherOutputStream;
        int currSplitFileCounter = 0;
        if (this.outputStream instanceof SplitOutputStream) {
            this.zipModel.getEndCentralDirRecord().setOffsetOfStartOfCentralDir(((SplitOutputStream)this.outputStream).getFilePointer());
            currSplitFileCounter = ((SplitOutputStream)this.outputStream).getCurrSplitFileCounter();
            cipherOutputStream = this;
        } else {
            CipherOutputStream cipherOutputStream2 = this;
            cipherOutputStream = cipherOutputStream2;
            cipherOutputStream2.zipModel.getEndCentralDirRecord().setOffsetOfStartOfCentralDir(this.totalBytesWritten);
        }
        if (cipherOutputStream.zipModel.isZip64Format()) {
            if (this.zipModel.getZip64EndCentralDirRecord() == null) {
                this.zipModel.setZip64EndCentralDirRecord(new Zip64EndCentralDirRecord());
            }
            if (this.zipModel.getZip64EndCentralDirLocator() == null) {
                this.zipModel.setZip64EndCentralDirLocator(new Zip64EndCentralDirLocator());
            }
            CipherOutputStream cipherOutputStream3 = this;
            cipherOutputStream3.zipModel.getZip64EndCentralDirLocator().setNoOfDiskStartOfZip64EndOfCentralDirRec(currSplitFileCounter);
            cipherOutputStream3.zipModel.getZip64EndCentralDirLocator().setTotNumberOfDiscs(currSplitFileCounter + 1);
        }
        CipherOutputStream cipherOutputStream4 = this;
        cipherOutputStream4.zipModel.getEndCentralDirRecord().setNoOfThisDisk(currSplitFileCounter);
        cipherOutputStream4.zipModel.getEndCentralDirRecord().setNoOfThisDiskStartOfCentralDir(currSplitFileCounter);
        CipherOutputStream cipherOutputStream5 = this;
        new HeaderWriter().finalizeZipFile(cipherOutputStream5.zipModel, cipherOutputStream5.outputStream);
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void createFileHeader() throws ZipException {
        v0 = this;
        v0.fileHeader = new FileHeader();
        this.fileHeader.setSignature(33639248);
        v0.fileHeader.setVersionMadeBy(20);
        v0.fileHeader.setVersionNeededToExtract(20);
        if (!v0.zipParameters.isEncryptFiles()) ** GOTO lbl-1000
        if (this.zipParameters.getEncryptionMethod() == 99) {
            v1 = this;
            v1.fileHeader.setCompressionMethod(99);
            v2 = this;
            v3 = v2;
            v1.fileHeader.setAesExtraDataRecord(v2.generateAESExtraDataRecord(v2.zipParameters));
        } else lbl-1000:
        // 2 sources

        {
            v4 = this;
            v3 = v4;
            v4.fileHeader.setCompressionMethod(v4.zipParameters.getCompressionMethod());
        }
        if (v3.zipParameters.isEncryptFiles()) {
            v5 = this;
            v5.fileHeader.setEncrypted(true);
            v5.fileHeader.setEncryptionMethod(this.zipParameters.getEncryptionMethod());
        }
        fileName = null;
        if (this.zipParameters.isSourceExternalStream()) {
            v6 = this;
            v6.fileHeader.setLastModFileTime((int)Zip4jUtil.javaToDosTime(System.currentTimeMillis()));
            if (!Zip4jUtil.isStringNotNullAndNotEmpty(v6.zipParameters.getFileNameInZip())) {
                throw new ZipException("fileNameInZip is null or empty");
            }
            v7 = fileName = this.zipParameters.getFileNameInZip();
        } else {
            v8 = this;
            v9 = this;
            v8.fileHeader.setLastModFileTime((int)Zip4jUtil.javaToDosTime(Zip4jUtil.getLastModifiedFileTime(v8.sourceFile, v9.zipParameters.getTimeZone())));
            v9.fileHeader.setUncompressedSize(this.sourceFile.length());
            v7 = fileName = Zip4jUtil.getRelativeFileName(v8.sourceFile.getAbsolutePath(), this.zipParameters.getRootFolderInZip(), this.zipParameters.getDefaultFolderPath());
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(v7)) {
            throw new ZipException("fileName is null or empty. unable to create file header");
        }
        v10 = this;
        v10.fileHeader.setFileName(fileName);
        v11 = this;
        if (Zip4jUtil.isStringNotNullAndNotEmpty(v10.zipModel.getFileNameCharset())) {
            v11.fileHeader.setFileNameLength(Zip4jUtil.getEncodedStringLength(fileName, this.zipModel.getFileNameCharset()));
            v12 = this;
        } else {
            v11.fileHeader.setFileNameLength(Zip4jUtil.getEncodedStringLength(fileName));
            v12 = this;
        }
        v13 = this;
        if (v12.outputStream instanceof SplitOutputStream) {
            v13.fileHeader.setDiskNumberStart(((SplitOutputStream)this.outputStream).getCurrSplitFileCounter());
        } else {
            v13.fileHeader.setDiskNumberStart(0);
        }
        fileAttrs = 0;
        if (!this.zipParameters.isSourceExternalStream()) {
            v14 = this;
            fileAttrs = v14.getFileAttributes(v14.sourceFile);
        }
        v15 = new byte[4];
        v15[0] = (byte)fileAttrs;
        v15[1] = 0;
        v15[2] = 0;
        v15[3] = 0;
        externalFileAttrs = v15;
        v16 = this;
        v16.fileHeader.setExternalFileAttr(externalFileAttrs);
        if (v16.zipParameters.isSourceExternalStream()) {
            this.fileHeader.setDirectory(fileName.endsWith("/") || fileName.endsWith("\\"));
            v17 = this;
        } else {
            v18 = this;
            v17 = v18;
            v18.fileHeader.setDirectory(v18.sourceFile.isDirectory());
        }
        v19 = this;
        if (v17.fileHeader.isDirectory()) {
            v19.fileHeader.setCompressedSize(0L);
            v20 = this;
            v21 = v20;
            v20.fileHeader.setUncompressedSize(0L);
        } else {
            if (!v19.zipParameters.isSourceExternalStream()) {
                v22 = this;
                fileSize = Zip4jUtil.getFileLengh(v22.sourceFile);
                if (v22.zipParameters.getCompressionMethod() == 0) {
                    v23 = this;
                    if (this.zipParameters.getEncryptionMethod() == 0) {
                        v23.fileHeader.setCompressedSize(fileSize + 12L);
                        v24 = this;
                    } else if (v23.zipParameters.getEncryptionMethod() == 99) {
                        saltLength = 0;
                        switch (this.zipParameters.getAesKeyStrength()) {
                            case 1: {
                                while (false) {
                                }
                                saltLength = 8;
                                v25 = this;
                                break;
                            }
                            case 3: {
                                saltLength = 16;
                                v25 = this;
                                break;
                            }
                            default: {
                                throw new ZipException("invalid aes key strength, cannot determine key sizes");
                            }
                        }
                        v25.fileHeader.setCompressedSize(fileSize + (long)saltLength + 10L + 2L);
                        v24 = this;
                    } else {
                        v26 = this;
                        v24 = v26;
                        v26.fileHeader.setCompressedSize(0L);
                    }
                } else {
                    v27 = this;
                    v24 = v27;
                    v27.fileHeader.setCompressedSize(0L);
                }
                v24.fileHeader.setUncompressedSize(fileSize);
            }
            v21 = this;
        }
        if (v21.zipParameters.isEncryptFiles() && this.zipParameters.getEncryptionMethod() == 0) {
            v28 = this;
            v28.fileHeader.setCrc32(v28.zipParameters.getSourceFileCRC());
        }
        v29 = new byte[2];
        shortByte = v29;
        v30 = this;
        v29[0] = Raw.bitArrayToByte(v30.generateGeneralPurposeBitArray(this.fileHeader.isEncrypted(), this.zipParameters.getCompressionMethod()));
        if (Zip4jUtil.isStringNotNullAndNotEmpty(v30.zipModel.getFileNameCharset()) && this.zipModel.getFileNameCharset().equalsIgnoreCase("UTF8") || Zip4jUtil.detectCharSet(this.fileHeader.getFileName()).equals("UTF8")) {
            shortByte[1] = 8;
            v31 = this;
        } else {
            shortByte[1] = 0;
            v31 = this;
        }
        v31.fileHeader.setGeneralPurposeFlag(shortByte);
    }

    /*
     * WARNING - void declaration
     */
    public CipherOutputStream(OutputStream outputStream, ZipModel zipModel) {
        void zipModel2;
        void outputStream2;
        CipherOutputStream cipherOutputStream = this;
        CipherOutputStream cipherOutputStream2 = this;
        this.outputStream = outputStream2;
        this.initZipModel((ZipModel)zipModel2);
        CipherOutputStream cipherOutputStream3 = this;
        this.crc = new CRC32();
        cipherOutputStream2.totalBytesWritten = 0L;
        cipherOutputStream2.bytesWrittenForThisFile = 0L;
        cipherOutputStream.pendingBuffer = new byte[16];
        cipherOutputStream.pendingBufferLength = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.zipParameters.isEncryptFiles()) {
            if (this.zipParameters.getEncryptionMethod() == 99) {
                int n;
                if (this.pendingBufferLength != 0) {
                    if (len < 16 - this.pendingBufferLength) {
                        CipherOutputStream cipherOutputStream = this;
                        System.arraycopy(b, off, cipherOutputStream.pendingBuffer, cipherOutputStream.pendingBufferLength, len);
                        this.pendingBufferLength += len;
                        return;
                    }
                    CipherOutputStream cipherOutputStream = this;
                    System.arraycopy(b, off, cipherOutputStream.pendingBuffer, cipherOutputStream.pendingBufferLength, 16 - this.pendingBufferLength);
                    CipherOutputStream cipherOutputStream2 = this;
                    cipherOutputStream2.encryptAndWrite(cipherOutputStream.pendingBuffer, 0, cipherOutputStream2.pendingBuffer.length);
                    off = 16 - this.pendingBufferLength;
                    n = len = len - off;
                    this.pendingBufferLength = 0;
                } else {
                    n = len;
                }
                if (n != 0) {
                    if (len % 16 != 0) {
                        int n2 = len;
                        System.arraycopy(b, len + off - len % 16, this.pendingBuffer, 0, len % 16);
                        this.pendingBufferLength = n2 % 16;
                        len = n2 - this.pendingBufferLength;
                    }
                }
            }
        }
        if (len != 0) {
            this.encryptAndWrite(b, off, len);
        }
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    @Override
    public void write(int bval) throws IOException {
        byte[] b = new byte[1];
        b[0] = (byte)bval;
        this.write(b, 0, 1);
    }

    private /* synthetic */ int getFileAttributes(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null, cannot get file attributes");
        }
        if (!file.exists()) {
            return 0;
        }
        if (file.isDirectory()) {
            if (file.isHidden()) {
                return 18;
            }
            return 16;
        }
        if (!file.canWrite() && file.isHidden()) {
            return 3;
        }
        if (!file.canWrite()) {
            return 1;
        }
        if (file.isHidden()) {
            return 2;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public void putNextEntry(File file, ZipParameters zipParameters) throws ZipException {
        block18: {
            block17: {
                if (!zipParameters.isSourceExternalStream() && file == null) {
                    throw new ZipException("input file is null");
                }
                if (!zipParameters.isSourceExternalStream() && !Zip4jUtil.checkFileExists(file)) {
                    throw new ZipException("input file does not exist");
                }
                if (zipParameters == null) {
                    zipParameters = new ZipParameters();
                }
                this.sourceFile = file;
                this.zipParameters = (ZipParameters)zipParameters.clone();
                if (zipParameters.isSourceExternalStream()) break block17;
                if (!this.sourceFile.isDirectory()) ** GOTO lbl39
                v0 = this;
                v1 = v0;
                v0.zipParameters.setEncryptFiles(false);
                v0.zipParameters.setEncryptionMethod(-1);
                v0.zipParameters.setCompressionMethod(0);
                ** GOTO lbl40
            }
            if (!Zip4jUtil.isStringNotNullAndNotEmpty(this.zipParameters.getFileNameInZip())) {
                throw new ZipException("file name is empty for external stream");
            }
            if (this.zipParameters.getFileNameInZip().endsWith("/") || this.zipParameters.getFileNameInZip().endsWith("\\")) {
                v2 = this;
                v2.zipParameters.setEncryptFiles(false);
                v2.zipParameters.setEncryptionMethod(-1);
                v2.zipParameters.setCompressionMethod(0);
            }
lbl39:
            // 4 sources

            v1 = this;
lbl40:
            // 2 sources

            v1.createFileHeader();
            v3 = this;
            v3.createLocalFileHeader();
            if (v3.zipModel.isSplitArchive() && (this.zipModel.getCentralDirectory() == null || this.zipModel.getCentralDirectory().getFileHeaders() == null || this.zipModel.getCentralDirectory().getFileHeaders().size() == 0)) {
                var3_3 = new byte[4];
                v4 = this;
                Raw.writeIntLittleEndian((byte[])intByte, 0, 134695760);
                v4.outputStream.write((byte[])intByte);
                v4.totalBytesWritten += 4L;
            }
            if (!(this.outputStream instanceof SplitOutputStream)) ** GOTO lbl64
            if (this.totalBytesWritten != 4L) break block18;
            this.fileHeader.setOffsetLocalHeader(4L);
            ** GOTO lbl69
        }
        try {
            block19: {
                v5 = this;
                v5.fileHeader.setOffsetLocalHeader(((SplitOutputStream)v5.outputStream).getFilePointer());
                break block19;
lbl64:
                // 1 sources

                v6 = this;
                if (this.totalBytesWritten == 4L) {
                    v6.fileHeader.setOffsetLocalHeader(4L);
                } else {
                    v6.fileHeader.setOffsetLocalHeader(this.totalBytesWritten);
                }
            }
            headerWriter = new HeaderWriter();
            v7 = this;
            v8 = this;
            v7.totalBytesWritten += (long)headerWriter.writeLocalFileHeader(v8.zipModel, v8.localFileHeader, this.outputStream);
            if (!v7.zipParameters.isEncryptFiles()) ** GOTO lbl94
            v9 = this;
            v9.initEncrypter();
            if (v9.encrypter == null) ** GOTO lbl94
            if (zipParameters.getEncryptionMethod() == 0) {
                headerBytes = ((StandardEncrypter)this.encrypter).getHeaderBytes();
                v10 = this;
                v10.outputStream.write(headerBytes);
                v10.totalBytesWritten += (long)headerBytes.length;
                this.bytesWrittenForThisFile += (long)headerBytes.length;
                v11 = this;
            } else {
                if (zipParameters.getEncryptionMethod() == 99) {
                    saltBytes = ((AESEncrpyter)this.encrypter).getSaltBytes();
                    passwordVerifier = ((AESEncrpyter)this.encrypter).getDerivedPasswordVerifier();
                    v12 = this;
                    v12.outputStream.write(saltBytes);
                    v12.outputStream.write(passwordVerifier);
                    v12.totalBytesWritten += (long)(saltBytes.length + passwordVerifier.length);
                    this.bytesWrittenForThisFile += (long)(saltBytes.length + passwordVerifier.length);
                }
lbl94:
                // 5 sources

                v11 = this;
            }
            v11.crc.reset();
            return;
        }
        catch (CloneNotSupportedException e) {
            throw new ZipException(e);
        }
        catch (ZipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

