/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.CipherOutputStream;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;

public class DeflaterOutputStream
extends CipherOutputStream {
    protected Deflater deflater;
    private boolean firstBytesRead;
    private byte[] buff;

    @Override
    public void closeEntry() throws IOException, ZipException {
        if (this.zipParameters.getCompressionMethod() == 8) {
            if (!this.deflater.finished()) {
                DeflaterOutputStream deflaterOutputStream = this;
                DeflaterOutputStream deflaterOutputStream2 = deflaterOutputStream;
                deflaterOutputStream.deflater.finish();
                while (!deflaterOutputStream2.deflater.finished()) {
                    DeflaterOutputStream deflaterOutputStream3 = this;
                    deflaterOutputStream2 = deflaterOutputStream3;
                    deflaterOutputStream3.deflate();
                }
            }
            this.firstBytesRead = false;
        }
        super.closeEntry();
    }

    @Override
    public void write(int bval) throws IOException {
        byte[] b = new byte[1];
        b[0] = (byte)bval;
        this.write(b, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void finish() throws IOException, ZipException {
        super.finish();
    }

    private /* synthetic */ void deflate() throws IOException {
        DeflaterOutputStream deflaterOutputStream = this;
        int len = deflaterOutputStream.deflater.deflate(deflaterOutputStream.buff, 0, this.buff.length);
        if (len > 0) {
            if (this.deflater.finished()) {
                len -= 4;
            }
            if (!this.firstBytesRead) {
                DeflaterOutputStream deflaterOutputStream2 = this;
                super.write(deflaterOutputStream2.buff, 2, len - 2);
                deflaterOutputStream2.firstBytesRead = true;
                return;
            }
            DeflaterOutputStream deflaterOutputStream3 = this;
            super.write(deflaterOutputStream3.buff, 0, len);
        }
    }

    @Override
    public void putNextEntry(File file, ZipParameters zipParameters) throws ZipException {
        block4: {
            block6: {
                block5: {
                    ZipParameters zipParameters2 = zipParameters;
                    super.putNextEntry(file, zipParameters2);
                    if (zipParameters2.getCompressionMethod() != 8) break block4;
                    this.deflater.reset();
                    if (zipParameters.getCompressionLevel() < 0) break block5;
                    if (zipParameters.getCompressionLevel() <= 9) break block6;
                }
                if (zipParameters.getCompressionLevel() != -1) {
                    throw new ZipException("invalid compression level for deflater. compression level should be in the range of 0-9");
                }
            }
            this.deflater.setLevel(zipParameters.getCompressionLevel());
        }
    }

    /*
     * WARNING - void declaration
     */
    public DeflaterOutputStream(OutputStream outputStream, ZipModel zipModel) {
        void zipModel2;
        void outputStream2;
        DeflaterOutputStream deflaterOutputStream = this;
        super((OutputStream)outputStream2, (ZipModel)zipModel2);
        DeflaterOutputStream deflaterOutputStream2 = this;
        deflaterOutputStream2.deflater = new Deflater();
        deflaterOutputStream.buff = new byte[4096];
        deflaterOutputStream.firstBytesRead = false;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (this.zipParameters.getCompressionMethod() != 8) {
            super.write(buf, off, len);
            return;
        }
        DeflaterOutputStream deflaterOutputStream = this;
        DeflaterOutputStream deflaterOutputStream2 = deflaterOutputStream;
        deflaterOutputStream.deflater.setInput(buf, off, len);
        while (!deflaterOutputStream2.deflater.needsInput()) {
            DeflaterOutputStream deflaterOutputStream3 = this;
            deflaterOutputStream2 = deflaterOutputStream3;
            deflaterOutputStream3.deflate();
        }
    }
}

