/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import net.lingala.zip4j.crypto.AESDecrypter;
import net.lingala.zip4j.crypto.IDecrypter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.BaseInputStream;
import net.lingala.zip4j.unzip.UnzipEngine;

public class PartInputStream
extends BaseInputStream {
    private byte[] aesBlockByte;
    private IDecrypter decrypter;
    private long bytesRead;
    private UnzipEngine unzipEngine;
    private byte[] oneByteBuff;
    private long length;
    private int count;
    private RandomAccessFile raf;
    private int aesBytesReturned;
    private boolean isAESEncryptedFile;

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public UnzipEngine getUnzipEngine() {
        return this.unzipEngine;
    }

    @Override
    public int available() {
        long amount = this.length - this.bytesRead;
        if (amount > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)amount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private /* synthetic */ void checkAndReadAESMacBytes() throws IOException {
        PartInputStream partInputStream;
        if (!this.isAESEncryptedFile || this.decrypter == null || !(this.decrypter instanceof AESDecrypter)) return;
        if (((AESDecrypter)this.decrypter).getStoredMac() != null) {
            return;
        }
        byte[] macBytes = new byte[10];
        int readLen = -1;
        readLen = this.raf.read(macBytes);
        if (readLen != 10) {
            if (!this.unzipEngine.getZipModel().isSplitArchive()) throw new IOException("Error occured while reading stored AES authentication bytes");
            PartInputStream partInputStream2 = this;
            partInputStream = partInputStream2;
            partInputStream2.raf.close();
            partInputStream2.raf = partInputStream2.unzipEngine.startNextSplitFile();
            int n = readLen;
            int newlyRead = partInputStream2.raf.read(macBytes, n, 10 - n);
            readLen += newlyRead;
        } else {
            partInputStream = this;
        }
        ((AESDecrypter)partInputStream.unzipEngine.getDecrypter()).setStoredMac(macBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if ((long)len > this.length - this.bytesRead && (len = (int)(this.length - this.bytesRead)) == 0) {
            this.checkAndReadAESMacBytes();
            return -1;
        }
        if (this.unzipEngine.getDecrypter() instanceof AESDecrypter && this.bytesRead + (long)len < this.length) {
            if (len % 16 != 0) {
                int n = len;
                len = n - n % 16;
            }
        }
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            PartInputStream partInputStream = this;
            partInputStream.count = partInputStream.raf.read(b, off, len);
            if (partInputStream.count < len && this.unzipEngine.getZipModel().isSplitArchive()) {
                int newlyRead;
                PartInputStream partInputStream2 = this;
                partInputStream2.raf.close();
                partInputStream2.raf = partInputStream2.unzipEngine.startNextSplitFile();
                if (partInputStream2.count < 0) {
                    this.count = 0;
                }
                if ((newlyRead = this.raf.read(b, this.count, len - this.count)) > 0) {
                    this.count += newlyRead;
                }
            }
        }
        if (this.count > 0) {
            PartInputStream partInputStream;
            if (this.decrypter != null) {
                try {
                    this.decrypter.decryptData(b, off, this.count);
                    partInputStream = this;
                }
                catch (ZipException e) {
                    throw new IOException(e.getMessage());
                }
            } else {
                partInputStream = this;
            }
            partInputStream.bytesRead += (long)this.count;
        }
        if (this.bytesRead >= this.length) {
            this.checkAndReadAESMacBytes();
        }
        return this.count;
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public long skip(long amount) throws IOException {
        if (amount < 0L) {
            throw new IllegalArgumentException();
        }
        if (amount > this.length - this.bytesRead) {
            amount = this.length - this.bytesRead;
        }
        this.bytesRead += amount;
        return amount;
    }

    /*
     * Unable to fully structure code
     */
    public PartInputStream(RandomAccessFile var1_1, long var2_2, long var4_3, UnzipEngine var6_4) {
        v0 = this;
        v1 = this;
        v2 = this;
        v3 = this;
        v4 = this;
        super();
        v4.oneByteBuff = new byte[1];
        v4.aesBlockByte = new byte[16];
        v3.aesBytesReturned = 0;
        v3.isAESEncryptedFile = false;
        v2.count = -1;
        v2.raf = raf;
        this.unzipEngine = unzipEngine;
        v1.decrypter = this.unzipEngine.getDecrypter();
        v1.bytesRead = 0L;
        v0.length = len;
        if (!var6_4.getFileHeader().isEncrypted()) ** GOTO lbl-1000
        if (unzipEngine.getFileHeader().getEncryptionMethod() == 99) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        v0.isAESEncryptedFile = v5;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    @Override
    public int read() throws IOException {
        block6: {
            block8: {
                block7: {
                    if (this.bytesRead >= this.length) {
                        return -1;
                    }
                    if (!this.isAESEncryptedFile) break block6;
                    if (this.aesBytesReturned == 0) break block7;
                    if (this.aesBytesReturned != 16) break block8;
                }
                PartInputStream partInputStream = this;
                if (partInputStream.read(partInputStream.aesBlockByte) == -1) {
                    return -1;
                }
                this.aesBytesReturned = 0;
            }
            int n = this.aesBytesReturned;
            this.aesBytesReturned = n + 1;
            return this.aesBlockByte[n] & 0xFF;
        }
        PartInputStream partInputStream = this;
        if (partInputStream.read(partInputStream.oneByteBuff, 0, 1) == -1) {
            return -1;
        }
        return this.oneByteBuff[0] & 0xFF;
    }
}

