/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.util.Zip4jUtil;

public class SplitOutputStream
extends OutputStream {
    private File zipFile;
    private long bytesWrittenForThisPart;
    private long splitLength;
    private RandomAccessFile raf;
    private int currSplitFileCounter;
    private File outFile;

    public long getSplitLength() {
        return this.splitLength;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buff = new byte[1];
        buff[0] = (byte)b;
        this.write(buff, 0, 1);
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        if (this.splitLength != -1L) {
            if (this.splitLength < 65536L) {
                throw new IOException("split length less than minimum allowed split length of 65536 Bytes");
            }
            if (this.bytesWrittenForThisPart >= this.splitLength) {
                SplitOutputStream splitOutputStream = this;
                splitOutputStream.startNextSplitFile();
                splitOutputStream.raf.write(b, off, len);
                splitOutputStream.bytesWrittenForThisPart = len;
                return;
            }
            SplitOutputStream splitOutputStream = this;
            if (this.bytesWrittenForThisPart + (long)len > this.splitLength) {
                splitOutputStream.raf.write(b, off, (int)(this.splitLength - this.bytesWrittenForThisPart));
                SplitOutputStream splitOutputStream2 = this;
                splitOutputStream2.startNextSplitFile();
                splitOutputStream2.raf.write(b, off + (int)(this.splitLength - this.bytesWrittenForThisPart), (int)((long)len - (this.splitLength - this.bytesWrittenForThisPart)));
                splitOutputStream2.bytesWrittenForThisPart = (long)len - (this.splitLength - this.bytesWrittenForThisPart);
                return;
            }
            splitOutputStream.raf.write(b, off, len);
            this.bytesWrittenForThisPart += (long)len;
            return;
        }
        SplitOutputStream splitOutputStream = this;
        splitOutputStream.raf.write(b, off, len);
        splitOutputStream.bytesWrittenForThisPart += (long)len;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void startNextSplitFile() throws IOException {
        try {
            SplitOutputStream splitOutputStream;
            SplitOutputStream splitOutputStream2 = this;
            String zipFileWithoutExt = Zip4jUtil.getZipFileNameWithoutExt(splitOutputStream2.outFile.getName());
            File currSplitFile = null;
            String zipFileName = splitOutputStream2.zipFile.getAbsolutePath();
            if (splitOutputStream2.currSplitFileCounter < 9) {
                currSplitFile = new File(new StringBuilder().insert(0, this.outFile.getParent()).append(System.getProperty("file.separator")).append(zipFileWithoutExt).append(".z0").append(this.currSplitFileCounter + 1).toString());
                splitOutputStream = this;
            } else {
                currSplitFile = new File(new StringBuilder().insert(0, this.outFile.getParent()).append(System.getProperty("file.separator")).append(zipFileWithoutExt).append(".z").append(this.currSplitFileCounter + 1).toString());
                splitOutputStream = this;
            }
            splitOutputStream.raf.close();
            if (currSplitFile.exists()) {
                throw new IOException(new StringBuilder().insert(0, "split file: ").append(currSplitFile.getName()).append(" already exists in the current directory, cannot rename this file").toString());
            }
            if (!this.zipFile.renameTo(currSplitFile)) {
                throw new IOException("cannot rename newly created split file");
            }
            this.zipFile = new File(zipFileName);
            SplitOutputStream splitOutputStream3 = this;
            this.raf = new RandomAccessFile(this.zipFile, "rw");
            ++this.currSplitFileCounter;
            return;
        }
        catch (ZipException e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean isSplitZipFile() {
        if (this.splitLength != -1L) {
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    @Override
    public void flush() throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    public SplitOutputStream(File file, long l) throws FileNotFoundException, ZipException {
        void file2;
        void splitLength;
        if (l >= 0L && splitLength < 65536L) {
            throw new ZipException("split length less than minimum allowed split length of 65536 Bytes");
        }
        SplitOutputStream splitOutputStream = this;
        SplitOutputStream splitOutputStream2 = this;
        splitOutputStream2.raf = new RandomAccessFile((File)file2, "rw");
        splitOutputStream2.splitLength = splitLength;
        splitOutputStream.zipFile = this.outFile = file2;
        splitOutputStream.currSplitFileCounter = 0;
        this.bytesWrittenForThisPart = 0L;
    }

    public SplitOutputStream(String name) throws FileNotFoundException, ZipException {
        this(Zip4jUtil.isStringNotNullAndNotEmpty(name) ? new File(name) : null);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public int getCurrSplitFileCounter() {
        return this.currSplitFileCounter;
    }

    public SplitOutputStream(File file) throws FileNotFoundException, ZipException {
        this(file, -1L);
    }

    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    public SplitOutputStream(String name, long splitLength) throws FileNotFoundException, ZipException {
        long l;
        File file;
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(name)) {
            file = new File(name);
            l = splitLength;
        } else {
            file = null;
            l = splitLength;
        }
        this(file, l);
    }
}

