/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.model;

import java.util.ArrayList;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.UnzipParameters;
import net.lingala.zip4j.model.Zip64ExtendedInfo;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.unzip.Unzip;
import net.lingala.zip4j.util.Zip4jUtil;

public class FileHeader {
    private int fileCommentLength;
    private boolean isDirectory;
    private String fileComment;
    private boolean dataDescriptorExists;
    private boolean fileNameUTF8Encoded;
    private int compressionMethod;
    private long offsetLocalHeader;
    private ArrayList extraDataRecords;
    private long uncompressedSize;
    private long compressedSize;
    private byte[] generalPurposeFlag;
    private int fileNameLength;
    private int diskNumberStart;
    private int extraFieldLength;
    private byte[] externalFileAttr;
    private String fileName;
    private boolean isEncrypted;
    private int lastModFileTime;
    private int encryptionMethod;
    private byte[] internalFileAttr;
    private Zip64ExtendedInfo zip64ExtendedInfo;
    private AESExtraDataRecord aesExtraDataRecord;
    private String password;
    private int versionNeededToExtract;
    private int versionMadeBy;
    private long crc32;
    private int signature;
    private byte[] crcBuff;

    public boolean isDataDescriptorExists() {
        return this.dataDescriptorExists;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setZip64ExtendedInfo(Zip64ExtendedInfo zip64ExtendedInfo) {
        void zip64ExtendedInfo2;
        this.zip64ExtendedInfo = zip64ExtendedInfo2;
    }

    public void setOffsetLocalHeader(long offsetLocalHeader) {
        this.offsetLocalHeader = offsetLocalHeader;
    }

    public void setAesExtraDataRecord(AESExtraDataRecord aesExtraDataRecord) {
        this.aesExtraDataRecord = aesExtraDataRecord;
    }

    public void setExtraDataRecords(ArrayList extraDataRecords) {
        this.extraDataRecords = extraDataRecords;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public byte[] getInternalFileAttr() {
        return this.internalFileAttr;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getVersionMadeBy() {
        return this.versionMadeBy;
    }

    public int getFileCommentLength() {
        return this.fileCommentLength;
    }

    public int getSignature() {
        return this.signature;
    }

    public void setLastModFileTime(int lastModFileTime) {
        this.lastModFileTime = lastModFileTime;
    }

    public String getPassword() {
        return this.password;
    }

    public void setVersionMadeBy(int versionMadeBy) {
        this.versionMadeBy = versionMadeBy;
    }

    public void setCrcBuff(byte[] crcBuff) {
        this.crcBuff = crcBuff;
    }

    public boolean isFileNameUTF8Encoded() {
        return this.fileNameUTF8Encoded;
    }

    public void setEncryptionMethod(int encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
    }

    public void extractFile(ZipModel zipModel, String outPath, UnzipParameters unzipParameters, String newFileName, ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("input zipModel is null");
        }
        if (!Zip4jUtil.checkOutputFolder(outPath)) {
            throw new ZipException("Invalid output path");
        }
        if (this == null) {
            throw new ZipException("invalid file header");
        }
        new Unzip(zipModel).extractFile(this, outPath, unzipParameters, newFileName, progressMonitor, runInThread);
    }

    public byte[] getGeneralPurposeFlag() {
        return this.generalPurposeFlag;
    }

    public void setEncrypted(boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    public void setCrc32(long crc32) {
        this.crc32 = crc32;
    }

    public ArrayList getExtraDataRecords() {
        return this.extraDataRecords;
    }

    public int getExtraFieldLength() {
        return this.extraFieldLength;
    }

    public int getFileNameLength() {
        return this.fileNameLength;
    }

    public void setFileNameUTF8Encoded(boolean fileNameUTF8Encoded) {
        this.fileNameUTF8Encoded = fileNameUTF8Encoded;
    }

    public long getOffsetLocalHeader() {
        return this.offsetLocalHeader;
    }

    public void setUncompressedSize(long uncompressedSize) {
        this.uncompressedSize = uncompressedSize;
    }

    public void setFileNameLength(int fileNameLength) {
        this.fileNameLength = fileNameLength;
    }

    public byte[] getCrcBuff() {
        return this.crcBuff;
    }

    public void setVersionNeededToExtract(int versionNeededToExtract) {
        this.versionNeededToExtract = versionNeededToExtract;
    }

    public void setGeneralPurposeFlag(byte[] generalPurposeFlag) {
        this.generalPurposeFlag = generalPurposeFlag;
    }

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public byte[] getExternalFileAttr() {
        return this.externalFileAttr;
    }

    public void setCompressedSize(long compressedSize) {
        this.compressedSize = compressedSize;
    }

    public FileHeader() {
        FileHeader fileHeader = this;
        this.encryptionMethod = -1;
        fileHeader.crc32 = 0L;
        fileHeader.uncompressedSize = 0L;
    }

    public void setExternalFileAttr(byte[] externalFileAttr) {
        this.externalFileAttr = externalFileAttr;
    }

    public Zip64ExtendedInfo getZip64ExtendedInfo() {
        return this.zip64ExtendedInfo;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public long getCrc32() {
        return this.crc32 & 0xFFFFFFFFL;
    }

    public void setDiskNumberStart(int diskNumberStart) {
        this.diskNumberStart = diskNumberStart;
    }

    public int getLastModFileTime() {
        return this.lastModFileTime;
    }

    public void setInternalFileAttr(byte[] internalFileAttr) {
        this.internalFileAttr = internalFileAttr;
    }

    public String getFileComment() {
        return this.fileComment;
    }

    public int getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public AESExtraDataRecord getAesExtraDataRecord() {
        return this.aesExtraDataRecord;
    }

    public void setSignature(int signature) {
        this.signature = signature;
    }

    public void setCompressionMethod(int compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public void setFileCommentLength(int fileCommentLength) {
        this.fileCommentLength = fileCommentLength;
    }

    public void extractFile(ZipModel zipModel, String outPath, UnzipParameters unzipParameters, ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        this.extractFile(zipModel, outPath, unzipParameters, null, progressMonitor, runInThread);
    }

    public void setExtraFieldLength(int extraFieldLength) {
        this.extraFieldLength = extraFieldLength;
    }

    public void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setDataDescriptorExists(boolean dataDescriptorExists) {
        this.dataDescriptorExists = dataDescriptorExists;
    }

    public void extractFile(ZipModel zipModel, String outPath, ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        this.extractFile(zipModel, outPath, null, progressMonitor, runInThread);
    }

    public int getDiskNumberStart() {
        return this.diskNumberStart;
    }

    public int getVersionNeededToExtract() {
        return this.versionNeededToExtract;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

