/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.model;

import java.util.TimeZone;
import net.lingala.zip4j.util.InternalZipConstants;
import net.lingala.zip4j.util.Zip4jUtil;

public class ZipParameters
implements Cloneable {
    private String password;
    private String fileNameInZip;
    private TimeZone timeZone;
    private int compressionLevel;
    private boolean isSourceExternalStream;
    private String rootFolderInZip;
    private int compressionMethod;
    private boolean readHiddenFiles;
    private boolean includeRootFolder;
    private int aesKeyStrength;
    private int encryptionMethod;
    private boolean encryptFiles;
    private int sourceFileCRC;
    private String defaultFolderPath;

    public void setEncryptionMethod(int encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isReadHiddenFiles() {
        return this.readHiddenFiles;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getFileNameInZip() {
        return this.fileNameInZip;
    }

    public int getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public void setAesKeyStrength(int aesKeyStrength) {
        this.aesKeyStrength = aesKeyStrength;
    }

    public void setFileNameInZip(String fileNameInZip) {
        this.fileNameInZip = fileNameInZip;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDefaultFolderPath(String defaultFolderPath) {
        this.defaultFolderPath = defaultFolderPath;
    }

    public ZipParameters() {
        ZipParameters zipParameters = this;
        ZipParameters zipParameters2 = this;
        ZipParameters zipParameters3 = this;
        zipParameters3.compressionMethod = 8;
        zipParameters3.encryptFiles = false;
        zipParameters2.readHiddenFiles = true;
        zipParameters2.encryptionMethod = -1;
        zipParameters.aesKeyStrength = -1;
        zipParameters.includeRootFolder = true;
        zipParameters.timeZone = TimeZone.getDefault();
    }

    public void setSourceExternalStream(boolean isSourceExternalStream) {
        this.isSourceExternalStream = isSourceExternalStream;
    }

    public void setEncryptFiles(boolean encryptFiles) {
        this.encryptFiles = encryptFiles;
    }

    public boolean isEncryptFiles() {
        return this.encryptFiles;
    }

    public int getSourceFileCRC() {
        return this.sourceFileCRC;
    }

    public void setReadHiddenFiles(boolean readHiddenFiles) {
        this.readHiddenFiles = readHiddenFiles;
    }

    public boolean isIncludeRootFolder() {
        return this.includeRootFolder;
    }

    public int getAesKeyStrength() {
        return this.aesKeyStrength;
    }

    public void setCompressionMethod(int compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public void setRootFolderInZip(String rootFolderInZip) {
        if (Zip4jUtil.isStringNotNullAndNotEmpty(rootFolderInZip)) {
            if (!rootFolderInZip.endsWith("\\") && !rootFolderInZip.endsWith("/")) {
                rootFolderInZip = new StringBuilder().insert(0, rootFolderInZip).append(InternalZipConstants.FILE_SEPARATOR).toString();
            }
            rootFolderInZip = rootFolderInZip.replaceAll("\\\\", "/");
        }
        this.rootFolderInZip = rootFolderInZip;
    }

    public boolean isSourceExternalStream() {
        return this.isSourceExternalStream;
    }

    public String getDefaultFolderPath() {
        return this.defaultFolderPath;
    }

    public String getRootFolderInZip() {
        return this.rootFolderInZip;
    }

    public void setSourceFileCRC(int sourceFileCRC) {
        this.sourceFileCRC = sourceFileCRC;
    }

    public void setIncludeRootFolder(boolean includeRootFolder) {
        this.includeRootFolder = includeRootFolder;
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }
}

