/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.progress;

import net.lingala.zip4j.exception.ZipException;

public class ProgressMonitor {
    private long workCompleted;
    public static final int OPERATION_MERGE = 4;
    public static final int STATE_BUSY = 1;
    public static final int RESULT_SUCCESS = 0;
    private int state;
    public static final int RESULT_CANCELLED = 3;
    public static final int OPERATION_EXTRACT = 1;
    private int percentDone;
    private boolean pause;
    private int result;
    public static final int OPERATION_CALC_CRC = 3;
    public static final int STATE_READY = 0;
    public static final int OPERATION_ADD = 0;
    public static final int OPERATION_NONE = -1;
    public static final int RESULT_WORKING = 1;
    public static final int OPERATION_REMOVE = 2;
    private int currentOperation;
    private long totalWork;
    private String fileName;
    public static final int RESULT_ERROR = 2;
    private boolean cancelAllTasks;
    private Throwable exception;

    public int getCurrentOperation() {
        return this.currentOperation;
    }

    public boolean isCancelAllTasks() {
        return this.cancelAllTasks;
    }

    public long getTotalWork() {
        return this.totalWork;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isPause() {
        return this.pause;
    }

    public void setPause(boolean pause) {
        this.pause = pause;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public void updateWorkCompleted(long workCompleted) {
        ProgressMonitor progressMonitor = this;
        progressMonitor.workCompleted += workCompleted;
        this.percentDone = (int)(progressMonitor.workCompleted * 100L / this.totalWork);
        if (progressMonitor.percentDone > 100) {
            this.percentDone = 100;
        }
        ProgressMonitor progressMonitor2 = this;
        while (progressMonitor2.pause) {
            try {
                Thread.sleep(150L);
                progressMonitor2 = this;
            }
            catch (InterruptedException interruptedException) {
                progressMonitor2 = this;
            }
        }
    }

    public void setCurrentOperation(int currentOperation) {
        this.currentOperation = currentOperation;
    }

    public void endProgressMonitorError(Throwable throwable) throws ZipException {
        ProgressMonitor progressMonitor = this;
        this.reset();
        progressMonitor.result = 2;
        progressMonitor.exception = throwable;
    }

    public void setTotalWork(long totalWork) {
        this.totalWork = totalWork;
    }

    public void endProgressMonitorSuccess() throws ZipException {
        this.reset();
        this.result = 0;
    }

    public int getState() {
        return this.state;
    }

    public void setPercentDone(int percentDone) {
        this.percentDone = percentDone;
    }

    public void fullReset() {
        ProgressMonitor progressMonitor = this;
        this.reset();
        this.exception = null;
        progressMonitor.result = 0;
        progressMonitor.percentDone = 0;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setState(int state) {
        this.state = state;
    }

    public ProgressMonitor() {
        ProgressMonitor progressMonitor = this;
        progressMonitor.reset();
        progressMonitor.percentDone = 0;
    }

    public void cancelAllTasks() {
        this.cancelAllTasks = true;
    }

    public int getResult() {
        return this.result;
    }

    public void reset() {
        ProgressMonitor progressMonitor = this;
        ProgressMonitor progressMonitor2 = this;
        this.currentOperation = -1;
        progressMonitor2.state = 0;
        progressMonitor2.fileName = null;
        progressMonitor.totalWork = 0L;
        progressMonitor.workCompleted = 0L;
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getWorkCompleted() {
        return this.workCompleted;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }
}

