/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.unzip;

import java.io.File;
import java.util.ArrayList;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.CentralDirectory;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.UnzipParameters;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.unzip.UnzipEngine;
import net.lingala.zip4j.util.Zip4jUtil;

public class Unzip {
    private ZipModel zipModel;

    private /* synthetic */ long calculateTotalWork(ArrayList fileHeaders) throws ZipException {
        int i;
        if (fileHeaders == null) {
            throw new ZipException("fileHeaders is null, cannot calculate total work");
        }
        long totalWork = 0L;
        int n = i = 0;
        while (n < fileHeaders.size()) {
            FileHeader fileHeader = (FileHeader)fileHeaders.get(i);
            totalWork = fileHeader.getZip64ExtendedInfo() != null && fileHeader.getZip64ExtendedInfo().getUnCompressedSize() > 0L ? (totalWork += fileHeader.getZip64ExtendedInfo().getCompressedSize()) : (totalWork += fileHeader.getCompressedSize());
            n = ++i;
        }
        return totalWork;
    }

    /*
     * Exception decompiling
     */
    private /* synthetic */ void initExtractFile(FileHeader fileHeader, String outPath, UnzipParameters unzipParameters, String newFileName, ProgressMonitor progressMonitor) throws ZipException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void initExtractAll(ArrayList fileHeaders, UnzipParameters unzipParameters, ProgressMonitor progressMonitor, String outPath) throws ZipException {
        int i;
        int n = i = 0;
        while (n < fileHeaders.size()) {
            void fileHeader;
            FileHeader fileHeader2 = (FileHeader)fileHeaders.get(i);
            this.initExtractFile((FileHeader)fileHeader, outPath, unzipParameters, null, progressMonitor);
            if (progressMonitor.isCancelAllTasks()) {
                ProgressMonitor progressMonitor2 = progressMonitor;
                progressMonitor2.setResult(3);
                progressMonitor2.setState(0);
                return;
            }
            n = ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Unzip(ZipModel zipModel) throws ZipException {
        void zipModel2;
        if (zipModel == null) {
            throw new ZipException("ZipModel is null");
        }
        this.zipModel = zipModel2;
    }

    private /* synthetic */ void checkOutputDirectoryStructure(FileHeader fileHeader, String outPath, String newFileName) throws ZipException {
        if (fileHeader == null || !Zip4jUtil.isStringNotNullAndNotEmpty(outPath)) {
            throw new ZipException("Cannot check output directory structure...one of the parameters was null");
        }
        String fileName = fileHeader.getFileName();
        if (Zip4jUtil.isStringNotNullAndNotEmpty(newFileName)) {
            fileName = newFileName;
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileName)) {
            return;
        }
        String compOutPath = new StringBuilder().insert(0, outPath).append(fileName).toString();
        try {
            File file = new File(compOutPath);
            String parentDir = file.getParent();
            File parentDirFile = new File(parentDir);
            if (!parentDirFile.exists()) {
                parentDirFile.mkdirs();
                return;
            }
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public void extractFile(FileHeader fileHeader, String outPath, UnzipParameters unzipParameters, String newFileName, ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        if (fileHeader == null) {
            throw new ZipException("fileHeader is null");
        }
        progressMonitor.setTotalWork(fileHeader.getCompressedSize());
        if (runInThread) {
            new Thread(this, "Zip4j", fileHeader, outPath, unzipParameters, newFileName, progressMonitor){
                final /* synthetic */ FileHeader val$fileHeader;
                final /* synthetic */ UnzipParameters val$unzipParameters;
                final /* synthetic */ String val$outPath;
                final /* synthetic */ String val$newFileName;
                final /* synthetic */ Unzip this$0;
                final /* synthetic */ ProgressMonitor val$progressMonitor;
                {
                    void this$0;
                    2 v0 = this;
                    2 v1 = this;
                    this.this$0 = this$0;
                    v1.val$fileHeader = fileHeader;
                    v1.val$outPath = string2;
                    v0.val$unzipParameters = unzipParameters;
                    v0.val$newFileName = string3;
                    this.val$progressMonitor = progressMonitor;
                    super(string);
                }

                @Override
                public void run() {
                    try {
                        2 v0 = this;
                        2 v1 = this;
                        2 v2 = this;
                        v0.this$0.initExtractFile(v0.val$fileHeader, v1.val$outPath, v1.val$unzipParameters, v2.val$newFileName, v2.val$progressMonitor);
                        return;
                    }
                    catch (ZipException zipException) {
                        return;
                    }
                }
            }.start();
            return;
        }
        this.initExtractFile(fileHeader, outPath, unzipParameters, newFileName, progressMonitor);
    }

    public ZipInputStream getInputStream(FileHeader fileHeader) throws ZipException {
        return new UnzipEngine(this.zipModel, fileHeader).getInputStream();
    }

    /*
     * WARNING - void declaration
     */
    public void extractAll(UnzipParameters unzipParameters, String outPath, ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        void fileHeaders;
        CentralDirectory centralDirectory = this.zipModel.getCentralDirectory();
        if (centralDirectory == null || centralDirectory.getFileHeaders() == null) {
            throw new ZipException("invalid central directory in zipModel");
        }
        ArrayList arrayList = centralDirectory.getFileHeaders();
        ProgressMonitor progressMonitor2 = progressMonitor;
        progressMonitor.setCurrentOperation(1);
        progressMonitor2.setTotalWork(this.calculateTotalWork((ArrayList)fileHeaders));
        progressMonitor2.setState(1);
        if (runInThread) {
            new Thread(this, "Zip4j", (ArrayList)fileHeaders, unzipParameters, progressMonitor, outPath){
                final /* synthetic */ String val$outPath;
                final /* synthetic */ UnzipParameters val$unzipParameters;
                final /* synthetic */ ProgressMonitor val$progressMonitor;
                final /* synthetic */ Unzip this$0;
                final /* synthetic */ ArrayList val$fileHeaders;

                @Override
                public void run() {
                    try {
                        1 v0 = this;
                        1 v1 = this;
                        v0.this$0.initExtractAll(v0.val$fileHeaders, v1.val$unzipParameters, v1.val$progressMonitor, this.val$outPath);
                        v0.val$progressMonitor.endProgressMonitorSuccess();
                        return;
                    }
                    catch (ZipException zipException) {
                        return;
                    }
                }
                {
                    void this$0;
                    1 v0 = this;
                    1 v1 = this;
                    v1.this$0 = this$0;
                    v1.val$fileHeaders = arrayList;
                    v0.val$unzipParameters = unzipParameters;
                    v0.val$progressMonitor = progressMonitor;
                    this.val$outPath = string2;
                    super(string);
                }
            }.start();
            return;
        }
        this.initExtractAll((ArrayList)fileHeaders, unzipParameters, progressMonitor, outPath);
    }
}

