/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.unzip;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.zip.CRC32;
import net.lingala.zip4j.core.HeaderReader;
import net.lingala.zip4j.crypto.AESDecrypter;
import net.lingala.zip4j.crypto.IDecrypter;
import net.lingala.zip4j.crypto.StandardDecrypter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.InflaterInputStream;
import net.lingala.zip4j.io.PartInputStream;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.UnzipParameters;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.unzip.UnzipUtil;
import net.lingala.zip4j.util.Raw;
import net.lingala.zip4j.util.Zip4jUtil;

public class UnzipEngine {
    private ZipModel zipModel;
    private IDecrypter decrypter;
    private FileHeader fileHeader;
    private LocalFileHeader localFileHeader;
    private int currSplitFileCounter = 0;
    private CRC32 crc;

    public void updateCRC(byte[] buff, int offset, int len) {
        if (buff != null) {
            this.crc.update(buff, offset, len);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unzipFile(ProgressMonitor progressMonitor, String outPath, String newFileName, UnzipParameters unzipParameters) throws ZipException {
        FileOutputStream os;
        ZipInputStream is;
        block8: {
            ProgressMonitor progressMonitor2;
            if (this.zipModel == null || this.fileHeader == null || !Zip4jUtil.isStringNotNullAndNotEmpty(outPath)) {
                throw new ZipException("Invalid parameters passed during unzipping file. One or more of the parameters were null");
            }
            is = null;
            os = null;
            byte[] buff = new byte[4096];
            int readLength = -1;
            UnzipEngine unzipEngine = this;
            is = unzipEngine.getInputStream();
            os = unzipEngine.getOutputStream(outPath, newFileName);
            do {
                readLength = ((InputStream)is).read(buff);
                if (readLength == -1) break block8;
                progressMonitor2 = progressMonitor;
                ((OutputStream)os).write(buff, 0, readLength);
                progressMonitor2.updateWorkCompleted(readLength);
            } while (!progressMonitor2.isCancelAllTasks());
            ProgressMonitor progressMonitor3 = progressMonitor;
            progressMonitor3.setResult(3);
            progressMonitor3.setState(0);
            this.closeStreams(is, os);
            return;
        }
        try {
            UnzipEngine unzipEngine = this;
            unzipEngine.closeStreams(is, os);
            UnzipUtil.applyFileAttributes(unzipEngine.fileHeader, new File(this.getOutputFileNameWithPath(outPath, newFileName)), unzipParameters);
        }
        catch (IOException e) {
            try {
                throw new ZipException(e);
                catch (Exception e2) {
                    throw new ZipException(e2);
                }
            }
            catch (Throwable throwable) {
                this.closeStreams(is, os);
                throw throwable;
            }
        }
        this.closeStreams(is, os);
        return;
    }

    public void updateCRC(int b) {
        this.crc.update(b);
    }

    public IDecrypter getDecrypter() {
        return this.decrypter;
    }

    private /* synthetic */ byte[] getAESPasswordVerifier(RandomAccessFile raf) throws ZipException {
        try {
            byte[] pvBytes = new byte[2];
            raf.read(pvBytes);
            return pvBytes;
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
    }

    /*
     * Loose catch block
     */
    private /* synthetic */ boolean checkLocalHeader() throws ZipException {
        boolean bl;
        RandomAccessFile rafForLH;
        block19: {
            block17: {
                boolean bl2;
                block18: {
                    rafForLH = null;
                    rafForLH = this.checkSplitFile();
                    if (rafForLH == null) {
                        rafForLH = new RandomAccessFile(new File(this.zipModel.getZipFile()), "r");
                    }
                    HeaderReader headerReader = new HeaderReader(rafForLH);
                    UnzipEngine unzipEngine = this;
                    unzipEngine.localFileHeader = headerReader.readLocalFileHeader(unzipEngine.fileHeader);
                    if (unzipEngine.localFileHeader == null) {
                        throw new ZipException("error reading local file header. Is this a valid zip file?");
                    }
                    if (this.localFileHeader.getCompressionMethod() == this.fileHeader.getCompressionMethod()) break block17;
                    bl2 = false;
                    if (rafForLH == null) break block18;
                    try {
                        rafForLH.close();
                        return bl2;
                    }
                    catch (IOException iOException) {
                        return bl2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            bl = true;
            if (rafForLH == null) break block19;
            try {
                rafForLH.close();
                return bl;
            }
            catch (IOException iOException) {
                return bl;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
        catch (FileNotFoundException e) {
            try {
                throw new ZipException(e);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block20: {
                    if (rafForLH != null) {
                        try {
                            rafForLH.close();
                            throwable2 = throwable;
                            break block20;
                        }
                        catch (IOException iOException) {
                            throwable2 = throwable;
                            break block20;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
        }
    }

    public RandomAccessFile startNextSplitFile() throws IOException, FileNotFoundException {
        UnzipEngine unzipEngine;
        UnzipEngine unzipEngine2 = this;
        String currZipFile = unzipEngine2.zipModel.getZipFile();
        String partFile = null;
        if (unzipEngine2.currSplitFileCounter == this.zipModel.getEndCentralDirRecord().getNoOfThisDisk()) {
            UnzipEngine unzipEngine3 = this;
            unzipEngine = unzipEngine3;
            partFile = unzipEngine3.zipModel.getZipFile();
        } else if (this.currSplitFileCounter >= 9) {
            String string = currZipFile;
            partFile = new StringBuilder().insert(0, string.substring(0, string.lastIndexOf("."))).append(".z").append(this.currSplitFileCounter + 1).toString();
            unzipEngine = this;
        } else {
            String string = currZipFile;
            partFile = new StringBuilder().insert(0, string.substring(0, string.lastIndexOf("."))).append(".z0").append(this.currSplitFileCounter + 1).toString();
            unzipEngine = this;
        }
        ++unzipEngine.currSplitFileCounter;
        try {
            if (!Zip4jUtil.checkFileExists(partFile)) {
                throw new IOException(new StringBuilder().insert(0, "zip split file does not exist: ").append(partFile).toString());
            }
        }
        catch (ZipException e) {
            throw new IOException(e.getMessage());
        }
        return new RandomAccessFile(partFile, "r");
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    private /* synthetic */ FileOutputStream getOutputStream(String outPath, String newFileName) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(outPath)) {
            throw new ZipException("invalid output path");
        }
        try {
            File file = new File(this.getOutputFileNameWithPath(outPath, newFileName));
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            return fileOutputStream;
        }
        catch (FileNotFoundException e) {
            throw new ZipException(e);
        }
    }

    private /* synthetic */ byte[] getStandardDecrypterHeaderBytes(RandomAccessFile raf) throws ZipException {
        try {
            byte[] headerBytes = new byte[12];
            RandomAccessFile randomAccessFile = raf;
            randomAccessFile.seek(this.localFileHeader.getOffsetStartOfData());
            randomAccessFile.read(headerBytes, 0, 12);
            return headerBytes;
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ZipInputStream getInputStream() throws ZipException {
        if (this.fileHeader == null) {
            throw new ZipException("file header is null, cannot get inputstream");
        }
        try {
            RandomAccessFile randomAccessFile;
            int compressionMethod;
            long offsetStartOfData;
            long comprSize;
            RandomAccessFile raf;
            block20: {
                UnzipEngine unzipEngine;
                block19: {
                    UnzipEngine unzipEngine2 = this;
                    raf = unzipEngine2.createFileHandler("r");
                    String errMsg = "local header and file header do not match";
                    if (!unzipEngine2.checkLocalHeader()) {
                        throw new ZipException(errMsg);
                    }
                    UnzipEngine unzipEngine3 = this;
                    unzipEngine3.init(raf);
                    comprSize = unzipEngine3.localFileHeader.getCompressedSize();
                    offsetStartOfData = unzipEngine3.localFileHeader.getOffsetStartOfData();
                    if (unzipEngine3.localFileHeader.isEncrypted()) {
                        if (this.localFileHeader.getEncryptionMethod() == 99) {
                            if (this.decrypter instanceof AESDecrypter) {
                                comprSize -= (long)(((AESDecrypter)this.decrypter).getSaltLength() + ((AESDecrypter)this.decrypter).getPasswordVerifierLength() + 10);
                                offsetStartOfData += (long)(((AESDecrypter)this.decrypter).getSaltLength() + ((AESDecrypter)this.decrypter).getPasswordVerifierLength());
                                unzipEngine = this;
                                break block19;
                            } else {
                                throw new ZipException(new StringBuilder().insert(0, "invalid decryptor when trying to calculate compressed size for AES encrypted file: ").append(this.fileHeader.getFileName()).toString());
                            }
                        }
                        if (this.localFileHeader.getEncryptionMethod() == 0) {
                            comprSize -= 12L;
                            offsetStartOfData += 12L;
                        }
                    }
                    unzipEngine = this;
                }
                compressionMethod = unzipEngine.fileHeader.getCompressionMethod();
                if (this.fileHeader.getEncryptionMethod() == 99) {
                    if (this.fileHeader.getAesExtraDataRecord() != null) {
                        randomAccessFile = raf;
                        compressionMethod = this.fileHeader.getAesExtraDataRecord().getCompressionMethod();
                        break block20;
                    } else {
                        throw new ZipException(new StringBuilder().insert(0, "AESExtraDataRecord does not exist for AES encrypted file: ").append(this.fileHeader.getFileName()).toString());
                    }
                }
                randomAccessFile = raf;
            }
            randomAccessFile.seek(offsetStartOfData);
            switch (compressionMethod) {
                case 0: {
                    return new ZipInputStream(new PartInputStream(raf, offsetStartOfData, comprSize, this));
                }
                case 8: {
                    return new ZipInputStream(new InflaterInputStream(raf, offsetStartOfData, comprSize, this));
                }
            }
            throw new ZipException("compression type not supported");
        }
        catch (ZipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    private /* synthetic */ RandomAccessFile createFileHandler(String mode) throws ZipException {
        RandomAccessFile raf;
        block5: {
            if (this.zipModel == null || !Zip4jUtil.isStringNotNullAndNotEmpty(this.zipModel.getZipFile())) {
                throw new ZipException("input parameter is null in getFilePointer");
            }
            raf = null;
            if (!this.zipModel.isSplitArchive()) break block5;
            raf = this.checkSplitFile();
            return raf;
        }
        try {
            raf = new RandomAccessFile(new File(this.zipModel.getZipFile()), mode);
            return raf;
        }
        catch (FileNotFoundException e) {
            throw new ZipException(e);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public ZipModel getZipModel() {
        return this.zipModel;
    }

    public void checkCRC() throws ZipException {
        if (this.fileHeader != null) {
            if (this.fileHeader.getEncryptionMethod() == 99) {
                if (this.decrypter != null && this.decrypter instanceof AESDecrypter) {
                    byte[] tmpMacBytes = ((AESDecrypter)this.decrypter).getCalculatedAuthenticationBytes();
                    byte[] storedMac = ((AESDecrypter)this.decrypter).getStoredMac();
                    byte[] calculatedMac = new byte[10];
                    if (calculatedMac == null || storedMac == null) {
                        throw new ZipException(new StringBuilder().insert(0, "CRC (MAC) check failed for ").append(this.fileHeader.getFileName()).toString());
                    }
                    System.arraycopy(tmpMacBytes, 0, calculatedMac, 0, 10);
                    if (!Arrays.equals(calculatedMac, storedMac)) {
                        throw new ZipException(new StringBuilder().insert(0, "invalid CRC (MAC) for file: ").append(this.fileHeader.getFileName()).toString());
                    }
                }
            } else {
                long calculatedCRC = this.crc.getValue() & 0xFFFFFFFFL;
                if (calculatedCRC != this.fileHeader.getCrc32()) {
                    String errMsg = new StringBuilder().insert(0, "invalid CRC for file: ").append(this.fileHeader.getFileName()).toString();
                    if (this.localFileHeader.isEncrypted() && this.localFileHeader.getEncryptionMethod() == 0) {
                        errMsg = new StringBuilder().insert(0, errMsg).append(" - Wrong Password?").toString();
                    }
                    throw new ZipException(errMsg);
                }
            }
        }
    }

    private /* synthetic */ void closeStreams(InputStream is, OutputStream os) throws ZipException {
        OutputStream outputStream;
        block6: {
            block7: {
                if (is != null) {
                    try {
                        is.close();
                        is = null;
                        outputStream = os;
                        break block6;
                    }
                    catch (IOException e) {
                        if (e == null || !Zip4jUtil.isStringNotNullAndNotEmpty(e.getMessage()) || e.getMessage().indexOf(" - Wrong Password?") < 0) break block7;
                        throw new ZipException(e.getMessage());
                    }
                }
            }
            outputStream = os;
        }
        if (outputStream != null) {
            try {
                os.close();
                os = null;
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private /* synthetic */ byte[] getAESSalt(RandomAccessFile raf) throws ZipException {
        if (this.localFileHeader.getAesExtraDataRecord() == null) {
            return null;
        }
        try {
            UnzipEngine unzipEngine = this;
            AESExtraDataRecord aesExtraDataRecord = unzipEngine.localFileHeader.getAesExtraDataRecord();
            byte[] saltBytes = new byte[unzipEngine.calculateAESSaltLength(aesExtraDataRecord)];
            RandomAccessFile randomAccessFile = raf;
            randomAccessFile.seek(this.localFileHeader.getOffsetStartOfData());
            randomAccessFile.read(saltBytes);
            return saltBytes;
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public UnzipEngine(ZipModel zipModel, FileHeader fileHeader) throws ZipException {
        void zipModel2;
        void fileHeader2;
        if (zipModel == null || fileHeader2 == null) {
            throw new ZipException("Invalid parameters passed to StoreUnzip. One or more of the parameters were null");
        }
        UnzipEngine unzipEngine = this;
        unzipEngine.zipModel = zipModel2;
        unzipEngine.fileHeader = fileHeader2;
        UnzipEngine unzipEngine2 = this;
        this.crc = new CRC32();
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int calculateAESSaltLength(AESExtraDataRecord aesExtraDataRecord) throws ZipException {
        if (aesExtraDataRecord == null) {
            throw new ZipException("unable to determine salt length: AESExtraDataRecord is null");
        }
        switch (aesExtraDataRecord.getAesStrength()) {
            case 1: {
                return 8;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 16;
            }
        }
        throw new ZipException("unable to determine salt length: invalid aes key strength");
    }

    private /* synthetic */ void initDecrypter(RandomAccessFile raf) throws ZipException {
        if (this.localFileHeader == null) {
            throw new ZipException("local file header is null, cannot init decrypter");
        }
        if (this.localFileHeader.isEncrypted()) {
            if (this.localFileHeader.getEncryptionMethod() == 0) {
                UnzipEngine unzipEngine = this;
                this.decrypter = new StandardDecrypter(this.fileHeader, this.getStandardDecrypterHeaderBytes(raf));
                return;
            }
            if (this.localFileHeader.getEncryptionMethod() == 99) {
                UnzipEngine unzipEngine = this;
                this.decrypter = new AESDecrypter(this.localFileHeader, this.getAESSalt(raf), this.getAESPasswordVerifier(raf));
                return;
            }
            throw new ZipException("unsupported encryption method");
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ RandomAccessFile checkSplitFile() throws ZipException {
        if (this.zipModel.isSplitArchive()) {
            UnzipEngine unzipEngine = this;
            int diskNumberStartOfFile = unzipEngine.fileHeader.getDiskNumberStart();
            unzipEngine.currSplitFileCounter = diskNumberStartOfFile + 1;
            String curZipFile = unzipEngine.zipModel.getZipFile();
            String partFile = null;
            if (diskNumberStartOfFile == this.zipModel.getEndCentralDirRecord().getNoOfThisDisk()) {
                partFile = this.zipModel.getZipFile();
            } else if (diskNumberStartOfFile >= 9) {
                String string = curZipFile;
                partFile = new StringBuilder().insert(0, string.substring(0, string.lastIndexOf("."))).append(".z").append(diskNumberStartOfFile + 1).toString();
            } else {
                String string = curZipFile;
                partFile = new StringBuilder().insert(0, string.substring(0, string.lastIndexOf("."))).append(".z0").append(diskNumberStartOfFile + 1).toString();
            }
            try {
                RandomAccessFile raf = new RandomAccessFile(partFile, "r");
                if (this.currSplitFileCounter == 1) {
                    void splitSig;
                    byte[] byArray = new byte[4];
                    void v3 = splitSig;
                    raf.read((byte[])v3);
                    if ((long)Raw.readIntLittleEndian((byte[])v3, 0) != 134695760L) {
                        throw new ZipException("invalid first part split file signature");
                    }
                }
                return raf;
            }
            catch (FileNotFoundException e) {
                throw new ZipException(e);
            }
            catch (IOException e) {
                throw new ZipException(e);
            }
        }
        return null;
    }

    private /* synthetic */ String getOutputFileNameWithPath(String outPath, String newFileName) throws ZipException {
        String fileName = null;
        fileName = Zip4jUtil.isStringNotNullAndNotEmpty(newFileName) ? newFileName : this.fileHeader.getFileName();
        return new StringBuilder().insert(0, outPath).append(System.getProperty("file.separator")).append(fileName).toString();
    }

    public LocalFileHeader getLocalFileHeader() {
        return this.localFileHeader;
    }

    private /* synthetic */ void init(RandomAccessFile raf) throws ZipException {
        if (this.localFileHeader == null) {
            throw new ZipException("local file header is null, cannot initialize input stream");
        }
        try {
            this.initDecrypter(raf);
            return;
        }
        catch (ZipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }
}

