/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.unzip;

import java.io.File;
import java.util.TimeZone;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.UnzipParameters;
import net.lingala.zip4j.util.Zip4jUtil;

public class UnzipUtil {
    private static TimeZone defaultTimeZone = TimeZone.getDefault();

    private static /* synthetic */ void setFileLastModifiedTime(FileHeader fileHeader, File file) throws ZipException {
        if (fileHeader.getLastModFileTime() <= 0) {
            return;
        }
        if (file.exists()) {
            file.setLastModified(Zip4jUtil.getLocalTimeFromDSTTime(defaultTimeZone, Zip4jUtil.dosToJavaTme(fileHeader.getLastModFileTime())));
        }
    }

    public static void applyFileAttributes(FileHeader fileHeader, File file, UnzipParameters unzipParameters) throws ZipException {
        UnzipParameters unzipParameters2;
        boolean bl;
        UnzipParameters unzipParameters3;
        boolean bl2;
        UnzipParameters unzipParameters4;
        boolean bl3;
        if (fileHeader == null) {
            throw new ZipException("cannot set file properties: file header is null");
        }
        if (file == null) {
            throw new ZipException("cannot set file properties: output file is null");
        }
        if (!Zip4jUtil.checkFileExists(file)) {
            throw new ZipException("cannot set file properties: file doesnot exist");
        }
        if (unzipParameters == null || !unzipParameters.isIgnoreDateTimeAttributes()) {
            UnzipUtil.setFileLastModifiedTime(fileHeader, file);
        }
        if (unzipParameters == null) {
            UnzipUtil.setFileAttributes(fileHeader, file, true, true, true, true);
            return;
        }
        if (unzipParameters.isIgnoreAllFileAttributes()) {
            UnzipUtil.setFileAttributes(fileHeader, file, false, false, false, false);
            return;
        }
        if (!unzipParameters.isIgnoreReadOnlyFileAttribute()) {
            bl3 = true;
            unzipParameters4 = unzipParameters;
        } else {
            bl3 = false;
            unzipParameters4 = unzipParameters;
        }
        if (!unzipParameters4.isIgnoreHiddenFileAttribute()) {
            bl2 = true;
            unzipParameters3 = unzipParameters;
        } else {
            bl2 = false;
            unzipParameters3 = unzipParameters;
        }
        if (!unzipParameters3.isIgnoreArchiveFileAttribute()) {
            bl = true;
            unzipParameters2 = unzipParameters;
        } else {
            bl = false;
            unzipParameters2 = unzipParameters;
        }
        UnzipUtil.setFileAttributes(fileHeader, file, bl3, bl2, bl, !unzipParameters2.isIgnoreSystemFileAttribute());
    }

    public static void applyFileAttributes(FileHeader fileHeader, File file) throws ZipException {
        UnzipUtil.applyFileAttributes(fileHeader, file, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static /* synthetic */ void setFileAttributes(FileHeader fileHeader, File file, boolean setReadOnly, boolean setHidden, boolean setArchive, boolean setSystem) throws ZipException {
        if (fileHeader == null) {
            throw new ZipException("invalid file header. cannot set file attributes");
        }
        byte[] externalAttrbs = fileHeader.getExternalFileAttr();
        if (externalAttrbs == null) {
            return;
        }
        switch (externalAttrbs[0]) {
            case 1: {
                if (!setReadOnly) break;
                Zip4jUtil.setFileReadOnly(file);
                return;
            }
            case 2: 
            case 18: {
                if (!setHidden) break;
                Zip4jUtil.setFileHidden(file);
                return;
            }
            case 32: 
            case 48: {
                if (!setArchive) break;
                Zip4jUtil.setFileArchive(file);
                return;
            }
            case 3: {
                if (setReadOnly) {
                    Zip4jUtil.setFileReadOnly(file);
                }
                if (!setHidden) break;
                Zip4jUtil.setFileHidden(file);
                return;
            }
            case 33: {
                if (setArchive) {
                    Zip4jUtil.setFileArchive(file);
                }
                if (!setReadOnly) break;
                Zip4jUtil.setFileReadOnly(file);
                return;
            }
            case 34: 
            case 50: {
                if (setArchive) {
                    Zip4jUtil.setFileArchive(file);
                }
                if (!setHidden) break;
                Zip4jUtil.setFileHidden(file);
                return;
            }
            case 35: {
                if (setArchive) {
                    Zip4jUtil.setFileArchive(file);
                }
                if (setReadOnly) {
                    Zip4jUtil.setFileReadOnly(file);
                }
                if (!setHidden) break;
                Zip4jUtil.setFileHidden(file);
                return;
            }
            case 38: {
                if (setReadOnly) {
                    Zip4jUtil.setFileReadOnly(file);
                }
                if (setHidden) {
                    Zip4jUtil.setFileHidden(file);
                }
                if (!setSystem) break;
                Zip4jUtil.setFileSystemMode(file);
                return;
            }
        }
    }
}

