/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import net.lingala.zip4j.core.HeaderWriter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.SplitOutputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.util.Raw;
import net.lingala.zip4j.util.Zip4jUtil;

public class ArchiveMaintainer {
    private /* synthetic */ void restoreFileName(File zipFile, String tmpZipFileName) throws ZipException {
        if (zipFile.delete()) {
            if (!new File(tmpZipFileName).renameTo(zipFile)) {
                throw new ZipException("cannot rename modified zip file");
            }
        } else {
            throw new ZipException("cannot delete old zip file");
        }
    }

    private /* synthetic */ RandomAccessFile createFileHandler(ZipModel zipModel, String mode) throws ZipException {
        if (zipModel == null || !Zip4jUtil.isStringNotNullAndNotEmpty(zipModel.getZipFile())) {
            throw new ZipException("input parameter is null in getFilePointer, cannot create file handler to remove file");
        }
        try {
            return new RandomAccessFile(new File(zipModel.getZipFile()), mode);
        }
        catch (FileNotFoundException e) {
            throw new ZipException(e);
        }
    }

    public void initProgressMonitorForMergeOp(ZipModel zipModel, ProgressMonitor progressMonitor) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot calculate total work for merge op");
        }
        ProgressMonitor progressMonitor2 = progressMonitor;
        progressMonitor.setCurrentOperation(4);
        progressMonitor2.setFileName(zipModel.getZipFile());
        progressMonitor2.setTotalWork(this.calculateTotalWorkForMergeOp(zipModel));
        progressMonitor.setState(1);
    }

    private /* synthetic */ OutputStream prepareOutputStreamForMerge(File outFile) throws ZipException {
        if (outFile == null) {
            throw new ZipException("outFile is null, cannot create outputstream");
        }
        try {
            return new FileOutputStream(outFile);
        }
        catch (FileNotFoundException e) {
            throw new ZipException(e);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void copyFile(RandomAccessFile inputStream, OutputStream outputStream, long start, long end, ProgressMonitor progressMonitor) throws ZipException {
        if (inputStream == null || outputStream == null) {
            throw new ZipException("input or output stream is null, cannot copy file");
        }
        if (start < 0L) {
            throw new ZipException("starting offset is negative, cannot copy file");
        }
        if (end < 0L) {
            throw new ZipException("end offset is negative, cannot copy file");
        }
        if (start > end) {
            throw new ZipException("start offset is greater than end offset, cannot copy file");
        }
        if (start == end) {
            return;
        }
        if (progressMonitor.isCancelAllTasks()) {
            v0 = progressMonitor;
            v0.setResult(3);
            v0.setState(0);
            return;
        }
        try {
            block13: {
                inputStream.seek(start);
                readLen = -2;
                bytesRead = 0L;
                bytesToRead = end - start;
                if (end - start >= 4096L) break block13;
                var9_11 = new byte[(int)(end - start)];
                v1 = inputStream;
                ** GOTO lbl37
            }
            buff = new byte[4096];
            while (true) {
                v1 = inputStream;
lbl37:
                // 2 sources

                readLen = v1.read(buff);
                if (readLen != -1) {
                    v2 = progressMonitor;
                    outputStream.write(buff, 0, readLen);
                    v2.updateWorkCompleted(readLen);
                    if (v2.isCancelAllTasks()) {
                        progressMonitor.setResult(3);
                        return;
                    }
                    if ((bytesRead += (long)readLen) == bytesToRead) {
                        return;
                    }
                    if (bytesRead + (long)buff.length <= bytesToRead) continue;
                    buff = new byte[(int)(bytesToRead - bytesRead)];
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public HashMap initRemoveZipFile(ZipModel zipModel, FileHeader fileHeader, ProgressMonitor progressMonitor) throws ZipException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ RandomAccessFile createSplitZipFileHandler(ZipModel zipModel, int partNumber) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot create split file handler");
        }
        if (partNumber < 0) {
            throw new ZipException("invlaid part number, cannot create split file handler");
        }
        try {
            String curZipFile = zipModel.getZipFile();
            String partFile = null;
            if (partNumber == zipModel.getEndCentralDirRecord().getNoOfThisDisk()) {
                partFile = zipModel.getZipFile();
            } else if (partNumber >= 9) {
                String string = curZipFile;
                partFile = new StringBuilder().insert(0, string.substring(0, string.lastIndexOf("."))).append(".z").append(partNumber + 1).toString();
            } else {
                String string = curZipFile;
                partFile = new StringBuilder().insert(0, string.substring(0, string.lastIndexOf("."))).append(".z0").append(partNumber + 1).toString();
            }
            File tmpFile = new File(partFile);
            if (!Zip4jUtil.checkFileExists(tmpFile)) {
                throw new ZipException(new StringBuilder().insert(0, "split file does not exist: ").append(partFile).toString());
            }
            return new RandomAccessFile(tmpFile, "r");
        }
        catch (FileNotFoundException e) {
            throw new ZipException(e);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    private /* synthetic */ void updateSplitZip64EndCentralDirRec(ZipModel zipModel, ArrayList fileSizeList) throws ZipException {
        int i;
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot update split Zip64 end of central directory record");
        }
        if (zipModel.getZip64EndCentralDirRecord() == null) {
            return;
        }
        ZipModel zipModel2 = zipModel;
        zipModel2.getZip64EndCentralDirRecord().setNoOfThisDisk(0);
        zipModel2.getZip64EndCentralDirRecord().setNoOfThisDiskStartOfCentralDir(0);
        zipModel2.getZip64EndCentralDirRecord().setTotNoOfEntriesInCentralDirOnThisDisk(zipModel.getEndCentralDirRecord().getTotNoOfEntriesInCentralDir());
        long offsetStartCenDirWRTStartDiskNo = 0L;
        int n = i = 0;
        while (n < fileSizeList.size()) {
            Long l = (Long)fileSizeList.get(i);
            offsetStartCenDirWRTStartDiskNo += l.longValue();
            n = ++i;
        }
        zipModel.getZip64EndCentralDirRecord().setOffsetStartCenDirWRTStartDiskNo(zipModel.getZip64EndCentralDirRecord().getOffsetStartCenDirWRTStartDiskNo() + offsetStartCenDirWRTStartDiskNo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void updateSplitFileHeader(ZipModel zipModel, ArrayList fileSizeList, boolean splitSigRemoved) throws ZipException {
        try {
            if (zipModel.getCentralDirectory() == null) {
                throw new ZipException("corrupt zip model - getCentralDirectory, cannot update split zip model");
            }
            int fileHeaderCount = zipModel.getCentralDirectory().getFileHeaders().size();
            int splitSigOverhead = 0;
            if (splitSigRemoved) {
                splitSigOverhead = 4;
            }
            for (int i = 0; i < fileHeaderCount; ++i) {
                int j;
                long offsetLHToAdd = 0L;
                int n = j = 0;
                while (n < ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).getDiskNumberStart()) {
                    Long l = (Long)fileSizeList.get(j);
                    offsetLHToAdd += l.longValue();
                    n = ++j;
                }
                ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).setOffsetLocalHeader(((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).getOffsetLocalHeader() + offsetLHToAdd - (long)splitSigOverhead);
                FileHeader fileHeader = (FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i);
                fileHeader.setDiskNumberStart(0);
            }
            return;
        }
        catch (ZipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public void initProgressMonitorForRemoveOp(ZipModel zipModel, FileHeader fileHeader, ProgressMonitor progressMonitor) throws ZipException {
        if (zipModel == null || fileHeader == null || progressMonitor == null) {
            throw new ZipException("one of the input parameters is null, cannot calculate total work");
        }
        ProgressMonitor progressMonitor2 = progressMonitor;
        progressMonitor.setCurrentOperation(2);
        progressMonitor2.setFileName(fileHeader.getFileName());
        progressMonitor2.setTotalWork(this.calculateTotalWorkForRemoveOp(zipModel, fileHeader));
        progressMonitor.setState(1);
    }

    private /* synthetic */ void updateSplitZipModel(ZipModel zipModel, ArrayList fileSizeList, boolean splitSigRemoved) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot update split zip model");
        }
        ZipModel zipModel2 = zipModel;
        zipModel2.setSplitArchive(false);
        ArchiveMaintainer archiveMaintainer = this;
        archiveMaintainer.updateSplitFileHeader(zipModel, fileSizeList, splitSigRemoved);
        archiveMaintainer.updateSplitEndCentralDirectory(zipModel2);
        if (zipModel2.isZip64Format()) {
            ArchiveMaintainer archiveMaintainer2 = this;
            archiveMaintainer2.updateSplitZip64EndCentralDirLocator(zipModel, fileSizeList);
            archiveMaintainer2.updateSplitZip64EndCentralDirRec(zipModel, fileSizeList);
        }
    }

    private /* synthetic */ long calculateTotalWorkForRemoveOp(ZipModel zipModel, FileHeader fileHeader) throws ZipException {
        return Zip4jUtil.getFileLengh(new File(zipModel.getZipFile())) - fileHeader.getCompressedSize();
    }

    private /* synthetic */ long calculateTotalWorkForMergeOp(ZipModel zipModel) throws ZipException {
        long totSize = 0L;
        if (zipModel.isSplitArchive()) {
            int i;
            ZipModel zipModel2 = zipModel;
            int totNoOfSplitFiles = zipModel2.getEndCentralDirRecord().getNoOfThisDisk();
            String partFile = null;
            String curZipFile = zipModel2.getZipFile();
            int partNumber = 0;
            int n = i = 0;
            while (n <= totNoOfSplitFiles) {
                long l;
                if (partNumber == zipModel.getEndCentralDirRecord().getNoOfThisDisk()) {
                    partFile = zipModel.getZipFile();
                    l = totSize;
                } else if (partNumber >= 9) {
                    String string = curZipFile;
                    partFile = new StringBuilder().insert(0, string.substring(0, string.lastIndexOf("."))).append(".z").append(partNumber + 1).toString();
                    l = totSize;
                } else {
                    String string = curZipFile;
                    partFile = new StringBuilder().insert(0, string.substring(0, string.lastIndexOf("."))).append(".z0").append(partNumber + 1).toString();
                    l = totSize;
                }
                totSize = l + Zip4jUtil.getFileLengh(new File(partFile));
                n = ++i;
            }
        }
        return totSize;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setComment(ZipModel zipModel, String comment) throws ZipException {
        HeaderWriter headerWriter;
        if (comment == null) {
            throw new ZipException("comment is null, cannot update Zip file with comment");
        }
        if (zipModel == null) {
            throw new ZipException("zipModel is null, cannot update Zip file with comment");
        }
        ZipModel zipModel2 = zipModel;
        zipModel2.getEndCentralDirRecord().setComment(comment);
        zipModel2.getEndCentralDirRecord().setCommentBytes(comment.getBytes());
        zipModel2.getEndCentralDirRecord().setCommentLength(comment.length());
        SplitOutputStream outputStream = null;
        HeaderWriter headerWriter2333332 = new HeaderWriter();
        outputStream = new SplitOutputStream(zipModel.getZipFile());
        if (zipModel.isZip64Format()) {
            headerWriter = headerWriter2333332;
            outputStream.seek(zipModel.getZip64EndCentralDirRecord().getOffsetStartCenDirWRTStartDiskNo());
        } else {
            outputStream.seek(zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
            headerWriter = headerWriter2333332;
        }
        headerWriter.finalizeZipFileWithoutValidations(zipModel, outputStream);
        if (outputStream == null) return;
        try {
            outputStream.close();
            return;
        }
        catch (IOException headerWriter2333332) {
            return;
        }
        catch (FileNotFoundException e) {
            try {
                throw new ZipException(e);
                catch (IOException e2) {
                    throw new ZipException(e2);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (outputStream != null) {
                    try {
                        outputStream.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public HashMap removeZipFile(ZipModel zipModel, FileHeader fileHeader, ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        if (runInThread) {
            void thread;
            Thread thread2 = new Thread(this, "Zip4j", zipModel, fileHeader, progressMonitor){
                final /* synthetic */ ArchiveMaintainer this$0;
                final /* synthetic */ FileHeader val$fileHeader;
                final /* synthetic */ ZipModel val$zipModel;
                final /* synthetic */ ProgressMonitor val$progressMonitor;

                @Override
                public void run() {
                    try {
                        1 v0 = this;
                        1 v1 = this;
                        v0.this$0.initRemoveZipFile(v0.val$zipModel, v1.val$fileHeader, v1.val$progressMonitor);
                        v0.val$progressMonitor.endProgressMonitorSuccess();
                        return;
                    }
                    catch (ZipException zipException) {
                        return;
                    }
                }
                {
                    void this$0;
                    1 v0 = this;
                    this.this$0 = this$0;
                    v0.val$zipModel = zipModel;
                    v0.val$fileHeader = fileHeader;
                    this.val$progressMonitor = progressMonitor;
                    super(string);
                }
            };
            thread.start();
            return null;
        }
        HashMap retMap = this.initRemoveZipFile(zipModel, fileHeader, progressMonitor);
        progressMonitor.endProgressMonitorSuccess();
        return retMap;
    }

    private /* synthetic */ void updateSplitEndCentralDirectory(ZipModel zipModel) throws ZipException {
        try {
            if (zipModel == null) {
                throw new ZipException("zip model is null - cannot update end of central directory for split zip model");
            }
            if (zipModel.getCentralDirectory() == null) {
                throw new ZipException("corrupt zip model - getCentralDirectory, cannot update split zip model");
            }
            ZipModel zipModel2 = zipModel;
            zipModel2.getEndCentralDirRecord().setNoOfThisDisk(0);
            zipModel2.getEndCentralDirRecord().setNoOfThisDiskStartOfCentralDir(0);
            zipModel2.getEndCentralDirRecord().setTotNoOfEntriesInCentralDir(zipModel.getCentralDirectory().getFileHeaders().size());
            zipModel2.getEndCentralDirRecord().setTotNoOfEntriesInCentralDirOnThisDisk(zipModel.getCentralDirectory().getFileHeaders().size());
            return;
        }
        catch (ZipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public void mergeSplitZipFiles(ZipModel zipModel, File outputZipFile, ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        if (runInThread) {
            new Thread(this, "Zip4j", zipModel, outputZipFile, progressMonitor){
                final /* synthetic */ File val$outputZipFile;
                final /* synthetic */ ZipModel val$zipModel;
                final /* synthetic */ ArchiveMaintainer this$0;
                final /* synthetic */ ProgressMonitor val$progressMonitor;
                {
                    void this$0;
                    2 v0 = this;
                    this.this$0 = this$0;
                    v0.val$zipModel = zipModel;
                    v0.val$outputZipFile = file;
                    this.val$progressMonitor = progressMonitor;
                    super(string);
                }

                @Override
                public void run() {
                    try {
                        2 v0 = this;
                        2 v1 = this;
                        v0.this$0.initMergeSplitZipFile(v0.val$zipModel, v1.val$outputZipFile, v1.val$progressMonitor);
                        return;
                    }
                    catch (ZipException zipException) {
                        return;
                    }
                }
            }.start();
            return;
        }
        this.initMergeSplitZipFile(zipModel, outputZipFile, progressMonitor);
    }

    private /* synthetic */ void updateSplitZip64EndCentralDirLocator(ZipModel zipModel, ArrayList fileSizeList) throws ZipException {
        int i;
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot update split Zip64 end of central directory locator");
        }
        if (zipModel.getZip64EndCentralDirLocator() == null) {
            return;
        }
        zipModel.getZip64EndCentralDirLocator().setNoOfDiskStartOfZip64EndOfCentralDirRec(0);
        long offsetZip64EndCentralDirRec = 0L;
        int n = i = 0;
        while (n < fileSizeList.size()) {
            Long l = (Long)fileSizeList.get(i);
            offsetZip64EndCentralDirRec += l.longValue();
            n = ++i;
        }
        ZipModel zipModel2 = zipModel;
        zipModel2.getZip64EndCentralDirLocator().setOffsetZip64EndOfCentralDirRec(zipModel.getZip64EndCentralDirLocator().getOffsetZip64EndOfCentralDirRec() + offsetZip64EndCentralDirRec);
        zipModel2.getZip64EndCentralDirLocator().setTotNumberOfDiscs(1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void initMergeSplitZipFile(ZipModel zipModel, File outputZipFile, ProgressMonitor progressMonitor) throws ZipException {
        block35: {
            block34: {
                block33: {
                    block30: {
                        block31: {
                            if (zipModel == null) {
                                v0 = e = new ZipException("one of the input parameters is null, cannot merge split zip file");
                                progressMonitor.endProgressMonitorError(v0);
                                throw v0;
                            }
                            if (!zipModel.isSplitArchive()) {
                                v1 = e = new ZipException("archive not a split zip file");
                                progressMonitor.endProgressMonitorError(v1);
                                throw v1;
                            }
                            outputStream = null;
                            inputStream = null;
                            fileSizeList = new ArrayList<Long>();
                            totBytesWritten = 0L;
                            splitSigRemoved = false;
                            try {
                                totNoOfSplitFiles = zipModel.getEndCentralDirRecord().getNoOfThisDisk();
                                if (totNoOfSplitFiles <= 0) {
                                    throw new ZipException("corrupt zip model, archive not a split zip file");
                                }
                                outputStream = this.prepareOutputStreamForMerge(outputZipFile);
                                v2 = i = 0;
lbl24:
                                // 2 sources

                                while (v2 <= totNoOfSplitFiles) {
                                    inputStream = this.createSplitZipFileHandler(zipModel, i);
                                    start = 0;
                                    end = new Long(inputStream.length());
                                    if (i == 0 && zipModel.getCentralDirectory() != null && zipModel.getCentralDirectory().getFileHeaders() != null && zipModel.getCentralDirectory().getFileHeaders().size() > 0) {
                                        var14_21 = new byte[4];
                                        v3 = buff;
                                        inputStream.seek(0L);
                                        inputStream.read((byte[])v3);
                                        if ((long)Raw.readIntLittleEndian((byte[])v3, 0) == 134695760L) {
                                            start = 4;
                                            splitSigRemoved = true;
                                        }
                                    }
                                    if (i == totNoOfSplitFiles) {
                                        end = new Long(zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
                                    }
                                    this.copyFile(inputStream, outputStream, start, end, progressMonitor);
                                    totBytesWritten += end - (long)start;
                                    if (progressMonitor.isCancelAllTasks()) {
                                        v4 = progressMonitor;
                                        v4.setResult(3);
                                        v4.setState(0);
                                        if (outputStream == null) break block30;
                                        break block31;
                                    }
                                    ** GOTO lbl-1000
                                }
                                ** GOTO lbl117
                            }
                            catch (IOException e) {
                                try {
                                    progressMonitor.endProgressMonitorError(e);
                                    throw new ZipException(e);
                                    catch (Exception e) {
                                        progressMonitor.endProgressMonitorError(e);
                                        throw new ZipException(e);
                                    }
                                }
                                catch (Throwable var15_25) {
                                    block32: {
                                        if (outputStream != null) {
                                            try {
                                                outputStream.close();
                                                v5 = inputStream;
                                                break block32;
                                            }
                                            catch (IOException var16_26) {
                                                // empty catch block
                                            }
                                        }
                                        v5 = inputStream;
                                    }
                                    if (v5 != null) {
                                        try {
                                            inputStream.close();
                                            v6 = var15_25;
                                            throw v6;
                                        }
                                        catch (IOException var16_27) {
                                            // empty catch block
                                        }
                                    }
                                    v6 = var15_25;
                                    throw v6;
                                }
                            }
                        }
                        try {
                            outputStream.close();
                            v7 = inputStream;
                            break block33;
                        }
                        catch (IOException var14_22) {
                            // empty catch block
                        }
                    }
                    v7 = inputStream;
                }
                if (v7 == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException var14_23) {
                    // empty catch block
                }
                return;
lbl-1000:
                // 1 sources

                {
                    fileSizeList.add(end);
                    try {
                        inputStream.close();
                    }
                    catch (IOException var14_24) {
                        // empty catch block
                    }
                    v2 = ++i;
                    ** GOTO lbl24
lbl117:
                    // 1 sources

                    i = (ZipModel)zipModel.clone();
                    v8 = newZipModel;
                    v8.getEndCentralDirRecord().setOffsetOfStartOfCentralDir(totBytesWritten);
                    this.updateSplitZipModel((ZipModel)v8, fileSizeList, splitSigRemoved);
                    start = new HeaderWriter();
                    headerWriter.finalizeZipFileWithoutValidations((ZipModel)newZipModel, outputStream);
                    progressMonitor.endProgressMonitorSuccess();
                    if (outputStream == null) break block34;
                }
                try {
                    outputStream.close();
                    v9 = inputStream;
                    break block35;
                }
                catch (IOException totNoOfSplitFiles) {
                    // empty catch block
                }
            }
            v9 = inputStream;
        }
        if (v9 == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException totNoOfSplitFiles) {
            return;
        }
    }
}

