/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.util.Zip4jUtil;

public class CRCUtil {
    private static final int BUF_SIZE = 16384;

    public static long computeFileCRC(String inputFile) throws ZipException {
        return CRCUtil.computeFileCRC(inputFile, null);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long computeFileCRC(String inputFile, ProgressMonitor progressMonitor) throws ZipException {
        void crc32;
        InputStream inputStream;
        block15: {
            if (!Zip4jUtil.isStringNotNullAndNotEmpty(inputFile)) {
                throw new ZipException("input file is null or empty, cannot calculate CRC for the file");
            }
            inputStream = null;
            Zip4jUtil.checkFileReadAccess(inputFile);
            inputStream = new FileInputStream(new File(inputFile));
            byte[] buff = new byte[16384];
            int readLen = -2;
            CRC32 cRC32 = new CRC32();
            while (true) {
                readLen = inputStream.read(buff);
                if (readLen == -1) break block15;
                crc32.update(buff, 0, readLen);
                if (progressMonitor == null) continue;
                ProgressMonitor progressMonitor2 = progressMonitor;
                progressMonitor2.updateWorkCompleted(readLen);
                if (progressMonitor2.isCancelAllTasks()) break;
            }
            ProgressMonitor progressMonitor3 = progressMonitor;
            progressMonitor3.setResult(3);
            progressMonitor3.setState(0);
            long l = 0L;
            if (inputStream == null) return l;
            try {
                inputStream.close();
                return l;
            }
            catch (IOException e) {
                throw new ZipException("error while closing the file after calculating crc");
            }
        }
        long l = crc32.getValue();
        if (inputStream == null) return l;
        try {
            inputStream.close();
            return l;
        }
        catch (IOException e) {
            throw new ZipException("error while closing the file after calculating crc");
        }
        catch (IOException e) {
            try {
                throw new ZipException(e);
                catch (Exception e2) {
                    throw new ZipException(e2);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (inputStream == null) {
                    throwable2 = throwable;
                    throw throwable2;
                }
                try {
                    inputStream.close();
                    throwable2 = throwable;
                    throw throwable2;
                }
                catch (IOException e3) {
                    throw new ZipException("error while closing the file after calculating crc");
                }
            }
        }
    }
}

