/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.DataInput;
import java.io.IOException;
import net.lingala.zip4j.exception.ZipException;

public class Raw {
    public static byte bitArrayToByte(int[] bitArray) throws ZipException {
        int i;
        if (bitArray == null) {
            throw new ZipException("bit array is null, cannot calculate byte from bits");
        }
        if (bitArray.length != 8) {
            throw new ZipException("invalid bit array length, cannot calculate byte");
        }
        if (!Raw.checkBits(bitArray)) {
            throw new ZipException("invalid bits provided, bits contain other values than 0 or 1");
        }
        int retNum = 0;
        int n = i = 0;
        while (n < bitArray.length) {
            double d = Math.pow(2.0, i) * (double)bitArray[i];
            retNum = (int)((double)retNum + d);
            n = ++i;
        }
        return (byte)retNum;
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeShortLittleEndian(byte[] byArray, int n, short s) {
        void value;
        array[pos + true] = (byte)(value >>> 8);
        array[n] = (byte)(value & 0xFF);
    }

    public static int readIntLittleEndian(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8 | (b[off + 2] & 0xFF | (b[off + 3] & 0xFF) << 8) << 16;
    }

    public static long readLongLittleEndian(byte[] array, int pos) {
        long temp = 0L;
        temp = 0L | (long)(array[pos + 7] & 0xFF);
        temp <<= 8;
        temp |= (long)(array[pos + 6] & 0xFF);
        temp <<= 8;
        temp |= (long)(array[pos + 5] & 0xFF);
        temp <<= 8;
        temp |= (long)(array[pos + 4] & 0xFF);
        temp <<= 8;
        temp |= (long)(array[pos + 3] & 0xFF);
        temp <<= 8;
        temp |= (long)(array[pos + 2] & 0xFF);
        temp <<= 8;
        temp |= (long)(array[pos + 1] & 0xFF);
        temp <<= 8;
        return temp |= (long)(array[pos] & 0xFF);
    }

    public static byte[] toByteArray(int in, int outSize) {
        int i;
        byte[] out = new byte[outSize];
        byte[] intArray = Raw.toByteArray(in);
        int n = i = 0;
        while (n < intArray.length && i < outSize) {
            int n2 = i++;
            out[n2] = intArray[n2];
            n = i;
        }
        return out;
    }

    public static final short readShortBigEndian(byte[] array, int pos) {
        int temp = 0;
        short s = (short)(0 | array[pos] & 0xFF);
        temp = s;
        short s2 = (short)(s << 8);
        temp = s2;
        short s3 = (short)(s2 | array[pos + 1] & 0xFF);
        temp = s3;
        return s3;
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeIntLittleEndian(byte[] byArray, int n, int n2) {
        void value;
        void pos;
        void v0 = pos;
        array[pos + 3] = (byte)(value >>> 24);
        array[v0 + 2] = (byte)(value >>> 16);
        array[v0 + true] = (byte)(value >>> 8);
        array[n] = (byte)(value & 0xFF);
    }

    public static byte[] toByteArray(int in) {
        byte[] out;
        byte[] byArray = out = new byte[4];
        out[0] = (byte)in;
        out[1] = (byte)(in >> 8);
        byArray[2] = (byte)(in >> 16);
        out[3] = (byte)(in >> 24);
        return byArray;
    }

    public static int readLeInt(DataInput di, byte[] b) throws ZipException {
        try {
            di.readFully(b, 0, 4);
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
        return b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF | (b[3] & 0xFF) << 8) << 16;
    }

    public static int readShortLittleEndian(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8;
    }

    /*
     * WARNING - void declaration
     */
    public static void writeLongLittleEndian(byte[] byArray, int n, long l) {
        void value;
        void pos;
        void v0 = pos;
        void v1 = pos;
        array[pos + 7] = (byte)(value >>> 56);
        array[pos + 6] = (byte)(value >>> 48);
        array[v1 + 5] = (byte)(value >>> 40);
        array[v1 + 4] = (byte)(value >>> 32);
        array[pos + 3] = (byte)(value >>> 24);
        array[v0 + 2] = (byte)(value >>> 16);
        array[v0 + true] = (byte)(value >>> 8);
        array[n] = (byte)(value & 0xFFL);
    }

    private static /* synthetic */ boolean checkBits(int[] bitArray) {
        int i;
        int n = i = 0;
        while (n < bitArray.length) {
            if (bitArray[i] != 0) {
                if (bitArray[i] != 1) {
                    return false;
                }
            }
            n = ++i;
        }
        return true;
    }
}

