/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.util.InternalZipConstants;

public class Zip4jUtil {
    public static void setFileReadOnly(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null. cannot set read only file attribute");
        }
        if (file.exists()) {
            file.setReadOnly();
        }
    }

    public static long getFileLengh(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null, cannot calculate file length");
        }
        if (file.isDirectory()) {
            return -1L;
        }
        return file.length();
    }

    public static boolean checkFileWriteAccess(String path) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(path)) {
            throw new ZipException("path is null");
        }
        if (!Zip4jUtil.checkFileExists(path)) {
            throw new ZipException("zip file does not exist");
        }
        try {
            File file = new File(path);
            return file.canWrite();
        }
        catch (Exception e) {
            throw new ZipException("cannot read zip file");
        }
    }

    private static /* synthetic */ long getDayLightSavingsTime(TimeZone timeZone, long time) throws ZipException {
        try {
            if (timeZone == null) {
                timeZone = TimeZone.getDefault();
            }
            if (timeZone != null && timeZone.getDSTSavings() > 0) {
                long l = time;
                time = l - (long)(timeZone.getOffset(l) - timeZone.getDSTSavings());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return time;
    }

    public static int getIndexOfFileHeader(ZipModel zipModel, FileHeader fileHeader) throws ZipException {
        int i;
        if (zipModel == null || fileHeader == null) {
            throw new ZipException("input parameters is null, cannot determine index of file header");
        }
        if (zipModel.getCentralDirectory() == null) {
            throw new ZipException("central directory is null, ccannot determine index of file header");
        }
        if (zipModel.getCentralDirectory().getFileHeaders() == null) {
            throw new ZipException("file Headers are null, cannot determine index of file header");
        }
        if (zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
            return -1;
        }
        String fileName = fileHeader.getFileName();
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileName)) {
            throw new ZipException("file name in file header is empty or null, cannot determine index of file header");
        }
        ArrayList fileHeaders = zipModel.getCentralDirectory().getFileHeaders();
        int n = i = 0;
        while (n < fileHeaders.size()) {
            String fileNameForHdr = ((FileHeader)fileHeaders.get(i)).getFileName();
            if (Zip4jUtil.isStringNotNullAndNotEmpty(fileNameForHdr) && fileName.equalsIgnoreCase(fileNameForHdr)) {
                return i;
            }
            n = ++i;
        }
        return -1;
    }

    public static long getLastModifiedFileTime(File file, TimeZone timeZone) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null, cannot read last modified file time");
        }
        if (!file.exists()) {
            throw new ZipException("input file does not exist, cannot read last modified file time");
        }
        return Zip4jUtil.getDayLightSavingsTime(timeZone, file.lastModified());
    }

    public static byte[] convertCharset(String str) throws ZipException {
        byte[] converted;
        block6: {
            String charSet;
            block5: {
                converted = null;
                charSet = Zip4jUtil.detectCharSet(str);
                if (!charSet.equals("Cp850")) break block5;
                converted = str.getBytes("Cp850");
                return converted;
            }
            if (!charSet.equals("UTF8")) break block6;
            converted = str.getBytes("UTF8");
            return converted;
        }
        try {
            converted = str.getBytes();
            return converted;
        }
        catch (UnsupportedEncodingException err) {
            return str.getBytes();
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public static void setFileHidden(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null. cannot set hidden file attribute");
        }
        if (!Zip4jUtil.isWindows()) {
            return;
        }
        if (file.exists()) {
            try {
                Runtime.getRuntime().exec(new StringBuilder().insert(0, "attrib +H \"").append(file.getAbsolutePath()).append("\"").toString());
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static FileHeader getFileHeaderWithExactMatch(ZipModel zipModel, String fileName) throws ZipException {
        int i;
        if (zipModel == null) {
            throw new ZipException(new StringBuilder().insert(0, "zip model is null, cannot determine file header with exact match for fileName: ").append(fileName).toString());
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileName)) {
            throw new ZipException(new StringBuilder().insert(0, "file name is null, cannot determine file header with exact match for fileName: ").append(fileName).toString());
        }
        if (zipModel.getCentralDirectory() == null) {
            throw new ZipException(new StringBuilder().insert(0, "central directory is null, cannot determine file header with exact match for fileName: ").append(fileName).toString());
        }
        if (zipModel.getCentralDirectory().getFileHeaders() == null) {
            throw new ZipException(new StringBuilder().insert(0, "file Headers are null, cannot determine file header with exact match for fileName: ").append(fileName).toString());
        }
        if (zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
            return null;
        }
        ArrayList fileHeaders = zipModel.getCentralDirectory().getFileHeaders();
        int n = i = 0;
        while (n < fileHeaders.size()) {
            FileHeader fileHeader = (FileHeader)fileHeaders.get(i);
            String fileNameForHdr = fileHeader.getFileName();
            if (Zip4jUtil.isStringNotNullAndNotEmpty(fileNameForHdr) && fileName.equalsIgnoreCase(fileNameForHdr)) {
                return fileHeader;
            }
            n = ++i;
        }
        return null;
    }

    public static boolean isStringNotNullAndNotEmpty(String str) {
        if (str == null || str.trim().length() <= 0) {
            return false;
        }
        return true;
    }

    public static String getZipFileNameWithoutExt(String zipFile) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(zipFile)) {
            throw new ZipException("zip file name is empty or null, cannot determine zip file name");
        }
        String tmpFileName = zipFile;
        if (tmpFileName.indexOf(System.getProperty("file.separator")) >= 0) {
            String string = zipFile;
            tmpFileName = string.substring(string.lastIndexOf(System.getProperty("file.separator")));
        }
        if (tmpFileName.indexOf(".") > 0) {
            String string = tmpFileName;
            tmpFileName = string.substring(0, string.indexOf("."));
        }
        return tmpFileName;
    }

    public static String detectCharSet(String str) throws ZipException {
        block7: {
            String tempString;
            byte[] byteString;
            block6: {
                if (str == null) {
                    throw new ZipException("input string is null, cannot detect charset");
                }
                String string = str;
                byteString = string.getBytes("Cp850");
                tempString = new String(byteString, "Cp850");
                if (!string.equals(tempString)) break block6;
                return "Cp850";
            }
            String string = str;
            byteString = string.getBytes("UTF8");
            tempString = new String(byteString, "UTF8");
            if (!string.equals(tempString)) break block7;
            return "UTF8";
        }
        try {
            return InternalZipConstants.CHARSET_DEFAULT;
        }
        catch (UnsupportedEncodingException e) {
            return InternalZipConstants.CHARSET_DEFAULT;
        }
        catch (Exception e) {
            return InternalZipConstants.CHARSET_DEFAULT;
        }
    }

    public static boolean checkArrayListTypes(ArrayList sourceList, int type) throws ZipException {
        if (sourceList == null) {
            throw new ZipException("input arraylist is null, cannot check types");
        }
        if (sourceList.size() <= 0) {
            return true;
        }
        boolean invalidFound = false;
        block0 : switch (type) {
            case 1: {
                int i;
                while (false) {
                }
                int n = i = 0;
                while (n < sourceList.size()) {
                    if (!(sourceList.get(i) instanceof File)) {
                        invalidFound = true;
                        break block0;
                    }
                    n = ++i;
                }
                break;
            }
            case 2: {
                int i;
                int n = i = 0;
                while (n < sourceList.size()) {
                    if (!(sourceList.get(i) instanceof String)) {
                        invalidFound = true;
                        break block0;
                    }
                    n = ++i;
                }
                break;
            }
        }
        if (!invalidFound) {
            return true;
        }
        return false;
    }

    public static FileHeader getFileHeader(ZipModel zipModel, String fileName) throws ZipException {
        if (zipModel == null) {
            throw new ZipException(new StringBuilder().insert(0, "zip model is null, cannot determine file header for fileName: ").append(fileName).toString());
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileName)) {
            throw new ZipException(new StringBuilder().insert(0, "file name is null, cannot determine file header for fileName: ").append(fileName).toString());
        }
        FileHeader fileHeader = null;
        fileHeader = Zip4jUtil.getFileHeaderWithExactMatch(zipModel, fileName);
        if (fileHeader == null && (fileHeader = Zip4jUtil.getFileHeaderWithExactMatch(zipModel, fileName = fileName.replaceAll("\\\\", "/"))) == null) {
            fileName = fileName.replaceAll("/", "\\\\");
            fileHeader = Zip4jUtil.getFileHeaderWithExactMatch(zipModel, fileName);
        }
        return fileHeader;
    }

    public static String getFileNameFromFilePath(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null, cannot get file name");
        }
        if (file.isDirectory()) {
            return null;
        }
        return file.getName();
    }

    public static long getLocalTimeFromDSTTime(TimeZone timeZone, long time) throws ZipException {
        try {
            if (timeZone == null) {
                timeZone = TimeZone.getDefault();
            }
            if (timeZone != null && timeZone.getDSTSavings() > 0) {
                long l = time;
                time = l + (long)(timeZone.getOffset(l) - timeZone.getDSTSavings());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return time;
    }

    public static void setFileSystemMode(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null. cannot set archive file attribute");
        }
        if (!Zip4jUtil.isWindows()) {
            return;
        }
        if (file.exists()) {
            try {
                Runtime.getRuntime().exec(new StringBuilder().insert(0, "attrib +S \"").append(file.getAbsolutePath()).append("\"").toString());
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void setFileArchive(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null. cannot set archive file attribute");
        }
        if (!Zip4jUtil.isWindows()) {
            return;
        }
        if (file.exists()) {
            block6: {
                if (!file.isDirectory()) break block6;
                Runtime.getRuntime().exec(new StringBuilder().insert(0, "attrib +A \"").append(file.getAbsolutePath()).append("\"").toString());
                return;
            }
            try {
                Runtime.getRuntime().exec(new StringBuilder().insert(0, "attrib +A \"").append(file.getAbsolutePath()).append("\"").toString());
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isWindows() {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            return true;
        }
        return false;
    }

    public static String getCp850EncodedString(byte[] data) {
        try {
            String retString = new String(data, "Cp850");
            return retString;
        }
        catch (UnsupportedEncodingException e) {
            return new String(data);
        }
    }

    public static boolean checkFileExists(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("cannot check if file exists: input file is null");
        }
        return file.exists();
    }

    public static long javaToDosTime(long time) {
        Calendar cal;
        Calendar calendar = cal = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int year = calendar.get(1);
        if (year < 1980) {
            return 0x210000L;
        }
        return year - 1980 << 25 | cal.get(2) + 1 << 21 | cal.get(5) << 16 | cal.get(11) << 11 | cal.get(12) << 5 | cal.get(13) >> 1;
    }

    public static int getEncodedStringLength(String str) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(str)) {
            throw new ZipException("input string is null, cannot calculate encoded String length");
        }
        String string = str;
        return Zip4jUtil.getEncodedStringLength(string, Zip4jUtil.detectCharSet(string));
    }

    public static boolean checkFileExists(String path) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(path)) {
            throw new ZipException("path is null");
        }
        return Zip4jUtil.checkFileExists(new File(path));
    }

    public static ArrayList getFilesInDirectoryRec(File path, boolean readHiddenFiles) throws ZipException {
        int i;
        if (path == null) {
            throw new ZipException("input path is null, cannot read files in the directory");
        }
        ArrayList<File> result = new ArrayList<File>();
        File file = path;
        List<File> filesDirs = Arrays.asList(file.listFiles());
        if (!file.canRead()) {
            return result;
        }
        int n = i = 0;
        while (n < filesDirs.size()) {
            File file2 = filesDirs.get(i);
            if (file2.isHidden() && !readHiddenFiles) {
                return result;
            }
            result.add(file2);
            if (file2.isDirectory()) {
                ArrayList deeperList = Zip4jUtil.getFilesInDirectoryRec(file2, readHiddenFiles);
                result.addAll(deeperList);
            }
            n = ++i;
        }
        return result;
    }

    public static boolean checkFileReadAccess(String path) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(path)) {
            throw new ZipException("path is null");
        }
        if (!Zip4jUtil.checkFileExists(path)) {
            throw new ZipException("zip file does not exist");
        }
        try {
            File file = new File(path);
            return file.canRead();
        }
        catch (Exception e) {
            throw new ZipException("cannot read zip file");
        }
    }

    public static long dosToJavaTme(int dosTime) {
        int sec = 2 * (dosTime & 0x1F);
        int min = dosTime >> 5 & 0x3F;
        int hrs = dosTime >> 11 & 0x1F;
        int day = dosTime >> 16 & 0x1F;
        int mon = (dosTime >> 21 & 0xF) - 1;
        int year = (dosTime >> 25 & 0x7F) + 1980;
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, mon, day, hrs, min, sec);
        return calendar.getTime().getTime();
    }

    public static String getAbsoluteFilePath(String filePath) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(filePath)) {
            throw new ZipException("filePath is null or empty, cannot get absolute file path");
        }
        return new File(filePath).getAbsolutePath();
    }

    public static ArrayList getSplitZipFiles(ZipModel zipModel) throws ZipException {
        int i;
        if (zipModel == null) {
            throw new ZipException("cannot get split zip files: zipmodel is null");
        }
        if (zipModel.getEndCentralDirRecord() == null) {
            return null;
        }
        ArrayList<String> retList = new ArrayList<String>();
        String currZipFile = zipModel.getZipFile();
        String partFile = null;
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(currZipFile)) {
            throw new ZipException("cannot get split zip files: zipfile is null");
        }
        if (!zipModel.isSplitArchive()) {
            ArrayList<String> arrayList = retList;
            arrayList.add(currZipFile);
            return arrayList;
        }
        int numberOfThisDisk = zipModel.getEndCentralDirRecord().getNoOfThisDisk();
        if (numberOfThisDisk == 0) {
            ArrayList<String> arrayList = retList;
            arrayList.add(currZipFile);
            return arrayList;
        }
        int n = i = 0;
        while (n <= numberOfThisDisk) {
            if (i == numberOfThisDisk) {
                retList.add(zipModel.getZipFile());
            } else {
                ArrayList<String> arrayList;
                if (i >= 9) {
                    String string = currZipFile;
                    partFile = new StringBuilder().insert(0, string.substring(0, string.lastIndexOf("."))).append(".z").append(i + 1).toString();
                    arrayList = retList;
                } else {
                    String string = currZipFile;
                    partFile = new StringBuilder().insert(0, string.substring(0, string.lastIndexOf("."))).append(".z0").append(i + 1).toString();
                    arrayList = retList;
                }
                arrayList.add(partFile);
            }
            n = ++i;
        }
        return retList;
    }

    public static int getEncodedStringLength(String str, String charset) throws ZipException {
        ByteBuffer byteBuffer;
        block9: {
            ByteBuffer byteBuffer2;
            block8: {
                block7: {
                    if (!Zip4jUtil.isStringNotNullAndNotEmpty(str)) {
                        throw new ZipException("input string is null, cannot calculate encoded String length");
                    }
                    if (!Zip4jUtil.isStringNotNullAndNotEmpty(charset)) {
                        throw new ZipException("encoding is not defined, cannot calculate string length");
                    }
                    byteBuffer2 = null;
                    if (!charset.equals("Cp850")) break block7;
                    byteBuffer2 = ByteBuffer.wrap(str.getBytes("Cp850"));
                }
                if (!charset.equals("UTF8")) break block8;
                byteBuffer2 = ByteBuffer.wrap(str.getBytes("UTF8"));
            }
            try {
                byteBuffer2 = ByteBuffer.wrap(str.getBytes(charset));
            }
            catch (UnsupportedEncodingException e) {
                byteBuffer = byteBuffer2 = ByteBuffer.wrap(str.getBytes());
                break block9;
            }
            catch (Exception e) {
                throw new ZipException(e);
            }
            byteBuffer = byteBuffer2;
        }
        return byteBuffer.limit();
    }

    public static long getFileLengh(String file) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(file)) {
            throw new ZipException("invalid file name");
        }
        return Zip4jUtil.getFileLengh(new File(file));
    }

    public static String decodeFileName(byte[] data, boolean isUTF8) {
        if (isUTF8) {
            try {
                return new String(data, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                return new String(data);
            }
        }
        return Zip4jUtil.getCp850EncodedString(data);
    }

    public static boolean checkOutputFolder(String path) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(path)) {
            throw new ZipException(new NullPointerException("output path is null"));
        }
        File file = new File(path);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new ZipException("output folder is not valid");
            }
            if (!file.canWrite()) {
                throw new ZipException("no write access to output folder");
            }
        } else {
            try {
                File file2 = file;
                file2.mkdirs();
                if (!file2.isDirectory()) {
                    throw new ZipException("output folder is not valid");
                }
                if (!file.canWrite()) {
                    throw new ZipException("no write access to destination folder");
                }
            }
            catch (Exception e) {
                throw new ZipException("Cannot create destination folder");
            }
        }
        return true;
    }

    public static String getRelativeFileName(String file, String rootFolderInZip, String rootFolderPath) throws ZipException {
        String string;
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(file)) {
            throw new ZipException("input file path/name is empty, cannot calculate relative file name");
        }
        String fileName = null;
        if (Zip4jUtil.isStringNotNullAndNotEmpty(rootFolderPath)) {
            String string2;
            File tmpFile;
            String tmpFileName = file.substring(rootFolderPath.length());
            if (tmpFileName.startsWith(System.getProperty("file.separator"))) {
                tmpFileName = tmpFileName.substring(1);
            }
            if ((tmpFile = new File(file)).isDirectory()) {
                tmpFileName = tmpFileName.replaceAll("\\\\", "/");
                string2 = tmpFileName = new StringBuilder().insert(0, tmpFileName).append("/").toString();
            } else {
                String bkFileName = tmpFileName.substring(0, tmpFileName.indexOf(tmpFile.getName()));
                bkFileName = bkFileName.replaceAll("\\\\", "/");
                string2 = tmpFileName = new StringBuilder().insert(0, bkFileName).append(tmpFile.getName()).toString();
            }
            fileName = string2;
            string = rootFolderInZip;
        } else {
            File relFile = new File(file);
            if (relFile.isDirectory()) {
                fileName = new StringBuilder().insert(0, relFile.getName()).append("/").toString();
                string = rootFolderInZip;
            } else {
                fileName = Zip4jUtil.getFileNameFromFilePath(new File(file));
                string = rootFolderInZip;
            }
        }
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            fileName = new StringBuilder().insert(0, rootFolderInZip).append(fileName).toString();
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileName)) {
            throw new ZipException("Error determining file name");
        }
        return fileName;
    }

    public static boolean isSupportedCharset(String charset) throws ZipException {
        boolean bl;
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(charset)) {
            throw new ZipException("charset is null or empty, cannot check if it is supported");
        }
        try {
            new String("a".getBytes(), charset);
            bl = true;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
        return bl;
    }
}

