/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.CipherOutputStream;
import net.lingala.zip4j.io.DeflaterOutputStream;
import net.lingala.zip4j.io.SplitOutputStream;
import net.lingala.zip4j.io.ZipOutputStream;
import net.lingala.zip4j.model.EndCentralDirRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.util.ArchiveMaintainer;
import net.lingala.zip4j.util.CRCUtil;
import net.lingala.zip4j.util.Zip4jUtil;

public class ZipEngine {
    private ZipModel zipModel;

    private /* synthetic */ void checkParameters(ZipParameters parameters) throws ZipException {
        if (parameters == null) {
            throw new ZipException("cannot validate zip parameters");
        }
        if (parameters.getCompressionMethod() != 0) {
            if (parameters.getCompressionMethod() != 8) {
                throw new ZipException("unsupported compression type");
            }
        }
        if (parameters.getCompressionMethod() == 8 && parameters.getCompressionLevel() < 0) {
            if (parameters.getCompressionLevel() > 9) {
                throw new ZipException("invalid compression level. compression level dor deflate should be in the range of 0-9");
            }
        }
        if (parameters.isEncryptFiles()) {
            if (parameters.getEncryptionMethod() != 0) {
                if (parameters.getEncryptionMethod() != 99) {
                    throw new ZipException("unsupported encryption method");
                }
            }
            if (!Zip4jUtil.isStringNotNullAndNotEmpty(parameters.getPassword())) {
                throw new ZipException("input password is empty or null");
            }
        } else {
            parameters.setAesKeyStrength(-1);
            parameters.setEncryptionMethod(-1);
        }
    }

    public void addFolderToZip(File file, ZipParameters parameters, ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        ZipParameters zipParameters;
        if (file == null || parameters == null) {
            throw new ZipException("one of the input parameters is null, cannot add folder to zip");
        }
        if (!Zip4jUtil.checkFileExists(file.getAbsolutePath())) {
            throw new ZipException("input folder does not exist");
        }
        if (!file.isDirectory()) {
            throw new ZipException("input file is not a folder, user addFileToZip method to add files");
        }
        if (!Zip4jUtil.checkFileReadAccess(file.getAbsolutePath())) {
            throw new ZipException(new StringBuilder().insert(0, "cannot read folder: ").append(file.getAbsolutePath()).toString());
        }
        String rootFolderPath = null;
        if (parameters.isIncludeRootFolder()) {
            rootFolderPath = file.getParentFile() != null ? file.getParentFile().getAbsolutePath() : "";
            zipParameters = parameters;
        } else {
            rootFolderPath = file.getAbsolutePath();
            zipParameters = parameters;
        }
        zipParameters.setDefaultFolderPath(rootFolderPath);
        this.addFiles(Zip4jUtil.getFilesInDirectoryRec(file, parameters.isReadHiddenFiles()), parameters, progressMonitor, runInThread);
    }

    public void addFiles(ArrayList fileList, ZipParameters parameters, ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        if (fileList == null || parameters == null) {
            throw new ZipException("one of the input parameters is null when adding files");
        }
        if (fileList.size() <= 0) {
            throw new ZipException("no files to add");
        }
        ProgressMonitor progressMonitor2 = progressMonitor;
        progressMonitor.setTotalWork(this.calculateTotalWork(fileList, parameters));
        progressMonitor2.setCurrentOperation(0);
        progressMonitor2.setState(1);
        progressMonitor.setResult(1);
        if (runInThread) {
            new Thread(this, "Zip4j", fileList, parameters, progressMonitor){
                final /* synthetic */ ArrayList val$fileList;
                final /* synthetic */ ProgressMonitor val$progressMonitor;
                final /* synthetic */ ZipEngine this$0;
                final /* synthetic */ ZipParameters val$parameters;

                @Override
                public void run() {
                    try {
                        1 v0 = this;
                        1 v1 = this;
                        v0.this$0.initAddFiles(v0.val$fileList, v1.val$parameters, v1.val$progressMonitor);
                        return;
                    }
                    catch (ZipException zipException) {
                        return;
                    }
                }
                {
                    void this$0;
                    1 v0 = this;
                    this.this$0 = this$0;
                    v0.val$fileList = arrayList;
                    v0.val$parameters = zipParameters;
                    this.val$progressMonitor = progressMonitor;
                    super(string);
                }
            }.start();
            return;
        }
        this.initAddFiles(fileList, parameters, progressMonitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void removeFilesIfExists(ArrayList fileList, ZipParameters parameters, ProgressMonitor progressMonitor) throws ZipException {
        block22: {
            block21: {
                if (this.zipModel == null) return;
                if (this.zipModel.getCentralDirectory() == null) return;
                if (this.zipModel.getCentralDirectory().getFileHeaders() == null) return;
                if (this.zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
                    return;
                }
                outputStream = null;
                try {
                    i = 0;
lbl11:
                    // 2 sources

                    while (i < fileList.size()) {
                        fileName = Zip4jUtil.getRelativeFileName(((File)fileList.get(i)).getAbsolutePath(), parameters.getRootFolderInZip(), parameters.getDefaultFolderPath());
                        fileHeader = Zip4jUtil.getFileHeader(this.zipModel, fileName);
                        if (fileHeader == null) ** GOTO lbl70
                        if (outputStream != null) {
                            outputStream.close();
                            outputStream = null;
                        }
                        v0 = new ArchiveMaintainer();
                        v1 = progressMonitor;
                        v1.setCurrentOperation(2);
                        retMap = v0.initRemoveZipFile(this.zipModel, fileHeader, progressMonitor);
                        if (v1.isCancelAllTasks()) {
                            v2 = progressMonitor;
                            v2.setResult(3);
                            v2.setState(0);
                            if (outputStream == null) return;
                            break block21;
                        }
                        ** GOTO lbl-1000
                    }
                    break block22;
                }
                catch (IOException e) {
                    try {
                        throw new ZipException(e);
                    }
                    catch (Throwable var14_15) {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                                v3 = var14_15;
                                throw v3;
                            }
                            catch (IOException var15_16) {
                                // empty catch block
                            }
                        }
                        v3 = var14_15;
                        throw v3;
                    }
                }
            }
            try {
                outputStream.close();
                return;
            }
            catch (IOException var11_12) {
                // empty catch block
            }
            return;
lbl-1000:
            // 1 sources

            {
                progressMonitor.setCurrentOperation(0);
                if (outputStream != null) ** GOTO lbl70
                outputStream = this.prepareFileOutputStream();
                if (retMap == null || retMap.get("offsetCentralDir") == null) ** GOTO lbl70
                offsetCentralDir = -1L;
                try {
                    v4 = offsetCentralDir = Long.parseLong((String)retMap.get("offsetCentralDir"));
                }
                catch (NumberFormatException e) {
                    throw new ZipException("NumberFormatException while parsing offset central directory. Cannot update already existing file header");
                }
                catch (Exception e) {
                    throw new ZipException("Error while parsing offset central directory. Cannot update already existing file header");
                }
            }
            {
                if (v4 >= 0L) {
                    outputStream.seek(offsetCentralDir);
                }
lbl70:
                // 6 sources

                ++i;
                ** GOTO lbl11
            }
        }
        if (outputStream == null) return;
        try {
            outputStream.close();
            return;
        }
        catch (IOException i) {
            return;
        }
    }

    private /* synthetic */ long calculateTotalWork(ArrayList fileList, ZipParameters parameters) throws ZipException {
        int i;
        if (fileList == null) {
            throw new ZipException("file list is null, cannot calculate total work");
        }
        long totalWork = 0L;
        int n = i = 0;
        while (n < fileList.size()) {
            if (fileList.get(i) instanceof File && ((File)fileList.get(i)).exists()) {
                String relativeFileName;
                FileHeader fileHeader;
                ZipEngine zipEngine;
                if (parameters.isEncryptFiles() && parameters.getEncryptionMethod() == 0) {
                    totalWork += Zip4jUtil.getFileLengh((File)fileList.get(i)) * 2L;
                    zipEngine = this;
                } else {
                    totalWork += Zip4jUtil.getFileLengh((File)fileList.get(i));
                    zipEngine = this;
                }
                if (zipEngine.zipModel.getCentralDirectory() != null && this.zipModel.getCentralDirectory().getFileHeaders() != null && this.zipModel.getCentralDirectory().getFileHeaders().size() > 0 && (fileHeader = Zip4jUtil.getFileHeader(this.zipModel, relativeFileName = Zip4jUtil.getRelativeFileName(((File)fileList.get(i)).getAbsolutePath(), parameters.getRootFolderInZip(), parameters.getDefaultFolderPath()))) != null) {
                    totalWork += Zip4jUtil.getFileLengh(new File(this.zipModel.getZipFile())) - fileHeader.getCompressedSize();
                }
            }
            n = ++i;
        }
        return totalWork;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addStreamToZip(InputStream inputStream, ZipParameters parameters) throws ZipException {
        if (inputStream == null) throw new ZipException("one of the input parameters is null, cannot add stream to zip");
        if (parameters == null) {
            throw new ZipException("one of the input parameters is null, cannot add stream to zip");
        }
        CipherOutputStream outputStream = null;
        try {
            ZipEngine zipEngine = this;
            zipEngine.checkParameters(parameters);
            boolean isZipFileAlreadExists2333332 = Zip4jUtil.checkFileExists(zipEngine.zipModel.getZipFile());
            SplitOutputStream splitOutputStream = new SplitOutputStream(new File(this.zipModel.getZipFile()), this.zipModel.getSplitLength());
            outputStream = new ZipOutputStream(splitOutputStream, this.zipModel);
            if (isZipFileAlreadExists2333332) {
                if (this.zipModel.getEndCentralDirRecord() == null) {
                    throw new ZipException("invalid end of central directory record");
                }
                splitOutputStream.seek(this.zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
            }
            byte[] readBuff = new byte[4096];
            int readLen = -1;
            ZipParameters zipParameters = parameters;
            ((DeflaterOutputStream)outputStream).putNextEntry(null, zipParameters);
            if (!zipParameters.getFileNameInZip().endsWith("/") && !parameters.getFileNameInZip().endsWith("\\")) {
                InputStream inputStream2 = inputStream;
                while (true) {
                    readLen = inputStream2.read(readBuff);
                    if (readLen != -1) {
                        inputStream2 = inputStream;
                        ((ZipOutputStream)outputStream).write(readBuff, 0, readLen);
                        continue;
                    }
                    break;
                }
            }
        }
        catch (ZipException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new ZipException(e2);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (outputStream != null) {
                    try {
                        outputStream.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        {
            CipherOutputStream cipherOutputStream = outputStream;
            ((DeflaterOutputStream)cipherOutputStream).closeEntry();
            ((DeflaterOutputStream)cipherOutputStream).finish();
            if (outputStream == null) return;
        }
        try {
            outputStream.close();
            return;
        }
        catch (IOException isZipFileAlreadExists2333332) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ZipEngine(ZipModel zipModel) throws ZipException {
        void zipModel2;
        if (zipModel == null) {
            throw new ZipException("zip model is null in ZipEngine constructor");
        }
        this.zipModel = zipModel2;
    }

    private /* synthetic */ RandomAccessFile prepareFileOutputStream() throws ZipException {
        String outPath = this.zipModel.getZipFile();
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(outPath)) {
            throw new ZipException("invalid output path");
        }
        try {
            File outFile = new File(outPath);
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            return new RandomAccessFile(outFile, "rw");
        }
        catch (FileNotFoundException e) {
            throw new ZipException(e);
        }
    }

    private /* synthetic */ EndCentralDirRecord createEndOfCentralDirectoryRecord() {
        EndCentralDirRecord endCentralDirRecord;
        EndCentralDirRecord endCentralDirRecord2 = endCentralDirRecord = new EndCentralDirRecord();
        EndCentralDirRecord endCentralDirRecord3 = endCentralDirRecord;
        endCentralDirRecord.setSignature(101010256L);
        endCentralDirRecord3.setNoOfThisDisk(0);
        endCentralDirRecord3.setTotNoOfEntriesInCentralDir(0);
        endCentralDirRecord2.setTotNoOfEntriesInCentralDirOnThisDisk(0);
        endCentralDirRecord2.setOffsetOfStartOfCentralDir(0L);
        return endCentralDirRecord2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void initAddFiles(ArrayList fileList, ZipParameters parameters, ProgressMonitor progressMonitor) throws ZipException {
        CipherOutputStream cipherOutputStream;
        InputStream inputStream;
        CipherOutputStream outputStream;
        block29: {
            block28: {
                int i;
                if (fileList == null) throw new ZipException("one of the input parameters is null when adding files");
                if (parameters == null) {
                    throw new ZipException("one of the input parameters is null when adding files");
                }
                if (fileList.size() <= 0) {
                    throw new ZipException("no files to add");
                }
                if (this.zipModel.getEndCentralDirRecord() == null) {
                    this.zipModel.setEndCentralDirRecord(this.createEndOfCentralDirectoryRecord());
                }
                outputStream = null;
                inputStream = null;
                ZipEngine zipEngine = this;
                zipEngine.checkParameters(parameters);
                zipEngine.removeFilesIfExists(fileList, parameters, progressMonitor);
                boolean isZipFileAlreadExists2333332 = Zip4jUtil.checkFileExists(this.zipModel.getZipFile());
                SplitOutputStream splitOutputStream = new SplitOutputStream(new File(this.zipModel.getZipFile()), this.zipModel.getSplitLength());
                outputStream = new ZipOutputStream(splitOutputStream, this.zipModel);
                if (isZipFileAlreadExists2333332) {
                    if (this.zipModel.getEndCentralDirRecord() == null) {
                        throw new ZipException("invalid end of central directory record");
                    }
                    splitOutputStream.seek(this.zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
                }
                byte[] readBuff = new byte[4096];
                int readLen = -1;
                int n = i = 0;
                while (n < fileList.size()) {
                    if (parameters.isEncryptFiles() && parameters.getEncryptionMethod() == 0) {
                        progressMonitor.setCurrentOperation(3);
                        parameters.setSourceFileCRC((int)CRCUtil.computeFileCRC(((File)fileList.get(i)).getAbsolutePath(), progressMonitor));
                        progressMonitor.setCurrentOperation(0);
                    }
                    ((DeflaterOutputStream)outputStream).putNextEntry((File)fileList.get(i), parameters);
                    if (((File)fileList.get(i)).isDirectory()) {
                        ((DeflaterOutputStream)outputStream).closeEntry();
                    } else {
                        InputStream inputStream2 = new FileInputStream((File)fileList.get(i));
                        while (true) {
                            readLen = ((InputStream)inputStream2).read(readBuff);
                            if (readLen == -1) break;
                            inputStream2 = inputStream;
                            ((ZipOutputStream)outputStream).write(readBuff, 0, readLen);
                            progressMonitor.updateWorkCompleted(readLen);
                        }
                        ((DeflaterOutputStream)outputStream).closeEntry();
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    n = ++i;
                }
                ((DeflaterOutputStream)outputStream).finish();
                progressMonitor.endProgressMonitorSuccess();
                if (inputStream == null) break block28;
                try {
                    inputStream.close();
                    cipherOutputStream = outputStream;
                    break block29;
                }
                catch (IOException isZipFileAlreadExists2333332) {
                    // empty catch block
                }
            }
            cipherOutputStream = outputStream;
        }
        if (cipherOutputStream == null) return;
        try {
            outputStream.close();
            return;
        }
        catch (IOException isZipFileAlreadExists2333332) {
            return;
        }
        catch (ZipException e) {
            try {
                ZipException zipException = e;
                progressMonitor.endProgressMonitorError(zipException);
                throw zipException;
                catch (Exception e2) {
                    progressMonitor.endProgressMonitorError(e2);
                    throw new ZipException(e2);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                CipherOutputStream cipherOutputStream2;
                block30: {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                            cipherOutputStream2 = outputStream;
                            break block30;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    cipherOutputStream2 = outputStream;
                }
                if (cipherOutputStream2 != null) {
                    try {
                        outputStream.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
    }
}

