/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.model.tools.MathUtils;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParticleOrb
extends SpriteTexturedParticle {
    private double targetX;
    private double targetY;
    private double targetZ;
    private double startX;
    private double startY;
    private double startZ;
    private double signX;
    private double signZ;
    private float red;
    private float green;
    private float blue;
    private int mode;
    private double duration;

    public ParticleOrb(World world, double x, double y, double z, double targetX, double targetZ) {
        super(world, x, y, z);
        this.targetX = targetX;
        this.targetZ = targetZ;
        this.field_70544_f = (4.5f + this.field_187136_p.nextFloat() * 1.5f) * 0.1f;
        this.field_70547_e = 120;
        this.signX = Math.signum(targetX - this.field_187126_f);
        this.signZ = Math.signum(targetZ - this.field_187128_h);
        this.mode = 0;
        this.field_82339_as = 0.0f;
        this.blue = 1.0f;
        this.green = 1.0f;
        this.red = 1.0f;
    }

    public ParticleOrb(World world, double x, double y, double z, double targetX, double targetY, double targetZ, double speed) {
        this(world, x, y, z, targetX, targetZ);
        this.targetY = targetY;
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.duration = speed;
        this.mode = 1;
        this.field_82339_as = 0.1f;
    }

    public ParticleOrb(World world, double x, double y, double z, double vx, double vy, double vz, double r, double g, double b, double scale, int duration) {
        super(world, x, y, z);
        this.field_70544_f = (float)scale * 0.1f;
        this.field_70547_e = duration;
        this.duration = duration;
        this.field_187129_i = vx;
        this.field_187130_j = vy;
        this.field_187131_k = vz;
        this.func_70538_b((float)r, (float)g, (float)b);
        this.mode = 2;
    }

    public IParticleRenderType func_217558_b() {
        return MMRenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    }

    public int func_189214_a(float delta) {
        return 0xF0 | super.func_189214_a(delta) & 0xFF0000;
    }

    public void func_189213_a() {
        this.field_82339_as = 0.1f;
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.mode == 0) {
            double vecX = this.targetX - this.field_187126_f;
            double vecZ = this.targetZ - this.field_187128_h;
            double dist = Math.sqrt(vecX * vecX + vecZ * vecZ);
            if (dist > 2.0 || Math.signum(vecX) != this.signX || Math.signum(vecZ) != this.signZ || this.field_70546_d > this.field_70547_e) {
                this.func_187112_i();
                return;
            }
            double peak = 0.5;
            this.field_82339_as = (float)(dist > 0.5 ? MathUtils.linearTransformd(dist, 0.5, 2.0, 1.0, 0.0) : MathUtils.linearTransformd(dist, 0.1f, 0.5, 0.0, 1.0));
            double minVel = 0.05;
            double maxVel = 0.3;
            double progress = Math.sin(-0.7853981633974483 * dist) + 1.0;
            double magMultipler = (progress * 0.25 + 0.05) / dist;
            this.field_187129_i = vecX *= magMultipler;
            this.field_187130_j = progress;
            this.field_187131_k = vecZ *= magMultipler;
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        } else if (this.mode == 1) {
            this.field_82339_as = (float)this.field_70546_d / (float)this.duration;
            this.field_187126_f = this.startX + (this.targetX - this.startX) / (1.0 + Math.exp(-(8.0 / this.duration) * ((double)this.field_70546_d - this.duration / 2.0)));
            this.field_187127_g = this.startY + (this.targetY - this.startY) / (1.0 + Math.exp(-(8.0 / this.duration) * ((double)this.field_70546_d - this.duration / 2.0)));
            this.field_187128_h = this.startZ + (this.targetZ - this.startZ) / (1.0 + Math.exp(-(8.0 / this.duration) * ((double)this.field_70546_d - this.duration / 2.0)));
            if ((double)this.field_70546_d == this.duration) {
                this.func_187112_i();
            }
        } else if (this.mode == 2) {
            super.func_189213_a();
            if (this.field_70546_d >= this.field_70547_e) {
                this.func_187112_i();
            }
        }
        ++this.field_70546_d;
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        this.field_82339_as = this.mode == 2 ? Math.max(1.0f - ((float)this.field_70546_d + partialTicks) / (float)this.duration, 0.001f) : ((float)this.field_70546_d + partialTicks) / (float)this.duration;
        this.field_70552_h = this.red;
        this.field_70553_i = this.green;
        this.field_70551_j = this.blue;
        super.func_225606_a_(buffer, renderInfo, partialTicks);
    }

    public static class OrbData
    implements IParticleData {
        public static final IParticleData.IDeserializer<OrbData> DESERIALIZER = new IParticleData.IDeserializer<OrbData>(){

            public OrbData deserialize(ParticleType<OrbData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float r = (float)reader.readDouble();
                reader.expect(' ');
                float g = (float)reader.readDouble();
                reader.expect(' ');
                float b = (float)reader.readDouble();
                reader.expect(' ');
                float scale = (float)reader.readDouble();
                reader.expect(' ');
                int duration = reader.readInt();
                return new OrbData(r, g, b, scale, duration);
            }

            public OrbData read(ParticleType<OrbData> particleTypeIn, PacketBuffer buffer) {
                return new OrbData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt());
            }
        };
        private final float r;
        private final float g;
        private final float b;
        private float scale;
        private int duration;
        private float targetX;
        private float targetY;
        private float targetZ;
        private float speed;
        private int mode;

        public OrbData(float targetX, float targetZ) {
            this.targetX = targetX;
            this.targetZ = targetZ;
            this.b = 1.0f;
            this.g = 1.0f;
            this.r = 1.0f;
            this.mode = 0;
        }

        public OrbData(float targetX, float targetY, float targetZ, float speed) {
            this(targetX, targetZ);
            this.targetY = targetY;
            this.speed = speed;
            this.mode = 1;
        }

        public OrbData(float r, float g, float b, float scale, int duration) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.scale = scale;
            this.duration = duration;
            this.mode = 2;
        }

        public void func_197553_a(PacketBuffer buffer) {
            buffer.writeFloat(this.r);
            buffer.writeFloat(this.g);
            buffer.writeFloat(this.b);
            buffer.writeFloat(this.scale);
            buffer.writeInt(this.duration);
        }

        public String func_197555_a() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %d", Registry.field_212632_u.func_177774_c(this.func_197554_b()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.scale), this.duration);
        }

        public ParticleType<OrbData> func_197554_b() {
            return (ParticleType)ParticleHandler.ORB.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getB() {
            return this.b;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getScale() {
            return this.scale;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getDuration() {
            return this.duration;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getTargetX() {
            return this.targetX;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getTargetY() {
            return this.targetY;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getTargetZ() {
            return this.targetZ;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getSpeed() {
            return this.speed;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getMode() {
            return this.mode;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class OrbFactory
    implements IParticleFactory<OrbData> {
        private final IAnimatedSprite spriteSet;

        public OrbFactory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(OrbData typeIn, World worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleOrb particle = typeIn.getMode() == 0 ? new ParticleOrb(worldIn, x, y, z, typeIn.getTargetX(), typeIn.getTargetZ()) : (typeIn.getMode() == 1 ? new ParticleOrb(worldIn, x, y, z, typeIn.getTargetX(), typeIn.getTargetY(), typeIn.getTargetZ(), typeIn.getSpeed()) : new ParticleOrb(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getR(), typeIn.getG(), typeIn.getB(), typeIn.getScale(), typeIn.getDuration()));
            particle.func_217566_b(this.spriteSet);
            return particle;
        }
    }
}

