/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParticleSnowFlake
extends SpriteTexturedParticle {
    private int swirlTick;
    private float spread;
    boolean swirls;

    public ParticleSnowFlake(World world, double x, double y, double z, double vX, double vY, double vZ, double duration, boolean swirls) {
        super(world, x, y, z);
        this.func_187115_a(1.0f, 1.0f);
        this.field_187129_i = vX;
        this.field_187130_j = vY;
        this.field_187131_k = vZ;
        this.field_70547_e = (int)duration;
        this.swirlTick = this.field_187136_p.nextInt(120);
        this.spread = this.field_187136_p.nextFloat();
        this.swirls = swirls;
    }

    protected float func_217564_d() {
        return super.func_217564_d() - (super.func_217564_d() - super.func_217563_c()) / 8.0f;
    }

    protected float func_217560_f() {
        return super.func_217560_f() - (super.func_217560_f() - super.func_217562_e()) / 8.0f;
    }

    public IParticleRenderType func_217558_b() {
        return MMRenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.swirls) {
            Vector3f motionVec = new Vector3f((float)this.field_187129_i, (float)this.field_187130_j, (float)this.field_187131_k);
            motionVec.func_229194_d_();
            float yaw = (float)Math.atan2(motionVec.func_195899_a(), motionVec.func_195902_c());
            float pitch = (float)Math.atan2(motionVec.func_195900_b(), 1.0);
            float swirlRadius = 4.0f * ((float)this.field_70546_d / (float)this.field_70547_e) * this.spread;
            Quaternion quatSpin = motionVec.func_229193_c_((float)this.swirlTick * 0.2f);
            Quaternion quatOrient = new Quaternion(pitch, yaw, 0.0f, false);
            Vector3f vec = new Vector3f(swirlRadius, 0.0f, 0.0f);
            vec.func_214905_a(quatOrient);
            vec.func_214905_a(quatSpin);
            this.field_187126_f += (double)vec.func_195899_a();
            this.field_187127_g += (double)vec.func_195900_b();
            this.field_187128_h += (double)vec.func_195902_c();
        }
        if (this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
        }
        ++this.field_70546_d;
        ++this.swirlTick;
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        float var = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        this.field_82339_as = (float)(1.0 - Math.exp(10.0f * (var - 1.0f)) - Math.pow(2000.0, -var));
        if ((double)this.field_82339_as < 0.1) {
            this.field_82339_as = 0.1f;
        }
        super.func_225606_a_(buffer, renderInfo, partialTicks);
    }

    public static class SnowflakeData
    implements IParticleData {
        public static final IParticleData.IDeserializer<SnowflakeData> DESERIALIZER = new IParticleData.IDeserializer<SnowflakeData>(){

            public SnowflakeData deserialize(ParticleType<SnowflakeData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float duration = (float)reader.readDouble();
                reader.expect(' ');
                boolean swirls = reader.readBoolean();
                return new SnowflakeData(duration, swirls);
            }

            public SnowflakeData read(ParticleType<SnowflakeData> particleTypeIn, PacketBuffer buffer) {
                return new SnowflakeData(buffer.readFloat(), buffer.readBoolean());
            }
        };
        private final float duration;
        private final boolean swirls;

        public SnowflakeData(float duration, boolean spins) {
            this.duration = duration;
            this.swirls = spins;
        }

        public void func_197553_a(PacketBuffer buffer) {
            buffer.writeFloat(this.duration);
            buffer.writeBoolean(this.swirls);
        }

        public String func_197555_a() {
            return String.format(Locale.ROOT, "%s %.2f %b", Registry.field_212632_u.func_177774_c(this.func_197554_b()), Float.valueOf(this.duration), this.swirls);
        }

        public ParticleType<SnowflakeData> func_197554_b() {
            return (ParticleType)ParticleHandler.SNOWFLAKE.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getDuration() {
            return this.duration;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean getSwirls() {
            return this.swirls;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class SnowFlakeFactory
    implements IParticleFactory<SnowflakeData> {
        private final IAnimatedSprite spriteSet;

        public SnowFlakeFactory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(SnowflakeData typeIn, World worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleSnowFlake particle = new ParticleSnowFlake(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getDuration(), typeIn.getSwirls());
            particle.func_217568_a(this.spriteSet);
            return particle;
        }
    }
}

