/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParticleVanillaCloudExtended
extends SpriteTexturedParticle {
    private final IAnimatedSprite animatedSprite;
    private float oSize;
    private float airDrag;
    private float red;
    private float green;
    private float blue;
    private Vec3d[] destination;

    protected ParticleVanillaCloudExtended(World worldIn, IAnimatedSprite animatedSprite, double xCoordIn, double yCoordIn, double zCoordIn, double motionX, double motionY, double motionZ, double scale, double r, double g, double b, double drag, double duration, Vec3d[] destination) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        this.field_187129_i *= (double)0.1f;
        this.field_187130_j *= (double)0.1f;
        this.field_187131_k *= (double)0.1f;
        this.field_187129_i += motionX;
        this.field_187130_j += motionY;
        this.field_187131_k += motionZ;
        float f1 = 1.0f - this.field_187136_p.nextFloat() * 0.3f;
        this.red = (float)((double)f1 * r);
        this.green = (float)((double)f1 * g);
        this.blue = (float)((double)f1 * b);
        this.field_70544_f *= 0.75f;
        this.field_70544_f *= 2.5f;
        this.oSize = this.field_70544_f * (float)scale;
        this.field_70547_e = (int)duration;
        if (this.field_70547_e == 0) {
            this.field_70547_e = 1;
        }
        this.airDrag = (float)drag;
        this.destination = destination;
        this.field_190017_n = false;
        this.animatedSprite = animatedSprite;
        if (destination != null) {
            this.func_217567_a(animatedSprite.func_217591_a(this.field_70547_e - this.field_70546_d, this.field_70547_e));
        } else {
            this.func_217566_b(this.animatedSprite);
        }
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.func_217566_b(this.animatedSprite);
        if (this.destination != null && this.destination.length == 1) {
            this.func_217567_a(this.animatedSprite.func_217591_a(this.field_70547_e - this.field_70546_d, this.field_70547_e));
            Vec3d destinationVec = this.destination[0];
            Vec3d diff = destinationVec.func_178788_d(new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h));
            if (diff.func_72433_c() < 0.5) {
                this.func_187112_i();
            }
            float attractScale = 0.7f * ((float)this.field_70546_d / (float)this.field_70547_e) * ((float)this.field_70546_d / (float)this.field_70547_e);
            this.field_187129_i = diff.field_72450_a * (double)attractScale;
            this.field_187130_j = diff.field_72448_b * (double)attractScale;
            this.field_187131_k = diff.field_72449_c * (double)attractScale;
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= (double)this.airDrag;
        this.field_187130_j *= (double)this.airDrag;
        this.field_187131_k *= (double)this.airDrag;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
    }

    public static void spawnVanillaCloud(World world, double x, double y, double z, double motionX, double motionY, double motionZ, double scale, double r, double g, double b, double drag, double duration) {
        world.func_195594_a((IParticleData)new VanillaCloudData((float)scale, (float)r, (float)g, (float)b, (float)drag, (float)duration, null), x, y, z, motionX, motionY, motionZ);
    }

    public static void spawnVanillaCloudDestination(World world, double x, double y, double z, double motionX, double motionY, double motionZ, double scale, double r, double g, double b, double drag, double duration, Vec3d[] destination) {
        world.func_195594_a((IParticleData)new VanillaCloudData((float)scale, (float)r, (float)g, (float)b, (float)drag, (float)duration, destination), x, y, z, motionX, motionY, motionZ);
    }

    public static class VanillaCloudData
    implements IParticleData {
        public static final IParticleData.IDeserializer<VanillaCloudData> DESERIALIZER = new IParticleData.IDeserializer<VanillaCloudData>(){

            public VanillaCloudData deserialize(ParticleType<VanillaCloudData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float scale = (float)reader.readDouble();
                reader.expect(' ');
                float red = (float)reader.readDouble();
                reader.expect(' ');
                float green = (float)reader.readDouble();
                reader.expect(' ');
                float blue = (float)reader.readDouble();
                reader.expect(' ');
                float drag = (float)reader.readDouble();
                reader.expect(' ');
                float duration = (float)reader.readDouble();
                return new VanillaCloudData(scale, red, green, blue, drag, duration, null);
            }

            public VanillaCloudData read(ParticleType<VanillaCloudData> particleTypeIn, PacketBuffer buffer) {
                return new VanillaCloudData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), null);
            }
        };
        private final float red;
        private final float green;
        private final float blue;
        private final float scale;
        private final float drag;
        private final float duration;
        private final Vec3d[] destination;

        public VanillaCloudData(float scale, float redIn, float greenIn, float blueIn, float drag, float duration, Vec3d[] destination) {
            this.red = redIn;
            this.green = greenIn;
            this.blue = blueIn;
            this.scale = scale;
            this.drag = drag;
            this.duration = duration;
            this.destination = destination;
        }

        public void func_197553_a(PacketBuffer buffer) {
            buffer.writeFloat(this.scale);
            buffer.writeFloat(this.red);
            buffer.writeFloat(this.green);
            buffer.writeFloat(this.blue);
            buffer.writeFloat(this.drag);
            buffer.writeFloat(this.duration);
        }

        public String func_197555_a() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %.2f", Registry.field_212632_u.func_177774_c(this.func_197554_b()), Float.valueOf(this.scale), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.drag), Float.valueOf(this.duration));
        }

        public ParticleType<VanillaCloudData> func_197554_b() {
            return (ParticleType)ParticleHandler.VANILLA_CLOUD_EXTENDED.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getScale() {
            return this.scale;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getRed() {
            return this.red;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getGreen() {
            return this.green;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getBlue() {
            return this.blue;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getDrag() {
            return this.drag;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getDuration() {
            return this.duration;
        }

        @OnlyIn(value=Dist.CLIENT)
        public Vec3d[] getDestination() {
            return this.destination;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class CloudFactory
    implements IParticleFactory<VanillaCloudData> {
        private final IAnimatedSprite spriteSet;

        public CloudFactory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(VanillaCloudData typeIn, World worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleVanillaCloudExtended particle = new ParticleVanillaCloudExtended(worldIn, this.spriteSet, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getScale(), typeIn.getRed(), typeIn.getGreen(), typeIn.getBlue(), typeIn.getDrag(), typeIn.getDuration(), typeIn.getDestination());
            particle.func_70538_b(typeIn.getRed(), typeIn.getGreen(), typeIn.getBlue());
            return particle;
        }
    }
}

