/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle.util;

import com.bobmowzie.mowziesmobs.client.particle.ParticleRibbon;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AdvancedParticleBase
extends SpriteTexturedParticle {
    public float airDrag;
    public float red;
    public float green;
    public float blue;
    public float alpha;
    public float prevRed;
    public float prevGreen;
    public float prevBlue;
    public float prevAlpha;
    public float scale;
    public float prevScale;
    public float field_70544_f;
    public ParticleRotation rotation;
    public boolean emissive;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;
    public ParticleComponent[] components;
    public ParticleRibbon ribbon;

    protected AdvancedParticleBase(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double motionX, double motionY, double motionZ, ParticleRotation rotation, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, ParticleComponent[] components) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        this.field_187129_i = motionX;
        this.field_187130_j = motionY;
        this.field_187131_k = motionZ;
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
        this.alpha = (float)a;
        this.scale = (float)scale;
        this.field_70547_e = (int)duration;
        this.airDrag = (float)drag;
        this.rotation = rotation;
        this.components = components;
        this.emissive = emissive;
        this.ribbon = null;
        for (ParticleComponent component : components) {
            component.init(this);
        }
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.prevRed = this.red;
        this.prevGreen = this.green;
        this.prevBlue = this.blue;
        this.prevAlpha = this.alpha;
        this.rotation.setPrevValues();
        this.prevScale = this.scale;
    }

    public IParticleRenderType func_217558_b() {
        return MMRenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    }

    public int func_189214_a(float partialTick) {
        int i = super.func_189214_a(partialTick);
        if (this.emissive) {
            int k = i >> 16 & 0xFF;
            return 0xF0 | k << 16;
        }
        return i;
    }

    public void func_189213_a() {
        this.prevRed = this.red;
        this.prevGreen = this.green;
        this.prevBlue = this.blue;
        this.prevAlpha = this.alpha;
        this.prevScale = this.scale;
        this.rotation.setPrevValues();
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.prevMotionX = this.field_187129_i;
        this.prevMotionY = this.field_187130_j;
        this.prevMotionZ = this.field_187131_k;
        for (ParticleComponent component : this.components) {
            component.preUpdate(this);
        }
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
        this.field_187129_i *= (double)this.airDrag;
        this.field_187130_j *= (double)this.airDrag;
        this.field_187131_k *= (double)this.airDrag;
        for (ParticleComponent component : this.components) {
            component.postUpdate(this);
        }
        if (this.ribbon != null) {
            this.ribbon.func_187109_b(this.field_187126_f, this.field_187127_g, this.field_187128_h);
            this.ribbon.positions[0] = new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h);
            this.ribbon.prevPositions[0] = this.getPrevPos();
        }
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        this.field_82339_as = this.prevAlpha + (this.alpha - this.prevAlpha) * partialTicks;
        if ((double)this.field_82339_as < 0.01) {
            this.field_82339_as = 0.01f;
        }
        this.field_70552_h = this.prevRed + (this.red - this.prevRed) * partialTicks;
        this.field_70553_i = this.prevGreen + (this.green - this.prevGreen) * partialTicks;
        this.field_70551_j = this.prevBlue + (this.blue - this.prevBlue) * partialTicks;
        this.field_70544_f = this.prevScale + (this.scale - this.prevScale) * partialTicks;
        for (ParticleComponent component : this.components) {
            component.preRender(this, partialTicks);
        }
        Vec3d vec3d = renderInfo.func_216785_c();
        float f = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - vec3d.func_82615_a());
        float f1 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - vec3d.func_82617_b());
        float f2 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - vec3d.func_82616_c());
        Quaternion quaternion = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        if (this.rotation instanceof ParticleRotation.FaceCamera) {
            ParticleRotation.FaceCamera faceCameraRot = (ParticleRotation.FaceCamera)this.rotation;
            if (faceCameraRot.faceCameraAngle == 0.0f && faceCameraRot.prevFaceCameraAngle == 0.0f) {
                quaternion = renderInfo.func_227995_f_();
            } else {
                quaternion = new Quaternion(renderInfo.func_227995_f_());
                float f3 = MathHelper.func_219799_g((float)partialTicks, (float)faceCameraRot.prevFaceCameraAngle, (float)faceCameraRot.faceCameraAngle);
                quaternion.func_195890_a(Vector3f.field_229183_f_.func_229193_c_(f3));
            }
        } else if (this.rotation instanceof ParticleRotation.EulerAngles) {
            ParticleRotation.EulerAngles eulerRot = (ParticleRotation.EulerAngles)this.rotation;
            float rotX = eulerRot.prevPitch + (eulerRot.pitch - eulerRot.prevPitch) * partialTicks;
            float rotY = eulerRot.prevYaw + (eulerRot.yaw - eulerRot.prevYaw) * partialTicks;
            float rotZ = eulerRot.prevRoll + (eulerRot.roll - eulerRot.prevRoll) * partialTicks;
            Quaternion quatX = new Quaternion(rotX, 0.0f, 0.0f, false);
            Quaternion quatY = new Quaternion(0.0f, rotY, 0.0f, false);
            Quaternion quatZ = new Quaternion(0.0f, 0.0f, rotZ, false);
            quaternion.func_195890_a(quatZ);
            quaternion.func_195890_a(quatY);
            quaternion.func_195890_a(quatX);
        }
        if (this.rotation instanceof ParticleRotation.OrientVector) {
            ParticleRotation.OrientVector orientRot = (ParticleRotation.OrientVector)this.rotation;
            double x = orientRot.prevOrientation.field_72450_a + (orientRot.orientation.field_72450_a - orientRot.prevOrientation.field_72450_a) * (double)partialTicks;
            double y = orientRot.prevOrientation.field_72448_b + (orientRot.orientation.field_72448_b - orientRot.prevOrientation.field_72448_b) * (double)partialTicks;
            double z = orientRot.prevOrientation.field_72449_c + (orientRot.orientation.field_72449_c - orientRot.prevOrientation.field_72449_c) * (double)partialTicks;
            float pitch = (float)Math.asin(-y);
            float yaw = (float)MathHelper.func_181159_b((double)x, (double)z);
            Quaternion quatX = new Quaternion(pitch, 0.0f, 0.0f, false);
            Quaternion quatY = new Quaternion(0.0f, yaw, 0.0f, false);
            quaternion.func_195890_a(quatY);
            quaternion.func_195890_a(quatX);
        }
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.field_70544_f * 0.1f;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(f4);
            vector3f.func_195904_b(f, f1, f2);
        }
        float f7 = this.func_217563_c();
        float f8 = this.func_217564_d();
        float f5 = this.func_217562_e();
        float f6 = this.func_217560_f();
        int j = this.func_189214_a(partialTicks);
        buffer.func_225582_a_((double)avector3f[0].func_195899_a(), (double)avector3f[0].func_195900_b(), (double)avector3f[0].func_195902_c()).func_225583_a_(f8, f6).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        buffer.func_225582_a_((double)avector3f[1].func_195899_a(), (double)avector3f[1].func_195900_b(), (double)avector3f[1].func_195902_c()).func_225583_a_(f8, f5).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        buffer.func_225582_a_((double)avector3f[2].func_195899_a(), (double)avector3f[2].func_195900_b(), (double)avector3f[2].func_195902_c()).func_225583_a_(f7, f5).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        buffer.func_225582_a_((double)avector3f[3].func_195899_a(), (double)avector3f[3].func_195900_b(), (double)avector3f[3].func_195902_c()).func_225583_a_(f7, f6).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        for (ParticleComponent component : this.components) {
            component.postRender(this, buffer, renderInfo, partialTicks, j);
        }
    }

    public float getAge() {
        return this.field_70546_d;
    }

    public double getPosX() {
        return this.field_187126_f;
    }

    public void setPosX(double posX) {
        this.func_187109_b(posX, this.field_187127_g, this.field_187128_h);
    }

    public double getPosY() {
        return this.field_187127_g;
    }

    public void setPosY(double posY) {
        this.func_187109_b(this.field_187126_f, posY, this.field_187128_h);
    }

    public double getPosZ() {
        return this.field_187128_h;
    }

    public void setPosZ(double posZ) {
        this.func_187109_b(this.field_187126_f, this.field_187127_g, posZ);
    }

    public double getMotionX() {
        return this.field_187129_i;
    }

    public void setMotionX(double motionX) {
        this.field_187129_i = motionX;
    }

    public double getMotionY() {
        return this.field_187130_j;
    }

    public void setMotionY(double motionY) {
        this.field_187130_j = motionY;
    }

    public double getMotionZ() {
        return this.field_187131_k;
    }

    public void setMotionZ(double motionZ) {
        this.field_187131_k = motionZ;
    }

    public Vec3d getPrevPos() {
        return new Vec3d(this.field_187123_c, this.field_187124_d, this.field_187125_e);
    }

    public double getPrevPosX() {
        return this.field_187123_c;
    }

    public double getPrevPosY() {
        return this.field_187124_d;
    }

    public double getPrevPosZ() {
        return this.field_187125_e;
    }

    public World getWorld() {
        return this.field_187122_b;
    }

    public static void spawnParticle(World world, ParticleType<AdvancedParticleData> particle, double x, double y, double z, double motionX, double motionY, double motionZ, boolean faceCamera, double yaw, double pitch, double roll, double faceCameraAngle, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive) {
        AdvancedParticleBase.spawnParticle(world, particle, x, y, z, motionX, motionY, motionZ, faceCamera, yaw, pitch, roll, faceCameraAngle, scale, r, g, b, a, drag, duration, emissive, new ParticleComponent[0]);
    }

    public static void spawnParticle(World world, ParticleType<AdvancedParticleData> particle, double x, double y, double z, double motionX, double motionY, double motionZ, boolean faceCamera, double yaw, double pitch, double roll, double faceCameraAngle, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, ParticleComponent[] components) {
        ParticleRotation rotation = faceCamera ? new ParticleRotation.FaceCamera((float)faceCameraAngle) : new ParticleRotation.EulerAngles((float)yaw, (float)pitch, (float)roll);
        world.func_195594_a((IParticleData)new AdvancedParticleData(particle, rotation, scale, r, g, b, a, drag, duration, emissive, components), x, y, z, motionX, motionY, motionZ);
    }

    public static void spawnParticle(World world, ParticleType<AdvancedParticleData> particle, double x, double y, double z, double motionX, double motionY, double motionZ, ParticleRotation rotation, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, ParticleComponent[] components) {
        world.func_195594_a((IParticleData)new AdvancedParticleData(particle, rotation, scale, r, g, b, a, drag, duration, emissive, components), x, y, z, motionX, motionY, motionZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<AdvancedParticleData> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(AdvancedParticleData typeIn, World worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            AdvancedParticleBase particle = new AdvancedParticleBase(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getRotation(), typeIn.getScale(), typeIn.getRed(), typeIn.getGreen(), typeIn.getBlue(), typeIn.getAlpha(), typeIn.getAirDrag(), typeIn.getDuration(), typeIn.isEmissive(), typeIn.getComponents());
            particle.func_70538_b((float)typeIn.getRed(), (float)typeIn.getGreen(), (float)typeIn.getBlue());
            particle.func_217568_a(this.spriteSet);
            return particle;
        }
    }
}

