/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySolarBeam;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderSolarBeam
extends EntityRenderer<EntitySolarBeam> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mowziesmobs", "textures/effects/solar_beam.png");
    private static final float TEXTURE_WIDTH = 256.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    private static final float START_RADIUS = 1.3f;
    private static final float BEAM_RADIUS = 1.0f;
    private boolean clearerView = false;
    public static final VertexFormat POSITION_TEX_LMAP = new VertexFormat(ImmutableList.of((Object)DefaultVertexFormats.field_181713_m, (Object)DefaultVertexFormats.field_181715_o, (Object)DefaultVertexFormats.field_181716_p));

    public RenderSolarBeam(EntityRendererManager mgr) {
        super(mgr);
    }

    public ResourceLocation getEntityTexture(EntitySolarBeam entity) {
        return TEXTURE;
    }

    public void render(EntitySolarBeam solarBeam, float entityYaw, float delta, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.clearerView = solarBeam.caster instanceof PlayerEntity && Minecraft.func_71410_x().field_71439_g == solarBeam.caster && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
        float length = (float)Math.sqrt(Math.pow(solarBeam.collidePosX - solarBeam.func_226277_ct_(), 2.0) + Math.pow(solarBeam.collidePosY - solarBeam.func_226278_cu_(), 2.0) + Math.pow(solarBeam.collidePosZ - solarBeam.func_226281_cx_(), 2.0));
        int frame = MathHelper.func_76141_d((float)(((float)(solarBeam.appear.getTimer() - 1) + delta) * 2.0f));
        if (frame < 0) {
            frame = 6;
        }
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(MMRenderType.getGlowingEffect(this.getEntityTexture(solarBeam)));
        this.renderStart(frame, matrixStackIn, ivertexbuilder, packedLightIn);
        this.renderBeam(length, 57.295776f * solarBeam.getYaw(), 57.295776f * solarBeam.getPitch(), frame, matrixStackIn, ivertexbuilder, packedLightIn);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(solarBeam.collidePosX - solarBeam.func_226277_ct_(), solarBeam.collidePosY - solarBeam.func_226278_cu_(), solarBeam.collidePosZ - solarBeam.func_226281_cx_());
        this.renderEnd(frame, solarBeam.blockSide, matrixStackIn, ivertexbuilder, packedLightIn);
        matrixStackIn.func_227865_b_();
    }

    private void renderFlatQuad(int frame, MatrixStack matrixStackIn, IVertexBuilder builder, int packedLightIn) {
        float minU = 0.0f + 0.0625f * (float)frame;
        float minV = 0.0f;
        float maxU = minU + 0.0625f;
        float maxV = minV + 0.5f;
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        this.drawVertex(matrix4f, matrix3f, builder, -1.3f, -1.3f, 0.0f, minU, minV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -1.3f, 1.3f, 0.0f, minU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.3f, 1.3f, 0.0f, maxU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.3f, -1.3f, 0.0f, maxU, minV, 1.0f, packedLightIn);
    }

    private void renderStart(int frame, MatrixStack matrixStackIn, IVertexBuilder builder, int packedLightIn) {
        if (this.clearerView) {
            return;
        }
        matrixStackIn.func_227860_a_();
        Quaternion quat = this.field_76990_c.func_229098_b_();
        matrixStackIn.func_227863_a_(quat);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.func_227865_b_();
    }

    private void renderEnd(int frame, Direction side, MatrixStack matrixStackIn, IVertexBuilder builder, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        Quaternion quat = this.field_76990_c.func_229098_b_();
        matrixStackIn.func_227863_a_(quat);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.func_227865_b_();
        if (side == null) {
            return;
        }
        matrixStackIn.func_227860_a_();
        Quaternion sideQuat = side.func_229384_a_();
        sideQuat.func_195890_a(new Quaternion(90.0f, 0.0f, 0.0f, true));
        matrixStackIn.func_227863_a_(sideQuat);
        matrixStackIn.func_227861_a_(0.0, 0.0, (double)-0.01f);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.func_227865_b_();
    }

    private void drawBeam(float length, int frame, MatrixStack matrixStackIn, IVertexBuilder builder, int packedLightIn) {
        float minU = 0.0f;
        float minV = 0.5f + 0.03125f * (float)frame;
        float maxU = minU + 0.078125f;
        float maxV = minV + 0.03125f;
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        this.drawVertex(matrix4f, matrix3f, builder, -1.0f, 0.0f, 0.0f, minU, minV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -1.0f, length, 0.0f, minU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.0f, length, 0.0f, maxU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.0f, 0.0f, 0.0f, maxU, minV, 1.0f, packedLightIn);
    }

    private void renderBeam(float length, float yaw, float pitch, int frame, MatrixStack matrixStackIn, IVertexBuilder builder, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(new Quaternion(90.0f, 0.0f, 0.0f, true));
        matrixStackIn.func_227863_a_(new Quaternion(0.0f, 0.0f, yaw - 90.0f, true));
        matrixStackIn.func_227863_a_(new Quaternion(-pitch, 0.0f, 0.0f, true));
        matrixStackIn.func_227860_a_();
        if (!this.clearerView) {
            matrixStackIn.func_227863_a_(new Quaternion(0.0f, Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216777_e() + 90.0f, 0.0f, true));
        }
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.func_227865_b_();
        if (!this.clearerView) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(new Quaternion(0.0f, -Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216777_e() - 90.0f, 0.0f, true));
            this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, IVertexBuilder vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        vertexBuilder.func_227888_a_(matrix, offsetX, offsetY, offsetZ).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f * alpha).func_225583_a_(textureX, textureY).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLightIn).func_227887_a_(normals, 0.0f, 1.0f, 0.0f).func_181675_d();
    }
}

