/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ai;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.Vec3d;

public class MMAIAvoidEntity<U extends CreatureEntity, T extends Entity>
extends Goal {
    private static final double NEAR_DISTANCE = 7.0;
    protected final U entity;
    private final Predicate<T> selector;
    private final double farSpeed;
    private final double nearSpeed;
    private final float evadeDistance;
    private final Class<T> avoidedEntityType;
    private final int horizontalEvasion;
    private final int verticalEvasion;
    private final int numChecks;
    private T entityEvading;
    private Path entityPathEntity;

    public MMAIAvoidEntity(U entity, Class<T> avoidedEntityType, float evadeDistance, double farSpeed, double nearSpeed) {
        this(entity, avoidedEntityType, Predicates.alwaysTrue(), evadeDistance, farSpeed, nearSpeed, 10, 12, 7);
    }

    public MMAIAvoidEntity(U entity, Class<T> avoidedEntityType, float evadeDistance, double farSpeed, double nearSpeed, int numChecks, int horizontalEvasion, int verticalEvasion) {
        this(entity, avoidedEntityType, Predicates.alwaysTrue(), evadeDistance, farSpeed, nearSpeed, numChecks, horizontalEvasion, verticalEvasion);
    }

    public MMAIAvoidEntity(U entity, Class<T> avoidedEntityType, Predicate<? super T> predicate, float evadeDistance, double farSpeed, double nearSpeed, int numChecks, int horizontalEvasion, int verticalEvasion) {
        this.entity = entity;
        this.selector = e -> e != null && EntityPredicates.field_188444_d.test(e) && e.func_70089_S() && entity.func_70635_at().func_75522_a(e) && !entity.func_184191_r(e) && predicate.test(e);
        this.avoidedEntityType = avoidedEntityType;
        this.evadeDistance = evadeDistance;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        this.numChecks = numChecks;
        this.horizontalEvasion = horizontalEvasion;
        this.verticalEvasion = verticalEvasion;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        List entities = ((CreatureEntity)this.entity).field_70170_p.func_175647_a(this.avoidedEntityType, this.entity.func_174813_aQ().func_72314_b((double)this.evadeDistance, 3.0, (double)this.evadeDistance), this.selector);
        if (entities.isEmpty()) {
            this.onSafe();
            return false;
        }
        this.entityEvading = (Entity)entities.get(0);
        for (int n = 0; n < this.numChecks; ++n) {
            Vec3d pos = RandomPositionGenerator.func_75461_b(this.entity, (int)this.horizontalEvasion, (int)this.verticalEvasion, (Vec3d)this.entityEvading.func_174791_d());
            if (pos == null || this.entityEvading.func_70092_e(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c) < this.entityEvading.func_70068_e(this.entity)) continue;
            this.entityPathEntity = this.entity.func_70661_as().func_225466_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0);
            if (this.entityPathEntity == null) continue;
            return true;
        }
        this.onPathNotFound();
        return false;
    }

    protected void onSafe() {
    }

    protected void onPathNotFound() {
    }

    public boolean func_75253_b() {
        return !this.entity.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75484_a(this.entityPathEntity, this.farSpeed);
    }

    public void func_75251_c() {
        this.entityEvading = null;
    }

    public void func_75246_d() {
        this.entity.func_70661_as().func_75489_a(this.entity.func_70068_e(this.entityEvading) < 49.0 ? this.nearSpeed : this.farSpeed);
    }
}

