/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ai.animation;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public final class EntityAIAvoidEntity<T extends Entity>
extends Goal {
    private CreatureEntity entity;
    private final Class<T> avoidClass;
    private final float distance;
    private final Predicate<T> predicate;
    private final double speed;
    private final PathNavigator navigator;
    private T avoiding;
    private Path path;

    public EntityAIAvoidEntity(CreatureEntity entity, Class<T> avoidClass, float distance, double speed) {
        this(entity, avoidClass, e -> true, distance, speed);
    }

    public EntityAIAvoidEntity(CreatureEntity entity, Class<T> avoidClass, Predicate<? super T> predicate, float distance, double speed) {
        this.entity = entity;
        this.avoidClass = avoidClass;
        this.distance = distance;
        Predicate<Entity> visible = e -> e.func_70089_S() && entity.func_70635_at().func_75522_a(e);
        Predicate<Entity> targetable = e -> !(e instanceof PlayerEntity) || !e.func_175149_v() && !((PlayerEntity)e).func_184812_l_();
        this.predicate = targetable.and(predicate).and(visible);
        this.speed = speed;
        this.navigator = entity.func_70661_as();
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        List entities = this.entity.field_70170_p.func_175647_a(this.avoidClass, this.entity.func_174813_aQ().func_72314_b((double)this.distance, 3.0, (double)this.distance), this.predicate);
        if (entities.isEmpty()) {
            return false;
        }
        this.avoiding = (Entity)entities.get(this.entity.func_70681_au().nextInt(entities.size()));
        Vec3d pos = RandomPositionGenerator.func_75461_b((CreatureEntity)this.entity, (int)((int)(this.distance + 1.0f)), (int)((int)(this.distance / 2.0f + 1.0f)), (Vec3d)new Vec3d(this.avoiding.func_226277_ct_(), this.avoiding.func_226278_cu_(), this.avoiding.func_226281_cx_()));
        if (pos == null) {
            return false;
        }
        if (this.avoiding.func_70092_e(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c) < this.avoiding.func_70068_e((Entity)this.entity)) {
            return false;
        }
        this.path = this.navigator.func_179680_a(new BlockPos(pos), 0);
        return this.path != null;
    }

    public boolean func_75253_b() {
        return !this.navigator.func_75500_f();
    }

    public void func_75249_e() {
        this.navigator.func_75484_a(this.path, this.speed);
    }

    public void func_75251_c() {
        this.avoiding = null;
    }

    public void func_75246_d() {
        this.entity.func_70661_as().func_75489_a(this.speed);
    }
}

