/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorMaterial;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="mowziesmobs", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ConfigHandler {
    private static final String LANG_PREFIX = "config.mowziesmobs.";
    public static final General GENERAL;
    public static final ToolsAndAbilities TOOLS_AND_ABILITIES;
    public static final Mobs MOBS;
    public static final Client CLIENT;
    private static final ForgeConfigSpec.Builder COMMON_BUILDER;
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER;
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec CLIENT_CONFIG;

    private ConfigHandler() {
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
    }

    @SubscribeEvent
    public static void onReload(ModConfig.Reloading configEvent) {
    }

    static {
        COMMON_BUILDER = new ForgeConfigSpec.Builder();
        CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        GENERAL = new General(COMMON_BUILDER);
        TOOLS_AND_ABILITIES = new ToolsAndAbilities(COMMON_BUILDER);
        MOBS = new Mobs(COMMON_BUILDER);
        CLIENT = new Client(CLIENT_BUILDER);
        COMMON_CONFIG = COMMON_BUILDER.build();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> glowEffect;

        private Client(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            this.glowEffect = builder.comment("Toggles the lantern glow effect, which may look bad with certain shaders").translation("config.mowziesmobs.glow_effect").define("glow_effect", true);
            builder.pop();
        }
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<List<String>> freeze_blacklist;

        private General(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.freeze_blacklist = builder.comment("Add a mob's full name here to prevent it from being frozen or taking damage from ice magic.").translation("config.mowziesmobs.freeze_blacklist").define("freeze_blacklist", Arrays.asList("mowziesmobs:frostmaw", "minecraft:enderdragon", "minecraft:blaze", "minecraft:magma_cube"));
            builder.pop();
        }
    }

    public static class ToolsAndAbilities {
        public final ForgeConfigSpec.ConfigValue<Float> sunsBlessingAttackMultiplier;
        public final ForgeConfigSpec.ConfigValue<Float> geomancyAttackMultiplier;
        public final WroughtHelm WROUGHT_HELM;
        public final AxeOfAThousandMetals AXE_OF_A_THOUSAND_METALS;
        public final SolVisage SOL_VISAGE;
        public final IceCrystal ICE_CRYSTAL;
        public final BarakoaMask BARAKOA_MASK;
        public final BarakoaSpear BARAKOA_SPEAR;
        public final NagaFangDagger NAGA_FANG_DAGGER;
        public final Blowgun BLOW_GUN;

        ToolsAndAbilities(ForgeConfigSpec.Builder builder) {
            builder.push("tools_and_abilities");
            this.sunsBlessingAttackMultiplier = builder.translation("config.mowziesmobs.suns_blessing_attack_multiplier").define("suns_blessing_attack_multiplier", (Object)Float.valueOf(1.0f));
            this.geomancyAttackMultiplier = builder.translation("config.mowziesmobs.geomancy_attack_multiplier").define("geomancy_attack_multiplier", (Object)Float.valueOf(1.0f));
            this.WROUGHT_HELM = new WroughtHelm(builder);
            this.AXE_OF_A_THOUSAND_METALS = new AxeOfAThousandMetals(builder);
            this.SOL_VISAGE = new SolVisage(builder);
            this.ICE_CRYSTAL = new IceCrystal(builder);
            this.BARAKOA_MASK = new BarakoaMask(builder);
            this.BARAKOA_SPEAR = new BarakoaSpear(builder);
            this.NAGA_FANG_DAGGER = new NagaFangDagger(builder);
            this.BLOW_GUN = new Blowgun(builder);
            builder.pop();
        }
    }

    public static class Mobs {
        public final Frostmaw FROSTMAW;
        public final Barako BARAKO;
        public final FerrousWroughtnaut FERROUS_WROUGHTNAUT;
        public final Grottol GROTTOL;
        public final Lantern LANTERN;
        public final Barakoa BARAKOA;
        public final Naga NAGA;
        public final Foliaath FOLIAATH;

        Mobs(ForgeConfigSpec.Builder builder) {
            builder.push("mobs");
            this.FROSTMAW = new Frostmaw(builder);
            this.BARAKO = new Barako(builder);
            this.FERROUS_WROUGHTNAUT = new FerrousWroughtnaut(builder);
            this.GROTTOL = new Grottol(builder);
            this.LANTERN = new Lantern(builder);
            this.BARAKOA = new Barakoa(builder);
            this.NAGA = new Naga(builder);
            this.FOLIAATH = new Foliaath(builder);
            builder.pop();
        }
    }

    public static class Blowgun {
        public final ForgeConfigSpec.ConfigValue<Double> attackDamage;
        public final ForgeConfigSpec.ConfigValue<Integer> poisonDuration;

        Blowgun(ForgeConfigSpec.Builder builder) {
            builder.push("blowgun");
            this.poisonDuration = builder.comment("Duration in ticks of the poison effect (20 ticks = 1 second).").translation("config.mowziesmobs.poison_duration").define("poison_duration", (Object)40);
            this.attackDamage = builder.comment("Multiply all damage done with the blowgun/darts by this amount.").translation("config.mowziesmobs.attack_damage").define("attack_damage", (Object)1.0);
            builder.pop();
        }
    }

    public static class NagaFangDagger {
        public final ToolConfig toolConfig;
        public final ForgeConfigSpec.ConfigValue<Integer> poisonDuration;
        public final ForgeConfigSpec.ConfigValue<Float> bonusDamage;

        NagaFangDagger(ForgeConfigSpec.Builder builder) {
            builder.push("naga_fang_dagger");
            this.toolConfig = new ToolConfig(builder, 3.0f, 2.0f);
            this.poisonDuration = builder.comment("Duration in ticks of the poison effect (20 ticks = 1 second).").translation("config.mowziesmobs.poison_duration").define("poison_duration", (Object)40);
            this.bonusDamage = builder.comment("Bonus damage when attacking from behind").translation("config.mowziesmobs.bonus_damage").define("bonus_damage", (Object)Float.valueOf(3.0f));
            builder.pop();
        }
    }

    public static class BarakoaSpear {
        public final ToolConfig toolConfig;

        BarakoaSpear(ForgeConfigSpec.Builder builder) {
            builder.push("barakoa_spear");
            this.toolConfig = new ToolConfig(builder, 5.0f, 1.6f);
            builder.pop();
        }
    }

    public static class IceCrystal {
        public final ForgeConfigSpec.ConfigValue<Float> attackMultiplier;
        public final ForgeConfigSpec.ConfigValue<Boolean> breakable;
        public final ForgeConfigSpec.ConfigValue<Integer> durability;

        IceCrystal(ForgeConfigSpec.Builder builder) {
            builder.push("ice_crystal");
            this.attackMultiplier = builder.comment("Multiply all damage done with the ice crystal by this amount.").translation("config.mowziesmobs.attack_multiplier").define("attack_multiplier", (Object)Float.valueOf(1.0f));
            this.breakable = builder.comment(new String[]{"Set to true for the ice crystal to have limited durability.", "Prevents regeneration in inventory."}).translation("config.mowziesmobs.breakable").define("breakable", false);
            this.durability = builder.comment("Ice crystal durability").translation("config.mowziesmobs.durability").define("durability", (Object)600);
            builder.pop();
        }
    }

    public static class BarakoaMask {
        public final ArmorConfig armorConfig;

        BarakoaMask(ForgeConfigSpec.Builder builder) {
            builder.push("barakoa_mask");
            this.armorConfig = new ArmorConfig(builder, ArmorMaterial.LEATHER.func_200902_b(EquipmentSlotType.HEAD), ArmorMaterial.LEATHER.func_200901_e());
            builder.pop();
        }
    }

    public static class SolVisage {
        public final ArmorConfig armorConfig;
        public final ForgeConfigSpec.ConfigValue<Boolean> breakable;

        SolVisage(ForgeConfigSpec.Builder builder) {
            builder.push("sol_visage");
            this.armorConfig = new ArmorConfig(builder, ArmorMaterial.GOLD.func_200902_b(EquipmentSlotType.HEAD), ArmorMaterial.GOLD.func_200901_e());
            this.breakable = builder.comment("Set to true for the Sol Visage to have limited durability.").translation("config.mowziesmobs.breakable").define("breakable", false);
            builder.pop();
        }
    }

    public static class AxeOfAThousandMetals {
        public final ToolConfig toolConfig;
        public final ForgeConfigSpec.ConfigValue<Boolean> breakable;

        AxeOfAThousandMetals(ForgeConfigSpec.Builder builder) {
            builder.push("axe_of_a_thousand_metals");
            this.toolConfig = new ToolConfig(builder, 9.0f, 0.9f);
            this.breakable = builder.comment("Set to true for the Axe of a Thousand Metals to have limited durability.").translation("config.mowziesmobs.breakable").define("breakable", false);
            builder.pop();
        }
    }

    public static class WroughtHelm {
        public final ArmorConfig armorConfig;
        public final ForgeConfigSpec.ConfigValue<Boolean> breakable;

        WroughtHelm(ForgeConfigSpec.Builder builder) {
            builder.push("wrought_helm");
            this.armorConfig = new ArmorConfig(builder, ArmorMaterial.IRON.func_200902_b(EquipmentSlotType.HEAD), ArmorMaterial.IRON.func_200901_e());
            this.breakable = builder.comment("Set to true for the Wrought Helm to have limited durability.").translation("config.mowziesmobs.breakable").define("breakable", false);
            builder.pop();
        }
    }

    public static class Frostmaw {
        public final GenerationConfig generationConfig;
        public final CombatConfig combatConfig;
        public final ForgeConfigSpec.ConfigValue<Boolean> stealableIceCrystal;
        public final ForgeConfigSpec.ConfigValue<Boolean> hasBossBar;
        public final ForgeConfigSpec.ConfigValue<Boolean> healsOutOfBattle;

        Frostmaw(ForgeConfigSpec.Builder builder) {
            builder.push("frostmaw");
            this.generationConfig = new GenerationConfig(builder, 25, 8, new BiomeConfig(builder, Arrays.asList("SNOWY,!OCEAN,!RIVER,!BEACH"), new ArrayList<String>(), new ArrayList<String>()), 50.0f, 100.0f);
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            this.hasBossBar = builder.comment("Disable/enable Barako's boss health bar").translation("config.mowziesmobs.has_boss_bar").define("has_boss_bar", true);
            this.healsOutOfBattle = builder.comment("Disable/enable frostmaws healing while asleep").translation("config.mowziesmobs.heals_out_of_battle").define("heals_out_of_battle", true);
            this.stealableIceCrystal = builder.comment("Allow players to steal frostmaws' ice crystals (only using specific means!)").translation("config.mowziesmobs.stealable_ice_crystal").define("stealable_ice_crystal", true);
            builder.pop();
        }
    }

    public static class Barako {
        public final GenerationConfig generationConfig;
        public final CombatConfig combatConfig;
        public final ForgeConfigSpec.ConfigValue<Boolean> hasBossBar;
        public final ForgeConfigSpec.ConfigValue<Boolean> healsOutOfBattle;

        Barako(ForgeConfigSpec.Builder builder) {
            builder.push("barako");
            builder.comment("Generation controls for Barakoa villages");
            this.generationConfig = new GenerationConfig(builder, 25, 8, new BiomeConfig(builder, Arrays.asList("SAVANNA"), new ArrayList<String>(), new ArrayList<String>()), 50.0f, 100.0f);
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            this.hasBossBar = builder.comment("Disable/enable Barako's boss health bar").translation("config.mowziesmobs.has_boss_bar").define("has_boss_bar", true);
            this.healsOutOfBattle = builder.comment("Disable/enable Barako healing while not in combat").translation("config.mowziesmobs.heals_out_of_battle").define("heals_out_of_battle", true);
            builder.pop();
        }
    }

    public static class FerrousWroughtnaut {
        public final GenerationConfig generationConfig;
        public final CombatConfig combatConfig;
        public final ForgeConfigSpec.ConfigValue<Boolean> hasBossBar;
        public final ForgeConfigSpec.ConfigValue<Boolean> healsOutOfBattle;

        FerrousWroughtnaut(ForgeConfigSpec.Builder builder) {
            builder.push("ferrous_wroughtnaut");
            this.generationConfig = new GenerationConfig(builder, 15, 5, new BiomeConfig(builder, Arrays.asList(""), new ArrayList<String>(), new ArrayList<String>()), 30.0f, 55.0f);
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            this.hasBossBar = builder.comment("Disable/enable Ferrous Wroughtnauts' boss health bars").translation("config.mowziesmobs.has_boss_bar").define("has_boss_bar", true);
            this.healsOutOfBattle = builder.comment("Disable/enable Ferrous Wroughtnaut healing while not active").translation("config.mowziesmobs.heals_out_of_battle").define("heals_out_of_battle", true);
            builder.pop();
        }
    }

    public static class Grottol {
        public final SpawnConfig spawnConfig;
        public final ForgeConfigSpec.ConfigValue<Float> healthMultiplier;

        Grottol(ForgeConfigSpec.Builder builder) {
            builder.push("grottol");
            this.spawnConfig = new SpawnConfig(builder, 2, 1, 1, new BiomeConfig(builder, Arrays.asList(""), new ArrayList<String>(), new ArrayList<String>()), new ArrayList<String>(), 55, -1, false, false, true);
            this.healthMultiplier = builder.comment("Scale mob health by this value").translation("config.mowziesmobs.health_multiplier").define("health_multiplier", (Object)Float.valueOf(1.0f));
            builder.pop();
        }
    }

    public static class Lantern {
        public final SpawnConfig spawnConfig;
        public final ForgeConfigSpec.ConfigValue<Float> healthMultiplier;

        Lantern(ForgeConfigSpec.Builder builder) {
            builder.push("lantern");
            this.spawnConfig = new SpawnConfig(builder, 5, 2, 4, new BiomeConfig(builder, Arrays.asList("FOREST,MAGICAL,!SNOWY"), Arrays.asList("minecraft:dark_forest", "minecraft:dark_forest_hills"), new ArrayList<String>()), Arrays.asList("grass_block", "dark_oak_leaves", "dark_oak_log", "oak_leaves", "oak_log", "birch_leaves", "birch_log"), -1, 60, true, false, false);
            this.healthMultiplier = builder.comment("Scale mob health by this value").translation("config.mowziesmobs.health_multiplier").define("health_multiplier", (Object)Float.valueOf(1.0f));
            builder.pop();
        }
    }

    public static class Naga {
        public final SpawnConfig spawnConfig;
        public final CombatConfig combatConfig;

        Naga(ForgeConfigSpec.Builder builder) {
            builder.push("naga");
            this.spawnConfig = new SpawnConfig(builder, 70, 2, 4, new BiomeConfig(builder, Arrays.asList("BEACH,MOUNTAIN", "BEACH,HILLS"), Arrays.asList("minecraft:stone_shore"), new ArrayList<String>()), Arrays.asList("grass_block", "stone", "sand"), -1, -1, false, true, false);
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            builder.pop();
        }
    }

    public static class Barakoa {
        public final SpawnConfig spawnConfig;
        public final CombatConfig combatConfig;

        Barakoa(ForgeConfigSpec.Builder builder) {
            builder.push("barakoa");
            builder.comment(new String[]{"Controls spawning for Barakoana hunting groups", "Group size controls how many elites spawn, not followers", "See Barako config for village controls"});
            this.spawnConfig = new SpawnConfig(builder, 5, 1, 1, new BiomeConfig(builder, Arrays.asList("SAVANNA"), new ArrayList<String>(), new ArrayList<String>()), Arrays.asList("grass_block", "sand"), -1, 60, false, false, false);
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            builder.pop();
        }
    }

    public static class Foliaath {
        public final SpawnConfig spawnConfig;
        public final CombatConfig combatConfig;

        Foliaath(ForgeConfigSpec.Builder builder) {
            builder.push("foliaath");
            this.spawnConfig = new SpawnConfig(builder, 70, 1, 4, new BiomeConfig(builder, Arrays.asList("JUNGLE"), new ArrayList<String>(), new ArrayList<String>()), Arrays.asList("grass_block", "podzol", "jungle_leaves", "oak_leaves", "oak_log", "jungle_log"), -1, 60, false, false, false);
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            builder.pop();
        }
    }

    public static class ArmorConfig {
        public final ForgeConfigSpec.ConfigValue<Integer> damageReduction;
        public final ForgeConfigSpec.ConfigValue<Float> toughness;

        ArmorConfig(ForgeConfigSpec.Builder builder, int damageReduction, float toughness) {
            builder.push("armor_config");
            this.damageReduction = builder.comment("See official Minecraft Wiki for an explanation of how armor damage reduction works.").translation("config.mowziesmobs.damage_reduction").define("damage_reduction", (Object)damageReduction);
            this.toughness = builder.comment("See official Minecraft Wiki for an explanation of how armor toughness works.").translation("config.mowziesmobs.toughness").define("toughness", (Object)Float.valueOf(toughness));
            builder.pop();
        }
    }

    public static class ToolConfig {
        public final ForgeConfigSpec.ConfigValue<Float> attackDamage;
        public final ForgeConfigSpec.ConfigValue<Float> attackSpeed;

        ToolConfig(ForgeConfigSpec.Builder builder, float attackDamage, float attackSpeed) {
            builder.push("tool_config");
            this.attackDamage = builder.comment("Tool attack damage").translation("config.mowziesmobs.attack_damage").define("attack_damage", (Object)Float.valueOf(attackDamage));
            this.attackSpeed = builder.comment("Tool attack speed").translation("config.mowziesmobs.attack_speed").define("attack_speed", (Object)Float.valueOf(attackSpeed));
            builder.pop();
        }
    }

    public static class CombatConfig {
        public final ForgeConfigSpec.ConfigValue<Float> healthMultiplier;
        public final ForgeConfigSpec.ConfigValue<Float> attackMultiplier;

        CombatConfig(ForgeConfigSpec.Builder builder, float healthMultiplier, float attackMultiplier) {
            builder.push("combat_config");
            this.healthMultiplier = builder.comment("Scale mob health by this value").translation("config.mowziesmobs.health_multiplier").define("health_multiplier", (Object)Float.valueOf(healthMultiplier));
            this.attackMultiplier = builder.comment("Scale mob attack damage by this value").translation("config.mowziesmobs.attack_multiplier").define("attack_multiplier", (Object)Float.valueOf(attackMultiplier));
            builder.pop();
        }
    }

    public static class GenerationConfig {
        public final ForgeConfigSpec.ConfigValue<Integer> generationDistance;
        public final ForgeConfigSpec.ConfigValue<Integer> generationSeparation;
        public final BiomeConfig biomeConfig;
        public final ForgeConfigSpec.ConfigValue<List<String>> dimensions;
        public final ForgeConfigSpec.ConfigValue<Float> heightMin;
        public final ForgeConfigSpec.ConfigValue<Float> heightMax;

        GenerationConfig(ForgeConfigSpec.Builder builder, int generationDistance, int generationSeparation, BiomeConfig biomeConfig, float heightMin, float heightMax) {
            builder.comment("Controls for spawning structure/mob with world generation");
            builder.push("generation_config");
            this.generationDistance = builder.comment(new String[]{"Smaller number causes more generation, -1 to disable generation", "Maximum number of chunks between placements of this mob/structure"}).translation("config.mowziesmobs.generation_distance").define("generation_distance", (Object)generationDistance);
            this.generationSeparation = builder.comment(new String[]{"Smaller number causes more generation, -1 to disable generation", "Minimum number of chunks between placements of this mob/structure"}).translation("config.mowziesmobs.generation_separation").define("generation_separation", (Object)generationSeparation);
            this.biomeConfig = biomeConfig;
            this.dimensions = builder.comment("Names of dimensions this mob/structure can generate in").translation("config.mowziesmobs.dimensions").define("dimensions", Arrays.asList("minecraft:overworld"));
            this.heightMax = builder.comment("Maximum height for generation placement. -1 to ignore").translation("config.mowziesmobs.height_max").define("height_max", (Object)Float.valueOf(heightMax));
            this.heightMin = builder.comment("Minimum height for generation placement. -1 to ignore").translation("config.mowziesmobs.height_min").define("height_min", (Object)Float.valueOf(heightMin));
            builder.pop();
        }
    }

    public static class SpawnConfig {
        public final ForgeConfigSpec.ConfigValue<Integer> spawnRate;
        public final ForgeConfigSpec.ConfigValue<Integer> minGroupSize;
        public final ForgeConfigSpec.ConfigValue<Integer> maxGroupSize;
        public final BiomeConfig biomeConfig;
        public final ForgeConfigSpec.ConfigValue<List<String>> dimensions;
        public final ForgeConfigSpec.ConfigValue<Integer> heightMin;
        public final ForgeConfigSpec.ConfigValue<Integer> heightMax;
        public final ForgeConfigSpec.ConfigValue<Boolean> needsDarkness;
        public final ForgeConfigSpec.ConfigValue<Boolean> needsSeeSky;
        public final ForgeConfigSpec.ConfigValue<Boolean> needsCantSeeSky;
        public final ForgeConfigSpec.ConfigValue<List<String>> allowedBlocks;

        SpawnConfig(ForgeConfigSpec.Builder builder, int spawnRate, int minGroupSize, int maxGroupSize, BiomeConfig biomeConfig, List<String> allowedBlocks, int heightMax, int heightMin, boolean needsDarkness, boolean needsSeeSky, boolean needsCantSeeSky) {
            builder.comment("Controls for vanilla-style mob spawning");
            builder.push("spawn_config");
            this.spawnRate = builder.comment("Smaller number causes less spawning, 0 to disable spawning").translation("config.mowziesmobs.spawn_rate").define("spawn_rate", (Object)spawnRate);
            this.minGroupSize = builder.comment("Minimum number of mobs that appear in a spawn group").translation("config.mowziesmobs.min_group_size").define("min_group_size", (Object)minGroupSize);
            this.maxGroupSize = builder.comment("Maximum number of mobs that appear in a spawn group").translation("config.mowziesmobs.max_group_size").define("max_group_size", (Object)maxGroupSize);
            this.biomeConfig = biomeConfig;
            this.dimensions = builder.comment("Names of dimensions this mob can spawn in").translation("config.mowziesmobs.dimensions").define("dimensions", Arrays.asList("minecraft:overworld"));
            this.allowedBlocks = builder.comment("Names of blocks this mob is allowed to spawn on. Leave blank to allow any block.").translation("config.mowziesmobs.allowed_blocks").define("allowed_blocks", allowedBlocks);
            this.heightMax = builder.comment("Maximum height for this spawn. -1 to ignore.").translation("config.mowziesmobs.height_max").define("height_max", (Object)heightMax);
            this.heightMin = builder.comment("Minimum height for this spawn. -1 to ignore.").translation("config.mowziesmobs.height_min").define("height_min", (Object)heightMin);
            this.needsDarkness = builder.comment("Set to true to only allow this mob to spawn in the dark, like zombies and skeletons.").translation("config.mowziesmobs.needs_darkness").define("needs_darkness", needsDarkness);
            this.needsSeeSky = builder.comment("Set to true to only spawn mob if it can see the sky.").translation("config.mowziesmobs.min_group_size").define("needs_see_sky", needsSeeSky);
            this.needsCantSeeSky = builder.comment("Set to true to only spawn mob if it can't see the sky.").translation("config.mowziesmobs.min_group_size").define("needs_cant_see_sky", needsCantSeeSky);
            builder.pop();
        }
    }

    public static class BiomeConfig {
        public final ForgeConfigSpec.ConfigValue<List<String>> biomeTypes;
        public final ForgeConfigSpec.ConfigValue<List<String>> biomeWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<String>> biomeBlacklist;

        BiomeConfig(ForgeConfigSpec.Builder builder, List<String> biomeTypes, List<String> biomeWhitelist, List<String> biomeBlacklist) {
            builder.push("biome_config");
            this.biomeTypes = builder.comment(new String[]{"Each entry is a combination of allowed biome types.", "Separate types with commas to require biomes to have all types in an entry", "Put a '!' before a biome type to mean NOT that type", "A blank entry means all biomes. No entries means no biomes.", "For example, 'FOREST,MAGICAL,!SNOWY' would mean all biomes that are magical forests but not snowy", "'!MOUNTAIN' would mean all non-mountain biomes"}).translation("config.mowziesmobs.biome_type").define("biome_type", biomeTypes);
            this.biomeWhitelist = builder.comment("Allow spawns in these biomes regardless of the biome type settings").translation("config.mowziesmobs.biome_whitelist").define("biome_whitelist", biomeWhitelist);
            this.biomeBlacklist = builder.comment("Prevent spawns in these biomes regardless of the biome type settings").translation("config.mowziesmobs.biome_blacklist").define("biome_blacklist", biomeBlacklist);
            builder.pop();
        }
    }
}

