/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class LegSolver {
    public final Leg[] legs;

    public LegSolver(Leg ... legs) {
        this.legs = legs;
    }

    public final void update(LivingEntity entity) {
        double sideTheta = (double)entity.field_70761_aq / 57.29577951308232;
        double sideX = Math.cos(sideTheta);
        double sideZ = Math.sin(sideTheta);
        double forwardTheta = sideTheta + 1.5707963267948966;
        double forwardX = Math.cos(forwardTheta);
        double forwardZ = Math.sin(forwardTheta);
        for (Leg leg : this.legs) {
            leg.update(entity, sideX, sideZ, forwardX, forwardZ);
        }
    }

    public static final class Leg {
        public final float forward;
        public final float side;
        private float height;
        private float prevHeight;

        public Leg(float forward, float side) {
            this.forward = forward;
            this.side = side;
        }

        public float getHeight(float delta) {
            return this.prevHeight + (this.height - this.prevHeight) * delta;
        }

        public void update(LivingEntity entity, double sideX, double sideZ, double forwardX, double forwardZ) {
            this.prevHeight = this.height;
            this.height = this.settle(entity, entity.func_226277_ct_() + sideX * (double)this.side + forwardX * (double)this.forward, entity.func_226278_cu_(), entity.func_226281_cx_() + sideZ * (double)this.side + forwardZ * (double)this.forward, this.height);
        }

        private float settle(LivingEntity entity, double x, double y, double z, float height) {
            BlockPos pos = new BlockPos(x, y + 0.001, z);
            float dist = this.getDistance(entity.field_70170_p, pos);
            dist = (double)(1.0f - dist) < 0.001 ? this.getDistance(entity.field_70170_p, pos.func_177977_b()) + (float)y % 1.0f : (float)((double)dist - (1.0 - y % 1.0));
            if (entity.field_70122_E && height <= dist) {
                return height == dist ? height : Math.min(height + 0.3f, dist);
            }
            if (height > 0.0f) {
                return Math.max(height - 0.4f, dist);
            }
            return height;
        }

        private float getDistance(World world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            VoxelShape shape = state.func_196952_d((IBlockReader)world, pos);
            float f = 0.0f;
            if (!shape.func_197766_b()) {
                AxisAlignedBB aabb = shape.func_197752_a();
                f = (float)aabb.field_72337_e;
            }
            return 1.0f - Math.min(f, 1.0f);
        }
    }
}

