/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import com.bobmowzie.mowziesmobs.client.model.tools.IntermittentAnimation;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.IntermittentAnimatableEntity;
import com.bobmowzie.mowziesmobs.server.entity.MMBossInfoServer;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import com.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import org.apache.commons.lang3.ArrayUtils;

public abstract class MowzieEntity
extends CreatureEntity
implements IEntityAdditionalSpawnData,
IAnimatedEntity,
IntermittentAnimatableEntity {
    private static final byte START_IA_HEALTH_UPDATE_ID = 4;
    public int frame;
    public float targetDistance;
    public float targetAngle;
    public boolean active;
    public LivingEntity blockingEntity = null;
    private int animationTick;
    private Animation animation = NO_ANIMATION;
    private final List<IntermittentAnimation<?>> intermittentAnimations = new ArrayList();
    public boolean playsHurtAnimation = true;
    protected boolean dropAfterDeathAnim = true;
    public boolean hurtInterruptsAnimation = false;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3d[] socketPosArray;
    protected boolean prevOnGround;
    protected boolean prevPrevOnGround;
    protected boolean willLandSoon;
    private int killDataRecentlyHit;
    private DamageSource killDataCause;
    private PlayerEntity killDataAttackingPlayer;
    private final MMBossInfoServer bossInfo = new MMBossInfoServer(this);

    public MowzieEntity(EntityType<? extends MowzieEntity> type, World world) {
        super(type, world);
        if (world.field_72995_K) {
            this.socketPosArray = new Vec3d[0];
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    protected ConfigHandler.SpawnConfig getSpawnConfig() {
        return null;
    }

    public static boolean spawnPredicate(EntityType type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return true;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        ConfigHandler.SpawnConfig spawnConfig = this.getSpawnConfig();
        if (spawnConfig != null) {
            int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
            int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
            BlockPos pos = new BlockPos(i, j, k);
            List dimensionNames = (List)spawnConfig.dimensions.get();
            ResourceLocation currDimensionName = world.func_201675_m().func_186058_p().getRegistryName();
            if (currDimensionName == null || !dimensionNames.contains(currDimensionName.toString())) {
                return false;
            }
            float heightMax = ((Integer)spawnConfig.heightMax.get()).intValue();
            float heightMin = ((Integer)spawnConfig.heightMin.get()).intValue();
            if (this.func_226278_cu_() > (double)heightMax && heightMax >= 0.0f) {
                return false;
            }
            if (this.func_226278_cu_() < (double)heightMin) {
                return false;
            }
            if (((Boolean)spawnConfig.needsDarkness.get()).booleanValue() && !this.isValidLightLevel(world, pos, this.field_70146_Z)) {
                return false;
            }
            ResourceLocation blockName = world.func_180495_p(pos.func_177977_b()).func_177230_c().getRegistryName();
            List allowedBlocks = (List)spawnConfig.allowedBlocks.get();
            if (blockName == null) {
                return false;
            }
            if (!allowedBlocks.isEmpty() && !allowedBlocks.contains(blockName.func_110623_a())) {
                return false;
            }
            if (((Boolean)spawnConfig.needsSeeSky.get()).booleanValue() && !world.func_175710_j(pos)) {
                return false;
            }
            if (((Boolean)spawnConfig.needsCantSeeSky.get()).booleanValue() && world.func_175710_j(pos)) {
                return false;
            }
        }
        return super.func_213380_a(world, reason);
    }

    protected boolean isValidLightLevel(IWorld world, BlockPos pos, Random rand) {
        if (world.func_226658_a_(LightType.SKY, pos) > rand.nextInt(32)) {
            return false;
        }
        int lightLevel = world.func_201672_e().func_72911_I() ? world.func_205049_d(pos, 10) : world.func_201696_r(pos);
        return lightLevel <= rand.nextInt(8);
    }

    public void func_70071_h_() {
        this.prevPrevOnGround = this.prevOnGround;
        this.prevOnGround = this.field_70122_E;
        super.func_70071_h_();
        ++this.frame;
        if (this.getAnimation() != NO_ANIMATION) {
            ++this.animationTick;
            if (this.field_70170_p.field_72995_K && this.animationTick >= this.animation.getDuration()) {
                this.setAnimation(NO_ANIMATION);
            }
        }
        if (this.func_70638_az() != null) {
            this.targetDistance = this.func_70032_d((Entity)this.func_70638_az()) - this.func_70638_az().func_213311_cf() / 2.0f;
            this.targetAngle = (float)this.getAngleBetweenEntities((Entity)this, (Entity)this.func_70638_az());
        }
        this.willLandSoon = !this.field_70122_E && this.field_70170_p.func_72829_c(this.func_174813_aQ().func_191194_a(this.func_213322_ci()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.update();
    }

    protected void onAnimationFinish(Animation animation) {
    }

    public void writeSpawnData(PacketBuffer buf) {
        buf.writeInt(ArrayUtils.indexOf((Object[])this.getAnimations(), (Object)this.getAnimation()));
        buf.writeInt(this.getAnimationTick());
    }

    public void readSpawnData(PacketBuffer buf) {
        this.field_70126_B = this.field_70177_z;
        this.field_70761_aq = this.field_70758_at = this.field_70759_as;
        this.field_70760_ar = this.field_70758_at;
        int animOrdinal = buf.readInt();
        int animTick = buf.readInt();
        this.setAnimation(animOrdinal == -1 ? IAnimatedEntity.NO_ANIMATION : this.getAnimations()[animOrdinal]);
        this.setAnimationTick(animTick);
    }

    public boolean func_70652_k(Entity entityIn) {
        return this.attackEntityAsMob(entityIn, 1.0f, 1.0f);
    }

    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData livingData, CompoundNBT compound) {
        return super.func_213386_a(world, difficulty, reason, livingData, compound);
    }

    public boolean attackEntityAsMob(Entity entityIn, float damageMultiplier, float knockbackMultiplier) {
        boolean flag;
        int i;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * damageMultiplier;
        float f1 = (float)this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111126_e() * knockbackMultiplier;
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            f1 += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
            entityIn.func_70015_d(i * 4);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_70653_a((Entity)this, f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof PlayerEntity) {
                ItemStack itemstack1;
                PlayerEntity playerentity = (PlayerEntity)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.canDisableShield(itemstack1, (LivingEntity)playerentity, (LivingEntity)this) && itemstack1.isShield((LivingEntity)playerentity)) {
                    float f2 = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f2) {
                        playerentity.func_184811_cZ().func_185145_a(itemstack.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)playerentity, (byte)30);
                    }
                }
            }
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_130011_c(entityIn);
        }
        return flag;
    }

    public float getHealthRatio() {
        return this.func_110143_aJ() / this.func_110138_aP();
    }

    public double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.func_226281_cx_() - first.func_226281_cx_(), second.func_226277_ct_() - first.func_226277_ct_()) * 57.29577951308232 + 90.0;
    }

    public List<PlayerEntity> getPlayersNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List nearbyEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        List<PlayerEntity> listEntityPlayers = nearbyEntities.stream().filter(entityNeighbor -> entityNeighbor instanceof PlayerEntity && (double)this.func_70032_d((Entity)entityNeighbor) <= radius + (double)(entityNeighbor.func_213311_cf() / 2.0f)).map(entityNeighbor -> (PlayerEntity)entityNeighbor).collect(Collectors.toList());
        return listEntityPlayers;
    }

    public List<LivingEntity> getAttackableEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List nearbyEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        List<LivingEntity> listEntityLivingBase = nearbyEntities.stream().filter(entityNeighbor -> entityNeighbor instanceof LivingEntity && ((LivingEntity)entityNeighbor).func_190631_cK() && (!(entityNeighbor instanceof PlayerEntity) || !((PlayerEntity)entityNeighbor).func_184812_l_()) && (double)this.func_70032_d((Entity)entityNeighbor) <= radius + (double)(entityNeighbor.func_213311_cf() / 2.0f)).map(entityNeighbor -> (LivingEntity)entityNeighbor).collect(Collectors.toList());
        return listEntityLivingBase;
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double r) {
        return this.field_70170_p.func_175647_a(entityClass, this.func_174813_aQ().func_72314_b(r, r, r), e -> e != this && (double)this.func_70032_d((Entity)e) <= r + (double)(e.func_213311_cf() / 2.0f));
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.field_70170_p.func_175647_a(entityClass, this.func_174813_aQ().func_72314_b(dX, dY, dZ), e -> e != this && (double)this.func_70032_d((Entity)e) <= r + (double)(e.func_213311_cf() / 2.0f) && e.func_226278_cu_() <= this.func_226278_cu_() + dY);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.func_110143_aJ() <= 0.0f) {
            Animation death = this.getDeathAnimation();
            if (death != null) {
                this.onDeathUpdate(death.getDuration() - 20);
            } else {
                this.onDeathUpdate(20);
            }
        }
    }

    private void onDeathUpdate(int deathDuration) {
        this.onDeathAIUpdate();
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == deathDuration) {
            this.field_70717_bb = this.killDataAttackingPlayer;
            this.field_70718_bc = this.killDataRecentlyHit;
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) && this.dropAfterDeathAnim && this.killDataCause != null) {
                this.func_213345_d(this.killDataCause);
            }
            this.remove(false);
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
        }
    }

    protected void onDeathAIUpdate() {
    }

    protected final void func_70609_aI() {
    }

    public void func_70645_a(DamageSource cause) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)cause)) {
            return;
        }
        if (!this.field_70729_aU) {
            Entity entity = cause.func_76346_g();
            LivingEntity livingentity = this.func_94060_bK();
            if (this.field_70744_aE >= 0 && livingentity != null) {
                livingentity.func_191956_a((Entity)this, this.field_70744_aE, cause);
            }
            if (entity != null) {
                entity.func_70074_a((LivingEntity)this);
            }
            if (this.func_70608_bn()) {
                this.func_213366_dy();
            }
            this.field_70729_aU = true;
            this.func_110142_aN().func_94549_h();
            if (!this.field_70170_p.field_72995_K) {
                if (!this.dropAfterDeathAnim) {
                    this.func_213345_d(cause);
                }
                this.func_226298_f_(livingentity);
            }
            this.killDataCause = cause;
            this.killDataRecentlyHit = this.field_70718_bc;
            this.killDataAttackingPlayer = this.field_70717_bb;
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_213301_b(Pose.DYING);
            this.bossInfo.update();
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        boolean attack = super.func_70097_a(source, damage);
        if (attack) {
            if (this.func_110143_aJ() > 0.0f && (this.getAnimation() == NO_ANIMATION || this.hurtInterruptsAnimation) && this.playsHurtAnimation) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, this.getHurtAnimation());
            } else if (this.func_110143_aJ() <= 0.0f) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, this.getDeathAnimation());
            }
        }
        return attack;
    }

    protected void addIntermittentAnimation(IntermittentAnimation animation) {
        animation.setID((byte)this.intermittentAnimations.size());
        this.intermittentAnimations.add(animation);
    }

    public void func_70103_a(byte id) {
        if (id >= 4 && id - 4 < this.intermittentAnimations.size()) {
            this.intermittentAnimations.get(id - 4).start();
            return;
        }
        super.func_70103_a(id);
    }

    @Override
    public byte getOffsetEntityState() {
        return 4;
    }

    public void circleEntity(Entity target, float radius, float speed, boolean direction, int circleFrame, float offset, float moveSpeedMultiplier) {
        int directionInt = direction ? 1 : -1;
        double t = (double)(directionInt * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
        Vec3d movePos = target.func_213303_ch().func_72441_c((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
        this.func_70661_as().func_75492_a(movePos.func_82615_a(), movePos.func_82617_b(), movePos.func_82616_c(), (double)(speed * moveSpeedMultiplier));
    }

    protected void repelEntities(float x, float y, float z, float radius) {
        List<LivingEntity> nearbyEntities = this.getEntityLivingBaseNearby(x, y, z, radius);
        for (Entity entity : nearbyEntities) {
            double angle = (this.getAngleBetweenEntities((Entity)this, entity) + 90.0) * Math.PI / 180.0;
            entity.func_213293_j(-0.1 * Math.cos(angle), entity.func_213322_ci().field_72448_b, -0.1 * Math.sin(angle));
        }
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        if (animation == NO_ANIMATION) {
            this.onAnimationFinish(this.animation);
        }
        this.animation = animation;
        this.setAnimationTick(0);
    }

    public abstract Animation getDeathAnimation();

    public abstract Animation getHurtAnimation();

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_200203_b(ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected boolean hasBossBar() {
        return false;
    }

    protected BossInfo.Color bossBarColor() {
        return BossInfo.Color.PURPLE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setSocketPosArray(int index, Vec3d pos) {
        if (this.socketPosArray != null && this.socketPosArray.length > index) {
            this.socketPosArray[index] = pos;
        }
    }

    public boolean canBePushedByEntity(Entity entity) {
        return true;
    }

    public void func_70108_f(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!(this.func_70608_bn() || this.func_184223_x(entityIn) || entityIn.field_70145_X || this.field_70145_X || !((d2 = MathHelper.func_76132_a((double)(d0 = entityIn.func_226277_ct_() - this.func_226277_ct_()), (double)(d1 = entityIn.func_226281_cx_() - this.func_226281_cx_()))) >= (double)0.01f))) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= (double)(1.0f - this.field_70144_Y);
            d1 *= (double)(1.0f - this.field_70144_Y);
            if (!this.func_184207_aI() && this.canBePushedByEntity(entityIn)) {
                this.func_70024_g(-d0, 0.0, -d1);
            }
            if (!entityIn.func_184207_aI()) {
                entityIn.func_70024_g(d0, 0.0, d1);
            }
        }
    }
}

