/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.barakoa;

import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationActivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationBlockAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDeactivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationProjectileAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.ai.animation.EntityAIAvoidEntity;
import com.bobmowzie.mowziesmobs.server.ai.animation.SimpleAnimationAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityDart;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.SmartBodyHelper;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.MaskType;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.bobmowzie.mowziesmobs.server.item.ItemBarakoaMask;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.google.common.base.Supplier;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class EntityBarakoa
extends MowzieEntity
implements IRangedAttackMob,
IMob {
    public static final Animation DIE_ANIMATION = Animation.create(70);
    public static final Animation HURT_ANIMATION = Animation.create(10);
    public static final Animation ATTACK_ANIMATION = Animation.create(19);
    public static final Animation PROJECTILE_ATTACK_ANIMATION = Animation.create(20);
    public static final Animation IDLE_ANIMATION = Animation.create(35);
    public static final Animation ACTIVATE_ANIMATION = Animation.create(25);
    public static final Animation DEACTIVATE_ANIMATION = Animation.create(26);
    public static final Animation BLOCK_ANIMATION = Animation.create(10);
    private static final DataParameter<Boolean> DANCING = EntityDataManager.func_187226_a(EntityBarakoa.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MASK = EntityDataManager.func_187226_a(EntityBarakoa.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> WEAPON = EntityDataManager.func_187226_a(EntityBarakoa.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ACTIVE = EntityDataManager.func_187226_a(EntityBarakoa.class, (IDataSerializer)DataSerializers.field_187198_h);
    public ControlledAnimation doWalk = new ControlledAnimation(3);
    public ControlledAnimation dancing = new ControlledAnimation(7);
    private boolean circleDirection = true;
    protected int circleTick = 0;
    protected boolean attacking = false;
    private int timeSinceAttack = 0;
    private int cryDelay = -1;
    private int danceTimer = 0;
    private int ticksWithoutTarget;
    public int timeUntilDeath = -1;

    public EntityBarakoa(EntityType<? extends EntityBarakoa> type, World world) {
        super(type, world);
        this.setMask(MaskType.from(MathHelper.func_76136_a((Random)this.field_70146_Z, (int)1, (int)4)));
        this.field_70138_W = 1.0f;
        this.circleTick += this.field_70146_Z.nextInt(200);
        this.frame += this.field_70146_Z.nextInt(50);
        this.field_70728_aV = 8;
        this.active = false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -8.0f);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, new AnimationActivateAI<EntityBarakoa>(this, ACTIVATE_ANIMATION));
        this.field_70714_bg.func_75776_a(0, new AnimationDeactivateAI<EntityBarakoa>(this, DEACTIVATE_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationDieAI<EntityBarakoa>(this));
        this.field_70714_bg.func_75776_a(1, new EntityAIAvoidEntity<EntitySunstrike>(this, EntitySunstrike.class, EntitySunstrike::isStriking, 3.0f, 0.7f));
        this.field_70714_bg.func_75776_a(2, new AnimationBlockAI<EntityBarakoa>(this, BLOCK_ANIMATION));
        this.field_70714_bg.func_75776_a(2, new AnimationAttackAI<EntityBarakoa>(this, ATTACK_ANIMATION, (SoundEvent)MMSounds.ENTITY_BARAKOA_SWING.get(), null, 1.0f, 2.5f, 1.0f, 9, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimationProjectileAttackAI<EntityBarakoa>(this, PROJECTILE_ATTACK_ANIMATION, 9, (SoundEvent)MMSounds.ENTITY_BARAKOA_BLOWDART.get(), true){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityBarakoa.this.func_184185_a((SoundEvent)MMSounds.ENTITY_BARAKOA_INHALE.get(), 0.7f, 1.2f);
            }
        });
        this.field_70714_bg.func_75776_a(3, new AnimationTakeDamage<EntityBarakoa>(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new SimpleAnimationAI<EntityBarakoa>(this, IDLE_ANIMATION, false, true){
            private LivingEntity talkTarget;
            private final EntityPredicate pred;
            {
                this.pred = new EntityPredicate().func_221011_b().func_221008_a().func_221014_c().func_221013_a(8.0).func_221010_e();
            }

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                LivingEntity player = ((EntityBarakoa)this.entity).field_70170_p.func_225318_b(PlayerEntity.class, this.pred, (LivingEntity)this.entity, ((EntityBarakoa)this.entity).func_226277_ct_(), ((EntityBarakoa)this.entity).func_226278_cu_() + (double)((EntityBarakoa)this.entity).func_70047_e(), ((EntityBarakoa)this.entity).func_226281_cx_(), ((EntityBarakoa)this.entity).func_174813_aQ().func_72314_b(8.0, 3.0, 8.0));
                LivingEntity barakoa = ((EntityBarakoa)this.entity).field_70170_p.func_225318_b(EntityBarakoa.class, this.pred, (LivingEntity)this.entity, ((EntityBarakoa)this.entity).func_226277_ct_(), ((EntityBarakoa)this.entity).func_226278_cu_() + (double)((EntityBarakoa)this.entity).func_70047_e(), ((EntityBarakoa)this.entity).func_226281_cx_(), ((EntityBarakoa)this.entity).func_174813_aQ().func_72314_b(8.0, 3.0, 8.0));
                this.talkTarget = player == null ? barakoa : (barakoa == null ? player : (EntityBarakoa.this.field_70146_Z.nextBoolean() ? player : barakoa));
            }

            public void func_75246_d() {
                super.func_75246_d();
                if (this.talkTarget != null) {
                    ((EntityBarakoa)this.entity).field_70749_g.func_75651_a((Entity)this.talkTarget, (float)((EntityBarakoa)this.entity).func_184649_cE(), (float)((EntityBarakoa)this.entity).func_70646_bf());
                }
            }
        });
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.5, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.4));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, EntityBarakoa.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, EntityBarako.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected BodyController func_184650_s() {
        return new SmartBodyHelper((MobEntity)this);
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    protected SoundEvent func_184639_G() {
        if (this.getAnimation() == DEACTIVATE_ANIMATION) {
            return null;
        }
        if (!this.active || this.danceTimer != 0 || this.getEntitiesNearby(EntityBarakoa.class, 8.0, 3.0, 8.0, 8.0).isEmpty() && this.getEntitiesNearby(EntityBarako.class, 8.0, 3.0, 8.0, 8.0).isEmpty() && this.getEntitiesNearby(PlayerEntity.class, 8.0, 3.0, 8.0, 8.0).isEmpty()) {
            return null;
        }
        if (this.func_70638_az() == null) {
            int i = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)11);
            if (i < MMSounds.ENTITY_BARAKOA_TALK.size()) {
                this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_BARAKOA_TALK.get(i)).get(), 1.0f, 1.5f);
                AnimationHandler.INSTANCE.sendAnimationMessage(this, IDLE_ANIMATION);
            }
        } else {
            int i = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)7);
            if (i < MMSounds.ENTITY_BARAKOA_ANGRY.size()) {
                this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_BARAKOA_ANGRY.get(i)).get(), 1.0f, 1.6f);
            }
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return this.active ? (SoundEvent)MMSounds.ENTITY_BARAKOA_HURT.get() : null;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(10.0f * ((Float)ConfigHandler.MOBS.BARAKOA.combatConfig.healthMultiplier.get()).floatValue()));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)((float)(this.getMask() == MaskType.FURY ? 6 : 4) * ((Float)ConfigHandler.MOBS.BARAKOA.combatConfig.attackMultiplier.get()).floatValue()));
    }

    protected void updateAttackAI() {
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
        if (this.timeSinceAttack < 80) {
            ++this.timeSinceAttack;
        }
        if (this.func_70638_az() != null) {
            if ((double)this.targetDistance > 6.5) {
                this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 0.6);
            } else if (!this.attacking) {
                this.updateCircling();
            }
            if (this.field_70146_Z.nextInt(80) == 0 && this.timeSinceAttack == 80 && this.func_70635_at().func_75522_a((Entity)this.func_70638_az())) {
                this.attacking = true;
                if (this.getAnimation() == NO_ANIMATION && this.getWeapon() == 0) {
                    this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 0.5);
                }
            }
            if (this.attacking && this.getAnimation() == NO_ANIMATION && this.func_70635_at().func_75522_a((Entity)this.func_70638_az())) {
                if ((double)this.targetDistance <= 2.5 && this.getWeapon() == 0) {
                    this.attacking = false;
                    this.timeSinceAttack = 0;
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, ATTACK_ANIMATION);
                }
                if (this.getWeapon() == 1) {
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, PROJECTILE_ATTACK_ANIMATION);
                }
            }
        } else {
            this.attacking = false;
        }
    }

    @Override
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData livingData, CompoundNBT compound) {
        if (this.canHoldVaryingWeapons()) {
            this.setWeapon(this.field_70146_Z.nextInt(3) == 0 ? 1 : 0);
        }
        return super.func_213386_a(world, difficulty, reason, livingData, compound);
    }

    protected boolean canHoldVaryingWeapons() {
        return true;
    }

    protected void updateCircling() {
        LivingEntity target = this.func_70638_az();
        if (target != null) {
            if (this.field_70146_Z.nextInt(200) == 0) {
                boolean bl = this.circleDirection = !this.circleDirection;
            }
            this.circleTick = this.circleDirection ? ++this.circleTick : --this.circleTick;
            if (!this.attacking && (double)this.targetDistance < 4.5) {
                this.circleEntity((Entity)target, 7.0f, 0.3f, true, this.circleTick, 0.0f, 1.75f);
            } else {
                this.circleEntity((Entity)target, 7.0f, 0.3f, true, this.circleTick, 0.0f, 1.0f);
            }
            this.attacking = false;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.active && !this.getActive()) {
            this.setActive(true);
        }
        this.active = this.getActive();
        if (!this.active) {
            this.func_70661_as().func_75499_g();
            this.field_70761_aq = this.field_70177_z = this.field_70126_B;
            if (this.field_70122_E && this.getAnimation() == NO_ANIMATION) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_ANIMATION);
                this.func_184185_a((SoundEvent)MMSounds.ENTITY_BARAKOA_EMERGE.get(), 1.0f, 1.0f);
            }
            return;
        }
        this.updateAttackAI();
        if (this.getAnimation() != NO_ANIMATION) {
            this.func_70661_as().func_75499_g();
        }
        if (this.getDancing()) {
            this.setDancing(false);
            ++this.danceTimer;
        }
        if (this.getAnimation() == NO_ANIMATION || this.getAnimation() == IDLE_ANIMATION) {
            this.doWalk.increaseTimer();
        } else {
            this.doWalk.decreaseTimer();
        }
        if (this.danceTimer != 0 && this.danceTimer != 30) {
            ++this.danceTimer;
            this.dancing.increaseTimer();
        } else {
            this.danceTimer = 0;
            this.dancing.decreaseTimer();
        }
        if (!this.field_70170_p.field_72995_K && this.getAnimation() == NO_ANIMATION && this.danceTimer == 0 && this.field_70146_Z.nextInt(800) == 0) {
            this.setDancing(true);
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_BARAKOA_BATTLECRY_2.get(), 1.2f, 1.3f);
        }
        if (this.getAnimation() != NO_ANIMATION) {
            this.danceTimer = 0;
        }
        if (this.cryDelay > -1) {
            --this.cryDelay;
        }
        if (this.cryDelay == 0) {
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_BARAKOA_BATTLECRY.get(), 1.5f, 1.5f);
        }
        if (this.func_70638_az() != null && this.ticksWithoutTarget > 3) {
            this.cryDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-15, (int)30);
        }
        if (this.getAnimation() == ATTACK_ANIMATION && this.getAnimationTick() == 5) {
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_BARAKOA_SHOUT.get(), 1.0f, 1.1f);
        }
        this.ticksWithoutTarget = this.func_70638_az() == null ? ++this.ticksWithoutTarget : 0;
        if (this.timeUntilDeath > 0) {
            --this.timeUntilDeath;
        } else if (this.timeUntilDeath == 0) {
            this.func_70097_a(DamageSource.func_76354_b((Entity)this, null), this.func_110143_aJ());
        }
    }

    @Override
    protected void onAnimationFinish(Animation animation) {
        if (animation == ACTIVATE_ANIMATION) {
            this.setActive(true);
            this.active = true;
        }
        if (animation == DEACTIVATE_ANIMATION) {
            this.func_70106_y();
            ItemBarakoaMask mask = ItemHandler.BARAKOA_MASK_FURY;
            switch (this.getMask()) {
                case BLISS: {
                    mask = ItemHandler.BARAKOA_MASK_BLISS;
                    break;
                }
                case FEAR: {
                    mask = ItemHandler.BARAKOA_MASK_FEAR;
                    break;
                }
                case FURY: {
                    mask = ItemHandler.BARAKOA_MASK_FURY;
                    break;
                }
                case MISERY: {
                    mask = ItemHandler.BARAKOA_MASK_MISERY;
                    break;
                }
                case RAGE: {
                    mask = ItemHandler.BARAKOA_MASK_RAGE;
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                ItemStack item = this.func_70099_a(new ItemStack((IItemProvider)mask), 1.5f).func_92059_d();
                item.func_196085_b((int)Math.ceil((1.0f - this.getHealthRatio()) * (float)item.func_77958_k()));
            }
        }
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)MMSounds.ENTITY_BARAKOA_DIE.get();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DANCING, (Object)false);
        this.func_184212_Q().func_187214_a(MASK, (Object)0);
        this.func_184212_Q().func_187214_a(WEAPON, (Object)0);
        this.func_184212_Q().func_187214_a(ACTIVE, (Object)true);
    }

    public boolean getDancing() {
        return (Boolean)this.func_184212_Q().func_187225_a(DANCING);
    }

    public void setDancing(boolean dancing) {
        this.func_184212_Q().func_187227_b(DANCING, (Object)dancing);
    }

    public MaskType getMask() {
        return MaskType.from((Integer)this.func_184212_Q().func_187225_a(MASK));
    }

    public void setMask(MaskType type) {
        this.func_184212_Q().func_187227_b(MASK, (Object)type.ordinal());
    }

    public int getWeapon() {
        return (Integer)this.func_184212_Q().func_187225_a(WEAPON);
    }

    public void setWeapon(int type) {
        this.func_184212_Q().func_187227_b(WEAPON, (Object)type);
    }

    public boolean getActive() {
        return (Boolean)this.func_184212_Q().func_187225_a(ACTIVE);
    }

    public void setActive(boolean active) {
        this.func_184212_Q().func_187227_b(ACTIVE, (Object)active);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("mask", this.getMask().ordinal());
        compound.func_74768_a("weapon", this.getWeapon());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setMask(MaskType.from(compound.func_74762_e("mask")));
        this.setWeapon(compound.func_74762_e("weapon"));
    }

    public void func_82196_d(LivingEntity target, float p_82196_2_) {
        EntityDart dart = new EntityDart(EntityHandler.DART, this.field_70170_p, (LivingEntity)this);
        Vec3d targetPos = target.func_213303_ch();
        double dx = targetPos.func_82615_a() - this.func_226277_ct_();
        double dy = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - dart.func_213303_ch().func_82617_b();
        double dz = targetPos.func_82616_c() - this.func_226281_cx_();
        double dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        dart.func_70186_c(dx, dy + dist * 0.2, dz, 1.6f, 1.0f);
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)this.func_184586_b(Hand.MAIN_HAND));
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)this.func_184586_b(Hand.MAIN_HAND));
        dart.func_70239_b((double)(p_82196_2_ * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            dart.func_70239_b(dart.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            dart.func_70240_a(j);
        }
        dart.func_70239_b(dart.func_70242_d() * (double)((Float)ConfigHandler.MOBS.BARAKOA.combatConfig.attackMultiplier.get()).floatValue());
        this.field_70170_p.func_217376_c((Entity)dart);
        this.attacking = false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.getAnimation() == DEACTIVATE_ANIMATION) {
            return false;
        }
        Entity entity = source.func_76346_g();
        boolean angleFlag = true;
        if (entity != null) {
            float entityRelativeAngle;
            int arc = 220;
            Vec3d entityPos = entity.func_213303_ch();
            float entityHitAngle = (float)((Math.atan2(entityPos.func_82616_c() - this.func_226281_cx_(), entityPos.func_82615_a() - this.func_226277_ct_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.field_70761_aq % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            boolean bl = angleFlag = (double)(entityRelativeAngle = entityHitAngle - entityAttackingAngle) <= (double)arc / 2.0 && (double)entityRelativeAngle >= (double)(-arc) / 2.0 || (double)entityRelativeAngle >= 360.0 - (double)arc / 2.0 || (double)entityRelativeAngle <= (double)(-arc) + 45.0;
        }
        if (angleFlag && this.getMask().canBlock && entity instanceof LivingEntity && (this.getAnimation() == NO_ANIMATION || this.getAnimation() == HURT_ANIMATION || this.getAnimation() == BLOCK_ANIMATION) && !source.func_76363_c()) {
            this.blockingEntity = (LivingEntity)entity;
            this.func_184185_a(SoundEvents.field_187767_eL, 0.3f, 1.5f);
            AnimationHandler.INSTANCE.sendAnimationMessage(this, BLOCK_ANIMATION);
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    protected ResourceLocation func_184647_J() {
        switch (this.getMask()) {
            case BLISS: {
                return LootTableHandler.BARAKOA_BLISS;
            }
            case FEAR: {
                return LootTableHandler.BARAKOA_FEAR;
            }
            case FURY: {
                return LootTableHandler.BARAKOA_FURY;
            }
            case MISERY: {
                return LootTableHandler.BARAKOA_MISERY;
            }
            case RAGE: {
                return LootTableHandler.BARAKOA_RAGE;
            }
        }
        return LootTableHandler.BARAKOA_FURY;
    }

    public boolean func_70067_L() {
        return this.active;
    }

    public boolean func_225503_b_(float distance, float damageMultipler) {
        if (this.active) {
            return super.func_225503_b_(distance, damageMultipler);
        }
        return false;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{DIE_ANIMATION, HURT_ANIMATION, ATTACK_ANIMATION, PROJECTILE_ATTACK_ANIMATION, BLOCK_ANIMATION, IDLE_ANIMATION, ACTIVATE_ANIMATION, DEACTIVATE_ANIMATION};
    }

    public boolean isBarakoDevoted() {
        return true;
    }

    public int randomizeWeapon() {
        return this.field_70146_Z.nextInt(3) == 0 ? 1 : 0;
    }
}

