/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.barakoa;

import com.google.common.base.Defaults;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;

public enum MaskType {
    FURY(Effects.field_76420_g, 0.7f, 2.0f, true),
    FEAR(Effects.field_76424_c),
    RAGE(Effects.field_76422_e),
    BLISS(Effects.field_76430_j),
    MISERY(Effects.field_76429_m);

    public static final int COUNT;
    public final Effect potion;
    public final float entityWidth;
    public final float entityHeight;
    public final boolean canBlock;
    public final String name;

    private MaskType(Effect potion) {
        this(potion, 0.6f, 1.7f, false);
    }

    private MaskType(Effect potion, float entityWidth, float entityHeight, boolean canBlock) {
        this.potion = potion;
        this.entityWidth = entityWidth;
        this.entityHeight = entityHeight;
        this.canBlock = canBlock;
        this.name = this.name().toLowerCase(Locale.ENGLISH);
    }

    public static MaskType from(int id) {
        if (id < 0 || id >= COUNT) {
            return MISERY;
        }
        return MaskType.values()[id];
    }

    public static <T> EnumMap<MaskType, T> newEnumMap(Class<T> type, T ... defaultValues) {
        EnumMap<MaskType, Object> map = new EnumMap<MaskType, Object>(MaskType.class);
        MaskType[] masks = MaskType.values();
        for (int i = 0; i < masks.length; ++i) {
            map.put(masks[i], i >= 0 && i < defaultValues.length ? defaultValues[i] : Defaults.defaultValue(type));
        }
        return map;
    }

    static {
        COUNT = MaskType.values().length;
    }
}

