/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EntityAxeAttack
extends EntityMagicEffect {
    private static final DataParameter<Boolean> VERTICAL = EntityDataManager.func_187226_a(EntityAxeAttack.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static int SWING_DURATION_HOR = 24;
    public static int SWING_DURATION_VER = 30;
    private float quakeAngle = 0.0f;
    private AxisAlignedBB quakeBB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public EntityAxeAttack(EntityType<? extends EntityAxeAttack> type, World world) {
        super(type, world);
    }

    public EntityAxeAttack(EntityType<? extends EntityAxeAttack> type, World world, LivingEntity caster, boolean vertical) {
        this(type, world);
        if (!world.field_72995_K) {
            this.setCasterID(caster.func_145782_y());
        }
        this.setVertical(vertical);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(VERTICAL, (Object)false);
    }

    @Override
    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.caster != null && !this.caster.func_70089_S()) {
            this.func_70106_y();
        }
        if (this.caster != null) {
            this.func_70080_a(this.caster.func_226277_ct_(), this.caster.func_226278_cu_(), this.caster.func_226281_cx_(), this.caster.field_70177_z, this.caster.field_70125_A);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 7) {
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_WROUGHT_WHOOSH.get(), 0.7f, 1.1f);
        }
        if (!this.field_70170_p.field_72995_K && this.caster != null) {
            if (!this.getVertical() && this.field_70173_aa == SWING_DURATION_HOR / 2 - 1) {
                this.dealDamage(7.0f * ((Float)ConfigHandler.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.toolConfig.attackDamage.get()).floatValue(), 4.5f, 160.0f, 1.2f);
            } else if (this.getVertical() && this.field_70173_aa == SWING_DURATION_VER / 2 - 1) {
                this.dealDamage(((Float)ConfigHandler.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.toolConfig.attackDamage.get()).floatValue(), 4.5f, 40.0f, 0.8f);
                this.quakeAngle = this.field_70177_z;
                this.quakeBB = this.func_174813_aQ();
                this.func_184185_a((SoundEvent)MMSounds.ENTITY_WROUGHT_AXE_LAND.get(), 0.3f, 0.5f);
                this.func_184185_a(SoundEvents.field_187539_bB, 2.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.1f);
            }
        }
        if (this.getVertical() && this.caster != null && this.field_70173_aa >= SWING_DURATION_VER / 2) {
            int maxDistance = 16;
            double perpFacing = (double)this.quakeAngle * (Math.PI / 180);
            double facingAngle = perpFacing + 1.5707963267948966;
            int hitY = MathHelper.func_76128_c((double)(this.quakeBB.field_72338_b - 0.5));
            int distance = this.field_70173_aa - 15;
            double spread = 1.099557410031076;
            int arcLen = MathHelper.func_76143_f((double)((double)distance * spread));
            double minY = this.quakeBB.field_72338_b;
            double maxY = this.quakeBB.field_72337_e;
            for (int i = 0; i < arcLen; ++i) {
                double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
                double vx = Math.cos(theta);
                double vz = Math.sin(theta);
                double px = this.func_226277_ct_() + vx * (double)distance;
                double pz = this.func_226281_cx_() + vz * (double)distance;
                float factor = 1.0f - (float)distance / (float)maxDistance;
                AxisAlignedBB selection = new AxisAlignedBB(px - 1.5, minY, pz - 1.5, px + 1.5, maxY, pz + 1.5);
                List hit = this.field_70170_p.func_217357_a(Entity.class, selection);
                for (Entity entity : hit) {
                    if (entity == this || entity instanceof FallingBlockEntity || entity == this.caster) continue;
                    float knockbackResistance = 0.0f;
                    if (entity instanceof LivingEntity) {
                        if (this.caster instanceof PlayerEntity) {
                            entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this.caster)), (factor * 5.0f + 1.0f) * (((Float)ConfigHandler.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.toolConfig.attackDamage.get()).floatValue() / 9.0f));
                        } else {
                            entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.caster), (factor * 5.0f + 1.0f) * (((Float)ConfigHandler.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.toolConfig.attackDamage.get()).floatValue() / 9.0f));
                        }
                        knockbackResistance = (float)((LivingEntity)entity).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
                    }
                    double magnitude = -0.2;
                    double x = vx * (double)(1.0f - factor) * magnitude * (double)(1.0f - knockbackResistance);
                    double y = 0.0;
                    if (entity.field_70122_E) {
                        y += 0.15 * (double)(1.0f - knockbackResistance);
                    }
                    double z = vz * (double)(1.0f - factor) * magnitude * (double)(1.0f - knockbackResistance);
                    entity.func_213317_d(entity.func_213322_ci().func_72441_c(x, y, z));
                    if (!(entity instanceof ServerPlayerEntity)) continue;
                    ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(entity));
                }
                if (!this.field_70170_p.field_73012_v.nextBoolean()) continue;
                int hitX = MathHelper.func_76128_c((double)px);
                int hitZ = MathHelper.func_76128_c((double)pz);
                BlockPos pos = new BlockPos(hitX, hitY, hitZ);
                BlockPos abovePos = new BlockPos((Vec3i)pos).func_177984_a();
                BlockState block = this.field_70170_p.func_180495_p(pos);
                BlockState blockAbove = this.field_70170_p.func_180495_p(abovePos);
                if (block.func_185904_a() == Material.field_151579_a || !block.func_215686_e((IBlockReader)this.field_70170_p, pos) || block.func_177230_c().hasTileEntity(block) || blockAbove.func_185904_a().func_76230_c()) continue;
                EntityFallingBlock fallingBlock = new EntityFallingBlock(EntityHandler.FALLING_BLOCK, this.field_70170_p, block, 0.3f);
                fallingBlock.func_70107_b((double)hitX + 0.5, hitY + 1, (double)hitZ + 0.5);
                this.field_70170_p.func_217376_c((Entity)fallingBlock);
            }
        }
        if (this.field_70173_aa > SWING_DURATION_HOR) {
            this.func_70106_y();
        }
    }

    private void dealDamage(float damage, float range, float arc, float knockback) {
        boolean hit = false;
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, 2.0, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.func_226281_cx_() - this.func_226281_cx_(), entityHit.func_226277_ct_() - this.func_226277_ct_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.field_70177_z % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.func_226281_cx_() - this.func_226281_cx_()) * (entityHit.func_226281_cx_() - this.func_226281_cx_()) + (entityHit.func_226277_ct_() - this.func_226277_ct_()) * (entityHit.func_226277_ct_() - this.func_226277_ct_()));
            if (!(entityHit != this.caster && entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f)) continue;
            PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)this.caster, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY);
            if (playerCapability != null) {
                playerCapability.setAxeCanAttack(true);
                if (this.caster instanceof PlayerEntity) {
                    ((PlayerEntity)this.caster).func_71059_n((Entity)entityHit);
                }
                playerCapability.setAxeCanAttack(false);
            } else {
                entityHit.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.caster), damage);
            }
            entityHit.func_213293_j(entityHit.func_213322_ci().field_72450_a * (double)knockback, entityHit.func_213322_ci().field_72448_b, entityHit.func_213322_ci().field_72449_c * (double)knockback);
            hit = true;
        }
        if (hit) {
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_WROUGHT_AXE_HIT.get(), 0.3f, 0.5f);
        }
    }

    public void setVertical(boolean vertical) {
        this.func_184212_Q().func_187227_b(VERTICAL, (Object)vertical);
    }

    public boolean getVertical() {
        return (Boolean)this.func_184212_Q().func_187225_a(VERTICAL);
    }

    private List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        ArrayList nearEntities = list.stream().filter(entityNeighbor -> entityNeighbor instanceof LivingEntity && (double)this.func_70032_d((Entity)entityNeighbor) <= radius).map(entityNeighbor -> (LivingEntity)entityNeighbor).collect(Collectors.toCollection(ArrayList::new));
        return nearEntities;
    }

    public LivingEntity getCaster() {
        return this.caster;
    }
}

