/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleVanillaCloudExtended;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.entity.naga.EntityNaga;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityPoisonBall
extends EntityMagicEffect
implements IProjectile {
    public static float GRAVITY = 0.05f;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;

    public EntityPoisonBall(EntityType<? extends EntityPoisonBall> type, World worldIn) {
        super(type, worldIn);
    }

    public EntityPoisonBall(EntityType<? extends EntityPoisonBall> type, World worldIn, LivingEntity caster) {
        super(type, worldIn);
        if (!this.field_70170_p.field_72995_K) {
            this.setCasterID(caster.func_145782_y());
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        this.func_213293_j(x * (double)velocity, y * (double)velocity, z * (double)velocity);
    }

    @Override
    public void func_70071_h_() {
        this.prevMotionX = this.func_213322_ci().field_72450_a;
        this.prevMotionY = this.func_213322_ci().field_72448_b;
        this.prevMotionZ = this.func_213322_ci().field_72449_c;
        super.func_70071_h_();
        this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, (double)GRAVITY, 0.0));
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.field_70177_z = -((float)MathHelper.func_181159_b((double)this.func_213322_ci().field_72450_a, (double)this.func_213322_ci().field_72449_c)) * 57.295776f;
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(1.0);
        if (!entitiesHit.isEmpty()) {
            for (LivingEntity entity : entitiesHit) {
                if (entity == this.caster || entity instanceof EntityNaga || !entity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.caster), 3.0f * ((Float)ConfigHandler.MOBS.NAGA.combatConfig.attackMultiplier.get()).floatValue())) continue;
                entity.func_195064_c(new EffectInstance(Effects.field_76436_u, 80, 1, false, true));
            }
        }
        if (!this.field_70170_p.func_226665_a__((Entity)this, this.func_174813_aQ().func_186662_g(0.1))) {
            this.explode();
        }
        if (this.field_70170_p.field_72995_K) {
            float scale = 1.0f;
            int steps = 4;
            double motionX = this.func_213322_ci().field_72450_a;
            double motionY = this.func_213322_ci().field_72448_b;
            double motionZ = this.func_213322_ci().field_72449_c;
            for (int step = 0; step < steps; ++step) {
                double life;
                double value;
                double zSpeed;
                double ySpeed;
                double xSpeed;
                int i;
                double x = this.field_70169_q + (double)step * (this.func_226277_ct_() - this.field_70169_q) / (double)steps;
                double y = this.field_70167_r + (double)step * (this.func_226278_cu_() - this.field_70167_r) / (double)steps + (double)(this.func_213302_cg() / 2.0f);
                double z = this.field_70166_s + (double)step * (this.func_226281_cx_() - this.field_70166_s) / (double)steps;
                for (i = 0; i < 1; ++i) {
                    xSpeed = (double)scale * 0.02 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    ySpeed = (double)scale * 0.02 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    zSpeed = (double)scale * 0.02 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    value = this.field_70146_Z.nextFloat() * 0.1f;
                    life = this.field_70146_Z.nextFloat() * 10.0f + 15.0f;
                    ParticleVanillaCloudExtended.spawnVanillaCloud(this.field_70170_p, x - motionX * 0.5, y - motionY * 0.5, z - motionZ * 0.5, xSpeed, ySpeed, zSpeed, scale, 0.25 + value, 0.75 + value, 0.25 + value, 0.99, life);
                }
                for (i = 0; i < 2; ++i) {
                    xSpeed = (double)scale * 0.06 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    ySpeed = (double)scale * 0.06 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    zSpeed = (double)scale * 0.06 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    value = this.field_70146_Z.nextFloat() * 0.1f;
                    life = this.field_70146_Z.nextFloat() * 5.0f + 10.0f;
                    AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), x + xSpeed - motionX * 0.5, y + ySpeed - motionY * 0.5, z + zSpeed - motionZ * 0.5, xSpeed, ySpeed, zSpeed, true, 0.0, 0.0, 0.0, 0.0, scale * 3.0f, 0.07 + value, 0.25 + value, 0.07 + value, 1.0, 0.99, life * 0.9, false);
                }
                for (i = 0; i < 1; ++i) {
                    if (!(this.field_70146_Z.nextFloat() < 0.9f)) continue;
                    xSpeed = (double)scale * 0.06 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    ySpeed = (double)scale * 0.06 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    zSpeed = (double)scale * 0.06 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    value = this.field_70146_Z.nextFloat() * 0.1f;
                    life = this.field_70146_Z.nextFloat() * 5.0f + 10.0f;
                    AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.BUBBLE.get()), x - motionX * 0.5, y - motionY * 0.5, z - motionZ * 0.5, xSpeed, ySpeed, zSpeed, true, 0.0, 0.0, 0.0, 0.0, 3.0, 0.25 + value, 0.75 + value, 0.25 + value, 1.0, 0.85, life, false);
                }
            }
        }
        if (this.field_70173_aa > 50) {
            this.func_70106_y();
        }
    }

    private void explode() {
        float explodeSpeed = 3.5f;
        if (this.field_70170_p.field_72995_K) {
            double life;
            double value;
            Vec3d particlePos;
            int i;
            for (i = 0; i < 26; ++i) {
                particlePos = new Vec3d((double)this.field_70146_Z.nextFloat() * 0.25, 0.0, 0.0);
                particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                value = this.field_70146_Z.nextFloat() * 0.1f;
                life = this.field_70146_Z.nextFloat() * 17.0f + 30.0f;
                ParticleVanillaCloudExtended.spawnVanillaCloud(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), particlePos.field_72450_a * (double)explodeSpeed, particlePos.field_72448_b * (double)explodeSpeed, particlePos.field_72449_c * (double)explodeSpeed, 1.0, 0.25 + value, 0.75 + value, 0.25 + value, 0.6, life);
            }
            for (i = 0; i < 26; ++i) {
                particlePos = new Vec3d((double)this.field_70146_Z.nextFloat() * 0.25, 0.0, 0.0);
                particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                value = this.field_70146_Z.nextFloat() * 0.1f;
                life = this.field_70146_Z.nextFloat() * 5.0f + 10.0f;
                AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), this.func_226277_ct_() + particlePos.field_72450_a, this.func_226278_cu_() + particlePos.field_72448_b, this.func_226281_cx_() + particlePos.field_72449_c, particlePos.field_72450_a * (double)explodeSpeed, particlePos.field_72448_b * (double)explodeSpeed, particlePos.field_72449_c * (double)explodeSpeed, true, 0.0, 0.0, 0.0, 0.0, 3.0, 0.07 + value, 0.25 + value, 0.07 + value, 1.0, 0.6, life * 0.95, false);
            }
            for (i = 0; i < 23; ++i) {
                particlePos = new Vec3d((double)this.field_70146_Z.nextFloat() * 0.25, 0.0, 0.0);
                particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                value = this.field_70146_Z.nextFloat() * 0.1f;
                life = this.field_70146_Z.nextFloat() * 10.0f + 20.0f;
                AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.BUBBLE.get()), this.func_226277_ct_() + particlePos.field_72450_a, this.func_226278_cu_() + particlePos.field_72448_b, this.func_226281_cx_() + particlePos.field_72449_c, particlePos.field_72450_a * (double)explodeSpeed, particlePos.field_72448_b * (double)explodeSpeed, particlePos.field_72449_c * (double)explodeSpeed, true, 0.0, 0.0, 0.0, 0.0, 3.0, 0.25 + value, 0.75 + value, 0.25 + value, 1.0, 0.6, life * 0.95, false);
            }
        }
        this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_ACID_HIT.get(), 1.0f, 1.0f);
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(2.0);
        if (!entitiesHit.isEmpty()) {
            for (LivingEntity entity : entitiesHit) {
                if (entity == this.caster || entity instanceof EntityNaga || !entity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.caster), 3.0f * ((Float)ConfigHandler.MOBS.NAGA.combatConfig.attackMultiplier.get()).floatValue())) continue;
                entity.func_195064_c(new EffectInstance(Effects.field_76436_u, 80, 0, false, true));
            }
        }
        this.func_70106_y();
    }
}

