/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.foliaath;

import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.client.model.tools.IntermittentAnimation;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityBabyFoliaath;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class EntityFoliaath
extends MowzieEntity
implements IMob {
    public static final Animation DIE_ANIMATION = Animation.create(50);
    public static final Animation HURT_ANIMATION = Animation.create(10);
    public static final Animation ATTACK_ANIMATION = Animation.create(14);
    private static final DataParameter<Boolean> CAN_DESPAWN = EntityDataManager.func_187226_a(EntityFoliaath.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ACTIVATE_TARGET = EntityDataManager.func_187226_a(EntityFoliaath.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int ACTIVATE_DURATION = 30;
    public IntermittentAnimation<EntityFoliaath> openMouth;
    public ControlledAnimation activate;
    public ControlledAnimation deathFlail;
    public ControlledAnimation stopDance;
    public int lastTimeDecrease;
    private int resettingTargetTimer;
    private double prevOpenMouth;
    private double prevActivate;
    private int activateTarget;

    public EntityFoliaath(EntityType<? extends EntityFoliaath> type, World world) {
        super(type, world);
        this.openMouth = new IntermittentAnimation<EntityFoliaath>(this, 15, 30, 50, !this.field_70170_p.field_72995_K);
        this.activate = new ControlledAnimation(30);
        this.deathFlail = new ControlledAnimation(5);
        this.stopDance = new ControlledAnimation(10);
        this.lastTimeDecrease = 0;
        this.resettingTargetTimer = 0;
        this.field_70728_aV = 10;
        this.addIntermittentAnimation(this.openMouth);
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, new AnimationAttackAI<EntityFoliaath>(this, ATTACK_ANIMATION, (SoundEvent)MMSounds.ENTITY_FOLIAATH_BITE_1.get(), null, 2.0f, 4.0f, ((Float)ConfigHandler.MOBS.FOLIAATH.combatConfig.attackMultiplier.get()).floatValue(), 3));
        this.field_70714_bg.func_75776_a(1, new AnimationTakeDamage<EntityFoliaath>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationDieAI<EntityFoliaath>(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, true, false, e -> (PlayerEntity.class.isAssignableFrom(e.getClass()) || CreatureEntity.class.isAssignableFrom(e.getClass())) && !(e instanceof EntityFoliaath) && !(e instanceof EntityBabyFoliaath)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(CAN_DESPAWN, (Object)true);
        this.func_184212_Q().func_187214_a(ACTIVATE_TARGET, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(10.0f * ((Float)ConfigHandler.MOBS.FOLIAATH.combatConfig.healthMultiplier.get()).floatValue()));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)MMSounds.ENTITY_FOLIAATH_HURT.get();
    }

    public SoundEvent func_184615_bR() {
        return (SoundEvent)MMSounds.ENTITY_FOLIAATH_DIE.get();
    }

    public boolean func_70104_M() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        int openMouthTime;
        super.func_70071_h_();
        this.func_213293_j(0.0, this.func_213322_ci().field_72448_b, 0.0);
        if (this.getAnimation() == NO_ANIMATION && !this.activate.canIncreaseTimer()) {
            this.openMouth.update();
        } else {
            this.openMouth.stop();
        }
        if (this.activate.getAnimationFraction() >= 0.8f) {
            if (!this.active) {
                this.active = true;
            }
        } else if (this.activate.getAnimationFraction() < 0.8f && this.active) {
            this.active = false;
        }
        if (this.frame % 13 == 3 && this.getAnimation() != DIE_ANIMATION) {
            if (this.openMouth.getTimeRunning() >= 10) {
                this.func_184185_a((SoundEvent)MMSounds.ENTITY_FOLIAATH_PANT_1.get(), 1.0f, 1.0f);
            } else if (this.activate.getTimer() >= 25) {
                this.func_184185_a((SoundEvent)MMSounds.ENTITY_FOLIAATH_PANT_2.get(), 1.0f, 1.0f);
            }
        }
        if (this.prevOpenMouth - (double)(openMouthTime = this.openMouth.getTimeRunning()) < 0.0) {
            if (openMouthTime == 1) {
                this.func_184185_a((SoundEvent)MMSounds.ENTITY_FOLIAATH_RUSTLE.get(), 1.0f, 1.0f);
            } else if (openMouthTime == 13) {
                this.func_184185_a((SoundEvent)MMSounds.ENTITY_FOLIAATH_GRUNT.get(), 1.0f, 1.0f);
            }
        }
        this.prevOpenMouth = openMouthTime;
        int activateTime = this.activate.getTimer();
        if (!this.field_70170_p.field_72995_K) {
            SoundEvent sound = null;
            if (this.prevActivate - (double)activateTime < 0.0) {
                switch (activateTime) {
                    case 1: {
                        sound = (SoundEvent)MMSounds.ENTITY_FOLIAATH_RUSTLE.get();
                        break;
                    }
                    case 5: {
                        sound = (SoundEvent)MMSounds.ENTITY_FOLIAATH_MERGE.get();
                    }
                }
            } else if (this.prevActivate - (double)activateTime > 0.0) {
                switch (activateTime) {
                    case 24: {
                        sound = (SoundEvent)MMSounds.ENTITY_FOLIAATH_RETREAT.get();
                        break;
                    }
                    case 28: {
                        sound = (SoundEvent)MMSounds.ENTITY_FOLIAATH_RUSTLE.get();
                    }
                }
            }
            if (sound != null) {
                this.func_184185_a(sound, 1.0f, 1.0f);
            }
        }
        this.prevActivate = activateTime;
        this.field_70761_aq = 0.0f;
        this.field_70177_z = 0.0f;
        if (this.resettingTargetTimer > 0 && !this.field_70170_p.field_72995_K) {
            this.field_70759_as = this.field_70758_at;
        }
        if (this.func_70638_az() != null) {
            this.field_70759_as = this.targetAngle;
            if (this.targetDistance <= 4.0f && this.func_70638_az().func_226278_cu_() - this.func_226278_cu_() >= -1.0 && this.func_70638_az().func_226278_cu_() - this.func_226278_cu_() <= 2.0 && this.getAnimation() == NO_ANIMATION && this.active) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, ATTACK_ANIMATION);
            }
            if ((double)this.targetDistance <= 10.5 && this.func_70638_az().func_226278_cu_() - this.func_226278_cu_() >= -1.5 && this.func_70638_az().func_226278_cu_() - this.func_226278_cu_() <= 2.0) {
                this.setActivateTarget(30);
                this.lastTimeDecrease = 0;
            } else if (this.lastTimeDecrease <= 30 && this.getAnimation() == NO_ANIMATION) {
                this.setActivateTarget(0);
                ++this.lastTimeDecrease;
            }
        } else if (!this.field_70170_p.field_72995_K && this.lastTimeDecrease <= 30 && this.getAnimation() == NO_ANIMATION && this.resettingTargetTimer == 0) {
            this.setActivateTarget(0);
            ++this.lastTimeDecrease;
        }
        if (this.getAnimation() == DIE_ANIMATION) {
            if (this.getAnimationTick() <= 12) {
                this.deathFlail.increaseTimer();
            } else {
                this.deathFlail.decreaseTimer();
            }
            this.stopDance.increaseTimer();
            this.setActivateTarget(30);
        }
        if (this.resettingTargetTimer > 0) {
            --this.resettingTargetTimer;
        }
        if (this.func_70638_az() != null && this.frame % 20 == 0 && this.getAnimation() == NO_ANIMATION) {
            this.func_70624_b(null);
            this.resettingTargetTimer = 20;
        }
        if (this.activateTarget == activateTime) {
            this.activateTarget = this.getActivateTarget();
        } else if (activateTime < this.activateTarget && this.activate.canIncreaseTimer() || activateTime > this.activateTarget && this.activate.canDecreaseTimer()) {
            this.activate.increaseTimer(activateTime < this.activateTarget ? 1 : -2);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float amount) {
        this.openMouth.resetTimeRunning();
        return (damageSource.func_76357_e() || this.active) && super.func_70097_a(damageSource, amount);
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    protected ConfigHandler.SpawnConfig getSpawnConfig() {
        return ConfigHandler.MOBS.FOLIAATH.spawnConfig;
    }

    @Override
    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        Biome biome = world.func_226691_t_(this.func_180425_c());
        int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
        BlockPos pos = new BlockPos(i, j, k);
        Block floor = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        BlockState floorDown1 = world.func_180495_p(pos.func_177979_c(2));
        BlockState floorDown2 = world.func_180495_p(pos.func_177979_c(3));
        boolean notInTree = true;
        if (floor instanceof LeavesBlock && floorDown1 != biome.func_205401_q().field_215454_b.func_204108_a() && floorDown2 != biome.func_205401_q().field_215454_b.func_204108_a()) {
            notInTree = false;
        }
        return super.func_213380_a(world, reason) && notInTree && this.getEntitiesNearby(AnimalEntity.class, 5.0, 5.0, 5.0, 5.0).isEmpty() && world.func_175659_aa() != Difficulty.PEACEFUL;
    }

    public void func_70074_a(LivingEntity entity) {
        this.func_195064_c(new EffectInstance(Effects.field_76428_l, 300, 1, true, true));
    }

    public boolean func_213392_I() {
        return (Boolean)this.func_184212_Q().func_187225_a(CAN_DESPAWN) == false;
    }

    public void setCanDespawn(boolean canDespawn) {
        this.func_184212_Q().func_187227_b(CAN_DESPAWN, (Object)canDespawn);
    }

    public int getActivateTarget() {
        return (Integer)this.func_184212_Q().func_187225_a(ACTIVATE_TARGET);
    }

    public void setActivateTarget(int activateTarget) {
        this.func_184212_Q().func_187227_b(ACTIVATE_TARGET, (Object)activateTarget);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("canDespawn", ((Boolean)this.func_184212_Q().func_187225_a(CAN_DESPAWN)).booleanValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCanDespawn(compound.func_74767_n("canDespawn"));
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{DIE_ANIMATION, HURT_ANIMATION, ATTACK_ANIMATION};
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.FOLIAATH;
    }
}

