/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.grottol;

import com.bobmowzie.mowziesmobs.server.entity.grottol.BlackPinkInYourArea;
import java.util.function.Consumer;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public final class BlackPinkRailLine
implements Consumer<AbstractMinecartEntity> {
    private final BlackPinkInYourArea action;
    private State state = new StateAcquireVertex();

    private BlackPinkRailLine(BlackPinkInYourArea action) {
        this.action = action;
    }

    @Override
    public void accept(AbstractMinecartEntity minecart) {
        this.state = this.next(minecart.field_70170_p, minecart);
    }

    private State next(World world, AbstractMinecartEntity minecart) {
        BlockPos pos = BlackPinkRailLine.getRailPosition(world, new BlockPos((Entity)minecart));
        if (AbstractRailBlock.func_208487_j((BlockState)world.func_180495_p(pos))) {
            return this.state.apply(world, minecart, pos);
        }
        return this.state.derail();
    }

    private static BlockPos getRailPosition(World world, BlockPos pos) {
        BlockPos below = pos.func_177977_b();
        return AbstractRailBlock.func_208488_a((World)world, (BlockPos)below) ? below : pos;
    }

    public static BlackPinkRailLine create() {
        return new BlackPinkRailLine(BlackPinkInYourArea.create());
    }

    private final class StateSearch
    extends State {
        private final long[] mask;
        private final long test = 0x10000000000000L;
        private Vec3i edge;
        private BlockPos vertex;
        private int ordinal;
        private long state;

        private StateSearch(Vec3i edge, BlockPos vertex) {
            this.mask = new long[]{1151706154984090261L, 1149919144941647226L, 1152921487426969583L, 1152635631447310335L};
            this.test = 0x10000000000000L;
            this.state = 0xFFFFFFFFFFFFEL;
            this.edge = edge;
            this.vertex = vertex;
        }

        @Override
        public State apply(World world, AbstractMinecartEntity minecart, BlockPos vertex) {
            if (!this.vertex.equals((Object)vertex)) {
                BlockPos edge = vertex.func_177973_b((Vec3i)this.vertex);
                int ordinal = this.getOrdinal(this.edge, (Vec3i)edge);
                if (ordinal >= 0 && ordinal < 4 && (ordinal != 1 || ordinal != this.ordinal) && ((this.state = (this.state | this.mask[ordinal]) << 1) & 0x10000000000000L) == 0L) {
                    BlackPinkRailLine.this.action.accept(world, minecart);
                }
                this.ordinal = ordinal;
                this.vertex = vertex;
                this.edge = edge;
            }
            return this;
        }

        private int getOrdinal(Vec3i v0, Vec3i v1) {
            return 1 + (v1.func_177952_p() * v0.func_177958_n() - v1.func_177958_n() * v0.func_177952_p()) + (v0.func_177958_n() * v1.func_177958_n() + v0.func_177952_p() * v1.func_177952_p() & 2);
        }

        @Override
        State derail() {
            return new StateAcquireVertex();
        }
    }

    private final class StateAcquireEdge
    extends State {
        private BlockPos vertex;

        private StateAcquireEdge(BlockPos vertex) {
            this.vertex = vertex;
        }

        @Override
        public State apply(World world, AbstractMinecartEntity minecart, BlockPos vertex) {
            return new StateSearch((Vec3i)vertex.func_177973_b((Vec3i)this.vertex), vertex);
        }

        @Override
        State derail() {
            return new StateAcquireVertex();
        }
    }

    private final class StateAcquireVertex
    extends State {
        private StateAcquireVertex() {
        }

        @Override
        public State apply(World world, AbstractMinecartEntity minecart, BlockPos vertex) {
            return new StateAcquireEdge(vertex);
        }

        @Override
        State derail() {
            return this;
        }
    }

    private abstract class State {
        private State() {
        }

        abstract State apply(World var1, AbstractMinecartEntity var2, BlockPos var3);

        abstract State derail();
    }
}

