/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.naga;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.client.model.tools.dynamics.DynamicChain;
import com.bobmowzie.mowziesmobs.client.particle.ParticleVanillaCloudExtended;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationProjectileAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.SimpleAnimationAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityPoisonBall;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.google.common.base.Supplier;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityNaga
extends MowzieEntity
implements IRangedAttackMob,
IMob,
IFlyingAnimal {
    @OnlyIn(value=Dist.CLIENT)
    public DynamicChain dc;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3d[] mouthPos;
    public static final Animation FLAP_ANIMATION = Animation.create(25);
    public static final Animation DODGE_ANIMATION = Animation.create(10);
    public static final Animation SPIT_ANIMATION = Animation.create(50);
    public static final Animation SWOOP_ANIMATION = Animation.create(54);
    public static final Animation HURT_TO_FALL_ANIMATION = Animation.create(20);
    public static final Animation LAND_ANIMATION = Animation.create(8);
    public static final Animation GET_UP_ANIMATION = Animation.create(33);
    public static final Animation TAIL_DEMO_ANIMATION = Animation.create(80);
    public static final Animation DIE_AIR_ANIMATION = Animation.create(70);
    public static final Animation DIE_GROUND_ANIMATION = Animation.create(70);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityNaga.class, (IDataSerializer)DataSerializers.field_187198_h);
    private ControlledAnimation hoverAnim = new ControlledAnimation(10);
    private ControlledAnimation flapAnim = new ControlledAnimation(10);
    public float hoverAnimFrac;
    public float prevHoverAnimFrac;
    public float flapAnimFrac;
    public float prevFlapAnimFrac;
    private boolean hasFlapSoundPlayed = false;
    @OnlyIn(value=Dist.CLIENT)
    public float shoulderRot;
    public static final int ROAR_DURATION = 30;
    public int roarAnimation = 0;
    public EnumNagaMovement movement = EnumNagaMovement.GLIDING;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;
    public static int SPIT_COOLDOWN_MAX = 120;
    public int spitCooldown = 0;
    public static int SWOOP_COOLDOWN_MAX = 90;
    public int swoopCooldown = 0;
    public float swoopTargetCorrectY;
    public float swoopTargetCorrectX;
    public static int GROUND_TIMER_MAX = 60;
    public int onGroundTimer = 0;
    public boolean interrupted = false;

    public EntityNaga(EntityType<? extends EntityNaga> type, World world) {
        super(type, world);
        if (world.field_72995_K) {
            this.dc = new DynamicChain((Entity)this);
            this.mouthPos = new Vec3d[]{new Vec3d(0.0, 0.0, 0.0)};
        }
        this.field_70728_aV = 10;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70714_bg.func_75776_a(5, (Goal)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new AIFlyAroundTarget(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new AILookAround(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, true, false, null));
        this.field_70714_bg.func_75776_a(2, (Goal)new SimpleAnimationAI<EntityNaga>(this, FLAP_ANIMATION, false){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityNaga.this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_FLAP_1.get(), 2.0f, (float)(0.85 + (double)EntityNaga.this.field_70146_Z.nextFloat() * 0.2));
            }

            public void func_75246_d() {
                super.func_75246_d();
                if (EntityNaga.this.getAnimationTick() >= 4 && EntityNaga.this.getAnimationTick() <= 9) {
                    EntityNaga.this.func_213317_d(EntityNaga.this.func_213322_ci().func_72441_c(0.0, 0.1, 0.0));
                }
            }
        });
        this.field_70714_bg.func_75776_a(2, new SimpleAnimationAI<EntityNaga>(this, DODGE_ANIMATION, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimationProjectileAttackAI<EntityNaga>(this, SPIT_ANIMATION, 30, null){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityNaga.this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_ACID_CHARGE.get(), 2.0f, 1.0f);
            }

            @Override
            public void func_75246_d() {
                super.func_75246_d();
                if (EntityNaga.this.interrupted) {
                    return;
                }
                if (EntityNaga.this.getAnimationTick() < 9) {
                    EntityNaga.this.func_213317_d(EntityNaga.this.func_213322_ci().func_72441_c(0.0, 0.015, 0.0));
                }
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new SimpleAnimationAI<EntityNaga>(this, SWOOP_ANIMATION, true){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityNaga.this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_FLAP_1.get(), 2.0f, 0.7f);
            }

            public void func_75246_d() {
                super.func_75246_d();
                if (EntityNaga.this.interrupted) {
                    return;
                }
                Vec3d v = new Vec3d(0.0, 0.0, 0.0);
                int phase1Length = 15;
                int phase2Length = 21;
                if (EntityNaga.this.getAnimationTick() < 23 + phase2Length) {
                    LivingEntity target = EntityNaga.this.func_70638_az();
                    if (EntityNaga.this.getAnimationTick() >= 1 && EntityNaga.this.getAnimationTick() < 1 + phase1Length) {
                        float frame = (float)(EntityNaga.this.getAnimationTick() - 1) / (float)phase1Length;
                        v = v.func_178787_e(new Vec3d((double)1.9f * Math.sin((double)frame * Math.PI * 2.0) * (double)frame, (double)-1.9f * Math.sin((double)frame * Math.PI * 2.0) * (double)frame, (double)0.8f * Math.sin((double)frame * Math.PI * 2.0)));
                    } else if (EntityNaga.this.getAnimationTick() >= 16) {
                        if (target != null) {
                            ((EntityNaga)this.entity).field_70749_g.func_75651_a((Entity)target, 30.0f, 30.0f);
                        }
                        if (EntityNaga.this.getAnimationTick() == 23) {
                            if (target != null) {
                                EntityNaga.this.swoopTargetCorrectY = 0.09f * (float)Math.abs(EntityNaga.this.func_226278_cu_() - target.func_226278_cu_());
                                EntityNaga.this.swoopTargetCorrectX = 0.1f * (float)Math.sqrt((EntityNaga.this.func_226277_ct_() - target.func_226277_ct_()) * (EntityNaga.this.func_226277_ct_() - target.func_226277_ct_()) + (EntityNaga.this.func_226281_cx_() - target.func_226281_cx_()) * (EntityNaga.this.func_226281_cx_() - target.func_226281_cx_()));
                                if (EntityNaga.this.swoopTargetCorrectX > 1.8f) {
                                    EntityNaga.this.swoopTargetCorrectX = 1.8f;
                                }
                                if (EntityNaga.this.swoopTargetCorrectY > 2.0f) {
                                    EntityNaga.this.swoopTargetCorrectY = 2.0f;
                                }
                            } else {
                                EntityNaga.this.swoopTargetCorrectY = 1.0f;
                                EntityNaga.this.swoopTargetCorrectX = 1.0f;
                            }
                        }
                        if (EntityNaga.this.getAnimationTick() >= 23 && EntityNaga.this.getAnimationTick() < 23 + phase2Length) {
                            float frame = (float)(EntityNaga.this.getAnimationTick() - 23) / (float)phase2Length;
                            v = v.func_178787_e(new Vec3d((double)EntityNaga.this.swoopTargetCorrectX * 1.4 * (1.0 - Math.exp(2.0f * (frame - 1.0f))), (double)EntityNaga.this.swoopTargetCorrectY * -1.5 * (Math.cos((double)frame * Math.PI) * (1.0 - Math.exp(7.0f * (frame - 1.0f)))), 0.0));
                            List<LivingEntity> entitiesHit = EntityNaga.this.getEntityLivingBaseNearby(4.0, 4.0, 4.0, 4.0);
                            for (LivingEntity entityHit : entitiesHit) {
                                if (entityHit instanceof EntityNaga) continue;
                                EntityNaga.this.func_70652_k((Entity)entityHit);
                            }
                        }
                    }
                    v = v.func_178785_b((float)Math.toRadians(-EntityNaga.this.field_70177_z - 90.0f));
                    EntityNaga.this.func_213293_j(v.field_72450_a, v.field_72448_b, v.field_72449_c);
                }
                if (EntityNaga.this.getAnimationTick() == 22) {
                    MowziesMobs.PROXY.playNagaSwoopSound((EntityNaga)this.entity);
                }
                if (EntityNaga.this.getAnimationTick() == 7) {
                    EntityNaga.this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_GRUNT_3.get(), 2.0f, 1.0f);
                }
                if (EntityNaga.this.getAnimationTick() == 22) {
                    EntityNaga.this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_ROAR_1.get(), 3.0f, 1.0f);
                }
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new SimpleAnimationAI<EntityNaga>(this, HURT_TO_FALL_ANIMATION, true){

            public void func_75246_d() {
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new SimpleAnimationAI<EntityNaga>(this, LAND_ANIMATION, true){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityNaga.this.func_184185_a((SoundEvent)MMSounds.MISC_GROUNDHIT_2.get(), 1.5f, 1.0f);
            }
        });
        this.field_70714_bg.func_75776_a(1, (Goal)new SimpleAnimationAI<EntityNaga>(this, GET_UP_ANIMATION, true){

            public void func_75246_d() {
                super.func_75246_d();
                if (EntityNaga.this.getAnimationTick() == 13) {
                    EntityNaga.this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_FLAP_1.get(), 2.0f, 1.0f);
                }
                if (EntityNaga.this.getAnimationTick() == 15) {
                    EntityNaga.this.func_213317_d(EntityNaga.this.func_213322_ci().func_72441_c(0.0, 1.6, 0.0));
                }
            }
        });
        this.field_70714_bg.func_75776_a(2, new SimpleAnimationAI<EntityNaga>(this, TAIL_DEMO_ANIMATION, false));
        this.field_70765_h = new NagaMoveHelper(this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ATTACKING, (Object)false);
    }

    public boolean func_70112_a(double distance) {
        return distance < 16600.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return super.func_184177_bl().func_186662_g(12.0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0 * (double)((Float)ConfigHandler.MOBS.NAGA.combatConfig.healthMultiplier.get()).floatValue());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0 * (double)((Float)ConfigHandler.MOBS.NAGA.combatConfig.attackMultiplier.get()).floatValue());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(45.0);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.getAnimation() != NO_ANIMATION) {
            return null;
        }
        int r = this.field_70146_Z.nextInt(4);
        if (r == 0) {
            this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_NAGA_ROAR.get(this.field_70146_Z.nextInt(4))).get(), 5.0f, 1.0f);
            this.roarAnimation = 0;
        } else if (r <= 2) {
            this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_NAGA_GROWL.get(this.field_70146_Z.nextInt(3))).get(), 4.0f, 1.0f);
        }
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_NAGA_GRUNT.get(this.field_70146_Z.nextInt(3))).get(), 2.0f, 1.0f);
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_NAGA_ROAR.get(this.field_70146_Z.nextInt(4))).get(), 3.0f, 1.0f);
        return null;
    }

    @Override
    public void func_70071_h_() {
        this.prevMotionX = this.func_213322_ci().field_72450_a;
        this.prevMotionY = this.func_213322_ci().field_72448_b;
        this.prevMotionZ = this.func_213322_ci().field_72449_c;
        this.prevHoverAnimFrac = this.hoverAnimFrac;
        this.prevFlapAnimFrac = this.flapAnimFrac;
        super.func_70071_h_();
        this.field_70761_aq = this.field_70177_z;
        if (this.spitCooldown > 0) {
            --this.spitCooldown;
        }
        if (this.swoopCooldown > 0) {
            --this.swoopCooldown;
        }
        if (this.onGroundTimer > 0) {
            --this.onGroundTimer;
        }
        if (this.roarAnimation < 30) {
            ++this.roarAnimation;
        }
        if (this.getAnimation() == null) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, NO_ANIMATION);
        }
        if (this.func_70644_a(Effects.field_76436_u)) {
            this.func_184596_c(Effects.field_76436_u);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() != null && (double)this.targetDistance < 29.5 && this.movement != EnumNagaMovement.FALLEN && this.movement != EnumNagaMovement.FALLING) {
                this.setAttacking(true);
                if (this.getAnimation() == NO_ANIMATION && this.swoopCooldown == 0 && this.field_70146_Z.nextInt(80) == 0 && this.func_226278_cu_() - this.func_70638_az().func_226278_cu_() > 0.0) {
                    this.interrupted = false;
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, SWOOP_ANIMATION);
                    this.swoopCooldown = SWOOP_COOLDOWN_MAX;
                } else if (this.getAnimation() == NO_ANIMATION && this.spitCooldown == 0 && this.field_70146_Z.nextInt(80) == 0) {
                    this.interrupted = false;
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, SPIT_ANIMATION);
                    this.spitCooldown = SPIT_COOLDOWN_MAX;
                }
            } else {
                this.setAttacking(false);
            }
        }
        if (this.movement != EnumNagaMovement.FALLING && this.movement != EnumNagaMovement.FALLEN) {
            if (this.getAttacking()) {
                this.movement = EnumNagaMovement.HOVERING;
                this.hoverAnim.increaseTimer();
                if (this.getAnimation() == NO_ANIMATION && !this.field_70170_p.field_72995_K) {
                    List<AbstractArrowEntity> arrowsNearby = this.getEntitiesNearby(AbstractArrowEntity.class, 30.0);
                    for (AbstractArrowEntity a : arrowsNearby) {
                        float dot;
                        Vec3d aActualMotion = new Vec3d(a.func_226277_ct_() - a.field_70169_q, a.func_226278_cu_() - a.field_70167_r, a.func_226281_cx_() - a.field_70166_s);
                        if (aActualMotion.func_72433_c() < 0.1 || a.field_70173_aa <= 1 || !((double)(dot = (float)a.func_213322_ci().func_72432_b().func_72430_b(this.func_174791_d().func_178788_d(a.func_174791_d()).func_72432_b())) > 0.96)) continue;
                        Vec3d dodgeVec = this.func_213322_ci().func_72431_c(new Vec3d(0.0, 1.0, 0.0)).func_72432_b().func_186678_a(1.2);
                        Vec3d newPosLeft = this.func_174791_d().func_178787_e(dodgeVec.func_186678_a(2.0));
                        Vec3d newPosRight = this.func_174791_d().func_178787_e(dodgeVec.func_186678_a(-2.0));
                        Vec3d diffLeft = newPosLeft.func_178788_d(a.func_174791_d());
                        Vec3d diffRight = newPosRight.func_178788_d(a.func_174791_d());
                        if (diffRight.func_72430_b(this.func_213322_ci()) > diffLeft.func_72430_b(this.func_213322_ci())) {
                            dodgeVec = dodgeVec.func_186678_a(-1.0);
                        }
                        this.func_213317_d(this.func_213322_ci().func_178787_e(dodgeVec));
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, DODGE_ANIMATION);
                    }
                }
            } else {
                this.movement = EnumNagaMovement.GLIDING;
                this.hoverAnim.decreaseTimer();
                this.flapAnim.decreaseTimer();
            }
        } else if (this.movement == EnumNagaMovement.FALLING && (this.field_70122_E || this.func_180799_ab() || this.func_70090_H())) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, LAND_ANIMATION);
            this.movement = EnumNagaMovement.FALLEN;
            this.onGroundTimer = GROUND_TIMER_MAX;
            this.func_213293_j(0.0, this.func_213322_ci().field_72448_b, 0.0);
            this.func_70661_as().func_75499_g();
        }
        if (this.movement == EnumNagaMovement.FALLEN && this.onGroundTimer <= 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimationTick(0);
            AnimationHandler.INSTANCE.sendAnimationMessage(this, GET_UP_ANIMATION);
        }
        if (this.getAnimation() == SWOOP_ANIMATION && this.getAnimationTick() < 43) {
            this.hoverAnim.increaseTimer();
            this.flapAnim.decreaseTimer();
        } else if (this.getAnimation() == HURT_TO_FALL_ANIMATION) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else if (this.getAnimation() == LAND_ANIMATION) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else if (this.getAnimation() == GET_UP_ANIMATION && this.getAnimationTick() < 26) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else if (this.movement == EnumNagaMovement.FALLEN) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
            this.field_70177_z = this.field_70126_B;
            this.field_70759_as = this.field_70758_at;
            this.field_70125_A = this.field_70127_C;
        } else if (this.movement == EnumNagaMovement.FALLING) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else {
            this.flapAnim.increaseTimer();
        }
        if (this.getAnimation() == SPIT_ANIMATION && this.field_70170_p.field_72995_K && this.mouthPos != null && !this.interrupted) {
            Vec3d particlePos;
            if (this.getAnimationTick() == 33) {
                float explodeSpeed = 2.4f;
                for (int i = 0; i < 25; ++i) {
                    particlePos = new Vec3d(0.25, 0.0, 0.0);
                    particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    double value = this.field_70146_Z.nextFloat() * 0.1f;
                    double life = this.field_70146_Z.nextFloat() * 10.0f + 20.0f;
                    ParticleVanillaCloudExtended.spawnVanillaCloud(this.field_70170_p, particlePos.field_72450_a + this.mouthPos[0].field_72450_a, particlePos.field_72448_b + this.mouthPos[0].field_72448_b, particlePos.field_72449_c + this.mouthPos[0].field_72449_c, particlePos.field_72450_a * (double)explodeSpeed, particlePos.field_72448_b * (double)explodeSpeed, particlePos.field_72449_c * (double)explodeSpeed, 1.0, 0.25 + value, 0.75 + value, 0.25 + value, 0.6, life);
                }
            }
            if (this.getAnimationTick() <= 15 && this.mouthPos != null && !this.interrupted) {
                int howMany = 4;
                for (int i = 0; i < howMany; ++i) {
                    particlePos = new Vec3d(3.0, 0.0, 0.0);
                    particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    double value = this.field_70146_Z.nextFloat() * 0.15f;
                    ParticleVanillaCloudExtended.spawnVanillaCloudDestination(this.field_70170_p, particlePos.field_72450_a + this.mouthPos[0].field_72450_a, particlePos.field_72448_b + this.mouthPos[0].field_72448_b, particlePos.field_72449_c + this.mouthPos[0].field_72449_c, 0.0, 0.0, 0.0, 1.0, 0.25 + value, 0.75 + value, 0.25 + value, 0.9, 15.0, this.mouthPos);
                }
            }
        }
        if (this.getAnimation() == HURT_TO_FALL_ANIMATION && this.getAnimationTick() == 17) {
            this.movement = EnumNagaMovement.FALLING;
        }
        if (this.getAnimation() == GET_UP_ANIMATION && this.getAnimationTick() == 26) {
            this.movement = EnumNagaMovement.HOVERING;
        }
        if (this.field_70170_p.field_72995_K && this.movement == EnumNagaMovement.HOVERING && (double)this.flapAnim.getAnimationFraction() >= 0.5) {
            if ((double)this.shoulderRot > 0.9) {
                this.hasFlapSoundPlayed = false;
            }
            if ((double)this.shoulderRot <= 0.7 && !this.hasFlapSoundPlayed) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)MMSounds.ENTITY_NAGA_FLAP_1.get(), SoundCategory.HOSTILE, 2.0f, (float)(0.85 + (double)this.field_70146_Z.nextFloat() * 0.2), false);
                this.hasFlapSoundPlayed = true;
            }
        }
        this.hoverAnimFrac = this.hoverAnim.getAnimationProgressSinSqrt();
        this.flapAnimFrac = this.flapAnim.getAnimationProgressSinSqrt();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    @Override
    protected ConfigHandler.SpawnConfig getSpawnConfig() {
        return ConfigHandler.MOBS.NAGA.spawnConfig;
    }

    @Override
    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        boolean flag = super.func_213380_a(world, reason);
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 5.0, this.func_226281_cx_());
        return flag && world.func_175659_aa() != Difficulty.PEACEFUL;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        boolean liquid = !this.field_70170_p.func_72953_d(this.func_174813_aQ());
        boolean worldCollision = this.field_70170_p.func_226665_a__((Entity)this, this.func_174813_aQ());
        boolean mobCollision = this.field_70170_p.func_226668_i_((Entity)this);
        return liquid && worldCollision && mobCollision;
    }

    @Override
    protected void onDeathAIUpdate() {
        super.onDeathAIUpdate();
        if (this.field_70725_aQ == 15 && this.movement != EnumNagaMovement.FALLEN) {
            this.movement = EnumNagaMovement.FALLING;
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        boolean isSwooping;
        boolean flag = super.func_70097_a(source, damage);
        boolean isSpitting = this.getAnimation() == SPIT_ANIMATION && this.getAnimationTick() < 30;
        boolean bl = isSwooping = this.getAnimation() == SWOOP_ANIMATION && this.getAnimationTick() < 25;
        if (flag && this.movement != EnumNagaMovement.FALLING && (isSpitting || isSwooping)) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, HURT_TO_FALL_ANIMATION);
            this.interrupted = true;
        }
        return flag;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (this.interrupted) {
            return;
        }
        Vec3d projectilePos = new Vec3d(1.0, -0.7, 0.0);
        projectilePos = projectilePos.func_178785_b((float)Math.toRadians(-this.field_70177_z - 90.0f));
        projectilePos = projectilePos.func_178787_e(this.func_174791_d());
        projectilePos = projectilePos.func_178787_e(new Vec3d(0.0, 0.0, 1.0).func_178789_a((float)Math.toRadians(-this.field_70125_A)).func_178785_b((float)Math.toRadians(-this.field_70759_as)));
        projectilePos = projectilePos.func_178787_e(new Vec3d(0.0, 0.0, 0.0));
        EntityPoisonBall poisonBall = new EntityPoisonBall(EntityHandler.POISON_BALL, this.field_70170_p, (LivingEntity)this);
        poisonBall.func_70107_b(projectilePos.field_72450_a, projectilePos.field_72448_b, projectilePos.field_72449_c);
        Vec3d look = this.func_70040_Z();
        Vec3d dir = new Vec3d(look.field_72450_a, 0.0, look.field_72449_c).func_72432_b();
        if (target != null) {
            float dy = (float)(projectilePos.field_72448_b - target.func_226278_cu_());
            float dx = (float)(projectilePos.field_72450_a - target.func_226277_ct_());
            float dz = (float)(projectilePos.field_72449_c - target.func_226281_cx_());
            float dist = (float)Math.sqrt(dx * dx + dz * dz);
            float timeGuess = (float)Math.sqrt(2.0f * dy / EntityPoisonBall.GRAVITY);
            float speed = Math.min(dist / timeGuess, 0.9f);
            poisonBall.func_70186_c(dir.field_72450_a * (double)speed, 0.1, dir.field_72449_c * (double)speed, 1.0f, 0.0f);
        }
        this.field_70170_p.func_217376_c((Entity)poisonBall);
        this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_ACID_SPIT.get(), 2.0f, 1.0f);
        this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_ACID_SPIT_HISS.get(), 2.0f, 1.0f);
    }

    @Override
    public Animation getDeathAnimation() {
        if (this.movement == EnumNagaMovement.FALLEN) {
            return DIE_GROUND_ANIMATION;
        }
        return DIE_AIR_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return null;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{FLAP_ANIMATION, DODGE_ANIMATION, SWOOP_ANIMATION, SPIT_ANIMATION, HURT_TO_FALL_ANIMATION, LAND_ANIMATION, GET_UP_ANIMATION, DIE_AIR_ANIMATION, DIE_GROUND_ANIMATION, TAIL_DEMO_ANIMATION};
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (this.movement == EnumNagaMovement.FALLING) {
            return super.func_225503_b_(distance, damageMultiplier);
        }
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (this.movement == EnumNagaMovement.FALLING) {
            super.func_184231_a(y, onGroundIn, state, pos);
        }
    }

    public void func_213352_e(Vec3d motion) {
        double d0 = 0.08;
        IAttributeInstance gravity = this.func_110148_a(ENTITY_GRAVITY);
        boolean flag = this.func_213322_ci().field_72448_b <= 0.0;
        d0 = gravity.func_111126_e();
        if (this.func_70090_H()) {
            this.func_213309_a(0.02f, motion);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)0.8f));
        } else if (this.func_180799_ab()) {
            this.func_213309_a(0.02f, motion);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
        } else if (this.movement == EnumNagaMovement.HOVERING) {
            BlockPos ground = new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b - 1.0, this.func_226281_cx_());
            float f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            this.func_213309_a(this.field_70122_E ? 0.1f * f1 : 0.02f, motion);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)f));
            MovementController entitymovehelper = this.func_70605_aq();
            double dx = entitymovehelper.func_179917_d() - this.func_226277_ct_();
            double dy = entitymovehelper.func_179919_e() - this.func_226278_cu_();
            double dz = entitymovehelper.func_179918_f() - this.func_226281_cx_();
            double distanceToDest = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (distanceToDest < 0.1 && this.getAnimation() == NO_ANIMATION) {
                this.func_213293_j(0.0, 0.0, 0.0);
            }
        } else if (this.movement == EnumNagaMovement.GLIDING) {
            Vec3d vec3d3 = this.func_213322_ci();
            if (vec3d3.field_72448_b > -0.5) {
                this.field_70143_R = 1.0f;
            }
            Vec3d vec3d = this.func_70040_Z();
            float f6 = this.field_70125_A * ((float)Math.PI / 180);
            double d9 = Math.sqrt(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c);
            double d11 = Math.sqrt(EntityNaga.func_213296_b((Vec3d)vec3d3));
            double d12 = vec3d.func_72433_c();
            float f3 = MathHelper.func_76134_b((float)f6);
            f3 = (float)((double)f3 * (double)f3 * Math.min(1.0, d12 / 0.4));
            vec3d3 = this.func_213322_ci().func_72441_c(0.0, d0 * (-1.0 + (double)f3 * 0.75), 0.0);
            if (vec3d3.field_72448_b < 0.0 && d9 > 0.0) {
                double d3 = vec3d3.field_72448_b * -0.1 * (double)f3;
                vec3d3 = vec3d3.func_72441_c(vec3d.field_72450_a * d3 / d9, d3, vec3d.field_72449_c * d3 / d9);
            }
            if (f6 < 0.0f && d9 > 0.0) {
                double d13 = d11 * (double)(-MathHelper.func_76126_a((float)f6)) * 0.04;
                vec3d3 = vec3d3.func_72441_c(-vec3d.field_72450_a * d13 / d9, d13 * 3.2, -vec3d.field_72449_c * d13 / d9);
            }
            if (d9 > 0.0) {
                vec3d3 = vec3d3.func_72441_c((vec3d.field_72450_a / d9 * d11 - vec3d3.field_72450_a) * 0.1, 0.0, (vec3d.field_72449_c / d9 * d11 - vec3d3.field_72449_c) * 0.1);
            }
            this.func_213317_d(vec3d3.func_216372_d((double)0.99f, (double)0.98f, (double)0.99f));
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (this.func_70605_aq().func_179919_e() - this.func_226278_cu_() > 0.0 && this.getAnimation() == NO_ANIMATION) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, FLAP_ANIMATION);
            }
        } else if (this.movement == EnumNagaMovement.FALLING || this.movement == EnumNagaMovement.FALLEN || this.func_175446_cd()) {
            BlockPos blockpos = new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b - 1.0, this.func_226281_cx_());
            float f5 = this.field_70170_p.func_180495_p(blockpos).getSlipperiness((IWorldReader)this.field_70170_p, blockpos, (Entity)this);
            float f7 = this.field_70122_E ? f5 * 0.91f : 0.91f;
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            Vec3d vec3d5 = this.func_213322_ci();
            if ((this.field_70123_F || this.field_70703_bu) && this.func_70617_f_()) {
                vec3d5 = new Vec3d(vec3d5.field_72450_a, 0.2, vec3d5.field_72449_c);
            }
            double d10 = vec3d5.field_72448_b;
            if (this.func_70644_a(Effects.field_188424_y)) {
                d10 += (0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1) - vec3d5.field_72448_b) * 0.2;
                this.field_70143_R = 0.0f;
            } else if (this.field_70170_p.field_72995_K && !this.field_70170_p.func_175667_e(blockpos)) {
                d10 = this.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
            } else if (!this.func_189652_ae()) {
                d10 -= d0;
            }
            this.func_213293_j(vec3d5.field_72450_a * (double)f7, d10 * (double)0.98f, vec3d5.field_72449_c * (double)f7);
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d5 = this.func_226277_ct_() - this.field_70169_q;
        double d6 = this.func_226281_cx_() - this.field_70166_s;
        double d8 = this.func_226278_cu_() - this.field_70167_r;
        float f8 = MathHelper.func_76133_a((double)(d5 * d5 + d8 * d8 + d6 * d6)) * 4.0f;
        if (f8 > 1.0f) {
            f8 = 1.0f;
        }
        this.field_70721_aZ += (f8 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    public boolean getAttacking() {
        return (Boolean)this.func_184212_Q().func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.func_184212_Q().func_187227_b(ATTACKING, (Object)attacking);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.NAGA;
    }

    static class NagaMoveHelper
    extends MovementController {
        private final EntityNaga parentEntity;
        private int courseChangeCooldown;

        public NagaMoveHelper(EntityNaga naga) {
            super((MobEntity)naga);
            this.parentEntity = naga;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                Vec3d vec3d = new Vec3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                double d0 = vec3d.func_72433_c();
                if (this.func_220673_a(vec3d = vec3d.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vec3d.func_186678_a(0.1)));
                } else {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            }
        }

        private boolean func_220673_a(Vec3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.field_70170_p.func_226665_a__((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    static class AIFlyAroundTarget
    extends Goal {
        private final EntityNaga parentEntity;

        public AIFlyAroundTarget(EntityNaga naga) {
            this.parentEntity = naga;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            MovementController entitymovehelper = this.parentEntity.func_70605_aq();
            if (this.parentEntity.func_70638_az() != null) {
                if (!entitymovehelper.func_75640_a()) {
                    return true;
                }
                double dx = entitymovehelper.func_179917_d() - this.parentEntity.func_226277_ct_();
                double dy = entitymovehelper.func_179919_e() - this.parentEntity.func_226278_cu_();
                double dz = entitymovehelper.func_179918_f() - this.parentEntity.func_226281_cx_();
                double distanceToDest = Math.sqrt(dx * dx + dy * dy + dz * dz);
                LivingEntity target = this.parentEntity.func_70638_az();
                double dx2 = entitymovehelper.func_179917_d() - target.func_226277_ct_();
                double dy2 = entitymovehelper.func_179919_e() - target.func_226278_cu_();
                double dz2 = entitymovehelper.func_179918_f() - target.func_226281_cx_();
                double distanceDestToTarget = Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2);
                boolean randomChance = this.parentEntity.field_70146_Z.nextInt(60) == 0;
                return distanceToDest > 60.0 || distanceDestToTarget > 20.0 || distanceDestToTarget < 5.0 || randomChance;
            }
            return false;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            LivingEntity target = this.parentEntity.func_70638_az();
            float yaw = (float)((double)random.nextFloat() * Math.PI * 2.0);
            float radius = 16.0f;
            double d0 = target.func_226277_ct_() + Math.cos(yaw) * (double)radius;
            double d1 = target.func_226278_cu_() + 8.0 + (double)(random.nextFloat() * 5.0f);
            double d2 = target.func_226281_cx_() + Math.sin(yaw) * (double)radius;
            double speed = this.parentEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, speed);
        }
    }

    static class AIRandomFly
    extends Goal {
        private final EntityNaga parentEntity;

        public AIRandomFly(EntityNaga naga) {
            this.parentEntity = naga;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController entitymovehelper = this.parentEntity.func_70605_aq();
            if (this.parentEntity.getAttacking()) {
                return false;
            }
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.func_226278_cu_()) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.func_226281_cx_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 24.0f);
            double d1 = this.parentEntity.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 24.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, this.parentEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
        }
    }

    static class AILookAround
    extends Goal {
        private final EntityNaga parentEntity;

        public AILookAround(EntityNaga naga) {
            this.parentEntity = naga;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                Vec3d motion = this.parentEntity.func_213322_ci();
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c)) * 57.295776f;
            } else {
                LivingEntity entitylivingbase = this.parentEntity.func_70638_az();
                if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 1600.0) {
                    double d1 = entitylivingbase.func_226277_ct_() - this.parentEntity.func_226277_ct_();
                    double d2 = entitylivingbase.func_226281_cx_() - this.parentEntity.func_226281_cx_();
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    public static enum EnumNagaMovement {
        GLIDING,
        HOVERING,
        SWIMMING,
        FALLING,
        FALLEN;

    }
}

