/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.wroughtnaut;

import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.server.ai.MMPathNavigateGround;
import com.bobmowzie.mowziesmobs.server.ai.WroughtnautAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationActivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDeactivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationFWNAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationFWNStompAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationFWNVerticalAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.SmartBodyHelper;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EntityWroughtnaut
extends MowzieEntity
implements IMob {
    public static final Animation DIE_ANIMATION = Animation.create(130);
    public static final Animation HURT_ANIMATION = Animation.create(15);
    public static final Animation ATTACK_ANIMATION = Animation.create(50);
    public static final Animation ATTACK_TWICE_ANIMATION = Animation.create(36);
    public static final Animation ATTACK_THRICE_ANIMATION = Animation.create(59);
    public static final Animation VERTICAL_ATTACK_ANIMATION = Animation.create(105);
    public static final Animation STOMP_ATTACK_ANIMATION = Animation.create(40);
    public static final Animation ACTIVATE_ANIMATION = Animation.create(45);
    public static final Animation DEACTIVATE_ANIMATION = Animation.create(15);
    private static final Animation[] ANIMATIONS = new Animation[]{DIE_ANIMATION, HURT_ANIMATION, ATTACK_ANIMATION, ATTACK_TWICE_ANIMATION, ATTACK_THRICE_ANIMATION, VERTICAL_ATTACK_ANIMATION, STOMP_ATTACK_ANIMATION, ACTIVATE_ANIMATION, DEACTIVATE_ANIMATION};
    private static final float[][] VERTICAL_ATTACK_BLOCK_OFFSETS = new float[][]{{-0.1f, -0.1f}, {-0.1f, 0.1f}, {0.1f, 0.1f}, {0.1f, -0.1f}};
    private static final DataParameter<Optional<BlockPos>> REST_POSITION = EntityDataManager.func_187226_a(EntityWroughtnaut.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Boolean> ACTIVE = EntityDataManager.func_187226_a(EntityWroughtnaut.class, (IDataSerializer)DataSerializers.field_187198_h);
    public ControlledAnimation walkAnim = new ControlledAnimation(10);
    public boolean swingDirection;
    public boolean vulnerable;
    private CeilingDisturbance disturbance;
    public Vec3d leftEyePos;
    public Vec3d rightEyePos;
    public Vec3d leftEyeRot;
    public Vec3d rightEyeRot;

    public EntityWroughtnaut(EntityType<? extends EntityWroughtnaut> type, World world) {
        super(type, world);
        this.field_70728_aV = 30;
        this.active = false;
        this.field_70138_W = 1.0f;
        this.dropAfterDeathAnim = true;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new AnimationFWNAttackAI(this, 4.0f, 5.0f, 100.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new AnimationFWNVerticalAttackAI(this, VERTICAL_ATTACK_ANIMATION, (SoundEvent)MMSounds.ENTITY_WROUGHT_WHOOSH.get(), 1.0f, 5.0f, 40.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new AnimationFWNStompAttackAI(this, STOMP_ATTACK_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationTakeDamage<EntityWroughtnaut>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationDieAI<EntityWroughtnaut>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationActivateAI<EntityWroughtnaut>(this, ACTIVATE_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationDeactivateAI<EntityWroughtnaut>(this, DEACTIVATE_ANIMATION));
        this.field_70714_bg.func_75776_a(2, (Goal)new WroughtnautAttackAI(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, true, false, null));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.98f;
    }

    protected PathNavigator func_175447_b(World world) {
        return new MMPathNavigateGround(this, world);
    }

    protected BodyController func_184650_s() {
        return new SmartBodyHelper((MobEntity)this);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)MMSounds.ENTITY_WROUGHT_HURT_1.get();
    }

    public SoundEvent func_184615_bR() {
        this.func_184185_a((SoundEvent)MMSounds.ENTITY_WROUGHT_SCREAM.get(), 1.0f, 1.0f);
        return null;
    }

    protected SoundEvent func_184639_G() {
        return this.getAnimation() == NO_ANIMATION && this.isActive() ? (SoundEvent)MMSounds.ENTITY_WROUGHT_AMBIENT.get() : null;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(40.0f * ((Float)ConfigHandler.MOBS.FERROUS_WROUGHTNAUT.combatConfig.healthMultiplier.get()).floatValue()));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(30.0);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entitySource = source.func_76346_g();
        if (entitySource != null) {
            if (!(this.active && this.func_70638_az() != null || !(entitySource instanceof LivingEntity) || entitySource instanceof PlayerEntity && ((PlayerEntity)entitySource).func_184812_l_() || entitySource instanceof EntityWroughtnaut)) {
                this.func_70624_b((LivingEntity)entitySource);
            }
            if (this.vulnerable) {
                float entityRelativeAngle;
                int arc = 220;
                float entityHitAngle = (float)((Math.atan2(entitySource.func_226281_cx_() - this.func_226281_cx_(), entitySource.func_226277_ct_() - this.func_226277_ct_()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = this.field_70761_aq % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                if ((entityRelativeAngle = entityHitAngle - entityAttackingAngle) <= (float)arc / 2.0f && entityRelativeAngle >= (float)(-arc) / 2.0f || entityRelativeAngle >= 360.0f - (float)arc / 2.0f || entityRelativeAngle <= (float)(-arc) + 45.0f) {
                    this.func_184185_a((SoundEvent)MMSounds.ENTITY_WROUGHT_UNDAMAGED.get(), 0.4f, 2.0f);
                    return false;
                }
                this.setAnimation(NO_ANIMATION);
                return super.func_70097_a(source, amount);
            }
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_WROUGHT_UNDAMAGED.get(), 0.4f, 2.0f);
        } else if (source.func_76357_e()) {
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    public boolean func_90999_ad() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70638_az() != null && (!this.func_70638_az().func_70089_S() || this.func_70638_az().func_110143_aJ() <= 0.0f)) {
            this.func_70624_b(null);
        }
        if (!this.field_70170_p.field_72995_K && this.getAnimation() == NO_ANIMATION && !this.func_175446_cd()) {
            if (this.isActive()) {
                if (this.func_70638_az() == null && this.field_191988_bg == 0.0f && this.isAtRestPos()) {
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, DEACTIVATE_ANIMATION);
                    this.setActive(false);
                }
            } else if (this.func_70638_az() != null && (double)this.targetDistance <= 4.5) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_ANIMATION);
                this.setActive(true);
            }
        }
        if (!this.isActive()) {
            this.func_213293_j(0.0, this.func_213322_ci().field_72448_b, 0.0);
            this.field_70177_z = this.field_70126_B;
        }
        this.field_70761_aq = this.field_70177_z;
        if (this.func_70638_az() == null && this.func_70661_as().func_75500_f() && !this.isAtRestPos() && this.isActive()) {
            this.updateRestPos();
        }
        if (this.getAnimation() == ATTACK_ANIMATION && this.getAnimationTick() == 1) {
            this.swingDirection = this.field_70146_Z.nextBoolean();
        } else if (this.getAnimation() == ACTIVATE_ANIMATION) {
            int tick = this.getAnimationTick();
            if (tick == 1) {
                this.func_184185_a((SoundEvent)MMSounds.ENTITY_WROUGHT_GRUNT_2.get(), 1.0f, 1.0f);
            } else if (tick == 27 || tick == 44) {
                this.func_184185_a((SoundEvent)MMSounds.ENTITY_WROUGHT_STEP.get(), 0.5f, 0.5f);
            }
        } else if (this.getAnimation() == VERTICAL_ATTACK_ANIMATION && this.getAnimationTick() == 29) {
            this.doVerticalAttackHitFX();
        } else if (this.getAnimation() == STOMP_ATTACK_ANIMATION) {
            this.doStompFX();
        }
        float moveX = (float)(this.func_226277_ct_() - this.field_70169_q);
        float moveZ = (float)(this.func_226281_cx_() - this.field_70166_s);
        float speed = MathHelper.func_76129_c((float)(moveX * moveX + moveZ * moveZ));
        if ((double)speed > 0.01) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.walkAnim.increaseTimer();
            }
        } else {
            this.walkAnim.decreaseTimer();
        }
        if (this.getAnimation() != NO_ANIMATION) {
            this.walkAnim.decreaseTimer(2);
        }
        if (this.field_70170_p.field_72995_K && this.frame % 20 == 1 && (double)speed > 0.03 && this.getAnimation() == NO_ANIMATION && this.isActive()) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)MMSounds.ENTITY_WROUGHT_STEP.get(), this.func_184176_by(), 0.5f, 0.5f, false);
        }
        this.repelEntities(1.7f, 4.0f, 1.7f, 1.7f);
        if (!this.active && !this.field_70170_p.field_72995_K && this.getAnimation() != ACTIVATE_ANIMATION && ((Boolean)ConfigHandler.MOBS.FERROUS_WROUGHTNAUT.healsOutOfBattle.get()).booleanValue()) {
            this.func_70691_i(0.3f);
        }
        if (this.disturbance != null && this.disturbance.update()) {
            this.disturbance = null;
        }
    }

    @Override
    protected void repelEntities(float x, float y, float z, float radius) {
        super.repelEntities(x, y, z, radius);
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    private boolean isAtRestPos() {
        Optional<BlockPos> restPos = this.getRestPos();
        if (restPos.isPresent()) {
            return restPos.get().func_177951_i((Vec3i)this.func_180425_c()) < 36.0;
        }
        return false;
    }

    private void updateRestPos() {
        boolean reassign = true;
        if (this.getRestPos().isPresent()) {
            BlockPos pos = this.getRestPos().get();
            if (this.func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.2)) {
                reassign = false;
            }
        }
        if (reassign) {
            this.setRestPos(this.func_180425_c());
        }
    }

    private void doVerticalAttackHitFX() {
        float strength;
        double theta = (double)(this.field_70761_aq - 4.0f) * (Math.PI / 180);
        double perpX = Math.cos(theta);
        double perpZ = Math.sin(theta);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        double x = this.func_226277_ct_() + 4.2 * vecX;
        double y = this.func_174813_aQ().field_72338_b + 0.1;
        double z = this.func_226281_cx_() + 4.2 * vecZ;
        int hitY = MathHelper.func_76128_c((double)(this.func_226278_cu_() - 0.2));
        for (int t = 0; t < VERTICAL_ATTACK_BLOCK_OFFSETS.length; ++t) {
            int hitZ;
            float ox = VERTICAL_ATTACK_BLOCK_OFFSETS[t][0];
            float oy = VERTICAL_ATTACK_BLOCK_OFFSETS[t][1];
            int hitX = MathHelper.func_76128_c((double)(x + (double)ox));
            BlockPos hit = new BlockPos(hitX, hitY, hitZ = MathHelper.func_76128_c((double)(z + (double)oy)));
            BlockState block = this.field_70170_p.func_180495_p(hit);
            if (block.func_185901_i() == BlockRenderType.INVISIBLE) continue;
            for (int n = 0; n < 6; ++n) {
                double pa = this.field_70146_Z.nextDouble() * 2.0 * Math.PI;
                double pd = this.field_70146_Z.nextDouble() * 0.6 + 0.1;
                double px = x + Math.cos(pa) * pd;
                double pz = z + Math.sin(pa) * pd;
                double magnitude = this.field_70146_Z.nextDouble() * 4.0 + 5.0;
                double velX = perpX * magnitude;
                double velY = this.field_70146_Z.nextDouble() * 3.0 + 6.0;
                double velZ = perpZ * magnitude;
                if (vecX * (pz - this.func_226281_cx_()) - vecZ * (px - this.func_226277_ct_()) > 0.0) {
                    velX = -velX;
                    velZ = -velZ;
                }
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, block), px, y, pz, velX, velY, velZ);
            }
        }
        int hitX = MathHelper.func_76128_c((double)x);
        int ceilY = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72337_e);
        int hitZ = MathHelper.func_76128_c((double)z);
        int maxHeight = 5;
        int height = 5;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        while (height-- > 0) {
            pos.func_181079_c(hitX, ceilY, hitZ);
            if (this.field_70170_p.func_180495_p((BlockPos)pos).func_185904_a().func_76230_c()) break;
            ++ceilY;
        }
        if ((strength = (float)height / 5.0f) >= 0.0f) {
            int radius = MathHelper.func_76123_f((float)(MathHelper.func_76129_c((float)(1.0f - strength * strength)) * 5.0f));
            this.disturbance = new CeilingDisturbance(hitX, ceilY, hitZ, radius, this.field_70146_Z.nextInt(5) + 3, this.field_70146_Z.nextInt(60) + 20);
        }
    }

    private void doStompFX() {
        double perpFacing = (double)this.field_70761_aq * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int tick = this.getAnimationTick();
        int maxDistance = 6;
        if (tick > 9 && tick < 17) {
            if (tick == 12) {
                double infront = 1.47;
                double side = -0.21;
                double vx = Math.cos(facingAngle) * 1.47;
                double vz = Math.sin(facingAngle) * 1.47;
                double perpX = Math.cos(perpFacing);
                double perpZ = Math.sin(perpFacing);
                double fx = this.func_226277_ct_() + vx + perpX * -0.21;
                double fy = this.func_174813_aQ().field_72338_b + 0.1;
                double fz = this.func_226281_cx_() + vz + perpZ * -0.21;
                int amount = 16 + this.field_70170_p.field_73012_v.nextInt(8);
                while (amount-- > 0) {
                    double theta = this.field_70170_p.field_73012_v.nextDouble() * Math.PI * 2.0;
                    double dist = this.field_70170_p.field_73012_v.nextDouble() * 0.1 + 0.25;
                    double sx = Math.cos(theta);
                    double sz = Math.sin(theta);
                    double px = fx + sx * dist;
                    double py = fy + this.field_70170_p.field_73012_v.nextDouble() * 0.1;
                    double pz = fz + sz * dist;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, px, py, pz, sx * 0.065, 0.0, sz * 0.065);
                }
            }
            if (tick % 2 == 0) {
                int distance = tick / 2 - 2;
                double spread = Math.PI * 2;
                int arcLen = MathHelper.func_76143_f((double)((double)distance * spread));
                for (int i = 0; i < arcLen; ++i) {
                    double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
                    double vx = Math.cos(theta);
                    double vz = Math.sin(theta);
                    double px = this.func_226277_ct_() + vx * (double)distance;
                    double pz = this.func_226281_cx_() + vz * (double)distance;
                    float factor = 1.0f - (float)distance / 6.0f;
                    if (!this.field_70170_p.field_73012_v.nextBoolean()) continue;
                    int amount = this.field_70170_p.field_73012_v.nextInt(5);
                    while (amount-- > 0) {
                        double velX = vx * 0.075;
                        double velY = (double)factor * 0.3 + 0.025;
                        double velZ = vz * 0.075;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, px + (double)(this.field_70170_p.field_73012_v.nextFloat() * 2.0f) - 1.0, this.func_174813_aQ().field_72338_b + 0.1 + (double)this.field_70170_p.field_73012_v.nextFloat() * 1.5, pz + (double)(this.field_70170_p.field_73012_v.nextFloat() * 2.0f) - 1.0, velX, velY, velZ);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingData, @Nullable CompoundNBT compound) {
        this.setRestPos(this.func_180425_c());
        return super.func_213386_a(world, difficulty, reason, livingData, compound);
    }

    public boolean func_213392_I() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(REST_POSITION, Optional.empty());
        this.func_184212_Q().func_187214_a(ACTIVE, (Object)false);
    }

    public Optional<BlockPos> getRestPos() {
        return (Optional)this.func_184212_Q().func_187225_a(REST_POSITION);
    }

    public void setRestPos(BlockPos pos) {
        this.func_184212_Q().func_187227_b(REST_POSITION, Optional.of(pos));
    }

    public boolean isActive() {
        return (Boolean)this.func_184212_Q().func_187225_a(ACTIVE);
    }

    public void setActive(boolean isActive) {
        this.func_184212_Q().func_187227_b(ACTIVE, (Object)isActive);
    }

    @Override
    public void writeSpawnData(PacketBuffer buf) {
        super.writeSpawnData(buf);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        Optional<BlockPos> restPos = this.getRestPos();
        if (restPos.isPresent()) {
            compound.func_218657_a("restPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getRestPos().get()));
        }
        compound.func_74757_a("active", this.isActive());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("restPos", 10)) {
            this.setRestPos(NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("restPos")));
        }
        this.setActive(compound.func_74767_n("active"));
        this.active = this.isActive();
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
    }

    @Override
    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.FERROUS_WROUGHTNAUT;
    }

    @Override
    protected boolean hasBossBar() {
        return (Boolean)ConfigHandler.MOBS.FERROUS_WROUGHTNAUT.hasBossBar.get();
    }

    @Override
    protected BossInfo.Color bossBarColor() {
        return BossInfo.Color.RED;
    }

    private class CeilingDisturbance {
        private final int ceilX;
        private final int ceilY;
        private final int ceilZ;
        private final int radius;
        private int delay;
        private int remainingTicks;
        private int duration;

        public CeilingDisturbance(int x, int y, int z, int radius, int delay, int remainingTicks) {
            this.ceilX = x;
            this.ceilY = y;
            this.ceilZ = z;
            this.radius = radius;
            this.delay = delay;
            this.remainingTicks = remainingTicks;
            this.duration = remainingTicks;
        }

        public boolean update() {
            if (--this.delay > 0) {
                return false;
            }
            float t = (float)this.remainingTicks / (float)this.duration;
            int amount = MathHelper.func_76123_f((float)((1.0f - MathHelper.func_76129_c((float)(1.0f - t * t))) * (float)this.radius * (float)this.radius * 0.15f));
            boolean playSound = true;
            BlockPos.Mutable pos = new BlockPos.Mutable();
            while (amount-- > 0) {
                double theta = EntityWroughtnaut.this.field_70146_Z.nextDouble() * Math.PI * 2.0;
                double dist = EntityWroughtnaut.this.field_70146_Z.nextDouble() * (double)this.radius;
                double x = (double)this.ceilX + Math.cos(theta) * dist;
                double y = (double)this.ceilY - 0.1 - EntityWroughtnaut.this.field_70146_Z.nextDouble() * 0.3;
                double z = (double)this.ceilZ + Math.sin(theta) * dist;
                int blockX = MathHelper.func_76128_c((double)x);
                int blockZ = MathHelper.func_76128_c((double)z);
                pos.func_181079_c(blockX, this.ceilY, blockZ);
                BlockState block = EntityWroughtnaut.this.field_70170_p.func_180495_p((BlockPos)pos);
                if (block.func_185901_i() == BlockRenderType.INVISIBLE) continue;
                EntityWroughtnaut.this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, block), x, y, z, 0.0, 0.0, 0.0);
                if (!playSound || !(EntityWroughtnaut.this.field_70146_Z.nextFloat() < 0.075f)) continue;
                SoundType sound = block.func_177230_c().getSoundType(block, (IWorldReader)EntityWroughtnaut.this.field_70170_p, (BlockPos)pos, null);
                EntityWroughtnaut.this.field_70170_p.func_184134_a(EntityWroughtnaut.this.func_226277_ct_(), EntityWroughtnaut.this.func_226278_cu_(), EntityWroughtnaut.this.func_226281_cx_(), sound.func_185845_c(), SoundCategory.BLOCKS, sound.func_185843_a() * 2.0f, sound.func_185847_b() * 0.6f, false);
                playSound = false;
            }
            return --this.remainingTicks <= 0;
        }
    }
}

