/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ToolItem;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemSpear
extends ToolItem {
    public ItemSpear(Item.Properties properties) {
        super(-2.0f + ((Float)ConfigHandler.TOOLS_AND_ABILITIES.BARAKOA_SPEAR.toolConfig.attackDamage.get()).floatValue(), -4.0f + ((Float)ConfigHandler.TOOLS_AND_ABILITIES.BARAKOA_SPEAR.toolConfig.attackSpeed.get()).floatValue(), (IItemTier)ItemTier.STONE, (Set)Sets.newHashSet(), properties);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnchantmentType.WEAPON || enchantment.field_77351_y == EnchantmentType.BREAKABLE || enchantment.field_77351_y == EnchantmentType.ALL;
    }

    public boolean func_77644_a(ItemStack heldItemStack, LivingEntity entityHit, LivingEntity player) {
        heldItemStack.func_222118_a(2, player, p -> p.func_213361_c(EquipmentSlotType.MAINHAND));
        if (entityHit instanceof AnimalEntity && entityHit.func_110138_aP() <= 30.0f && (double)field_77697_d.nextFloat() <= 0.33) {
            entityHit.func_70606_j(0.0f);
        }
        return true;
    }

    public static LivingEntity raytraceEntities(World world, PlayerEntity player, double range) {
        double collidePosZ;
        double collidePosY;
        double collidePosX;
        HitResult result = new HitResult();
        Vec3d pos = new Vec3d(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_());
        Vec3d segment = player.func_70040_Z();
        segment = pos.func_72441_c(segment.field_72450_a * range, segment.field_72448_b * range, segment.field_72449_c * range);
        result.setBlockHit((RayTraceResult)world.func_217299_a(new RayTraceContext(pos, segment, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player)));
        if (result.blockHit != null) {
            collidePosX = ((HitResult)result).blockHit.func_216347_e().field_72450_a;
            collidePosY = ((HitResult)result).blockHit.func_216347_e().field_72448_b;
            collidePosZ = ((HitResult)result).blockHit.func_216347_e().field_72449_c;
        } else {
            Vec3d end = player.func_70040_Z().func_186678_a(range).func_178787_e(pos);
            collidePosX = end.field_72450_a;
            collidePosY = end.field_72448_b;
            collidePosZ = end.field_72449_c;
        }
        List entities = world.func_217357_a(LivingEntity.class, new AxisAlignedBB(Math.min(pos.field_72450_a, collidePosX), Math.min(pos.field_72448_b, collidePosY), Math.min(pos.field_72449_c, collidePosZ), Math.max(pos.field_72450_a, collidePosX), Math.max(pos.field_72448_b, collidePosY), Math.max(pos.field_72449_c, collidePosZ)).func_72314_b(1.0, 1.0, 1.0));
        LivingEntity closest = null;
        for (LivingEntity entity : entities) {
            if (entity == player) continue;
            float pad = entity.func_70111_Y();
            AxisAlignedBB aabb = entity.func_174813_aQ().func_72314_b((double)pad, (double)pad, (double)pad);
            boolean hit = aabb.func_189973_a(pos, segment);
            if (!aabb.func_72318_a(pos) && !hit) continue;
            result.addEntityHit(entity);
            if (closest != null && !(player.func_70032_d((Entity)closest) > player.func_70032_d((Entity)entity))) continue;
            closest = entity;
        }
        return closest;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".text.0", new Object[0]));
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".text.1", new Object[0]));
    }

    public static class HitResult {
        private RayTraceResult blockHit;
        private List<LivingEntity> entities = new ArrayList<LivingEntity>();

        public RayTraceResult getBlockHit() {
            return this.blockHit;
        }

        public void setBlockHit(RayTraceResult blockHit) {
            this.blockHit = blockHit;
        }

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }
}

