/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.message;

import com.bobmowzie.mowziesmobs.client.sound.BlackPinkSound;
import com.bobmowzie.mowziesmobs.server.block.BlockGrottol;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public final class MessageBlackPinkInYourArea {
    private int entityID;

    public MessageBlackPinkInYourArea() {
    }

    public MessageBlackPinkInYourArea(AbstractMinecartEntity minecart) {
        this(minecart.func_145782_y());
    }

    private MessageBlackPinkInYourArea(int entityId) {
        this.entityID = entityId;
    }

    public static void serialize(MessageBlackPinkInYourArea message, PacketBuffer buf) {
        buf.func_150787_b(message.entityID);
    }

    public static MessageBlackPinkInYourArea deserialize(PacketBuffer buf) {
        MessageBlackPinkInYourArea message = new MessageBlackPinkInYourArea();
        message.entityID = buf.func_150792_a();
        return message;
    }

    public static class Handler
    implements BiConsumer<MessageBlackPinkInYourArea, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(MessageBlackPinkInYourArea message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                Entity entity = world.func_73045_a(message.entityID);
                if (entity instanceof AbstractMinecartEntity) {
                    AbstractMinecartEntity minecart = (AbstractMinecartEntity)entity;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new BlackPinkSound(minecart));
                    BlockState state = (BlockState)Blocks.field_150348_b.func_176223_P().func_206870_a(BlockGrottol.VARIANT, (Comparable)((Object)BlockGrottol.Variant.BLACK_PINK));
                    BlockPos pos = new BlockPos((Entity)minecart);
                    float scale = 0.75f;
                    double x = minecart.func_226277_ct_();
                    double y = minecart.func_226278_cu_() + 0.375 + 0.5 + (double)((float)(minecart.func_94085_r() - 8) / 16.0f * 0.75f);
                    double z = minecart.func_226281_cx_();
                    SoundType sound = state.func_177230_c().getSoundType(state, (IWorldReader)world, pos, (Entity)minecart);
                    world.func_184134_a(x, y, z, sound.func_185845_c(), minecart.func_184176_by(), (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f, false);
                    int size = 3;
                    float offset = -0.375f;
                    for (int ix = 0; ix < 3; ++ix) {
                        for (int iy = 0; iy < 3; ++iy) {
                            for (int iz = 0; iz < 3; ++iz) {
                                double dx = (double)ix / 3.0 * 0.75;
                                double dy = (double)iy / 3.0 * 0.75;
                                double dz = (double)iz / 3.0 * 0.75;
                                Vec3d minecartMotion = minecart.func_213322_ci();
                                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new DiggingParticle((World)world, x + dx + (double)offset, y + dy + (double)offset, z + dz + (double)offset, dx + minecartMotion.func_82615_a(), dy + minecartMotion.func_82617_b(), dz + minecartMotion.func_82616_c(), state){}.func_174846_a(pos));
                            }
                        }
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

