/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.message;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleVanillaCloudExtended;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageDaggerCrit {
    private int targetID;
    private int attackerID;

    public MessageDaggerCrit() {
    }

    public MessageDaggerCrit(LivingEntity target, LivingEntity attacker) {
        this.targetID = target.func_145782_y();
        this.attackerID = attacker.func_145782_y();
    }

    public static void serialize(MessageDaggerCrit message, PacketBuffer buf) {
        buf.func_150787_b(message.targetID);
        buf.func_150787_b(message.attackerID);
    }

    public static MessageDaggerCrit deserialize(PacketBuffer buf) {
        MessageDaggerCrit message = new MessageDaggerCrit();
        message.targetID = buf.func_150792_a();
        message.attackerID = buf.func_150792_a();
        return message;
    }

    public static class Handler
    implements BiConsumer<MessageDaggerCrit, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(MessageDaggerCrit message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.targetID);
                Entity attacker = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.attackerID);
                if (target != null && attacker != null) {
                    double life;
                    double value;
                    Vec3d particlePos;
                    int i;
                    Vec3d ringOffset = attacker.func_70040_Z().func_186678_a((double)(-target.func_213311_cf() / 2.0f));
                    ParticleRotation.OrientVector rotation = new ParticleRotation.OrientVector(ringOffset);
                    Vec3d pos = target.func_213303_ch().func_72441_c(0.0, (double)(target.func_213302_cg() / 2.0f), 0.0).func_178787_e(ringOffset);
                    AdvancedParticleBase.spawnParticle(target.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING_SPARKS.get()), pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), 0.0, 0.0, 0.0, rotation, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 6.0, false, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{1.0f, 1.0f, 0.0f}, new float[]{0.0f, 0.5f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(0.0f, 15.0f), false)});
                    Random rand = attacker.field_70170_p.func_201674_k();
                    float explodeSpeed = 2.5f;
                    for (i = 0; i < 10; ++i) {
                        particlePos = new Vec3d((double)rand.nextFloat() * 0.25, 0.0, 0.0);
                        particlePos = particlePos.func_178785_b((float)((double)(rand.nextFloat() * 2.0f) * Math.PI));
                        particlePos = particlePos.func_178789_a((float)((double)(rand.nextFloat() * 2.0f) * Math.PI));
                        value = rand.nextFloat() * 0.1f;
                        life = rand.nextFloat() * 8.0f + 15.0f;
                        ParticleVanillaCloudExtended.spawnVanillaCloud(target.field_70170_p, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), particlePos.field_72450_a * (double)explodeSpeed, particlePos.field_72448_b * (double)explodeSpeed, particlePos.field_72449_c * (double)explodeSpeed, 1.0, 0.25 + value, 0.75 + value, 0.25 + value, 0.6, life);
                    }
                    for (i = 0; i < 10; ++i) {
                        particlePos = new Vec3d((double)rand.nextFloat() * 0.25, 0.0, 0.0);
                        particlePos = particlePos.func_178785_b((float)((double)(rand.nextFloat() * 2.0f) * Math.PI));
                        particlePos = particlePos.func_178789_a((float)((double)(rand.nextFloat() * 2.0f) * Math.PI));
                        value = rand.nextFloat() * 0.1f;
                        life = rand.nextFloat() * 2.5f + 5.0f;
                        AdvancedParticleBase.spawnParticle(target.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), particlePos.field_72450_a * (double)explodeSpeed, particlePos.field_72448_b * (double)explodeSpeed, particlePos.field_72449_c * (double)explodeSpeed, true, 0.0, 0.0, 0.0, 0.0, 3.0, 0.07 + value, 0.25 + value, 0.07 + value, 1.0, 0.6, life * 0.95, false);
                    }
                    for (i = 0; i < 6; ++i) {
                        particlePos = new Vec3d((double)rand.nextFloat() * 0.25, 0.0, 0.0);
                        particlePos = particlePos.func_178785_b((float)((double)(rand.nextFloat() * 2.0f) * Math.PI));
                        particlePos = particlePos.func_178789_a((float)((double)(rand.nextFloat() * 2.0f) * Math.PI));
                        value = rand.nextFloat() * 0.1f;
                        life = rand.nextFloat() * 5.0f + 10.0f;
                        AdvancedParticleBase.spawnParticle(target.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.BUBBLE.get()), pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), particlePos.field_72450_a * (double)explodeSpeed, particlePos.field_72448_b * (double)explodeSpeed, particlePos.field_72449_c * (double)explodeSpeed, true, 0.0, 0.0, 0.0, 0.0, 3.0, 0.25 + value, 0.75 + value, 0.25 + value, 1.0, 0.6, life * 0.95, false);
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

