/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.power;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleOrb;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityBlockSwapper;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityBoulder;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.message.MessagePlayerStartSummonBoulder;
import com.bobmowzie.mowziesmobs.server.potion.PotionHandler;
import com.bobmowzie.mowziesmobs.server.power.Power;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.google.common.base.Supplier;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class PowerGeomancy
extends Power {
    public static final double SPAWN_BOULDER_REACH = 5.0;
    private int doubleTapTimer = 0;
    protected Random rand;
    private int spawnBoulderCooldown = 8;
    private boolean spawningBoulder = false;
    private boolean liftedMouse = true;
    public int spawnBoulderCharge = 0;
    public BlockPos spawnBoulderPos = new BlockPos(0, 0, 0);
    public Vec3d lookPos = new Vec3d(0.0, 0.0, 0.0);
    private BlockState spawnBoulderBlock = Blocks.field_150346_d.func_176223_P();
    public boolean tunneling;
    public boolean prevUnderground;
    public BlockState justDug = Blocks.field_150346_d.func_176223_P();

    public PowerGeomancy(PlayerCapability.PlayerCapabilityImp capability) {
        super(capability);
        this.rand = new Random();
    }

    @Override
    public void tick(TickEvent.PlayerTickEvent event) {
        super.tick(event);
        PlayerEntity player = event.player;
        --this.spawnBoulderCooldown;
        if (this.doubleTapTimer > 0) {
            --this.doubleTapTimer;
        }
        if (this.tunneling) {
            boolean underground;
            player.field_70143_R = 0.0f;
            player.field_71075_bZ.field_75100_b = false;
            boolean bl = underground = !player.field_70170_p.func_217357_a(EntityBlockSwapper.class, player.func_174813_aQ()).isEmpty();
            if (player.field_70122_E && !underground) {
                this.tunneling = false;
            }
            Vec3d lookVec = player.func_70040_Z();
            float tunnelSpeed = 0.9f;
            if (underground) {
                if (player.func_225608_bj_()) {
                    player.func_213293_j((double)tunnelSpeed * 0.5 * lookVec.field_72450_a, (double)tunnelSpeed * lookVec.field_72448_b, (double)tunnelSpeed * 0.5 * lookVec.field_72449_c);
                } else {
                    player.func_213293_j((double)tunnelSpeed * 0.5 * lookVec.field_72450_a, 1.0, (double)tunnelSpeed * 0.5 * lookVec.field_72449_c);
                }
                List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby((LivingEntity)player, 4.0, 4.0, 4.0, 4.0);
                for (LivingEntity entityHit : entitiesHit) {
                    entityHit.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 6.0f * ((Float)ConfigHandler.TOOLS_AND_ABILITIES.geomancyAttackMultiplier.get()).floatValue());
                }
            } else {
                player.func_213317_d(player.func_213322_ci().func_178786_a(0.0, 0.07, 0.0));
            }
            if (player.func_225608_bj_() && lookVec.field_72448_b < 0.0 || underground) {
                if (player.field_70173_aa % 16 == 0) {
                    player.func_184185_a((SoundEvent)((Supplier)MMSounds.EFFECT_GEOMANCY_RUMBLE.get(this.rand.nextInt(3))).get(), 0.6f, 0.5f + this.rand.nextFloat() * 0.2f);
                }
                for (double x = -1.5; x <= 1.5; x += 1.0) {
                    for (double y = -1.5; y <= 2.0; y += 1.0) {
                        for (double z = -1.5; z <= 2.0; z += 1.0) {
                            BlockPos pos;
                            BlockState blockState;
                            if (Math.sqrt(x * x + y * y + z * z) > 2.0 || !this.isBlockDiggable(blockState = player.field_70170_p.func_180495_p(pos = new BlockPos(player.func_226277_ct_() + x + player.func_213322_ci().func_82615_a(), player.func_226278_cu_() + y + player.func_213322_ci().func_82617_b() + 0.5, player.func_226281_cx_() + z + player.func_213322_ci().func_82616_c()))) || blockState.func_177230_c() == Blocks.field_150357_h) continue;
                            this.justDug = blockState;
                            EntityBlockSwapper.swapBlock(player.field_70170_p, pos, Blocks.field_150350_a.func_176223_P(), 10, false, false);
                        }
                    }
                }
            }
            if (!this.prevUnderground && underground) {
                player.func_184185_a((SoundEvent)((Supplier)MMSounds.EFFECT_GEOMANCY_BREAK_MEDIUM.get(this.rand.nextInt(3))).get(), 1.0f, 0.9f + this.rand.nextFloat() * 0.1f);
                if (player.field_70170_p.field_72995_K) {
                    AdvancedParticleBase.spawnParticle(player.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), (float)player.func_226277_ct_(), (float)player.func_226278_cu_() + 0.02f, (float)player.func_226281_cx_(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 10.0, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(10.0f, 30.0f), false)});
                }
            }
            if (this.prevUnderground && !underground) {
                player.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK.get(), 1.0f, 0.9f + this.rand.nextFloat() * 0.1f);
                if (player.field_70170_p.field_72995_K) {
                    AdvancedParticleBase.spawnParticle(player.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), (float)player.func_226277_ct_(), (float)player.func_226278_cu_() + 0.02f, (float)player.func_226281_cx_(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 10.0, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(10.0f, 30.0f), false)});
                }
                player.func_213317_d(player.func_213322_ci().func_186678_a(2.0));
                for (int i = 0; i < 6; ++i) {
                    if (this.justDug == null) {
                        this.justDug = Blocks.field_150346_d.func_176223_P();
                    }
                    EntityFallingBlock fallingBlock = new EntityFallingBlock(EntityHandler.FALLING_BLOCK, player.field_70170_p, 80, this.justDug);
                    fallingBlock.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_());
                    fallingBlock.func_213293_j(player.func_70681_au().nextFloat() * 0.8f - 0.4f, 0.4f + player.func_70681_au().nextFloat() * 0.8f, player.func_70681_au().nextFloat() * 0.8f - 0.4f);
                    player.field_70170_p.func_217376_c((Entity)fallingBlock);
                }
            }
            this.prevUnderground = underground;
        }
        if (this.spawningBoulder) {
            if (player.func_70092_e((double)this.spawnBoulderPos.func_177958_n(), (double)this.spawnBoulderPos.func_177956_o(), (double)this.spawnBoulderPos.func_177952_p()) > 36.0 || !this.canUse(player)) {
                this.spawningBoulder = false;
                this.spawnBoulderCharge = 0;
            } else {
                ++this.spawnBoulderCharge;
                if (this.spawnBoulderCharge > 2) {
                    player.func_195064_c(new EffectInstance(Effects.field_76421_d, 0, 2, false, false));
                }
                if (this.spawnBoulderCharge == 1 && player.field_70170_p.field_72995_K) {
                    MowziesMobs.PROXY.playBoulderChargeSound(player);
                }
                if ((this.spawnBoulderCharge + 10) % 10 == 0 && this.spawnBoulderCharge < 40 && player.field_70170_p.field_72995_K) {
                    AdvancedParticleBase.spawnParticle(player.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), (float)player.func_226277_ct_(), (float)player.func_226278_cu_() + player.func_213302_cg() / 2.0f, (float)player.func_226281_cx_(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 10.0, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.0f, 0.7f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd((0.8f + 2.7f * (float)this.spawnBoulderCharge / 60.0f) * 10.0f, 0.0f), false)});
                }
                if (this.spawnBoulderCharge == 50) {
                    if (player.field_70170_p.field_72995_K) {
                        AdvancedParticleBase.spawnParticle(player.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), (float)player.func_226277_ct_(), (float)player.func_226278_cu_() + player.func_213302_cg() / 2.0f, (float)player.func_226281_cx_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 20.0, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.7f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(0.0f, 40.0f), false)});
                    }
                    player.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.0f, 1.0f);
                }
                if (player.field_70170_p.field_72995_K && this.spawnBoulderCharge > 5 && this.spawnBoulderCharge < 30) {
                    int particleCount = 4;
                    while (--particleCount != 0) {
                        double radius = 0.5f + 1.5f * (float)this.spawnBoulderCharge / 30.0f;
                        double yaw = (double)(player.func_70681_au().nextFloat() * 2.0f) * Math.PI;
                        double pitch = (double)(player.func_70681_au().nextFloat() * 2.0f) * Math.PI;
                        double ox = radius * Math.sin(yaw) * Math.sin(pitch);
                        double oy = radius * Math.cos(pitch);
                        double oz = radius * Math.cos(yaw) * Math.sin(pitch);
                        player.field_70170_p.func_195594_a((IParticleData)new ParticleOrb.OrbData((float)player.func_226277_ct_(), (float)player.func_226278_cu_() + player.func_213302_cg() / 2.0f, (float)player.func_226281_cx_(), 14.0f), player.func_226277_ct_() + ox, player.func_226278_cu_() + oy + (double)(player.func_213302_cg() / 2.0f), player.func_226281_cx_() + oz, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.spawnBoulderCharge > 60) {
                this.spawnBoulder(player);
                this.liftedMouse = false;
            } else {
                int size = (int)Math.min(Math.max(0.0, Math.floor((float)this.spawnBoulderCharge / 10.0f) - 1.0), 2.0) + 1;
                EntityType<EntityBoulder> type = EntityHandler.BOULDERS[size];
                if (!player.field_70170_p.func_226664_a_(type.func_220328_a((double)((float)this.spawnBoulderPos.func_177958_n() + 0.5f), (double)(this.spawnBoulderPos.func_177956_o() + 2), (double)((float)this.spawnBoulderPos.func_177952_p() + 0.5f)))) {
                    this.spawnBoulder(player);
                }
            }
        }
    }

    @Override
    public void onRightMouseUp(PlayerEntity player) {
        super.onRightMouseUp(player);
        this.liftedMouse = true;
        if (this.spawningBoulder && player.func_70092_e((double)this.spawnBoulderPos.func_177958_n(), (double)this.spawnBoulderPos.func_177956_o(), (double)this.spawnBoulderPos.func_177952_p()) < 36.0) {
            this.spawnBoulder(player);
        } else {
            this.spawningBoulder = false;
            this.spawnBoulderCharge = 0;
        }
    }

    @Override
    public void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        super.onRightClickEmpty(event);
        PlayerEntity player = event.getPlayer();
        if (event.getHand() == Hand.MAIN_HAND && this.canUse(player) && !this.tunneling && !this.spawningBoulder && this.liftedMouse && this.spawnBoulderCooldown <= 0) {
            this.startSpawningBoulder(player);
            MowziesMobs.NETWORK.sendToServer((Object)new MessagePlayerStartSummonBoulder());
        }
    }

    @Override
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        super.onRightClickBlock(event);
        PlayerEntity player = event.getPlayer();
        if (event.getHand() == Hand.MAIN_HAND && this.canUse(player) && !this.tunneling && !this.spawningBoulder && this.liftedMouse && this.spawnBoulderCooldown <= 0) {
            this.startSpawningBoulder(player);
            MowziesMobs.NETWORK.sendToServer((Object)new MessagePlayerStartSummonBoulder());
        }
    }

    @Override
    public void onSneakDown(PlayerEntity player) {
        super.onSneakDown(player);
        if (this.doubleTapTimer > 0 && this.canUse(player) && !player.field_70122_E) {
            this.tunneling = true;
        }
        this.doubleTapTimer = 8;
    }

    @Override
    public void onSneakUp(PlayerEntity player) {
        super.onSneakUp(player);
    }

    public boolean isSpawningBoulder() {
        return this.spawningBoulder;
    }

    public BlockPos getSpawnBoulderPos() {
        return this.spawnBoulderPos;
    }

    public Vec3d getLookPos() {
        return this.lookPos;
    }

    private void spawnBoulder(PlayerEntity player) {
        int size = (int)Math.min(Math.max(0.0, Math.floor((float)this.spawnBoulderCharge / 10.0f) - 1.0), 2.0);
        if (this.spawnBoulderCharge >= 60) {
            size = 3;
        }
        EntityBoulder boulder = new EntityBoulder(EntityHandler.BOULDERS[size], player.field_70170_p, (LivingEntity)player, this.spawnBoulderBlock, this.spawnBoulderPos);
        boulder.func_70107_b((float)this.spawnBoulderPos.func_177958_n() + 0.5f, this.spawnBoulderPos.func_177956_o() + 2, (float)this.spawnBoulderPos.func_177952_p() + 0.5f);
        if (!player.field_70170_p.field_72995_K && boulder.checkCanSpawn()) {
            player.field_70170_p.func_217376_c((Entity)boulder);
        }
        if (this.spawnBoulderCharge > 2) {
            Vec3d playerEyes = player.func_174824_e(1.0f);
            Vec3d vec = playerEyes.func_178788_d(this.getLookPos()).func_72432_b();
            float yaw = (float)Math.atan2(vec.field_72449_c, vec.field_72450_a);
            float pitch = (float)Math.asin(vec.field_72448_b);
            player.field_70177_z = (float)((double)(yaw * 180.0f) / Math.PI + 90.0);
            player.field_70125_A = (float)((double)(pitch * 180.0f) / Math.PI);
        }
        this.spawnBoulderCooldown = 10;
        this.spawnBoulderCharge = 0;
        this.spawningBoulder = false;
    }

    @Override
    public boolean canUse(PlayerEntity player) {
        return player.func_184614_ca().func_190926_b() && player.func_70644_a((Effect)PotionHandler.GEOMANCY);
    }

    public int getSpawnBoulderCharge() {
        return this.spawnBoulderCharge;
    }

    public boolean isBlockDiggable(BlockState blockState) {
        Material mat = blockState.func_185904_a();
        if (mat != Material.field_151577_b && mat != Material.field_151578_c && mat != Material.field_151576_e && mat != Material.field_151571_B && mat != Material.field_151595_p) {
            return false;
        }
        return blockState.func_177230_c() != Blocks.field_150407_cf && blockState.func_177230_c() != Blocks.field_189878_dg && !(blockState.func_177230_c() instanceof FenceBlock) && blockState.func_177230_c() != Blocks.field_150474_ac && blockState.func_177230_c() != Blocks.field_189880_di && blockState.func_177230_c() != Blocks.field_150381_bn && blockState.func_177230_c() != Blocks.field_150378_br && blockState.func_177230_c() != Blocks.field_150477_bB && blockState.func_177230_c() != Blocks.field_180399_cE && blockState.func_177230_c() != Blocks.field_150438_bZ && !blockState.hasTileEntity();
    }

    public void startSpawningBoulder(PlayerEntity player) {
        BlockState blockAbove;
        Vec3d to;
        Vec3d from = player.func_174824_e(1.0f);
        BlockRayTraceResult result = player.field_70170_p.func_217299_a(new RayTraceContext(from, to = from.func_178787_e(player.func_70040_Z().func_186678_a(5.0)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            this.lookPos = result.func_216347_e();
        }
        this.spawnBoulderPos = result.func_216350_a();
        this.spawnBoulderBlock = player.field_70170_p.func_180495_p(this.spawnBoulderPos);
        if (result.func_216354_b() != Direction.UP && ((blockAbove = player.field_70170_p.func_180495_p(this.spawnBoulderPos.func_177984_a())).func_229980_m_((IBlockReader)player.field_70170_p, this.spawnBoulderPos.func_177984_a()) || blockAbove.isAir((IBlockReader)player.field_70170_p, this.spawnBoulderPos.func_177984_a()))) {
            return;
        }
        if (!this.isBlockDiggable(this.spawnBoulderBlock)) {
            return;
        }
        this.spawningBoulder = true;
    }
}

