/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.spawn;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.registries.ForgeRegistries;

public enum SpawnHandler {
    INSTANCE;

    public static Set<Biome> FROSTMAW_BIOMES;
    public static Set<Biome> BARAKO_BIOMES;
    public static Set<Biome> FERROUS_WROUGHTNAUT_BIOMES;
    private static final Map<String, BiomeDictionary.Type> BY_NAME;

    public void registerSpawnPlacementTypes() {
        EntitySpawnPlacementRegistry.PlacementType.create((String)"MMSPAWN", (TriPredicate)new TriPredicate<IWorldReader, BlockPos, EntityType<? extends MobEntity>>(){

            public boolean test(IWorldReader t, BlockPos pos, EntityType<? extends MobEntity> entityType) {
                BlockState block = t.func_180495_p(pos.func_177977_b());
                boolean flag = block.func_177230_c() != Blocks.field_150357_h && block.func_177230_c() != Blocks.field_180401_cv && block.func_185904_a().func_76230_c();
                BlockState iblockstateUp = t.func_180495_p(pos);
                BlockState iblockstateUp2 = t.func_180495_p(pos.func_177984_a());
                flag = flag && WorldEntitySpawner.func_222266_a((IBlockReader)t, (BlockPos)pos, (BlockState)iblockstateUp, (IFluidState)iblockstateUp.func_204520_s()) && WorldEntitySpawner.func_222266_a((IBlockReader)t, (BlockPos)pos.func_177984_a(), (BlockState)iblockstateUp2, (IFluidState)iblockstateUp2.func_204520_s());
                return flag;
            }
        });
    }

    public void registerSpawns() {
        EntitySpawnPlacementRegistry.PlacementType mmSpawn = EntitySpawnPlacementRegistry.PlacementType.valueOf((String)"MMSPAWN");
        if (mmSpawn != null) {
            EntitySpawnPlacementRegistry.func_209343_a(EntityHandler.FOLIAATH, (EntitySpawnPlacementRegistry.PlacementType)mmSpawn, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, MowzieEntity::spawnPredicate);
            EntitySpawnPlacementRegistry.func_209343_a(EntityHandler.LANTERN, (EntitySpawnPlacementRegistry.PlacementType)mmSpawn, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, MowzieEntity::spawnPredicate);
            EntitySpawnPlacementRegistry.func_209343_a(EntityHandler.BARAKOANA, (EntitySpawnPlacementRegistry.PlacementType)mmSpawn, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MowzieEntity::spawnPredicate);
            EntitySpawnPlacementRegistry.func_209343_a(EntityHandler.NAGA, (EntitySpawnPlacementRegistry.PlacementType)mmSpawn, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MowzieEntity::spawnPredicate);
        }
        for (BiomeDictionary.Type type : BiomeDictionary.Type.getAll()) {
            BY_NAME.put(type.getName(), type);
        }
        if ((Integer)ConfigHandler.MOBS.FROSTMAW.generationConfig.generationDistance.get() >= 0) {
            FROSTMAW_BIOMES = this.getBiomesFromConfig(ConfigHandler.MOBS.FROSTMAW.generationConfig.biomeConfig);
        }
        if ((Integer)ConfigHandler.MOBS.BARAKO.generationConfig.generationDistance.get() >= 0) {
            BARAKO_BIOMES = this.getBiomesFromConfig(ConfigHandler.MOBS.BARAKO.generationConfig.biomeConfig);
        }
        if ((Integer)ConfigHandler.MOBS.FERROUS_WROUGHTNAUT.generationConfig.generationDistance.get() >= 0) {
            FERROUS_WROUGHTNAUT_BIOMES = this.getBiomesFromConfig(ConfigHandler.MOBS.FERROUS_WROUGHTNAUT.generationConfig.biomeConfig);
        }
        if ((Integer)ConfigHandler.MOBS.FOLIAATH.spawnConfig.spawnRate.get() > 0) {
            Set<Biome> foliaathBiomes = this.getBiomesFromConfig(ConfigHandler.MOBS.FOLIAATH.spawnConfig.biomeConfig);
            this.registerEntityWorldSpawn(EntityHandler.FOLIAATH, (Integer)ConfigHandler.MOBS.FOLIAATH.spawnConfig.spawnRate.get(), (Integer)ConfigHandler.MOBS.FOLIAATH.spawnConfig.minGroupSize.get(), (Integer)ConfigHandler.MOBS.FOLIAATH.spawnConfig.maxGroupSize.get(), EntityClassification.MONSTER, foliaathBiomes.toArray(new Biome[foliaathBiomes.size()]));
        }
        if ((Integer)ConfigHandler.MOBS.BARAKOA.spawnConfig.spawnRate.get() > 0) {
            Set<Biome> barakoaBiomes = this.getBiomesFromConfig(ConfigHandler.MOBS.BARAKOA.spawnConfig.biomeConfig);
            this.registerEntityWorldSpawn(EntityHandler.BARAKOANA, (Integer)ConfigHandler.MOBS.BARAKOA.spawnConfig.spawnRate.get(), (Integer)ConfigHandler.MOBS.BARAKOA.spawnConfig.minGroupSize.get(), (Integer)ConfigHandler.MOBS.BARAKOA.spawnConfig.maxGroupSize.get(), EntityClassification.MONSTER, barakoaBiomes.toArray(new Biome[barakoaBiomes.size()]));
        }
        if ((Integer)ConfigHandler.MOBS.GROTTOL.spawnConfig.spawnRate.get() > 0) {
            Set<Biome> grottolBiomes = this.getBiomesFromConfig(ConfigHandler.MOBS.GROTTOL.spawnConfig.biomeConfig);
            this.registerEntityWorldSpawn(EntityHandler.GROTTOL, (Integer)ConfigHandler.MOBS.GROTTOL.spawnConfig.spawnRate.get(), (Integer)ConfigHandler.MOBS.GROTTOL.spawnConfig.minGroupSize.get(), (Integer)ConfigHandler.MOBS.GROTTOL.spawnConfig.maxGroupSize.get(), EntityClassification.MONSTER, grottolBiomes.toArray(new Biome[grottolBiomes.size()]));
        }
        if ((Integer)ConfigHandler.MOBS.LANTERN.spawnConfig.spawnRate.get() > 0) {
            Set<Biome> lanternBiomes = this.getBiomesFromConfig(ConfigHandler.MOBS.LANTERN.spawnConfig.biomeConfig);
            this.registerEntityWorldSpawn(EntityHandler.LANTERN, (Integer)ConfigHandler.MOBS.LANTERN.spawnConfig.spawnRate.get(), (Integer)ConfigHandler.MOBS.LANTERN.spawnConfig.minGroupSize.get(), (Integer)ConfigHandler.MOBS.LANTERN.spawnConfig.maxGroupSize.get(), EntityClassification.AMBIENT, lanternBiomes.toArray(new Biome[lanternBiomes.size()]));
        }
        if ((Integer)ConfigHandler.MOBS.NAGA.spawnConfig.spawnRate.get() > 0) {
            Set<Biome> nagaBiomes = this.getBiomesFromConfig(ConfigHandler.MOBS.NAGA.spawnConfig.biomeConfig);
            this.registerEntityWorldSpawn(EntityHandler.NAGA, (Integer)ConfigHandler.MOBS.NAGA.spawnConfig.spawnRate.get(), (Integer)ConfigHandler.MOBS.NAGA.spawnConfig.minGroupSize.get(), (Integer)ConfigHandler.MOBS.NAGA.spawnConfig.maxGroupSize.get(), EntityClassification.MONSTER, nagaBiomes.toArray(new Biome[nagaBiomes.size()]));
        }
    }

    private void registerEntityWorldSpawn(EntityType<?> entity, int weight, int min, int max, EntityClassification classification, Biome ... biomes) {
        for (Biome biome : biomes) {
            if (biome == null) continue;
            biome.func_76747_a(classification).add(new Biome.SpawnListEntry(entity, weight, min, max));
        }
    }

    private Set<Biome> getBiomesFromConfig(ConfigHandler.BiomeConfig biomeConfig) {
        HashSet biomeWhitelistNames = new HashSet((Collection)biomeConfig.biomeWhitelist.get());
        HashSet biomeBlacklistNames = new HashSet((Collection)biomeConfig.biomeBlacklist.get());
        HashSet<String> whiteOrBlacklistedBiomes = new HashSet<String>();
        HashSet<BiomeCombo> biomeCombos = new HashSet<BiomeCombo>();
        for (String biomeComboString : (List)biomeConfig.biomeTypes.get()) {
            BiomeCombo biomeCombo = new BiomeCombo(biomeComboString);
            biomeCombos.add(biomeCombo);
        }
        HashSet<Biome> toReturn = new HashSet<Biome>();
        for (Biome b : ForgeRegistries.BIOMES) {
            ResourceLocation biomeRegistryName = b.getRegistryName();
            if (biomeRegistryName == null) continue;
            String biomeName = biomeRegistryName.toString();
            if (biomeWhitelistNames.contains(biomeName)) {
                toReturn.add(b);
                whiteOrBlacklistedBiomes.add(biomeName);
                continue;
            }
            if (biomeBlacklistNames.contains(biomeName)) {
                whiteOrBlacklistedBiomes.add(biomeName);
                continue;
            }
            for (BiomeCombo biomeCombo : biomeCombos) {
                if (!biomeCombo.acceptsBiome(b)) continue;
                toReturn.add(b);
            }
        }
        for (String biomeName : biomeWhitelistNames) {
            if (whiteOrBlacklistedBiomes.contains(biomeName)) continue;
            System.out.println("Mowzie's Mobs config warning: No biome with name '" + biomeName + "'. Unable to whitelist.");
        }
        for (String biomeName : biomeBlacklistNames) {
            if (whiteOrBlacklistedBiomes.contains(biomeName)) continue;
            System.out.println("Mowzie's Mobs config warning: No biome with name '" + biomeName + "'. Unable to blacklist.");
        }
        return toReturn;
    }

    static {
        BY_NAME = new HashMap<String, BiomeDictionary.Type>();
    }

    private class BiomeCombo {
        BiomeDictionary.Type[] neededTypes;
        boolean[] inverted;

        private BiomeCombo(String biomeComboString) {
            String[] typeStrings = biomeComboString.toUpperCase().replace(" ", "").split(",");
            this.neededTypes = new BiomeDictionary.Type[typeStrings.length];
            this.inverted = new boolean[typeStrings.length];
            for (int i = 0; i < typeStrings.length; ++i) {
                if (typeStrings[i].length() == 0) continue;
                this.inverted[i] = typeStrings[i].charAt(0) == '!';
                String name = typeStrings[i].replace("!", "");
                BiomeDictionary.Type neededType = (BiomeDictionary.Type)BY_NAME.get(name);
                if (neededType == null) {
                    System.out.println("Mowzie's Mobs config warning: No biome dictionary type with name '" + name + "'. Unable to check for type.");
                }
                this.neededTypes[i] = neededType;
            }
        }

        private boolean acceptsBiome(Biome biome) {
            Set thisTypes = BiomeDictionary.getTypes((Biome)biome);
            for (int i = 0; i < this.neededTypes.length; ++i) {
                if (this.neededTypes[i] == null || !(!this.inverted[i] ? !thisTypes.contains(this.neededTypes[i]) : thisTypes.contains(this.neededTypes[i]))) continue;
                return false;
            }
            return true;
        }
    }
}

