/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature;

import com.bobmowzie.mowziesmobs.server.spawn.SpawnHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.BarakoaVillagePieces;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.BarakoaVillageStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.FrostmawPieces;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.FrostmawStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.WroughtnautChamberPieces;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.WroughtnautChamberStructure;
import java.util.Locale;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mowziesmobs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FeatureHandler {
    public static Structure<NoFeatureConfig> WROUGHTNAUT_CHAMBER = (Structure)new WroughtnautChamberStructure(NoFeatureConfig::func_214639_a).setRegistryName("mowziesmobs", "wroughtnaut_chamber");
    public static IStructurePieceType WROUGHTNAUT_CHAMBER_PIECE = WroughtnautChamberPieces.Piece::new;
    public static Structure<NoFeatureConfig> BARAKOA_VILLAGE = (Structure)new BarakoaVillageStructure(NoFeatureConfig::func_214639_a).setRegistryName("mowziesmobs", "barakoa_village");
    public static IStructurePieceType BARAKOA_VILLAGE_PIECE = BarakoaVillagePieces.Piece::new;
    public static IStructurePieceType BARAKOA_VILLAGE_FIREPIT = BarakoaVillagePieces.FirepitPiece::new;
    public static IStructurePieceType BARAKOA_VILLAGE_STAKE = BarakoaVillagePieces.StakePiece::new;
    public static IStructurePieceType BARAKOA_VILLAGE_ALTAR = BarakoaVillagePieces.AltarPiece::new;
    public static Structure<NoFeatureConfig> FROSTMAW = (Structure)new FrostmawStructure(NoFeatureConfig::func_214639_a).setRegistryName("mowziesmobs", "frostmaw_spawn");
    public static IStructurePieceType FROSTMAW_PIECE = FrostmawPieces.Piece::new;

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Feature[]{WROUGHTNAUT_CHAMBER, BARAKOA_VILLAGE, FROSTMAW});
        FeatureHandler.registerPiece(WROUGHTNAUT_CHAMBER_PIECE, "WROUGHTNAUT_CHAMBER_PIECE");
        FeatureHandler.registerPiece(BARAKOA_VILLAGE_PIECE, "BARAKOA_VILLAGE_PIECE");
        FeatureHandler.registerPiece(BARAKOA_VILLAGE_FIREPIT, "BARAKOA_VILLAGE_FIREPIT");
        FeatureHandler.registerPiece(BARAKOA_VILLAGE_STAKE, "BARAKOA_VILLAGE_STAKE");
        FeatureHandler.registerPiece(BARAKOA_VILLAGE_ALTAR, "BARAKOA_VILLAGE_ALTAR");
        FeatureHandler.registerPiece(FROSTMAW_PIECE, "FROSTMAW_PIECE");
    }

    static IStructurePieceType registerPiece(IStructurePieceType structurePiece, String key) {
        return (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)key.toLowerCase(Locale.ROOT), (Object)structurePiece);
    }

    public static void addStructureGeneration() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            ConfiguredFeature wroughtnautChamberFeature = WROUGHTNAUT_CHAMBER.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
            if (SpawnHandler.FERROUS_WROUGHTNAUT_BIOMES.contains(biome)) {
                biome.func_226711_a_(wroughtnautChamberFeature);
            }
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, wroughtnautChamberFeature);
            ConfiguredFeature barakoaVillageFeature = BARAKOA_VILLAGE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
            if (SpawnHandler.BARAKO_BIOMES.contains(biome)) {
                biome.func_226711_a_(barakoaVillageFeature);
            }
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, barakoaVillageFeature);
            ConfiguredFeature frostmawFeature = FROSTMAW.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
            if (SpawnHandler.FROSTMAW_BIOMES.contains(biome)) {
                biome.func_226711_a_(frostmawFeature);
            }
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, frostmawFeature);
        }
    }
}

